/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.datamodel.pdm.validationrule;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.datamodel.model.validator.MessageType;
import kd.bos.datamodel.model.validator.ValidateResultItem;
import kd.bos.datamodel.model.validator.ValidateRule;
import kd.bos.datamodel.pdm.model.Table;

public class TableNameLengthRule
implements ValidateRule<Table> {
    private int maxLength = 30;

    @Override
    public void setRuleParameter(Map<String, Object> parameter) {
        Object maxLengthConfigVal = parameter.get("maxLength");
        if (maxLengthConfigVal != null) {
            this.maxLength = Integer.parseInt(maxLengthConfigVal.toString());
        }
    }

    @Override
    public List<ValidateResultItem> validate(Table table) {
        ArrayList<ValidateResultItem> resultList = new ArrayList<ValidateResultItem>();
        String tableName = table.getNumber();
        if (tableName.length() > this.maxLength) {
            resultList.add(new ValidateResultItem(MessageType.Error, String.format("\u8868\u540d'%s'\u4e0d\u7b26\u5408\u89c4\u8303\uff0c\u540d\u79f0\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7%d\u4f4d\u3002", tableName, this.maxLength)));
        }
        return resultList;
    }
}

