/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.datamodel.pdm.validationrule;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.datamodel.model.validator.MessageType;
import kd.bos.datamodel.model.validator.ValidateResultItem;
import kd.bos.datamodel.model.validator.ValidateRule;
import kd.bos.datamodel.pdm.model.Table;

public class TableNamePrefixRule
implements ValidateRule<Table> {
    private String prefix = "T_";

    @Override
    public void setRuleParameter(Map<String, Object> parameter) {
        Object prefixVal = parameter.get("prefix");
        if (prefixVal != null) {
            this.prefix = prefixVal.toString();
        }
    }

    @Override
    public List<ValidateResultItem> validate(Table table) {
        String tableName = table.getNumber();
        ArrayList<ValidateResultItem> resultList = new ArrayList<ValidateResultItem>();
        if (!tableName.toUpperCase().startsWith(this.prefix) && !tableName.toUpperCase().startsWith("TK_")) {
            String message = String.format("\u8868\u540d'%s'\u4e0d\u7b26\u5408\u89c4\u8303\uff0c\u540d\u79f0\u5e94\u4f7f\u7528T_(t_)\u6216\u8005TK_(tk_)\u5f00\u5934\u3002", tableName);
            resultList.add(new ValidateResultItem(MessageType.Error, message));
        }
        return resultList;
    }
}

