/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.datamodel.meta.element;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.CollectionPropertyAttribute;
import kd.bos.datamodel.DMObject;
import kd.bos.datamodel.Package;
import kd.bos.datamodel.meta.element.BaseControl;
import kd.bos.datamodel.meta.element.DataModelBaseElement;
import kd.bos.datamodel.meta.element.pdm.PhysicalDiagram;
import kd.bos.datamodel.meta.element.pdm.RelationShipAp;
import kd.bos.datamodel.meta.element.pdm.TableAp;

public class DMPackageAp
extends DataModelBaseElement {
    private List<TableAp> tableAps = new ArrayList<TableAp>(10);
    private List<RelationShipAp> relationShipAps = new ArrayList<RelationShipAp>(10);

    @Override
    protected void flat() {
        if (this.getItems().isEmpty()) {
            if (!this.tableAps.isEmpty()) {
                this.getItems().addAll(this.tableAps);
            }
            if (!this.relationShipAps.isEmpty()) {
                this.getItems().addAll(this.relationShipAps);
            }
        }
    }

    @Override
    protected void clearProperty(boolean isClearProperty) {
        if (isClearProperty) {
            this.getTableAps().clear();
            this.getRelationshipAps().clear();
        }
    }

    @Override
    public void createControl() {
        if (!this.getItems().isEmpty()) {
            this.tableAps.clear();
            this.relationShipAps.clear();
            int tableIdx = 0;
            int relationIdx = 0;
            for (BaseControl item : this.getItems()) {
                if (item instanceof DataModelBaseElement) {
                    ((DataModelBaseElement)item).createControl();
                }
                if (item instanceof PhysicalDiagram) continue;
                if (item instanceof TableAp) {
                    ((TableAp)item).setSeq(tableIdx);
                    this.tableAps.add((TableAp)item);
                    ++tableIdx;
                    continue;
                }
                if (!(item instanceof RelationShipAp)) continue;
                ((RelationShipAp)item).setSeq(relationIdx);
                this.relationShipAps.add((RelationShipAp)item);
                ++relationIdx;
            }
        }
    }

    @CollectionPropertyAttribute(collectionItemPropertyType=TableAp.class)
    public List<TableAp> getTableAps() {
        return this.tableAps;
    }

    public void setTableAps(List<TableAp> tableAps) {
        this.tableAps = tableAps;
    }

    @CollectionPropertyAttribute(collectionItemPropertyType=RelationShipAp.class)
    public List<RelationShipAp> getRelationshipAps() {
        return this.relationShipAps;
    }

    public void setRelationshipAps(List<RelationShipAp> relationShipAps) {
        this.relationShipAps = relationShipAps;
    }

    public DMObject createDMO() {
        Package pkg = new Package();
        for (TableAp tableAp : this.tableAps) {
            pkg.getItem().add(tableAp.createDMO());
        }
        for (RelationShipAp relationShipAp : this.relationShipAps) {
        }
        return pkg;
    }
}

