/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.datamodel.meta.element.pdm;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DefaultValueAttribute;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.datamodel.DMObject;
import kd.bos.datamodel.meta.element.pdm.PDMDBOElementAp;
import kd.bos.datamodel.pdm.model.Column;
import kd.bos.datamodel.pdm.model.DataType;

public class ColumnAp
extends PDMDBOElementAp {
    private static Set<String> COL_SIZE = new HashSet<String>(Arrays.asList("CHAR", "NCHAR", "VARCHAR", "NVARCHAR", "DECIMAL"));
    private static Set<String> COL_DEFAULT = new HashSet<String>(Arrays.asList("CHAR", "VARCHAR", "NVARCHAR", "INTEGER", "BIGINT", "DECIMAL"));
    private String columnName;
    private int colunmType;
    private boolean isNotNull;
    private Object columnDef;
    private int columnLength;
    private int columnPrecision;
    private boolean isPrimaryKey;

    @SimplePropertyAttribute(name="ColumnName")
    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    @SimplePropertyAttribute(name="ColumnType")
    @DefaultValueAttribute(value="-1")
    public int getColunmType() {
        return this.colunmType;
    }

    public void setColunmType(int colunmType) {
        this.colunmType = colunmType;
    }

    @SimplePropertyAttribute(name="ColumnNull")
    public boolean isNotNull() {
        return this.isNotNull;
    }

    public void setNotNull(boolean notNull) {
        this.isNotNull = notNull;
    }

    @SimplePropertyAttribute(name="ColumnDef")
    public Object getColumnDef() {
        return this.columnDef;
    }

    public void setColumnDef(Object columnDef) {
        this.columnDef = columnDef;
    }

    @SimplePropertyAttribute(name="ColumnLength")
    public int getColumnLength() {
        return this.columnLength;
    }

    public void setColumnLength(int columnLength) {
        this.columnLength = columnLength;
    }

    @SimplePropertyAttribute(name="ColumnPrecision")
    public int getColumnPrecision() {
        return this.columnPrecision;
    }

    public void setColumnPrecision(int columnPrecision) {
        this.columnPrecision = columnPrecision;
    }

    @SimplePropertyAttribute(name="ColumnPrimaryKey")
    public boolean isPrimaryKey() {
        return this.isPrimaryKey;
    }

    public void setPrimaryKey(boolean primaryKey) {
        this.isPrimaryKey = primaryKey;
    }

    DMObject createDMO() {
        Column col = new Column(this.columnName);
        String name = this.getName() == null ? null : this.getName().getLocaleValue();
        col.setName(name);
        DataType dataType = DataType.valueOf((int)this.colunmType);
        col.setDataType(dataType);
        col.setComment(name);
        if (dataType == DataType.DECIMAL) {
            col.setPrecision(this.columnLength);
            col.setScale(this.columnPrecision);
        } else if (dataType != DataType.BIGINT && dataType != DataType.INT && dataType != DataType.SMALLINT && dataType != DataType.DATETIME) {
            col.setLength(this.columnLength);
        }
        col.setAllowNull(!this.isNotNull);
        if (this.columnDef != null) {
            col.setDefaultValue(this.columnDef.toString());
        }
        col.setModified(this.isModified());
        return col;
    }

    String getCreateSQL() {
        String colName = this.getColumnName().toUpperCase(Locale.ENGLISH);
        String colType = DataType.valueOf((int)this.getColunmType()).name().toUpperCase(Locale.ENGLISH);
        long colSize = this.getColumnLength();
        int digits = this.getColumnPrecision();
        boolean allowNull = !this.isNotNull();
        Object colDef = this.getColumnDef();
        return ColumnAp.getAddColumnScript(colName, colType, colSize, digits, allowNull, colDef);
    }

    static String getAddColumnScript(String colName, String colType, long colSize, int digits, boolean allowNull, Object colDef, String comment) {
        StringBuilder sb = new StringBuilder();
        sb.append(colName).append(" ");
        sb.append(ColumnAp.columnPropertyScript(colType, colSize, digits, allowNull, colDef));
        if (comment != null && comment.trim().length() > 0) {
            sb.append(" COMMENT '").append(comment).append("'");
        }
        return sb.toString();
    }

    static String getAddColumnScript(String colName, String colType, long colSize, int digits, boolean allowNull, Object colDef) {
        StringBuilder sb = new StringBuilder();
        sb.append(colName).append(" ");
        sb.append(ColumnAp.columnPropertyScript(colType, colSize, digits, allowNull, colDef));
        return sb.toString();
    }

    public static String columnPropertyScript(String colType, long colSize, long digits, boolean allowNull, Object colDef) {
        StringBuilder sb = ColumnAp.getColumnTypeScript(colType, colSize, digits);
        if (StringUtils.isNotBlank((Object)colDef) && COL_DEFAULT.contains(colType)) {
            sb.append(" DEFAULT ").append(ColumnAp.getDefault(colType, colDef));
        }
        if (!allowNull) {
            sb.append(" NOT NULL");
        }
        return sb.toString();
    }

    private static Object getDefault(String dataType, Object value) {
        DataType type = DataType.valueOf((String)dataType);
        Object newValue = type == DataType.DATETIME && value instanceof String && ((String)value).trim().length() != 0 ? ("getdate()".equalsIgnoreCase((String)value) ? "GETDATE()" : String.format("{ts'%s'}", value)) : (type == DataType.VARCHAR && "newid()".equalsIgnoreCase((String)value) ? "NEWID()" : ((type == DataType.CHAR || type == DataType.NCHAR || type == DataType.NVARCHAR || type == DataType.VARCHAR) && "''".equals(value) ? "' '" : value));
        return newValue;
    }

    private static StringBuilder getColumnTypeScript(String colType, long colSize, long digits) {
        StringBuilder sb = new StringBuilder();
        sb.append(colType);
        if (colSize > 0L && COL_SIZE.contains(colType)) {
            sb.append("(").append(colSize);
            if (digits > 0L && "DECIMAL".equals(colType)) {
                sb.append(",").append(digits);
            }
            sb.append(")");
        }
        return sb;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        ColumnAp columnAp = (ColumnAp)((Object)o);
        return this.isNotNull == columnAp.isNotNull && this.columnLength == columnAp.columnLength && this.columnPrecision == columnAp.columnPrecision && this.isPrimaryKey == columnAp.isPrimaryKey && this.columnName.equals(columnAp.columnName) && this.colunmType == columnAp.colunmType && Objects.equals(this.columnDef, columnAp.columnDef);
    }

    public int hashCode() {
        return Objects.hash(this.columnName, this.colunmType, this.isNotNull, this.columnDef, this.columnLength, this.columnPrecision, this.isPrimaryKey);
    }

    public String toString() {
        return String.format("%s-%s", this.getKey(), this.getColumnName() == null ? "" : this.getColumnName());
    }
}

