/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.datamodel.meta.element.pdm;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import kd.bos.dataentity.entity.CollectionPropertyAttribute;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.datamodel.DMObject;
import kd.bos.datamodel.meta.element.pdm.PDMDBOElementAp;
import kd.bos.datamodel.meta.element.pdm.RefColumnAp;
import kd.bos.datamodel.meta.element.pdm.TableAp;
import kd.bos.datamodel.pdm.model.Index;

public class IndexAp
extends PDMDBOElementAp {
    private String indexName;
    private String tableName;
    private List<RefColumnAp> indexColumnAps = new ArrayList<RefColumnAp>(10);
    private boolean isUnique;
    private boolean isCluster;

    @SimplePropertyAttribute(name="IndexName")
    public String getIndexName() {
        return this.indexName;
    }

    public void setIndexName(String indexName) {
        this.indexName = indexName;
    }

    @SimplePropertyAttribute(name="TableName")
    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    @CollectionPropertyAttribute(collectionItemPropertyType=RefColumnAp.class)
    public List<RefColumnAp> getIndexColumnAps() {
        return this.indexColumnAps;
    }

    public void setIndexColumnAps(List<RefColumnAp> indexColumnAps) {
        this.indexColumnAps = indexColumnAps;
    }

    @SimplePropertyAttribute(name="IndexUnique")
    public boolean isUnique() {
        return this.isUnique;
    }

    public void setUnique(boolean unique) {
        this.isUnique = unique;
    }

    @SimplePropertyAttribute(name="Cluster")
    public boolean isCluster() {
        return this.isCluster;
    }

    public void setCluster(boolean cluster) {
        this.isCluster = cluster;
    }

    @Override
    public void createIndex() {
        if (!this.isInitialized()) {
            // empty if block
        }
    }

    DMObject createDMO(TableAp tableAp) {
        Index idx = new Index(this.indexName);
        idx.setCluster(this.isCluster);
        idx.setUnique(this.isUnique);
        idx.setComment(this.getName().getLocaleValue());
        this.indexColumnAps.forEach(c -> idx.addColumn(tableAp.getColumnName(c.getRefId()), true));
        idx.setModified(this.isModified());
        return idx;
    }

    public String getIndexSQL(TableAp tableAp) {
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isNotEmpty((CharSequence)this.getIndexName()) && StringUtils.isNotEmpty((CharSequence)this.getTableName()) && !this.getIndexColumnAps().isEmpty()) {
            String indexName = this.getIndexName().toUpperCase(Locale.ENGLISH);
            String tableName = this.getTableName().toUpperCase(Locale.ENGLISH);
            sb.append(String.format(" IF NOT EXISTS (SELECT 1 FROM KSQL_INDEXES WHERE KSQL_TABNAME = '%s' AND KSQL_INDNAME = '%s')", tableName, indexName));
            sb.append(" CREATE ");
            if (this.isUnique()) {
                sb.append("UNIQUE ");
            }
            if (this.isCluster()) {
                sb.append(" CLUSTERED ");
            }
            sb.append(String.format("INDEX %1$s ON %2$s ( ", indexName, tableName));
            for (RefColumnAp indexColumnAp : this.getIndexColumnAps()) {
                sb.append(tableAp.getColumnName(indexColumnAp.getRefId()));
                sb.append(" ");
                sb.append(",");
            }
            sb.setLength(sb.length() - 1);
            sb.append(");\r\n");
        }
        return sb.toString().toUpperCase(Locale.ENGLISH);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        IndexAp indexAp = (IndexAp)((Object)o);
        return this.isUnique == indexAp.isUnique && this.isCluster == indexAp.isCluster && this.indexName.equals(indexAp.indexName) && this.tableName.equals(indexAp.tableName) && this.indexColumnAps.equals(indexAp.indexColumnAps);
    }

    public int hashCode() {
        return Objects.hash(this.indexName, this.tableName, this.indexColumnAps, this.isUnique, this.isCluster);
    }
}

