/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.datamodel.meta.element.pdm;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import kd.bos.dataentity.entity.CollectionPropertyAttribute;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.datamodel.DMObject;
import kd.bos.datamodel.meta.element.pdm.PDMDBOElementAp;
import kd.bos.datamodel.meta.element.pdm.RefColumnAp;
import kd.bos.datamodel.meta.element.pdm.TableAp;
import kd.bos.datamodel.pdm.model.PrimaryKey;

public class PrimaryKeyAp
extends PDMDBOElementAp {
    private String tableName;
    private String pk;
    private List<RefColumnAp> pkColumnList = new ArrayList<RefColumnAp>(10);
    private boolean isCluster;

    @Override
    public void createIndex() {
        if (!this.isInitialized()) {
            // empty if block
        }
    }

    @SimplePropertyAttribute(name="TableName")
    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    @SimplePropertyAttribute(name="PK")
    public String getPk() {
        return this.pk;
    }

    public void setPk(String pk) {
        this.pk = pk;
    }

    @CollectionPropertyAttribute(collectionItemPropertyType=RefColumnAp.class)
    public List<RefColumnAp> getPkColumnList() {
        return this.pkColumnList;
    }

    public void setPkColumnList(List<RefColumnAp> pkColumnList) {
        this.pkColumnList = pkColumnList;
    }

    @SimplePropertyAttribute(name="Cluster")
    public boolean isCluster() {
        return this.isCluster;
    }

    public void setCluster(boolean cluster) {
        this.isCluster = cluster;
    }

    DMObject createDMO(TableAp tableAp) {
        PrimaryKey primaryKey = new PrimaryKey(this.pk);
        String name = this.getName() == null ? null : this.getName().getLocaleValue();
        primaryKey.setName(name);
        primaryKey.setCluster(this.isCluster);
        this.pkColumnList.forEach(c -> primaryKey.addCol(tableAp.getColumnName(c.getRefId())));
        primaryKey.setComment(name);
        primaryKey.setModified(this.isModified());
        return primaryKey;
    }

    public String getPkSql(TableAp tableAp) {
        if (this.getPkColumnList().size() > 0) {
            List<RefColumnAp> pkColumnList = this.getPkColumnList();
            ArrayList<String> column = new ArrayList<String>(pkColumnList.size());
            for (RefColumnAp refColumnAp : pkColumnList) {
                String columnName = tableAp.getColumnName(refColumnAp.getRefId());
                columnName = columnName == null ? null : columnName.toUpperCase(Locale.ENGLISH);
                column.add(columnName);
            }
            String pkCols = String.join((CharSequence)",", column);
            String clustered = "0";
            if (this.isCluster()) {
                clustered = "1";
            }
            String pk = this.getPk() == null ? null : this.getPk().toUpperCase(Locale.ENGLISH);
            String tableName = tableAp.getTableName() == null ? null : tableAp.getTableName().toUpperCase(Locale.ENGLISH);
            return String.format(" EXEC p_AlterPK '%s', '%s', '%s', '%s';", pk, tableName, pkCols, clustered);
        }
        return "";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        PrimaryKeyAp that = (PrimaryKeyAp)((Object)o);
        return this.isCluster == that.isCluster && Objects.equals(this.tableName, that.tableName) && Objects.equals(this.pk, that.pk) && Objects.equals(this.pkColumnList, that.pkColumnList);
    }

    public int hashCode() {
        return Objects.hash(this.tableName, this.pk, this.pkColumnList, this.isCluster);
    }
}

