/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.datamodel.meta.element.pdm;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import kd.bos.dataentity.entity.CollectionPropertyAttribute;
import kd.bos.dataentity.entity.ComplexPropertyAttribute;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.datamodel.DMObject;
import kd.bos.datamodel.meta.element.BaseControl;
import kd.bos.datamodel.meta.element.DataModelBaseElement;
import kd.bos.datamodel.meta.element.pdm.ColumnAp;
import kd.bos.datamodel.meta.element.pdm.IndexAp;
import kd.bos.datamodel.meta.element.pdm.PDMDBOElementAp;
import kd.bos.datamodel.meta.element.pdm.PrimaryKeyAp;
import kd.bos.datamodel.meta.element.pdm.RefColumnAp;
import kd.bos.datamodel.pdm.model.Column;
import kd.bos.datamodel.pdm.model.DataType;
import kd.bos.datamodel.pdm.model.Index;
import kd.bos.datamodel.pdm.model.PrimaryKey;
import kd.bos.datamodel.pdm.model.Table;

public class TableAp
extends PDMDBOElementAp {
    private String tableName;
    private boolean allowDict;
    private List<ColumnAp> columns = new ArrayList<ColumnAp>(10);
    private PrimaryKeyAp primaryKey;
    private List<IndexAp> indexs = new ArrayList<IndexAp>(10);
    private long version;

    @SimplePropertyAttribute
    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    @SimplePropertyAttribute(name="AllowDict")
    public boolean isAllowDict() {
        return this.allowDict;
    }

    public void setAllowDict(boolean allowDict) {
        this.allowDict = allowDict;
    }

    @CollectionPropertyAttribute(collectionItemPropertyType=ColumnAp.class)
    public List<ColumnAp> getColumns() {
        return this.columns;
    }

    public void setColumns(List<ColumnAp> columns) {
        this.columns = columns;
    }

    @CollectionPropertyAttribute(collectionItemPropertyType=IndexAp.class)
    public List<IndexAp> getIndexs() {
        return this.indexs;
    }

    public void setIndexs(List<IndexAp> indexs) {
        this.indexs = indexs;
    }

    @ComplexPropertyAttribute(name="DMPrimaryKey")
    public PrimaryKeyAp getPrimaryKey() {
        return this.primaryKey;
    }

    public void setPrimaryKey(PrimaryKeyAp primaryKey) {
        this.primaryKey = primaryKey;
    }

    @SimplePropertyAttribute
    public long getVersion() {
        return this.version;
    }

    public void setVersion(long version) {
        this.version = version;
    }

    @Override
    protected void flat() {
        if (this.getItems().isEmpty()) {
            if (!this.columns.isEmpty()) {
                this.getItems().addAll(this.columns);
            }
            if (!this.indexs.isEmpty()) {
                this.getItems().addAll(this.indexs);
            }
            if (this.primaryKey != null) {
                this.getItems().add(this.primaryKey);
            }
        }
    }

    @Override
    protected void clearProperty(boolean isClearProperty) {
        if (isClearProperty) {
            this.getColumns().clear();
            this.getIndexs().clear();
            if (this.primaryKey != null) {
                this.primaryKey = null;
            }
        }
    }

    @Override
    public void createControl() {
        super.createControl();
        if (!this.getItems().isEmpty()) {
            this.columns.clear();
            this.indexs.clear();
            int colIdx = 0;
            int indexIdx = 0;
            for (BaseControl item : this.getItems()) {
                if (item instanceof DataModelBaseElement) {
                    ((DataModelBaseElement)item).createControl();
                }
                if (item instanceof ColumnAp) {
                    ((ColumnAp)item).setSeq(colIdx);
                    this.columns.add((ColumnAp)item);
                    ++colIdx;
                    continue;
                }
                if (item instanceof IndexAp) {
                    ((IndexAp)item).setSeq(indexIdx);
                    this.indexs.add((IndexAp)item);
                    ++indexIdx;
                    continue;
                }
                if (!(item instanceof PrimaryKeyAp)) continue;
                this.primaryKey = (PrimaryKeyAp)item;
            }
        }
    }

    public DMObject createDMO() {
        Table table = new Table(this.tableName);
        String name = this.getName() == null ? null : this.getName().getLocaleValue();
        table.setName(name);
        for (ColumnAp columnAp : this.columns) {
            Column col = (Column)columnAp.createDMO();
            table.addColumn(col);
        }
        if (this.primaryKey != null && this.primaryKey.getPk() != null) {
            table.setPrimaryKey((PrimaryKey)this.primaryKey.createDMO(this));
        }
        table.setComment(name);
        for (IndexAp indexAp : this.indexs) {
            table.addIndex((Index)indexAp.createDMO(this));
        }
        table.setModified(this.isModified());
        return table;
    }

    public String generateCreateSQL() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("IF NOT EXISTS (SELECT 1 FROM KSQL_USERTABLES WHERE KSQL_TABNAME = '%s') ", this.getTableName().toUpperCase(Locale.ENGLISH)));
        sb.append("\r\n");
        sb.append(String.format(" CREATE TABLE %s (", this.getTableName().toUpperCase(Locale.ENGLISH)));
        for (ColumnAp columnAp : this.getColumns()) {
            sb.append("\r\n");
            sb.append(columnAp.getCreateSQL());
            sb.append(",");
        }
        sb.setLength(sb.length() - 1);
        sb.append("\r\n");
        sb.append(")");
        sb.append(";");
        sb.append("\r\n");
        sb.append("\r\n");
        return sb.toString();
    }

    public String generateDropSQL() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("IF EXISTS (SELECT 1 FROM KSQL_USERTABLES WHERE KSQL_TABNAME = '%s') ", this.getTableName().toLowerCase(Locale.ENGLISH)));
        sb.append("\r\n");
        sb.append(String.format(" DROP TABLE %s;", this.getTableName().toUpperCase(Locale.ENGLISH)));
        sb.append("\r\n");
        return sb.toString();
    }

    public String generateConstraintSQL() {
        String sql = null;
        PrimaryKeyAp primaryKeyAp = this.getPrimaryKey();
        if (primaryKeyAp != null && StringUtils.isNotEmpty((CharSequence)primaryKeyAp.getPk())) {
            StringBuilder colList = new StringBuilder();
            List<RefColumnAp> columnApList = primaryKeyAp.getPkColumnList();
            if (!columnApList.isEmpty()) {
                for (RefColumnAp columnAp : columnApList) {
                    colList.append(this.getColumnName(columnAp.getRefId()));
                    colList.append(",");
                }
                colList.setLength(colList.length() - 1);
            }
            String clustered = primaryKeyAp.isCluster() ? "1" : "0";
            sql = String.format(" EXEC p_AlterPK '%1$s', '%2$s', '%3$s', '%4$s';\r\n", primaryKeyAp.getPk(), this.getTableName(), colList, clustered);
            sql = sql.toUpperCase(Locale.ENGLISH);
        }
        return sql;
    }

    public String getColumnName(String id) {
        List<ColumnAp> columns = this.getColumns();
        String columnName = null;
        for (ColumnAp columnAp : columns) {
            if (id == null || !id.equals(columnAp.getId())) continue;
            columnName = columnAp.getColumnName();
            break;
        }
        return columnName;
    }

    public String generateIndexSQL() {
        StringBuilder sIndexes = new StringBuilder();
        for (IndexAp index : this.getIndexs()) {
            sIndexes.append(index.getIndexSQL(this));
            sIndexes.append("\r\n");
        }
        return sIndexes.toString();
    }

    public String generateDropIndexes(String[] idxNames) {
        if (idxNames == null || idxNames.length == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (String idxName : idxNames) {
            sb.append(this.generateDropIndex(idxName));
            sb.append("\n");
        }
        return sb.toString();
    }

    public String generateDropIndex(String idxName) {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("EXEC p_DropIdx '%s', '%s';", idxName, this.getTableName()));
        return sb.toString();
    }

    public String getAddColumnsSQL(ColumnAp col) {
        if (col == null) {
            return null;
        }
        return this.getAddColumnsSQL(new ColumnAp[]{col});
    }

    String getAddColumnsSQL(ColumnAp[] cols) {
        if (cols == null || cols.length == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean flag = false;
        String tableName = this.getTableName().toUpperCase(Locale.ENGLISH);
        sb.append(String.format("IF NOT EXISTS (SELECT 1 FROM KSQL_USERCOLUMNS WHERE KSQL_COL_TABNAME = '%s' AND KSQL_COL_NAME ='%s') ", tableName, cols[0].getColumnName()));
        sb.append("\n");
        sb.append(String.format(" ALTER TABLE %s ADD (", tableName));
        for (ColumnAp col : cols) {
            if (flag) {
                sb.append(", ");
            }
            flag = true;
            long length = col.getColumnLength();
            int scale = col.getColumnPrecision();
            int colunmType = col.getColunmType();
            DataType dataType = DataType.valueOf((int)colunmType);
            sb.append(ColumnAp.getAddColumnScript(col.getColumnName(), dataType.name().toUpperCase(Locale.ENGLISH), length, scale, !col.isNotNull(), col.getColumnDef()));
        }
        sb.append(" );");
        return sb.toString();
    }

    public String getAlterColumnSQL(ColumnAp col) throws Exception {
        if (col == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        ColumnAp newCol = null;
        for (ColumnAp column : this.getColumns()) {
            if (!col.getColumnName().equalsIgnoreCase(column.getColumnName())) continue;
            newCol = column;
            break;
        }
        if (newCol == null) {
            throw new Exception("\u672a\u627e\u5230\u8be5\u5217\uff0c\u8bf7\u4f7f\u7528\u65b0\u589e\u5217\u65b9\u5f0f\uff01");
        }
        if (newCol.getColunmType() != col.getColunmType()) {
            throw new Exception("\u5217\u7c7b\u578b\u4e0d\u540c\uff0c\u4e0d\u80fd\u751f\u6210\uff01");
        }
        this.alterColumn(sb, col);
        return sb.toString();
    }

    String GetDropColumnSQL(ColumnAp[] cols) {
        if (cols == null || cols.length == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean flag = false;
        sb.append(String.format(" ALTER TABLE %s  DROP COLUMN (", this.getTableName()));
        for (ColumnAp col : cols) {
            if (flag) {
                sb.append(", ");
            }
            flag = true;
            sb.append(col.getColumnName());
        }
        sb.append(" );");
        sb.append("\n");
        return sb.toString();
    }

    private void alterColumn(StringBuilder sb, ColumnAp newCol) {
        String tableName = this.getTableName();
        String newColName = newCol.getColumnName();
        sb.append(String.format(" IF EXISTS (SELECT 1 FROM KSQL_USERCOLUMNS A INNER JOIN KSQL_CONSTRAINTS B ON A.TABLE_NAME = B.TABLE_NAME  WHERE A.TABLE_NAME = %s AND A.COLUMN_NAME = %s)", tableName, newColName));
        sb.append(String.format(" ALTER TABLE %s ALTER %s %s ", tableName, newColName, DataType.valueOf((int)newCol.getColunmType()).name().toUpperCase(Locale.ENGLISH)));
        long length = newCol.getColumnLength();
        int scale = newCol.getColumnPrecision();
        int colType = newCol.getColunmType();
        if (length > 0L && colType != DataType.INT.getValue() && colType != DataType.DATETIME.getValue()) {
            sb.append("(").append(newCol.getColumnLength());
            if (scale > 0) {
                sb.append(",").append(newCol.getColumnPrecision());
            }
            sb.append(")");
        }
        if (newCol.isNotNull()) {
            sb.append(" NOT NULL");
        }
        sb.append(" ;");
    }
}

