/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.datamodel.metadata;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.CollectionPropertyAttribute;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.datamodel.meta.element.BaseControl;
import kd.bos.datamodel.meta.element.DMPackageAp;
import kd.bos.datamodel.meta.element.DataModelAp;
import kd.bos.datamodel.meta.element.DataModelBaseElement;
import kd.bos.datamodel.meta.element.pdm.PhysicalDiagram;
import kd.bos.datamodel.metadata.AbstractDataModelMetadata;
import kd.bos.datamodel.metadata.DataModelDesignMeta;
import kd.bos.datamodel.metadata.pdm.PDMDiagramMetadata;
import kd.bos.datamodel.metadata.pdm.PDMEntityMetadata;
import kd.bos.metadata.AbstractMetadata;

public class DMClientMetadata
extends AbstractMetadata {
    private String product;
    private String number;
    private long creator;
    private Date createdDate;
    private long version;
    private LocaleString name;
    private LocaleString description;
    private List<BaseControl> items = new ArrayList<BaseControl>(10);

    public PDMEntityMetadata convertToDataModelMeta() {
        PDMEntityMetadata pdmMetadata = new PDMEntityMetadata();
        this.setMetadata(pdmMetadata);
        DataModelAp rootAp = null;
        if (this.items != null) {
            ArrayList<DMPackageAp> packageAps = new ArrayList<DMPackageAp>(10);
            ArrayList<PhysicalDiagram> physicalDiagrams = new ArrayList<PhysicalDiagram>(10);
            HashMap childMapping = new HashMap(5);
            for (Object item : this.items) {
                childMapping.putIfAbsent(item.getParentId(), new ArrayList(10));
                ((List)childMapping.get(item.getParentId())).add(item);
                if (item instanceof DMPackageAp) {
                    packageAps.add((DMPackageAp)((Object)item));
                }
                if (!(item instanceof PhysicalDiagram)) continue;
                physicalDiagrams.add((PhysicalDiagram)((Object)item));
            }
            for (Object item : this.items) {
                List list;
                if (item instanceof DataModelAp) {
                    rootAp = (DataModelAp)((Object)item);
                    continue;
                }
                if (!(item instanceof DataModelBaseElement) || (list = (List)childMapping.get(item.getId())) == null) continue;
                ((DataModelBaseElement)((Object)item)).getItems().addAll(list);
            }
            int pacakageIdx = 0;
            for (DMPackageAp dMPackageAp : packageAps) {
                dMPackageAp.setSeq(pacakageIdx);
                dMPackageAp.createControl();
                ++pacakageIdx;
            }
            int phyIdx = 0;
            for (PhysicalDiagram physicalDiagram : physicalDiagrams) {
                physicalDiagram.setSeq(phyIdx);
                physicalDiagram.createControl();
                ++phyIdx;
            }
            pdmMetadata.setPackageAps(packageAps);
            this.setRootMeta(pdmMetadata, rootAp);
            PDMDiagramMetadata pDMDiagramMetadata = new PDMDiagramMetadata();
            this.setMetadata(pDMDiagramMetadata);
            this.setRootMeta(pDMDiagramMetadata, rootAp);
            if (!physicalDiagrams.isEmpty()) {
                pDMDiagramMetadata.setPhysicalDiagramAps(physicalDiagrams);
            }
            pdmMetadata.setPdmDiagramMetadata(pDMDiagramMetadata);
        }
        return pdmMetadata;
    }

    private void setRootMeta(AbstractDataModelMetadata dataModelMetadata, DataModelAp rootAp) {
        if (rootAp != null) {
            dataModelMetadata.setNumber(rootAp.getKey());
            dataModelMetadata.setName(rootAp.getName());
            dataModelMetadata.setDescription(new LocaleString(rootAp.getDescription()));
        }
    }

    private void setMetadata(AbstractDataModelMetadata dataModelMetadata) {
        dataModelMetadata.setId(this.getId());
        dataModelMetadata.setProduct(this.getProduct());
        dataModelMetadata.setBizappId(this.getBizappId());
        dataModelMetadata.setNumber(this.getNumber());
        dataModelMetadata.setName(this.getName());
        dataModelMetadata.setDescription(this.getDescription());
        dataModelMetadata.setCreator(this.getCreator());
        dataModelMetadata.setCreatedDate(this.getCreatedDate());
        dataModelMetadata.setVersion(this.getVersion());
        dataModelMetadata.setIsv(this.getIsv());
        dataModelMetadata.setParentId(this.getParentId());
        dataModelMetadata.setMasterId(this.getMasterId());
        dataModelMetadata.setModifierId(String.valueOf(RequestContext.get().getCurrUserId()));
        dataModelMetadata.setModifyDate(new Date());
    }

    public void endInit() {
    }

    private void sortItems() {
        Collections.sort(this.items, new Comparator<BaseControl>(){

            @Override
            public int compare(BaseControl o1, BaseControl o2) {
                int compareValue = 0;
                compareValue = o1.getParentId() == null && o2.getParentId() == null ? 0 : (o1.getParentId() == null && o2.getParentId() != null ? -1 : (o1.getParentId() != null && o2.getParentId() == null ? 1 : o1.getParentId().compareTo(o2.getParentId())));
                if (compareValue != 0) {
                    return compareValue;
                }
                if (o1 instanceof DataModelBaseElement && o2 instanceof DataModelBaseElement) {
                    return Integer.compare(((DataModelBaseElement)o1).getSeq(), ((DataModelBaseElement)o2).getSeq());
                }
                return compareValue;
            }
        });
    }

    @CollectionPropertyAttribute(collectionItemPropertyType=BaseControl.class)
    public List<BaseControl> getItems() {
        return this.items;
    }

    public void setItems(List<BaseControl> items) {
        this.items = items;
    }

    public String getModelType() {
        return "PhysicalDataModel";
    }

    public IDataEntityType getDesingerMetaType() {
        return OrmUtils.getDataEntityType(DataModelDesignMeta.class);
    }

    public IDataEntityType getDesingerMetaLType() {
        return null;
    }

    @SimplePropertyAttribute
    public String getProduct() {
        return this.product;
    }

    public void setProduct(String product) {
        this.product = product;
    }

    @SimplePropertyAttribute
    public long getCreator() {
        return this.creator;
    }

    public void setCreator(long creator) {
        this.creator = creator;
    }

    @SimplePropertyAttribute
    public Date getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
    }

    @SimplePropertyAttribute
    public long getVersion() {
        return this.version;
    }

    public void setVersion(long version) {
        this.version = version;
    }

    @SimplePropertyAttribute
    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    @SimplePropertyAttribute
    public LocaleString getName() {
        return this.name;
    }

    public void setName(LocaleString name) {
        this.name = name;
    }

    @SimplePropertyAttribute
    public LocaleString getDescription() {
        return this.description;
    }

    public void setDescription(LocaleString description) {
        this.description = description;
    }
}

