/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.datamodel.metadata.dao;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.metadata.database.DbMetadataTable;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.datamodel.meta.element.pdm.ColumnAp;
import kd.bos.datamodel.meta.element.pdm.IndexAp;
import kd.bos.datamodel.meta.element.pdm.PrimaryKeyAp;
import kd.bos.datamodel.meta.element.pdm.RefColumnAp;
import kd.bos.datamodel.meta.element.pdm.TableAp;
import kd.bos.datamodel.pdm.model.DataType;
import kd.bos.db.SqlObject;
import kd.bos.entity.ca.CertRule;
import kd.bos.metadata.dao.AlterTableUtil;
import kd.bos.metadata.dao.IAlterTableUtil;
import kd.bos.metadata.dao.ShardingUtil;
import kd.bos.metadata.entity.BillEntity;
import kd.bos.metadata.entity.Entity;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.EntryEntity;
import kd.bos.metadata.entity.ITreeEntryEntity;
import kd.bos.metadata.entity.LinkEntryEntity;
import kd.bos.metadata.entity.MainEntity;
import kd.bos.metadata.entity.SubEntryEntity;
import kd.bos.metadata.entity.businessfield.MulBasedataField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.IDBField;
import kd.bos.metadata.entity.commonfield.MuliLangTextField;
import kd.bos.mservice.svc.attach.IAttachmentField;

class DMAlterTableUtilImpl
implements IAlterTableUtil {
    private static final String FPK_ID = "FPKID";

    DMAlterTableUtilImpl() {
    }

    public void genCreateTableSql(EntityMetadata entityMetadata, Entity<?, ?> entity, String tableName, List<SqlObject> sqlList, boolean useSharding, String trackParentTableName) {
        String entryParentPkField;
        ColumnAp columnAp;
        List entityList = entityMetadata.getEntitys();
        String pkFieldName = null;
        int pkFieldType = -5;
        for (Entity billEntity : entityList) {
            if (!(billEntity instanceof BillEntity)) continue;
            pkFieldName = ((BillEntity)billEntity).getPkFieldName();
            pkFieldType = ((BillEntity)billEntity).getPkType() == 0 ? -9 : -5;
            break;
        }
        TableAp tableAp = new TableAp();
        tableAp.setTableName(tableName);
        if (useSharding) {
            ShardingUtil.ensureAdd2CurrentRuntimeShardingConfig((EntityMetadata)entityMetadata, entity, (String)tableName, (String)trackParentTableName);
        }
        if (entity instanceof SubEntryEntity || entity instanceof LinkEntryEntity) {
            EntityItem parentItem = entityMetadata.getItemById(entity.getParentId());
            if (!(parentItem instanceof BillEntity)) {
                if (parentItem instanceof EntryEntity) {
                    pkFieldName = ((EntryEntity)parentItem).getEntryPkFieldName();
                } else if (parentItem == null) {
                    return;
                }
            }
            columnAp = this.getPkFieldType(pkFieldType);
            columnAp.setColumnName(pkFieldName);
            columnAp.setNotNull(true);
            tableAp.getColumns().add(columnAp);
        } else {
            if (entity instanceof EntryEntity && ((EntryEntity)entity).getFkFieldName() != null) {
                pkFieldName = ((EntryEntity)entity).getFkFieldName();
            }
            ColumnAp columnAp2 = this.getPkFieldType(pkFieldType);
            columnAp2.setColumnName(pkFieldName);
            columnAp2.setNotNull(true);
            tableAp.getColumns().add(columnAp2);
        }
        boolean existsEntryPKFieldName = false;
        if (!(entity instanceof MainEntity) && !StringUtils.isEmpty((CharSequence)((EntryEntity)entity).getEntryPkFieldName())) {
            columnAp = this.getPkFieldType(pkFieldType);
            columnAp.setColumnName(((EntryEntity)entity).getEntryPkFieldName());
            columnAp.setNotNull(true);
            tableAp.getColumns().add(columnAp);
            existsEntryPKFieldName = true;
        }
        if (!(entity instanceof MainEntity) && !StringUtils.isEmpty((CharSequence)entity.getKey()) && tableName.equalsIgnoreCase(entity.getTableName())) {
            columnAp = new ColumnAp();
            columnAp.setColunmType(DataType.INT.getValue());
            columnAp.setColumnName(((EntryEntity)entity).getSeqFieldName());
            columnAp.setColumnDef("0");
            columnAp.setNotNull(true);
            tableAp.getColumns().add(columnAp);
        }
        if (entity instanceof ITreeEntryEntity && StringUtils.isNotBlank((CharSequence)(entryParentPkField = ((ITreeEntryEntity)entity).getEntryParentPkFieldName()))) {
            ColumnAp columnAp3 = this.getPkFieldType(pkFieldType);
            columnAp3.setColumnName(entryParentPkField);
            columnAp3.setColumnDef("0");
            columnAp3.setNotNull(true);
            tableAp.getColumns().add(columnAp3);
        }
        if (entity instanceof BillEntity && StringUtils.isNotBlank((CharSequence)((BillEntity)entity).getEntityTypeId()) && tableName.equalsIgnoreCase(entity.getTableName())) {
            columnAp = this.getVarChar36NotNull();
            columnAp.setColumnName(((BillEntity)entity).getEntityTypeId());
            tableAp.getColumns().add(columnAp);
        }
        if (!StringUtils.isEmpty((CharSequence)entity.getSrcEntityDisaKey())) {
            // empty if block
        }
        ArrayList<IAttachmentField> attachmentFields = new ArrayList<IAttachmentField>(6);
        ArrayList<MulBasedataField> mulBDFields = new ArrayList<MulBasedataField>(6);
        ArrayList<MuliLangTextField> mulLangFields = new ArrayList<MuliLangTextField>(6);
        ArrayList fieldsCommentSql = new ArrayList(6);
        List entityItem = entity.getItems();
        for (EntityItem item : entityItem) {
            if (!(item instanceof Field)) continue;
            Field field = (Field)item;
            if (field instanceof IAttachmentField) {
                attachmentFields.add((IAttachmentField)field);
                continue;
            }
            if (field instanceof MulBasedataField) {
                mulBDFields.add((MulBasedataField)field);
                continue;
            }
            if (field instanceof MuliLangTextField && !StringUtils.isEmpty((CharSequence)field.getFieldName())) {
                mulLangFields.add((MuliLangTextField)field);
                if (!((MuliLangTextField)field).isGL()) continue;
            }
            if (!tableName.equalsIgnoreCase(field.getTableName(entity))) continue;
            List fields = field.getDBFields();
            for (IDBField idbField : fields) {
                ColumnAp columnAp4 = this.getColumnAp(idbField);
                tableAp.getColumns().add(columnAp4);
                idbField.generateFieldsComment(tableName, fieldsCommentSql);
            }
        }
        PrimaryKeyAp primaryKeyAp = new PrimaryKeyAp();
        String pkName = "pk_" + (tableName.length() > 2 ? tableName.substring(2) : tableName);
        primaryKeyAp.setPk(pkName);
        RefColumnAp pkRef = new RefColumnAp();
        String colName = existsEntryPKFieldName ? ((EntryEntity)entity).getEntryPkFieldName() : pkFieldName;
        pkRef.setRefId(colName);
        primaryKeyAp.getPkColumnList().add(pkRef);
        tableAp.setPrimaryKey(primaryKeyAp);
        String sqlCreateTable = tableAp.generateCreateSQL();
        sqlList.add(new SqlObject(sqlCreateTable, (kd.bos.db.SqlParameter[])new SqlParameter[0]));
        String constraintSQL = tableAp.generateConstraintSQL();
        sqlList.add(new SqlObject(constraintSQL, (kd.bos.db.SqlParameter[])new SqlParameter[0]));
        if (existsEntryPKFieldName) {
            IndexAp indexAp = new IndexAp();
            String idxName = String.format("idx_%s_fk", tableName.length() > 2 ? tableName.substring(2) : tableName);
            indexAp.setIndexName(idxName);
            indexAp.setTableName(tableName);
            RefColumnAp idxRef = new RefColumnAp();
            idxRef.setRefId(pkFieldName);
            indexAp.getIndexColumnAps().add(idxRef);
            tableAp.getIndexs().add(indexAp);
            String sqlFKIndex = tableAp.generateIndexSQL();
            sqlList.add(new SqlObject(sqlFKIndex, (kd.bos.db.SqlParameter[])new SqlParameter[0]));
        }
        if (mulLangFields.size() > 0 && tableName.equalsIgnoreCase(entity.getTableName())) {
            this.genAlertMulLangTableSQL(entityMetadata, entity, mulLangFields, sqlList, useSharding);
        }
        if (entity instanceof BillEntity && ((BillEntity)entity).getSignField().size() > 0 && ((CertRule)((BillEntity)entity).getSignField().get(0)).getSignoperate().size() > 0) {
            this.genAlertSignTableSQL(entityMetadata, entity, sqlList);
        }
        if (mulBDFields.size() > 0 && tableName.equalsIgnoreCase(entity.getTableName())) {
            this.genAlertMulBsdTableSQL(entityMetadata, entity, mulBDFields, sqlList);
        }
        if (attachmentFields.size() > 0 && tableName.equalsIgnoreCase(entity.getTableName())) {
            this.genAlertAttachmentTableSQL(entityMetadata, entity, attachmentFields, sqlList);
        }
        if (entity instanceof MainEntity && tableName.equalsIgnoreCase(entity.getTableName())) {
            this.genIssueTableSQL(entityMetadata, entity, sqlList);
        }
        if (entity instanceof MainEntity && !StringUtils.isEmpty((CharSequence)tableName) && tableName.equalsIgnoreCase(entity.getTableName())) {
            this.GenAlertTVRelationTableSQL(entityMetadata, entity, sqlList);
        }
        for (String fieldComment : fieldsCommentSql) {
            sqlList.add(new SqlObject(fieldComment, (kd.bos.db.SqlParameter[])new SqlParameter[0]));
        }
    }

    private ColumnAp getVarChar36NotNull() {
        ColumnAp columnAp = new ColumnAp();
        columnAp.setColunmType(DataType.VARCHAR.getValue());
        columnAp.setColumnLength(36);
        columnAp.setColumnDef("''");
        columnAp.setNotNull(true);
        return columnAp;
    }

    private void genAlertMulLangTableSQL(EntityMetadata entityMetadata, Entity<?, ?> entity, List<MuliLangTextField> multiLangFields, List<SqlObject> sqlList, boolean useSharding) {
        String mulLangTablePKField = FPK_ID;
        String defaultValue = "";
        String pkFieldName = null;
        int pkFieldType = -5;
        int mulLangPkFieldType = -9;
        if (StringUtils.isEmpty((CharSequence)entity.getTableName())) {
            return;
        }
        for (Entity billEntity : entityMetadata.getEntitys()) {
            if (!(billEntity instanceof BillEntity)) continue;
            pkFieldName = ((BillEntity)billEntity).getPkFieldName();
            mulLangPkFieldType = -9;
            pkFieldType = ((BillEntity)billEntity).getPkType() == 0 ? -9 : -5;
            break;
        }
        String mulLangTableName = entity.getTableName() + "_L";
        DbMetadataTable tableSchema = AlterTableUtil.getTableSchema((String)entityMetadata.getDBRouteKey(), (String)mulLangTableName, (boolean)false);
        if (pkFieldType == -9) {
            defaultValue = "' '";
        } else if (pkFieldType == -5) {
            defaultValue = "0";
        }
        TableAp tableAp = new TableAp();
        tableAp.setTableName(mulLangTableName);
        if (null == tableSchema) {
            String sql;
            ColumnAp columnAp;
            if (useSharding) {
                ShardingUtil.ensureAdd2CurrentRuntimeShardingConfig((EntityMetadata)entityMetadata, entity, (String)mulLangTableName.toLowerCase(), null);
            }
            ColumnAp pkCol = this.getPkFieldType(mulLangPkFieldType);
            pkCol.setColumnName(mulLangTablePKField);
            pkCol.setNotNull(true);
            tableAp.getColumns().add(pkCol);
            String sqlCreateTab = tableAp.generateCreateSQL();
            sqlList.add(new SqlObject(sqlCreateTab, (kd.bos.db.SqlParameter[])new SqlParameter[0]));
            PrimaryKeyAp primaryKeyAp = new PrimaryKeyAp();
            String pkName = "pk_" + (mulLangTableName.length() > 2 ? mulLangTableName.substring(2) : mulLangTableName);
            primaryKeyAp.setPk(pkName);
            RefColumnAp pkRef = new RefColumnAp();
            pkRef.setRefId(mulLangTablePKField);
            primaryKeyAp.getPkColumnList().add(pkRef);
            tableAp.setPrimaryKey(primaryKeyAp);
            String constraintSQL = tableAp.generateConstraintSQL();
            sqlList.add(new SqlObject(constraintSQL, (kd.bos.db.SqlParameter[])new SqlParameter[0]));
            if (entity instanceof MainEntity) {
                columnAp = this.getPkFieldType(pkFieldType);
                columnAp.setColumnName(pkFieldName);
                columnAp.setNotNull(true);
                columnAp.setColumnDef(defaultValue);
                sql = tableAp.getAddColumnsSQL(columnAp);
                sqlList.add(new SqlObject(sql, (kd.bos.db.SqlParameter[])new SqlParameter[0]));
            }
            if (!(entity instanceof MainEntity) && !StringUtils.isEmpty((CharSequence)((EntryEntity)entity).getEntryPkFieldName())) {
                columnAp = this.getPkFieldType(pkFieldType);
                columnAp.setColumnName(((EntryEntity)entity).getEntryPkFieldName());
                columnAp.setNotNull(true);
                columnAp.setColumnDef(defaultValue);
                sql = tableAp.getAddColumnsSQL(columnAp);
                sqlList.add(new SqlObject(sql, (kd.bos.db.SqlParameter[])new SqlParameter[0]));
            }
            ColumnAp fLocaleId = this.getfLocaleId();
            sql = tableAp.getAddColumnsSQL(fLocaleId);
            sqlList.add(new SqlObject(sql, (kd.bos.db.SqlParameter[])new SqlParameter[0]));
            String entryPkId = entity instanceof EntryEntity ? ((EntryEntity)entity).getEntryPkFieldName() : ((BillEntity)entity).getPkFieldName();
            IndexAp indexAp = new IndexAp();
            String idxName = "idx_" + mulLangTableName.substring(2) + "_0";
            indexAp.setIndexName(idxName);
            indexAp.setTableName(mulLangTableName);
            RefColumnAp idxRef = new RefColumnAp();
            idxRef.setRefId(entryPkId);
            indexAp.getIndexColumnAps().add(idxRef);
            RefColumnAp idxRef2 = new RefColumnAp();
            idxRef2.setRefId("FLocaleId");
            indexAp.getIndexColumnAps().add(idxRef2);
            indexAp.setUnique(true);
            tableAp.getIndexs().add(indexAp);
            String sqlFKIndex = tableAp.generateIndexSQL();
            sqlList.add(new SqlObject(sqlFKIndex, (kd.bos.db.SqlParameter[])new SqlParameter[0]));
        } else {
            String sql;
            ColumnAp columnAp;
            if (!DMAlterTableUtilImpl.existsFieldInTableSchema(tableSchema, mulLangTablePKField)) {
                columnAp = this.getPkFieldType(pkFieldType);
                columnAp.setColumnName(mulLangTablePKField);
                columnAp.setNotNull(true);
                columnAp.setColumnDef(defaultValue);
                sql = tableAp.getAddColumnsSQL(columnAp);
                sqlList.add(new SqlObject(sql, (kd.bos.db.SqlParameter[])new SqlParameter[0]));
            }
            if (entity instanceof MainEntity && !DMAlterTableUtilImpl.existsFieldInTableSchema(tableSchema, pkFieldName)) {
                columnAp = this.getPkFieldType(pkFieldType);
                columnAp.setColumnName(pkFieldName);
                columnAp.setNotNull(true);
                columnAp.setColumnDef(defaultValue);
                sql = tableAp.getAddColumnsSQL(columnAp);
                sqlList.add(new SqlObject(sql, (kd.bos.db.SqlParameter[])new SqlParameter[0]));
            }
            if (!(entity instanceof MainEntity) && !DMAlterTableUtilImpl.existsFieldInTableSchema(tableSchema, ((EntryEntity)entity).getEntryPkFieldName())) {
                columnAp = this.getPkFieldType(pkFieldType);
                columnAp.setColumnName(((EntryEntity)entity).getEntryPkFieldName());
                columnAp.setNotNull(true);
                columnAp.setColumnDef(defaultValue);
                sql = tableAp.getAddColumnsSQL(columnAp);
                sqlList.add(new SqlObject(sql, (kd.bos.db.SqlParameter[])new SqlParameter[0]));
            }
            if (!DMAlterTableUtilImpl.existsFieldInTableSchema(tableSchema, "FLocaleID")) {
                ColumnAp fLocaleId = this.getfLocaleId();
                sql = tableAp.getAddColumnsSQL(fLocaleId);
                sqlList.add(new SqlObject(sql, (kd.bos.db.SqlParameter[])new SqlParameter[0]));
            }
        }
        for (MuliLangTextField field : multiLangFields) {
            String sql;
            ColumnAp columnAp;
            if (StringUtils.isNotEmpty((CharSequence)field.getFieldName()) && !DMAlterTableUtilImpl.existsFieldInTableSchema(tableSchema, field.getFieldName())) {
                columnAp = this.getColumnAp((IDBField)field);
                sql = tableAp.getAddColumnsSQL(columnAp);
                sqlList.add(new SqlObject(sql, (kd.bos.db.SqlParameter[])new SqlParameter[0]));
            }
            if (field.isEncrypt() && StringUtils.isNotEmpty((CharSequence)field.getEncryptFieldName()) && !DMAlterTableUtilImpl.existsFieldInTableSchema(tableSchema, field.getEncryptFieldName())) {
                columnAp = this.getColumnAp((IDBField)field);
                sql = tableAp.getAddColumnsSQL(columnAp);
                sqlList.add(new SqlObject(sql, (kd.bos.db.SqlParameter[])new SqlParameter[0]));
            }
            if (!field.isPrivacyField() || !StringUtils.isNotEmpty((CharSequence)field.getFieldName()) || DMAlterTableUtilImpl.existsFieldInTableSchema(tableSchema, field.getFieldName() + "_pr")) continue;
            columnAp = this.getColumnAp((IDBField)field);
            sql = tableAp.getAddColumnsSQL(columnAp);
            sqlList.add(new SqlObject(sql, (kd.bos.db.SqlParameter[])new SqlParameter[0]));
        }
    }

    private void genAlertSignTableSQL(EntityMetadata entityMetadata, Entity<?, ?> entity, List<SqlObject> sqlList) {
        String pkFieldName = null;
        int pkFieldType = -5;
        if (StringUtils.isEmpty((CharSequence)entity.getTableName())) {
            return;
        }
        for (Entity billEntity : entityMetadata.getEntitys()) {
            if (!(billEntity instanceof BillEntity)) continue;
            pkFieldName = ((BillEntity)billEntity).getPkFieldName();
            pkFieldType = ((BillEntity)billEntity).getPkType() == 0 ? -9 : -5;
            break;
        }
        String signTableName = entity.getTableName() + "_SN";
        DbMetadataTable tableSchema = AlterTableUtil.getTableSchema((String)entityMetadata.getDBRouteKey(), (String)signTableName, (boolean)false);
        TableAp tableAp = new TableAp();
        tableAp.setTableName(signTableName);
        if (null == tableSchema) {
            ColumnAp pkCol = this.getPkFieldType(pkFieldType);
            pkCol.setColumnName(pkFieldName);
            pkCol.setNotNull(true);
            tableAp.getColumns().add(pkCol);
            String sqlCreateTab = tableAp.generateCreateSQL();
            sqlList.add(new SqlObject(sqlCreateTab, (kd.bos.db.SqlParameter[])new SqlParameter[0]));
            PrimaryKeyAp primaryKeyAp = new PrimaryKeyAp();
            String pkName = "pk_" + (signTableName.length() > 2 ? signTableName.substring(2) : signTableName);
            primaryKeyAp.setPk(pkName);
            RefColumnAp pkRef = new RefColumnAp();
            pkRef.setRefId(pkFieldName);
            primaryKeyAp.getPkColumnList().add(pkRef);
            tableAp.setPrimaryKey(primaryKeyAp);
            String constraintSQL = tableAp.generateConstraintSQL();
            sqlList.add(new SqlObject(constraintSQL, (kd.bos.db.SqlParameter[])new SqlParameter[0]));
            ColumnAp fCleartext = this.getNClob("FCLEARTEXT");
            String sqlClearText = tableAp.getAddColumnsSQL(fCleartext);
            sqlList.add(new SqlObject(sqlClearText, (kd.bos.db.SqlParameter[])new SqlParameter[0]));
            ColumnAp fSigntext = new ColumnAp();
            fSigntext.setColunmType(DataType.VARCHAR.getValue());
            fSigntext.setColumnLength(500);
            fSigntext.setNotNull(true);
            fSigntext.setColumnName("FSIGNTEXT");
            String sqlSigntext = tableAp.getAddColumnsSQL(fSigntext);
            sqlList.add(new SqlObject(sqlSigntext, (kd.bos.db.SqlParameter[])new SqlParameter[0]));
            ColumnAp fUserId = this.getfUserId();
            String sqlUserId = tableAp.getAddColumnsSQL(fUserId);
            sqlList.add(new SqlObject(sqlUserId, (kd.bos.db.SqlParameter[])new SqlParameter[0]));
            IndexAp indexAp = new IndexAp();
            String idxName = "idx_" + signTableName + "_SIGNID";
            indexAp.setIndexName(idxName);
            indexAp.setTableName(signTableName);
            RefColumnAp idxRef = new RefColumnAp();
            idxRef.setRefId("FID");
            indexAp.getIndexColumnAps().add(idxRef);
            tableAp.getIndexs().add(indexAp);
            String sqlFKIndex = tableAp.generateIndexSQL();
            sqlList.add(new SqlObject(sqlFKIndex, (kd.bos.db.SqlParameter[])new SqlParameter[0]));
        } else {
            if (!DMAlterTableUtilImpl.existsFieldInTableSchema(tableSchema, pkFieldName)) {
                ColumnAp pkCol = this.getPkFieldType(pkFieldType);
                pkCol.setColumnName(pkFieldName);
                pkCol.setNotNull(true);
                String sql = tableAp.getAddColumnsSQL(pkCol);
                sqlList.add(new SqlObject(sql, (kd.bos.db.SqlParameter[])new SqlParameter[0]));
            }
            if (!DMAlterTableUtilImpl.existsFieldInTableSchema(tableSchema, "FCLEARTEXT")) {
                ColumnAp fCleartext = this.getNClob("FCLEARTEXT");
                String sqlClearText = tableAp.getAddColumnsSQL(fCleartext);
                sqlList.add(new SqlObject(sqlClearText, (kd.bos.db.SqlParameter[])new SqlParameter[0]));
            }
            if (!DMAlterTableUtilImpl.existsFieldInTableSchema(tableSchema, "FSIGNTEXT")) {
                ColumnAp fSigntext = new ColumnAp();
                fSigntext.setColunmType(DataType.VARCHAR.getValue());
                fSigntext.setColumnLength(500);
                fSigntext.setNotNull(true);
                fSigntext.setColumnName("FSIGNTEXT");
                String sqlSigntext = tableAp.getAddColumnsSQL(fSigntext);
                sqlList.add(new SqlObject(sqlSigntext, (kd.bos.db.SqlParameter[])new SqlParameter[0]));
            }
            if (!DMAlterTableUtilImpl.existsFieldInTableSchema(tableSchema, "FUSERID")) {
                ColumnAp fUserId = this.getfUserId();
                String sqlUserId = tableAp.getAddColumnsSQL(fUserId);
                sqlList.add(new SqlObject(sqlUserId, (kd.bos.db.SqlParameter[])new SqlParameter[0]));
            }
        }
    }

    private void genAlertMulBsdTableSQL(EntityMetadata entityMetadata, Entity<?, ?> entity, List<MulBasedataField> mulBasedataFields, List<SqlObject> sqlList) {
        String mulBsdTablePKField = FPK_ID;
        String bsdFKField = "FBasedataId";
        if (StringUtils.isEmpty((CharSequence)entity.getTableName())) {
            return;
        }
        MainEntity rootEntity = entityMetadata.getRootEntity();
        if (rootEntity == null || !(rootEntity instanceof BillEntity)) {
            return;
        }
        String pkFieldName = ((BillEntity)rootEntity).getPkFieldName();
        int pkFieldType = ((BillEntity)rootEntity).getPkType() == 0 ? -9 : -5;
        String fkFieldName = pkFieldName;
        if (entity instanceof EntryEntity) {
            fkFieldName = ((EntryEntity)entity).getEntryPkFieldName();
        }
        if (StringUtils.isBlank((CharSequence)fkFieldName)) {
            return;
        }
        for (MulBasedataField mulBsdfield : mulBasedataFields) {
            String mulBsdTableName = mulBsdfield.getTableName();
            DbMetadataTable tableSchema = AlterTableUtil.getTableSchema((String)entityMetadata.getDBRouteKey(), (String)mulBsdTableName, (boolean)false);
            if (null != tableSchema || !StringUtils.isNotBlank((CharSequence)mulBsdTableName)) continue;
            TableAp tableAp = new TableAp();
            tableAp.setTableName(mulBsdTableName);
            ColumnAp pkCol = this.getPkFieldType(-5);
            pkCol.setColumnName(mulBsdTablePKField);
            pkCol.setNotNull(true);
            tableAp.getColumns().add(pkCol);
            ColumnAp fkCol = this.getPkFieldType(pkFieldType);
            fkCol.setColumnName(fkFieldName);
            fkCol.setNotNull(true);
            tableAp.getColumns().add(fkCol);
            ColumnAp bsdCol = this.getPkFieldType(mulBsdfield.getFieldDBType());
            bsdCol.setColumnName(bsdFKField);
            bsdCol.setNotNull(true);
            tableAp.getColumns().add(bsdCol);
            String sqlCreateTab = tableAp.generateCreateSQL();
            sqlList.add(new SqlObject(sqlCreateTab, (kd.bos.db.SqlParameter[])new SqlParameter[0]));
            PrimaryKeyAp primaryKeyAp = new PrimaryKeyAp();
            String pkName = "pk_" + (mulBsdTableName.length() > 2 ? mulBsdTableName.substring(2) : mulBsdTableName);
            primaryKeyAp.setPk(pkName);
            RefColumnAp pkRef = new RefColumnAp();
            pkRef.setRefId(mulBsdTablePKField);
            primaryKeyAp.getPkColumnList().add(pkRef);
            tableAp.setPrimaryKey(primaryKeyAp);
            String constraintSQL = tableAp.generateConstraintSQL();
            sqlList.add(new SqlObject(constraintSQL, (kd.bos.db.SqlParameter[])new SqlParameter[0]));
            IndexAp indexAp = new IndexAp();
            String idxName = "idx_" + (mulBsdTableName.length() > 2 ? mulBsdTableName.substring(2) : mulBsdTableName);
            indexAp.setIndexName(idxName);
            indexAp.setTableName(mulBsdTableName);
            RefColumnAp idxRef = new RefColumnAp();
            idxRef.setRefId(fkFieldName);
            indexAp.getIndexColumnAps().add(idxRef);
            tableAp.getIndexs().add(indexAp);
            String sqlFKIndex = tableAp.generateIndexSQL();
            sqlList.add(new SqlObject(sqlFKIndex, (kd.bos.db.SqlParameter[])new SqlParameter[0]));
        }
    }

    private void genAlertAttachmentTableSQL(EntityMetadata entityMetadata, Entity<?, ?> entity, List<IAttachmentField> attachmentFields, List<SqlObject> sqlList) {
        String attachmentTablePKField = FPK_ID;
        String attFKField = "FBasedataId";
        if (StringUtils.isEmpty((CharSequence)entity.getTableName())) {
            return;
        }
        String pkFieldName = null;
        int pkFieldType = -5;
        String defaultValue = "";
        for (Entity billEntity : entityMetadata.getEntitys()) {
            if (!(billEntity instanceof BillEntity)) continue;
            pkFieldName = ((BillEntity)billEntity).getPkFieldName();
            pkFieldType = ((BillEntity)billEntity).getPkType() == 0 ? -9 : -5;
            break;
        }
        if (pkFieldType == -9) {
            defaultValue = "' '";
        } else if (pkFieldType == -5) {
            defaultValue = "0";
        }
        for (IAttachmentField attfield : attachmentFields) {
            String sql;
            ColumnAp columnAp;
            String attTableName = attfield.getTableName();
            DbMetadataTable tableSchema = AlterTableUtil.getTableSchema((String)entityMetadata.getDBRouteKey(), (String)attTableName, (boolean)false);
            if (null != tableSchema || !StringUtils.isNotBlank((CharSequence)attTableName)) continue;
            TableAp tableAp = new TableAp();
            tableAp.setTableName(attTableName);
            ColumnAp pkCol = this.getPkFieldType(-5);
            pkCol.setColumnName(attachmentTablePKField);
            pkCol.setNotNull(true);
            tableAp.getColumns().add(pkCol);
            String sqlCreateTab = tableAp.generateCreateSQL();
            sqlList.add(new SqlObject(sqlCreateTab, (kd.bos.db.SqlParameter[])new SqlParameter[0]));
            PrimaryKeyAp primaryKeyAp = new PrimaryKeyAp();
            String pkName = "pk_" + (attTableName.length() > 2 ? attTableName.substring(2) : attTableName);
            primaryKeyAp.setPk(pkName);
            RefColumnAp pkRef = new RefColumnAp();
            pkRef.setRefId(attachmentTablePKField);
            primaryKeyAp.getPkColumnList().add(pkRef);
            tableAp.setPrimaryKey(primaryKeyAp);
            String constraintSQL = tableAp.generateConstraintSQL();
            sqlList.add(new SqlObject(constraintSQL, (kd.bos.db.SqlParameter[])new SqlParameter[0]));
            if (entity instanceof MainEntity) {
                columnAp = this.getPkFieldType(pkFieldType);
                columnAp.setColumnName(pkFieldName);
                columnAp.setNotNull(true);
                columnAp.setColumnDef(defaultValue);
                sql = tableAp.getAddColumnsSQL(columnAp);
                sqlList.add(new SqlObject(sql, (kd.bos.db.SqlParameter[])new SqlParameter[0]));
            }
            if (!(entity instanceof MainEntity) && !StringUtils.isEmpty((CharSequence)((EntryEntity)entity).getEntryPkFieldName())) {
                columnAp = this.getPkFieldType(pkFieldType);
                columnAp.setColumnName(((EntryEntity)entity).getEntryPkFieldName());
                columnAp.setNotNull(true);
                columnAp.setColumnDef(defaultValue);
                sql = tableAp.getAddColumnsSQL(columnAp);
                sqlList.add(new SqlObject(sql, (kd.bos.db.SqlParameter[])new SqlParameter[0]));
            }
            columnAp = this.getPkFieldType(pkFieldType);
            columnAp.setColumnName(attFKField);
            columnAp.setNotNull(true);
            columnAp.setColumnDef(defaultValue);
            sql = tableAp.getAddColumnsSQL(columnAp);
            sqlList.add(new SqlObject(sql, (kd.bos.db.SqlParameter[])new SqlParameter[0]));
        }
    }

    private void genIssueTableSQL(EntityMetadata entityMetadata, Entity<?, ?> entity, List<SqlObject> sqlList) {
    }

    private void GenAlertTVRelationTableSQL(EntityMetadata entityMetadata, Entity<?, ?> entity, List<SqlObject> sqlList) {
    }

    private ColumnAp getfUserId() {
        ColumnAp fUserId = new ColumnAp();
        fUserId.setColunmType(DataType.VARCHAR.getValue());
        fUserId.setColumnLength(20);
        fUserId.setNotNull(true);
        fUserId.setColumnName("FUSERID");
        return fUserId;
    }

    private ColumnAp getNClob(String colname) {
        ColumnAp columnAp = new ColumnAp();
        columnAp.setColunmType(DataType.NCLOB.getValue());
        columnAp.setNotNull(true);
        columnAp.setColumnName(colname);
        return columnAp;
    }

    private ColumnAp getfLocaleId() {
        ColumnAp fLocaleId = new ColumnAp();
        fLocaleId.setColumnName("FLocaleID");
        fLocaleId.setColunmType(DataType.VARCHAR.getValue());
        fLocaleId.setColumnLength(10);
        fLocaleId.setNotNull(true);
        fLocaleId.setColumnDef("''");
        return fLocaleId;
    }

    public void genAlterTableSql(EntityMetadata entityMetadata, Entity<?, ?> entity, DbMetadataTable tableSchema, String tableName, List<SqlObject> sqlList, boolean useSharding, boolean isExtMeta, ArrayList<String> fieldsCommentSql) {
        EntityItem parentItem;
        if (StringUtils.isEmpty((CharSequence)entity.getTableName()) || StringUtils.isEmpty((CharSequence)tableName)) {
            return;
        }
        String sql = "";
        List entityList = entityMetadata.getEntitys();
        String pkFieldName = null;
        int pkFieldType = -5;
        for (Entity billEntity : entityList) {
            if (!(billEntity instanceof BillEntity)) continue;
            pkFieldName = ((BillEntity)billEntity).getPkFieldName();
            pkFieldType = ((BillEntity)billEntity).getPkType() == 0 ? -9 : -5;
            break;
        }
        if ((entity instanceof SubEntryEntity || entity instanceof LinkEntryEntity) && !((parentItem = entityMetadata.getItemById(entity.getParentId())) instanceof BillEntity)) {
            if (parentItem instanceof EntryEntity) {
                pkFieldName = ((EntryEntity)parentItem).getEntryPkFieldName();
            } else if (parentItem == null) {
                return;
            }
        }
        TableAp tableAp = new TableAp();
        tableAp.setTableName(tableName);
        if (!DMAlterTableUtilImpl.existsFieldInTableSchema(tableSchema, pkFieldName) && !StringUtils.isEmpty((CharSequence)pkFieldName)) {
            ColumnAp columnAp = this.getPkFieldType(pkFieldType);
            columnAp.setColumnName(pkFieldName);
            columnAp.setNotNull(true);
            sql = tableAp.getAddColumnsSQL(columnAp);
            sqlList.add(new SqlObject(sql, (kd.bos.db.SqlParameter[])new SqlParameter[0]));
            fieldsCommentSql.add(String.format("COMMENT ON COLUMN %1$s.%2$s IS '%3$s';", tableName, pkFieldName, pkFieldName));
        }
        if (entity instanceof MainEntity) {
            if (entity instanceof BillEntity && !DMAlterTableUtilImpl.existsFieldInTableSchema(tableSchema, ((BillEntity)entity).getEntityTypeId()) && StringUtils.isNotBlank((CharSequence)((BillEntity)entity).getEntityTypeId()) && tableName.equalsIgnoreCase(entity.getTableName())) {
                String entityTypeId = ((BillEntity)entity).getEntityTypeId();
                ColumnAp columnAp = this.getVarChar36NotNull();
                columnAp.setColumnName(entityTypeId);
                sql = tableAp.getAddColumnsSQL(columnAp);
                sqlList.add(new SqlObject(sql, (kd.bos.db.SqlParameter[])new SqlParameter[0]));
                fieldsCommentSql.add(String.format("COMMENT ON COLUMN %1$s.%2$s IS '%3$s';", tableName, entityTypeId, entityTypeId));
            }
        } else {
            String entryParentPkField;
            ColumnAp columnAp;
            String entryPkField = ((EntryEntity)entity).getEntryPkFieldName();
            String entrySeqField = ((EntryEntity)entity).getSeqFieldName();
            if (!DMAlterTableUtilImpl.existsFieldInTableSchema(tableSchema, entryPkField) && !StringUtils.isEmpty((CharSequence)entryPkField)) {
                columnAp = this.getPkFieldType(pkFieldType);
                columnAp.setColumnName(entryPkField);
                columnAp.setNotNull(true);
                sql = tableAp.getAddColumnsSQL(columnAp);
                fieldsCommentSql.add(String.format("COMMENT ON COLUMN %1$s.%2$s IS '%3$s';", tableName, entryPkField, entryPkField));
                sqlList.add(new SqlObject(sql, (kd.bos.db.SqlParameter[])new SqlParameter[0]));
            }
            if (entity instanceof ITreeEntryEntity && !DMAlterTableUtilImpl.existsFieldInTableSchema(tableSchema, entryParentPkField = ((ITreeEntryEntity)entity).getEntryParentPkFieldName()) && !StringUtils.isEmpty((CharSequence)entryParentPkField)) {
                ColumnAp columnAp2 = this.getPkFieldType(pkFieldType);
                columnAp2.setColumnName(entryParentPkField);
                columnAp2.setNotNull(true);
                sql = tableAp.getAddColumnsSQL(columnAp2);
                fieldsCommentSql.add(String.format("COMMENT ON COLUMN %1$s.%2$s IS '%3$s';", tableName, entryParentPkField, entryParentPkField));
                sqlList.add(new SqlObject(sql, (kd.bos.db.SqlParameter[])new SqlParameter[0]));
            }
            if (!StringUtils.isEmpty((CharSequence)entrySeqField) && !DMAlterTableUtilImpl.existsFieldInTableSchema(tableSchema, entrySeqField) && tableName.equalsIgnoreCase(entity.getTableName())) {
                columnAp = new ColumnAp();
                columnAp.setColunmType(DataType.INT.getValue());
                columnAp.setColumnName(entrySeqField);
                columnAp.setColumnDef("0");
                columnAp.setNotNull(true);
                sql = tableAp.getAddColumnsSQL(columnAp);
                fieldsCommentSql.add(String.format("COMMENT ON COLUMN %1$s.%2$s IS '%3$s';", tableName, entrySeqField, entrySeqField));
                sqlList.add(new SqlObject(sql, (kd.bos.db.SqlParameter[])new SqlParameter[0]));
            }
        }
        ArrayList<MuliLangTextField> mulLangFields = new ArrayList<MuliLangTextField>();
        ArrayList<MulBasedataField> mulBDFields = new ArrayList<MulBasedataField>();
        ArrayList<IAttachmentField> attachmentFields = new ArrayList<IAttachmentField>();
        ArrayList<Field> listFields = new ArrayList<Field>();
        Field itemField = null;
        List entityItem = entity.getItems();
        for (EntityItem item : entityItem) {
            if (!(item instanceof Field)) continue;
            itemField = (Field)item;
            if (isExtMeta && !itemField.isExt()) continue;
            listFields.add(itemField);
        }
        for (Field field : listFields) {
            if (field instanceof MuliLangTextField) {
                mulLangFields.add((MuliLangTextField)field);
                if (!((MuliLangTextField)field).isGL()) continue;
            }
            if (field instanceof IAttachmentField) {
                attachmentFields.add((IAttachmentField)field);
                continue;
            }
            if (field instanceof MulBasedataField) {
                mulBDFields.add((MulBasedataField)field);
                continue;
            }
            if (!tableName.equalsIgnoreCase(field.getTableName(entity))) continue;
            List dbFields = field.getDBFields();
            for (IDBField dbField : dbFields) {
                this.addAlterTableField(tableSchema, tableName, sqlList, fieldsCommentSql, tableAp, dbField);
            }
        }
        if (mulLangFields.size() > 0 && tableName.equalsIgnoreCase(entity.getTableName())) {
            this.genAlertMulLangTableSQL(entityMetadata, entity, mulLangFields, sqlList, useSharding);
        }
        if (entity instanceof BillEntity && ((BillEntity)entity).getSignField().size() > 0 && ((CertRule)((BillEntity)entity).getSignField().get(0)).getSignoperate().size() > 0) {
            this.genAlertSignTableSQL(entityMetadata, entity, sqlList);
        }
        if (mulBDFields.size() > 0 && tableName.equalsIgnoreCase(entity.getTableName())) {
            this.genAlertMulBsdTableSQL(entityMetadata, entity, mulBDFields, sqlList);
        }
        if (attachmentFields.size() > 0 && tableName.equalsIgnoreCase(entity.getTableName())) {
            this.genAlertAttachmentTableSQL(entityMetadata, entity, attachmentFields, sqlList);
        }
        if (entity instanceof MainEntity && tableName.equalsIgnoreCase(entity.getTableName())) {
            this.genIssueTableSQL(entityMetadata, entity, sqlList);
        }
    }

    private void addAlterTableField(DbMetadataTable tableSchema, String tableName, List<SqlObject> sqlList, ArrayList<String> fieldsCommentSql, TableAp tableAp, IDBField dbField) {
        if (!StringUtils.isEmpty((CharSequence)dbField.getFieldName())) {
            String sql;
            ColumnAp columnAp;
            if (!DMAlterTableUtilImpl.existsFieldInTableSchema(tableSchema, dbField.getFieldName())) {
                columnAp = this.getColumnAp(dbField);
                try {
                    String colSql = tableAp.getAddColumnsSQL(columnAp);
                    sqlList.add(new SqlObject(colSql, (kd.bos.db.SqlParameter[])new SqlParameter[0]));
                    dbField.generateFieldsComment(tableName, fieldsCommentSql);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            if (dbField.isEncrypt() && !DMAlterTableUtilImpl.existsFieldInTableSchema(tableSchema, dbField.getEncryptFieldName())) {
                columnAp = this.getNClob(dbField.getEncryptFieldName());
                columnAp.setNotNull(false);
                sql = tableAp.getAddColumnsSQL(columnAp);
                sqlList.add(new SqlObject(sql, (kd.bos.db.SqlParameter[])new SqlParameter[0]));
            }
            if (dbField.isPrivacyField() && !DMAlterTableUtilImpl.existsFieldInTableSchema(tableSchema, dbField.getFieldName() + "_pr")) {
                columnAp = this.getNClob(dbField.getFieldName() + "_pr");
                columnAp.setNotNull(false);
                sql = tableAp.getAddColumnsSQL(columnAp);
                sqlList.add(new SqlObject(sql, (kd.bos.db.SqlParameter[])new SqlParameter[0]));
            }
        }
    }

    private ColumnAp getPkFieldType(int pkInt) {
        ColumnAp columnAp = new ColumnAp();
        DataType pkFieldType = null;
        switch (pkInt) {
            case 12: {
                pkFieldType = DataType.VARCHAR;
                columnAp.setColumnLength(36);
                break;
            }
            case -9: {
                pkFieldType = DataType.NVARCHAR;
                columnAp.setColumnLength(36);
                break;
            }
            case 4: {
                pkFieldType = DataType.INT;
                break;
            }
            case -5: {
                pkFieldType = DataType.BIGINT;
                break;
            }
            default: {
                pkFieldType = DataType.NVARCHAR;
                columnAp.setColumnLength(36);
            }
        }
        columnAp.setColunmType(pkFieldType.getValue());
        return columnAp;
    }

    private ColumnAp getColumnAp(IDBField field) {
        ColumnAp columnAp = new ColumnAp();
        CharSequence typeStr = null;
        String defVal = field.getDBDefValue();
        String fieldName = field.getFieldName();
        DataType columType = DataType.VARCHAR;
        if (field.isPrivacyField()) {
            fieldName = fieldName + "_pr";
            columType = DataType.NCLOB;
            columnAp.setNotNull(false);
        }
        if (field.isEncrypt()) {
            fieldName = field.getEncryptFieldName();
            columType = DataType.NCLOB;
            columnAp.setNotNull(false);
        }
        if (StringUtils.isEmpty(typeStr)) {
            short fieldType = DataType.fromSqlType((int)field.getFieldDBType()).getValue();
            columType = DataType.valueOf((int)fieldType);
            switch (field.getFieldDBType()) {
                case -9: 
                case 1: 
                case 12: {
                    defVal = String.format("'%s'", defVal);
                    columnAp.setColumnDef(defVal);
                    columnAp.setNotNull(true);
                    break;
                }
                case 2022: {
                    break;
                }
                case 4: {
                    if (StringUtils.isNotBlank((CharSequence)defVal)) {
                        columnAp.setColumnDef(defVal.trim());
                    }
                    columnAp.setNotNull(true);
                    break;
                }
                case 2004: 
                case 2009: 
                case 2011: {
                    columnAp.setNotNull(false);
                    break;
                }
                case -5: {
                    if (!StringUtils.isNotBlank((CharSequence)defVal)) break;
                    columnAp.setColumnDef(defVal.trim());
                    columnAp.setNotNull(true);
                    break;
                }
                default: {
                    defVal = String.format("'%s'", defVal);
                    columnAp.setNotNull(true);
                    columnAp.setColumnDef(defVal);
                }
            }
        }
        int length = field.getFieldLen();
        if (field.getFieldDBType() == -5) {
            length = field.getScale();
        } else if (field.getFieldDBType() == 3) {
            length = field.getPrecision();
            columnAp.setColumnPrecision(field.getScale());
        }
        columnAp.setColumnLength(length);
        columnAp.setColumnName(fieldName);
        columnAp.setColunmType(columType.getValue());
        return columnAp;
    }

    private static boolean existsFieldInTableSchema(DbMetadataTable tableSchema, String fieldName) {
        boolean exists = false;
        if (tableSchema != null && !StringUtils.isEmpty((CharSequence)fieldName)) {
            Object value = null;
            exists = tableSchema.getColumns().TryGetValue(fieldName, new RefObject(value));
        }
        return exists;
    }
}

