/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.datamodel.metadata.pdm;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.datamodel.metadata.pdm.ExtMetadataNode;
import kd.bos.datamodel.metadata.pdm.MetadataTree;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.metadata.dao.IMetadataNode;
import kd.bos.metadata.devportal.DesignAppMeta;
import kd.bos.metadata.entity.DesignEntityMeta;
import kd.bos.metadata.form.DesignFormMeta;

class MetadataNode
implements IMetadataNode {
    private MetadataNode parentNode;
    private List<ExtMetadataNode> extendNodes;
    private LocaleString loacleXml;
    private String xml;
    private MetadataNode childNode;
    private String id;
    private String parentId;
    private boolean isInherit;
    private LocaleString termJsonStrRes;
    private String version;

    public MetadataNode(String id, String parentId, String xml, boolean isInherit) {
        this(id, parentId, xml);
        this.isInherit = isInherit;
    }

    public MetadataNode(String id, String parentId, String xml) {
        this.id = id;
        this.extendNodes = new ArrayList<ExtMetadataNode>();
        this.loacleXml = new LocaleString();
        this.parentId = parentId;
        this.xml = xml;
        this.termJsonStrRes = new LocaleString();
    }

    public boolean isInherit() {
        return this.isInherit;
    }

    public MetadataNode getPrevNode() {
        return this.parentNode;
    }

    public void setParentNode(MetadataNode parentNode) {
        this.parentNode = parentNode;
        this.parentNode.setChildNode(this);
    }

    public List<ExtMetadataNode> getExtendNodes() {
        return this.extendNodes;
    }

    public LocaleString getLoacleXml() {
        return this.loacleXml;
    }

    public void setLoacleXml(LocaleString loacleXml) {
        this.loacleXml = loacleXml;
    }

    public String getXml() {
        return this.xml;
    }

    public void setXml(String xml) {
        this.xml = xml;
    }

    public MetadataNode getChildNode() {
        return this.childNode;
    }

    public void setChildNode(MetadataNode childNode) {
        this.childNode = childNode;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public LocaleString getTermJsonStrRes() {
        return this.termJsonStrRes;
    }

    public void setTermJsonStrRes(LocaleString termJsonStrRes) {
        this.termJsonStrRes = termJsonStrRes;
    }

    private static boolean supprotMetaTerm(IDataEntityType type) {
        if (type == null) {
            return false;
        }
        return type.getName().equals(OrmUtils.getDataEntityType(DesignAppMeta.class).getName()) || type.getName().equals(OrmUtils.getDataEntityType(DesignEntityMeta.class).getName()) || type.getName().equals(OrmUtils.getDataEntityType(DesignFormMeta.class).getName());
    }

    public static MetadataTree loadMetaTerm(IDataEntityType type, MetadataTree tree, boolean runtime) {
        if (!runtime) {
            return tree;
        }
        if (!MetadataNode.supprotMetaTerm(type)) {
            return tree;
        }
        if (!DB.exitsTable((DBRoute)MetadataNode.getDbRoute(type), (String)(type.getAlias() + "_TERM"))) {
            return tree;
        }
        MetadataNode rootNode = tree.getRootNode();
        if (rootNode == null) {
            return tree;
        }
        ArrayList<String> ids = new ArrayList<String>();
        MetadataNode.getTermFIdsFromTreeNode(rootNode, ids);
        MetadataNode.fillTermRes(tree, type);
        return tree;
    }

    private static void fillTermRes(MetadataTree tree, IDataEntityType dataEntityType) {
        ArrayList<String> ids = new ArrayList<String>();
        MetadataNode.getTermFIdsFromTreeNode(tree.getRootNode(), ids);
        if (ids.isEmpty()) {
            return;
        }
        StringBuilder inSql = new StringBuilder(22 * ids.size());
        inSql.append("?");
        for (int i = 1; i < ids.size(); ++i) {
            inSql.append(",").append("?");
        }
        String sql = String.format("select fid,flocaleid, fdata from " + dataEntityType.getAlias() + "_TERM where  %1$s in (%2$s)", "fid", inSql);
        SqlBuilder sbBuilder = new SqlBuilder();
        sbBuilder.append(sql, ids.toArray());
        Map res = (Map)DB.query((DBRoute)DBRoute.meta, (SqlBuilder)sbBuilder, rs -> {
            HashMap<String, LocaleString> result = new HashMap<String, LocaleString>();
            while (rs.next()) {
                LocaleString localeString;
                String v = rs.getString("fdata");
                String localid = rs.getString("flocaleid");
                if (result.get(rs.getString("fid")) == null) {
                    localeString = new LocaleString();
                    localeString.put(localid, (Object)v);
                    result.put(rs.getString("fid"), localeString);
                    continue;
                }
                localeString = (LocaleString)result.get(rs.getString("fid"));
                localeString.put(localid, (Object)v);
            }
            return result;
        });
        for (Map.Entry row : res.entrySet()) {
            if (tree.getNode((String)row.getKey()) != null) {
                tree.getNode((String)row.getKey()).setTermJsonStrRes((LocaleString)row.getValue());
                continue;
            }
            if (tree.getExtNode((String)row.getKey()) == null) continue;
            tree.getExtNode((String)row.getKey()).setTermJsonStrRes((LocaleString)row.getValue());
        }
    }

    private static void getTermFIdsFromTreeNode(MetadataNode node, List<String> ids) {
        if (node == null) {
            return;
        }
        ids.add(node.getId());
        for (MetadataNode metadataNode : node.getExtendNodes()) {
            MetadataNode.getTermFIdsFromTreeNode(metadataNode, ids);
        }
        if (node.getChildNode() != null) {
            MetadataNode.getTermFIdsFromTreeNode(node.getChildNode(), ids);
        }
    }

    private static DBRoute getDbRoute(IDataEntityType metaType) {
        String dbRouteKey = metaType.getDBRouteKey();
        return StringUtils.isBlank((CharSequence)dbRouteKey) ? DBRoute.meta : DBRoute.of((String)dbRouteKey);
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }
}

