/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.datamodel.metadata.pdm;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.datamodel.metadata.pdm.ExtMetadataNode;
import kd.bos.datamodel.metadata.pdm.MetadataNode;

class MetadataTree {
    private MetadataNode rootNode;
    private Map<String, MetadataNode> mapNodes = new HashMap<String, MetadataNode>(16);
    private Map<String, ExtMetadataNode> mapExtNodes;

    public MetadataTree(List<MetadataNode> nodes) {
        for (MetadataNode node : nodes) {
            if (StringUtils.isBlank((CharSequence)node.getParentId())) {
                this.rootNode = node;
            }
            this.mapNodes.put(node.getId(), node);
        }
        for (MetadataNode node : nodes) {
            MetadataNode parentNode;
            if (!StringUtils.isNotBlank((CharSequence)node.getParentId()) || (parentNode = this.mapNodes.get(node.getParentId())) == null) continue;
            node.setParentNode(parentNode);
        }
    }

    public void fillExtends(List<ExtMetadataNode> nodes) {
        this.mapExtNodes = new HashMap<String, ExtMetadataNode>(16);
        for (ExtMetadataNode node : nodes) {
            this.mapExtNodes.put(node.getId(), node);
        }
        for (ExtMetadataNode node : nodes) {
            if (StringUtils.isBlank((CharSequence)node.getParentId())) continue;
            MetadataNode parentNode = this.mapNodes.get(node.getParentId());
            if (parentNode == null) {
                parentNode = this.mapExtNodes.get(node.getParentId());
            }
            if (parentNode == null) continue;
            parentNode.getExtendNodes().add(node);
        }
    }

    public HashSet<String> getNodeIds() {
        HashSet<String> idSet = new HashSet<String>();
        for (String id : this.mapNodes.keySet()) {
            if (idSet.contains(id)) continue;
            idSet.add(id);
        }
        return idSet;
    }

    public HashSet<String> getExtendNodeIds() {
        HashSet<String> idSet = new HashSet<String>();
        for (String id : this.mapExtNodes.keySet()) {
            if (idSet.contains(id)) continue;
            idSet.add(id);
        }
        return idSet;
    }

    public MetadataNode getNode(String id) {
        return this.mapNodes.get(id);
    }

    public ExtMetadataNode getExtNode(String id) {
        return this.mapExtNodes.get(id);
    }

    public MetadataNode getRootNode() {
        return this.rootNode;
    }

    protected Map<String, MetadataNode> getNodes() {
        return new HashMap<String, MetadataNode>(this.mapNodes);
    }

    protected Map<String, MetadataNode> getExtNodes() {
        return new HashMap<String, MetadataNode>(this.mapExtNodes);
    }
}

