/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.datamodel.metadata.pdm;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.datamodel.meta.element.BaseControl;
import kd.bos.datamodel.meta.element.DMPackageAp;
import kd.bos.datamodel.meta.element.DataModelBaseElement;
import kd.bos.datamodel.meta.element.pdm.ColumnAp;
import kd.bos.datamodel.meta.element.pdm.IndexAp;
import kd.bos.datamodel.meta.element.pdm.PhysicalDiagram;
import kd.bos.datamodel.meta.element.pdm.RefColumnAp;
import kd.bos.datamodel.meta.element.pdm.TableAp;
import kd.bos.datamodel.metadata.AbstractDataModelMetadata;
import kd.bos.datamodel.metadata.DataModelDesignMeta;
import kd.bos.datamodel.metadata.pdm.PDMDiagramMetadata;
import kd.bos.datamodel.metadata.pdm.PDMEntityDesignMeta;
import kd.bos.datamodel.metadata.pdm.PDMEntityMetadata;
import kd.bos.datamodel.pdm.model.DataType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlBuilder;
import kd.bos.db.SqlParameter;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.isv.ISVService;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;

public class PDMDesignMetaDao {
    public static List<DataModelDesignMeta> getDataModelDesignMeta(boolean onlyCurrentIsv) {
        String isv = ISVService.getISVInfo().getId();
        IDataEntityType dataEntityType = OrmUtils.getDataEntityType(PDMEntityDesignMeta.class);
        SqlBuilder builder = new SqlBuilder();
        builder.append("select fid from", new Object[0]).append(dataEntityType.getAlias(), new Object[0]);
        if (onlyCurrentIsv) {
            builder.append(" where fisv = ", new Object[0]).append(isv, new Object[0]);
        }
        List idList = (List)DB.query((DBRoute)DBRoute.meta, (SqlBuilder)builder, rs -> {
            ArrayList<String> ids = new ArrayList<String>(10);
            while (rs.next()) {
                ids.add(rs.getString("fid"));
            }
            return ids;
        });
        Object[] dms = BusinessDataReader.load((Object[])idList.toArray(), (IDataEntityType)dataEntityType);
        ArrayList<DataModelDesignMeta> dataModelDesignMetas = new ArrayList<DataModelDesignMeta>(dms.length);
        for (Object dm : dms) {
            dataModelDesignMetas.add((DataModelDesignMeta)((Object)dm));
        }
        return dataModelDesignMetas;
    }

    public static String getBizAppIdByModelId(String id) {
        String sql = String.format("select fbizappid from %s where fid = ?", OrmUtils.getDataEntityType(PDMEntityDesignMeta.class).getAlias());
        Object[] params = new SqlParameter[]{new SqlParameter(":fid", 12, (Object)id)};
        return (String)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, rs -> {
            if (rs.next()) {
                return rs.getString("fbizappid");
            }
            return null;
        });
    }

    public static void deleteModelById(String modelId) {
        String sql = "delete from T_DM_PDMMODEL_D where fmasterid = ? and ftype = ?";
        Object[] parameters = new SqlParameter[]{new SqlParameter(":fmasterid", 12, (Object)modelId), new SqlParameter(":ftype", 12, (Object)"0")};
        String sql2 = "delete from T_DM_PDMDIAGRAM_D where fmasterid = ? and ftype = ?";
        Object[] parameters2 = new SqlParameter[]{new SqlParameter(":fmasterid", 12, (Object)modelId), new SqlParameter(":ftype", 12, (Object)"0")};
        DB.execute((DBRoute)DBRoute.meta, (String)sql, (Object[])parameters);
        DB.execute((DBRoute)DBRoute.meta, (String)sql2, (Object[])parameters2);
    }

    public static boolean modelExist(String modelId, IDataEntityType designerMetaType) {
        String tableName = designerMetaType.getAlias();
        String sql = String.format("select FId from %s where FID = ? ", tableName);
        Object[] params = new Object[]{modelId};
        ResultSetHandler<Boolean> action = new ResultSetHandler<Boolean>(){

            public Boolean handle(ResultSet rs) throws Exception {
                if (rs.next()) {
                    return true;
                }
                return false;
            }
        };
        return (Boolean)DB.query((DBRoute)PDMDesignMetaDao.getDbRoute(designerMetaType), (String)sql, (Object[])params, (ResultSetHandler)action);
    }

    public static boolean modelExistExt(String modelId, IDataEntityType designerMetaType) {
        String tableName = designerMetaType.getAlias();
        String sql = String.format("select FId from %s where FMASTERID = ? ", tableName);
        Object[] params = new Object[]{modelId};
        ResultSetHandler<Boolean> action = new ResultSetHandler<Boolean>(){

            public Boolean handle(ResultSet rs) throws Exception {
                if (rs.next()) {
                    return true;
                }
                return false;
            }
        };
        return (Boolean)DB.query((DBRoute)PDMDesignMetaDao.getDbRoute(designerMetaType), (String)sql, (Object[])params, (ResultSetHandler)action);
    }

    public static int getParalleExtCountByIsv(String modelId, String isv) {
        IDataEntityType mDesignMetaType = OrmUtils.getDataEntityType(PDMEntityDesignMeta.class);
        ORM orm = ORM.create();
        orm.setDataEntityType(mDesignMetaType.getName(), mDesignMetaType);
        QFilter[] qFilters = new QFilter[]{new QFilter("masterId", "=", (Object)modelId), new QFilter("isv", "=", (Object)isv)};
        return orm.count(mDesignMetaType.getName(), mDesignMetaType.getName(), qFilters);
    }

    public static void resetParentId(AbstractDataModelMetadata dataModelMetadata, String id) {
        ArrayList<DataModelBaseElement> items = new ArrayList<DataModelBaseElement>(10);
        if (dataModelMetadata instanceof PDMEntityMetadata && ((PDMEntityMetadata)dataModelMetadata).getPackageAps() != null) {
            items.addAll(((PDMEntityMetadata)dataModelMetadata).getPackageAps());
        }
        if (dataModelMetadata instanceof PDMDiagramMetadata && ((PDMDiagramMetadata)dataModelMetadata).getPhysicalDiagramAps() != null) {
            List<PhysicalDiagram> physicalDiagramAps = ((PDMDiagramMetadata)dataModelMetadata).getPhysicalDiagramAps();
            items.addAll(physicalDiagramAps);
        }
        for (BaseControl baseControl : items) {
            if (!dataModelMetadata.getMasterId().equals(baseControl.getParentId())) continue;
            baseControl.setParentId(id);
        }
    }

    public static void setRootChildParentId(AbstractDataModelMetadata dataModelMetadata) {
        ArrayList<DataModelBaseElement> items = new ArrayList<DataModelBaseElement>(10);
        if (dataModelMetadata instanceof PDMEntityMetadata && ((PDMEntityMetadata)dataModelMetadata).getPackageAps() != null) {
            items.addAll(((PDMEntityMetadata)dataModelMetadata).getPackageAps());
        }
        if (dataModelMetadata instanceof PDMDiagramMetadata && ((PDMDiagramMetadata)dataModelMetadata).getPhysicalDiagramAps() != null) {
            List<PhysicalDiagram> physicalDiagramAps = ((PDMDiagramMetadata)dataModelMetadata).getPhysicalDiagramAps();
            items.addAll(physicalDiagramAps);
        }
        for (BaseControl baseControl : items) {
            if (!StringUtils.isBlank((CharSequence)baseControl.getParentId())) continue;
            baseControl.setParentId(dataModelMetadata.getId());
        }
    }

    public static void clearRootChildParentId(AbstractDataModelMetadata dataModelMetadata) {
        ArrayList<DataModelBaseElement> items = new ArrayList<DataModelBaseElement>(10);
        if (dataModelMetadata instanceof PDMEntityMetadata && ((PDMEntityMetadata)dataModelMetadata).getPackageAps() != null) {
            items.addAll(((PDMEntityMetadata)dataModelMetadata).getPackageAps());
        }
        if (dataModelMetadata instanceof PDMDiagramMetadata && ((PDMDiagramMetadata)dataModelMetadata).getPhysicalDiagramAps() != null) {
            List<PhysicalDiagram> physicalDiagramAps = ((PDMDiagramMetadata)dataModelMetadata).getPhysicalDiagramAps();
            items.addAll(physicalDiagramAps);
        }
        for (BaseControl baseControl : items) {
            if (!dataModelMetadata.getId().equals(baseControl.getParentId())) continue;
            baseControl.setParentId("");
        }
    }

    public static void genDictionary(List<PDMEntityMetadata> dataModelMetaList) {
        Map appInfoMap = AppMetadataCache.getAllAppInfo();
        HashMap<String, AppInfo> appInfoByIdMap = new HashMap<String, AppInfo>(appInfoMap.size());
        for (Object appInfo : appInfoMap.values()) {
            appInfoByIdMap.put(appInfo.getId(), (AppInfo)appInfo);
        }
        ArrayList<String> appNumberList = new ArrayList<String>(dataModelMetaList.size());
        for (PDMEntityMetadata pdmMetadata : dataModelMetaList) {
            String appNumber = ((AppInfo)appInfoByIdMap.get(pdmMetadata.getBizappId())).getNumber();
            appNumberList.add(appNumber);
        }
        Map<String, Long> tableVersion = PDMDesignMetaDao.loadDictTableVersion(appNumberList);
        ArrayList<String> tableNameList = new ArrayList<String>();
        Date currDate = new Date();
        long timestamp = System.currentTimeMillis();
        for (PDMEntityMetadata pdmMetadata : dataModelMetaList) {
            String modelNumber = pdmMetadata.getNumber();
            String appNumber = ((AppInfo)appInfoByIdMap.get(pdmMetadata.getBizappId())).getNumber();
            ArrayList<Object[]> tableInsParams = new ArrayList<Object[]>();
            ArrayList<? extends Object[]> colInsParams = new ArrayList<Object[]>();
            ArrayList<? extends Object[]> idxInsParams = new ArrayList<Object[]>();
            for (DMPackageAp packageAp : pdmMetadata.getPackageAps()) {
                for (TableAp tableAp : packageAp.getTableAps()) {
                    String tableNumber = tableAp.getTableName().toUpperCase();
                    Long version = tableAp.getVersion();
                    if (version.equals(tableVersion.get(tableNumber))) continue;
                    String tableComment = tableAp.getName().getLocaleValue();
                    String tableDesc = tableAp.getDescription();
                    tableInsParams.add(new Object[]{tableNumber, appNumber, modelNumber, tableComment, tableDesc, currDate, version, timestamp});
                    colInsParams.addAll(PDMDesignMetaDao.createColParams(tableAp, currDate, timestamp));
                    tableNameList.add(tableNumber);
                    idxInsParams.addAll(PDMDesignMetaDao.createIdxParams(tableAp, timestamp));
                }
            }
            Object[] tableNames = tableNameList.toArray();
            SqlBuilder tableDelSql = new SqlBuilder();
            tableDelSql.append("delete from T_DM_DICTTABLE where ", new Object[0]).appendIn("FTABLENAME", tableNames);
            SqlBuilder colDelSql = new SqlBuilder();
            colDelSql.append("delete from T_DM_DICTCOLUMN where ", new Object[0]).appendIn("FTABLENAME", tableNames);
            SqlBuilder idxDelSql = new SqlBuilder();
            idxDelSql.append("delete from T_DM_DICTINDEX where ", new Object[0]).appendIn("FTABLENAME", tableNames);
            TXHandle txHandle = TX.requiresNew();
            Throwable throwable = null;
            try {
                DB.execute((DBRoute)DBRoute.meta, (SqlBuilder)tableDelSql);
                DB.execute((DBRoute)DBRoute.meta, (SqlBuilder)colDelSql);
                DB.execute((DBRoute)DBRoute.meta, (SqlBuilder)idxDelSql);
                DB.executeBatch((DBRoute)DBRoute.meta, (String)"insert into T_DM_DICTTABLE(FTABLENAME,FAPPNUMBER,FMODELNUMBER,FCOMMENT,FDESCRIPTION,FCREATEDATE,FVERSION,FTIMESTAMP) values(?,?,?,?,?,?,?,?);", tableInsParams);
                DB.executeBatch((DBRoute)DBRoute.meta, (String)"insert into T_DM_DICTCOLUMN(FTABLENAME,FCOLUMNNAME,FDATATYPE,FLENGTH,FPRECISION,FSCOLE,FDEFAULT,FALLOWNULL,FISCOMPUTED,FCOMMENT,FDESCRIPTION,FCREATEDATE,FTIMESTAMP) values(?,?,?,?,?,?,?,?,?,?,?,?,?);", colInsParams);
                DB.executeBatch((DBRoute)DBRoute.meta, (String)"insert into T_DM_DICTINDEX(FTABLENAME,FINDEXNAME,FISCLUSTER,FISUNIQUE,FTYPE,FCOLUMNS,FTIMESTAMP) values(?,?,?,?,?,?,?);", idxInsParams);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (txHandle == null) continue;
                if (throwable != null) {
                    try {
                        txHandle.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                txHandle.close();
            }
        }
    }

    private static Collection<? extends Object[]> createColParams(TableAp tableAp, Date currDate, long timestamp) {
        ArrayList<Object[]> colInsParams = new ArrayList<Object[]>(tableAp.getColumns().size());
        for (ColumnAp columnAp : tableAp.getColumns()) {
            String defaultVal;
            int length = columnAp.getColumnLength();
            int precision = 0;
            int scole = 0;
            if (columnAp.getColunmType() == 14) {
                length = 0;
                precision = columnAp.getColumnLength();
                scole = columnAp.getColumnPrecision();
            }
            if ((defaultVal = (String)columnAp.getColumnDef()) == null) {
                defaultVal = " ";
            }
            colInsParams.add(new Object[]{tableAp.getTableName().toUpperCase(), columnAp.getColumnName().toUpperCase(), DataType.valueOf((int)columnAp.getColunmType()).name(), length, precision, scole, defaultVal, columnAp.isNotNull(), "0", columnAp.getName().getLocaleValue(), columnAp.getName().getLocaleValue(), currDate, timestamp});
        }
        return colInsParams;
    }

    private static Collection<? extends Object[]> createIdxParams(TableAp tableAp, long timestamp) {
        ArrayList<Object[]> idxParams = new ArrayList<Object[]>(tableAp.getIndexs().size());
        HashMap<String, ColumnAp> columnApMap = new HashMap<String, ColumnAp>(tableAp.getColumns().size());
        for (ColumnAp columnAp : tableAp.getColumns()) {
            columnApMap.put(columnAp.getId(), columnAp);
        }
        for (IndexAp index : tableAp.getIndexs()) {
            String columnNames = "";
            for (RefColumnAp columnAp : index.getIndexColumnAps()) {
                columnNames = ((ColumnAp)((Object)columnApMap.get(columnAp.getRefId()))).getColumnName().toUpperCase() + ",";
            }
            columnNames = columnNames.substring(0, columnNames.length() - 1);
            idxParams.add(new Object[]{tableAp.getTableName().toUpperCase(), index.getIndexName().toUpperCase(), index.isCluster(), index.isUnique(), Character.valueOf('0'), columnNames, timestamp});
        }
        return idxParams;
    }

    private static Map<String, Long> loadDictTableVersion(List<String> appNumberList) {
        HashMap<String, Long> tableVersion = new HashMap<String, Long>();
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select FTABLENAME, FVERSION from T_DM_DICTTABLE where ", new Object[0]).appendIn("FAPPNUMBER", appNumberList.toArray());
        DB.query((DBRoute)DBRoute.meta, (SqlBuilder)sqlBuilder, rs -> {
            while (rs.next()) {
                tableVersion.put(rs.getString(1).toUpperCase(), rs.getLong(2));
            }
            return null;
        });
        return tableVersion;
    }

    private static DBRoute getDbRoute(IDataEntityType metaType) {
        String dbRouteKey = metaType.getDBRouteKey();
        return StringUtils.isBlank((CharSequence)dbRouteKey) ? DBRoute.meta : DBRoute.of((String)dbRouteKey);
    }

    public static PDMEntityDesignMeta getPDMEntityDesignByNumber(String number) {
        if (StringUtils.isBlank((CharSequence)number)) {
            return null;
        }
        IDataEntityType dataEntityType = OrmUtils.getDataEntityType(PDMEntityDesignMeta.class);
        String sql = String.format("select fid from %s where fnumber = ?", dataEntityType.getAlias());
        Object[] parameters = new SqlParameter[]{new SqlParameter(":fnumber", 12, (Object)number)};
        Object fid = DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])parameters, resultSet -> {
            if (resultSet.next()) {
                return resultSet.getString("fid");
            }
            return null;
        });
        if (fid == null) {
            return null;
        }
        return (PDMEntityDesignMeta)((Object)BusinessDataReader.load((Object[])new Object[]{fid}, (IDataEntityType)dataEntityType)[0]);
    }
}

