/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.datamodel.metadata.pdm;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcxmlSerializer;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.datamodel.metadata.AbstractDataModelMetadata;
import kd.bos.datamodel.metadata.DMMetaCategory;
import kd.bos.datamodel.metadata.DataModelDesignMeta;
import kd.bos.datamodel.metadata.pdm.DeltaPDMDiagramDesignMeta;
import kd.bos.datamodel.metadata.pdm.DeltaPDMEntityDesignMeta;
import kd.bos.datamodel.metadata.pdm.ExtMetadataNode;
import kd.bos.datamodel.metadata.pdm.IPDMDesignMetaReader;
import kd.bos.datamodel.metadata.pdm.MetadataNode;
import kd.bos.datamodel.metadata.pdm.MetadataTree;
import kd.bos.datamodel.metadata.pdm.PDMDesignMetaDao;
import kd.bos.datamodel.metadata.pdm.PDMDiagramDesignMeta;
import kd.bos.datamodel.metadata.pdm.PDMDiagramMetadata;
import kd.bos.datamodel.metadata.pdm.PDMEntityDesignMeta;
import kd.bos.datamodel.metadata.pdm.PDMEntityMetadata;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlBuilder;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.isv.ISVService;
import kd.bos.metadata.domainmodel.DomainModelBinder;
import kd.bos.metadata.domainmodel.DomainModelType;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;

class PDMDesignMetaReader
implements IPDMDesignMetaReader {
    private static final String modelType = "PhysicalDataModel";
    private DcBinder binder;
    private DcxmlSerializer xmlSerializer;
    private boolean colloctionIgnorePKValue;
    private IDataEntityType dDataModelType = null;
    private IDataEntityType mDataModelType = null;
    private IDataEntityType dDiagramType = null;
    private IDataEntityType mDiagramType = null;

    private IDataEntityType getDataEntityType(DMMetaCategory category) {
        IDataEntityType dt = null;
        switch (category) {
            case DDataModel: {
                dt = this.getDDataModelType();
                break;
            }
            case MDataModel: {
                dt = this.getMDataModelType();
                break;
            }
            case DDiagram: {
                dt = this.getDDiagramType();
                break;
            }
            case MDiagram: {
                dt = this.getMDiagramType();
            }
        }
        return dt;
    }

    private IDataEntityType getDDiagramType() {
        if (this.dDiagramType != null) {
            return this.dDiagramType;
        }
        this.dDiagramType = OrmUtils.getDataEntityType(DeltaPDMDiagramDesignMeta.class);
        return this.dDiagramType;
    }

    private IDataEntityType getMDiagramType() {
        if (this.mDiagramType != null) {
            return this.mDiagramType;
        }
        this.mDiagramType = OrmUtils.getDataEntityType(PDMDiagramDesignMeta.class);
        return this.mDiagramType;
    }

    private IDataEntityType getDDataModelType() {
        if (this.dDataModelType != null) {
            return this.dDataModelType;
        }
        this.dDataModelType = OrmUtils.getDataEntityType(DeltaPDMEntityDesignMeta.class);
        return this.dDataModelType;
    }

    private IDataEntityType getMDataModelType() {
        if (this.mDataModelType != null) {
            return this.mDataModelType;
        }
        this.mDataModelType = OrmUtils.getDataEntityType(PDMEntityDesignMeta.class);
        return this.mDataModelType;
    }

    @Override
    public DataModelDesignMeta loadEntityDesignMeta(String modelId) {
        return (PDMEntityDesignMeta)((Object)BusinessDataReader.read((Object)modelId, (IDataEntityType)this.getMDataModelType(), (Boolean)false));
    }

    <T extends DeltaPDMEntityDesignMeta> T loadDDesignMeta(String modelId, final T t) {
        String tableName = OrmUtils.getDataEntityType(((Object)t).getClass()).getAlias();
        String sql = String.format("select fid,fmasterid,fproduct,fbizappid,fnumber,fname,fcreator,fcreatedate,fmodifierid,fmodifydate,fversion,fisv,fdata,fismerge from %s where fmasterid=? and fcreator=? and fisv=? and fismerge=?", tableName);
        Object[] params = new Object[]{modelId, RequestContext.get().getCurrUserId(), ISVService.getISVInfo().getId(), "0"};
        DeltaPDMEntityDesignMeta designMeta = (DeltaPDMEntityDesignMeta)((Object)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, (ResultSetHandler)new ResultSetHandler<T>(){

            public T handle(ResultSet rs) throws Exception {
                if (rs.next()) {
                    t.setId(rs.getString(1));
                    t.setMasterId(rs.getString(2));
                    t.setProduct(rs.getString(3));
                    t.setBizappId(rs.getString(4));
                    t.setNumber(rs.getString(5));
                    t.setName(rs.getString(6));
                    t.setCreator(rs.getLong(7));
                    t.setCreatedDate(rs.getDate(8));
                    t.setModifierId(rs.getLong(9));
                    t.setModifyDate(rs.getDate(10));
                    t.setVersion(rs.getLong(11));
                    t.setIsv(rs.getString(12));
                    t.setDataXml(rs.getString(13));
                    t.setMerge(rs.getBoolean(14));
                    return (Object)t;
                }
                return null;
            }
        }));
        return (T)((Object)designMeta);
    }

    private DeltaPDMEntityDesignMeta loadDeltaDesignMeta(String modelId, DMMetaCategory metaType) {
        IDataEntityType dataEntityType = this.getDataEntityType(metaType);
        if (dataEntityType == null) {
            return null;
        }
        String sql = String.format("select fid,fmasterid,fproduct,fbizappid,fnumber,fname,fcreator,fcreatedate,fmodifierid,fmodifydate,fversion,fisv,fdata,fismerge from %s where fmasterid=? and fcreator=? and fisv=?", dataEntityType.getAlias());
        Object[] params = new Object[]{modelId, RequestContext.get().getCurrUserId(), ISVService.getISVInfo().getId()};
        DeltaPDMEntityDesignMeta designMeta = (DeltaPDMEntityDesignMeta)((Object)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, (ResultSetHandler)new ResultSetHandler<DeltaPDMEntityDesignMeta>(){

            public DeltaPDMEntityDesignMeta handle(ResultSet rs) throws Exception {
                if (rs.next()) {
                    DeltaPDMEntityDesignMeta designMeta = new DeltaPDMEntityDesignMeta();
                    designMeta.setId(rs.getString(1));
                    designMeta.setMasterId(rs.getString(2));
                    designMeta.setProduct(rs.getString(3));
                    designMeta.setBizappId(rs.getString(4));
                    designMeta.setNumber(rs.getString(5));
                    designMeta.setName(rs.getString(6));
                    designMeta.setCreator(rs.getLong(7));
                    designMeta.setCreatedDate(rs.getDate(8));
                    designMeta.setModifierId(rs.getLong(9));
                    designMeta.setModifyDate(rs.getDate(10));
                    designMeta.setVersion(rs.getLong(11));
                    designMeta.setIsv(rs.getString(12));
                    designMeta.setDataXml(rs.getString(13));
                    designMeta.setMerge(rs.getBoolean(14));
                    return designMeta;
                }
                return null;
            }
        }));
        return designMeta;
    }

    @Override
    public Map<String, Object> loadDesignMeta(String modelId) {
        DataModelDesignMeta designMeta = (DataModelDesignMeta)((Object)BusinessDataReader.read((Object)modelId, (IDataEntityType)this.getMDataModelType(), (Boolean)false));
        PDMEntityMetadata pdmMetadata = (PDMEntityMetadata)this.assembleMetadata(modelId, designMeta, false, DMMetaCategory.MDataModel);
        pdmMetadata.setDesignMeta(designMeta);
        PDMDesignMetaDao.setRootChildParentId(pdmMetadata);
        DataModelDesignMeta diagramdesignMeta = (DataModelDesignMeta)((Object)BusinessDataReader.read((Object)modelId, (IDataEntityType)this.getMDiagramType(), (Boolean)false));
        PDMDiagramMetadata pdmDiagramMetadata = (PDMDiagramMetadata)this.assembleMetadata(modelId, diagramdesignMeta, false, DMMetaCategory.MDiagram);
        if (pdmDiagramMetadata != null) {
            pdmDiagramMetadata.setDesignMeta(diagramdesignMeta);
            pdmMetadata.setPdmDiagramMetadata(pdmDiagramMetadata);
            PDMDesignMetaDao.setRootChildParentId(pdmDiagramMetadata);
        }
        return pdmMetadata.buildDesignMeta("zh_CN");
    }

    @Override
    public AbstractDataModelMetadata loadBaseMeta(String modelId, DMMetaCategory category) {
        if (!this.modelExist(modelId, this.getDataEntityType(category))) {
            return null;
        }
        DataModelDesignMeta designMeta = (DataModelDesignMeta)((Object)BusinessDataReader.read((Object)modelId, (IDataEntityType)this.getDataEntityType(category), (Boolean)false));
        AbstractDataModelMetadata abstractMetadata = this.assembleMetadata(modelId, designMeta, true, category);
        if (abstractMetadata.getBizappId() == null) {
            abstractMetadata.setBizappId(designMeta.getBizappId());
        }
        PDMDesignMetaDao.setRootChildParentId(abstractMetadata);
        return abstractMetadata;
    }

    private AbstractDataModelMetadata assembleBaseMetadata(String modelId, DataModelDesignMeta designMeta, DMMetaCategory category) {
        List<ExtMetadataNode> extNodeList;
        String xml = designMeta.getDataXml();
        String isv = ISVService.getISVInfo().getId();
        String modelIsv = designMeta.getIsv();
        boolean currentIsv = isv.equals(modelIsv);
        ArrayList<MetadataNode> nodes = new ArrayList<MetadataNode>();
        nodes.add(new MetadataNode(modelId, "", xml));
        ArrayList<ExtMetadataNode> extMetadataNodeList = new ArrayList<ExtMetadataNode>(10);
        if (!currentIsv && (extNodeList = this.getMExtNode(modelId, category)) != null) {
            extMetadataNodeList.addAll(extNodeList);
        }
        MetadataTree tree = new MetadataTree(nodes);
        tree.fillExtends(extMetadataNodeList);
        AbstractDataModelMetadata buildMetadata = this.buildMetadata(this.binder, tree);
        String mergeVer = this.buildMergeVer(tree);
        buildMetadata.setMergeVersion(mergeVer);
        return buildMetadata;
    }

    private AbstractDataModelMetadata assembleMetadata(String modelId, DataModelDesignMeta designMeta, boolean isBase, DMMetaCategory category) {
        String masterId = designMeta.getMasterId();
        String xml = designMeta.getDataXml();
        ArrayList<MetadataNode> nodes = new ArrayList<MetadataNode>();
        ArrayList<ExtMetadataNode> extMetadataNodeList = new ArrayList<ExtMetadataNode>(10);
        if (StringUtils.isNotBlank((CharSequence)masterId)) {
            DataModelDesignMeta masterDesignMeta = (DataModelDesignMeta)((Object)BusinessDataReader.read((Object)masterId, (IDataEntityType)this.getDataEntityType(category), (Boolean)false));
            nodes.add(new MetadataNode(masterId, "", masterDesignMeta.getDataXml()));
            extMetadataNodeList.add(new ExtMetadataNode(masterId, modelId, masterId, xml));
        } else {
            nodes.add(new MetadataNode(modelId, "", xml));
        }
        if (!isBase) {
            if (category == DMMetaCategory.MDataModel) {
                extMetadataNodeList.addAll(this.getDExtNode(modelId, DMMetaCategory.DDataModel));
            } else if (category == DMMetaCategory.MDiagram) {
                extMetadataNodeList.addAll(this.getDExtNode(modelId, DMMetaCategory.DDiagram));
            }
        }
        MetadataTree tree = new MetadataTree(nodes);
        tree.fillExtends(extMetadataNodeList);
        AbstractDataModelMetadata buildMetadata = this.buildMetadata(this.binder, tree);
        String mergeVer = this.buildMergeVer(tree);
        buildMetadata.setMergeVersion(mergeVer);
        return buildMetadata;
    }

    private AbstractDataModelMetadata assembleWholeMetadata(String modelId, DataModelDesignMeta designMeta, DMMetaCategory category) {
        String masterId = designMeta.getMasterId();
        String xml = designMeta.getDataXml();
        ArrayList<MetadataNode> nodes = new ArrayList<MetadataNode>();
        ArrayList<ExtMetadataNode> extMetadataNodeList = new ArrayList<ExtMetadataNode>(10);
        nodes.add(new MetadataNode(modelId, "", xml));
        List<ExtMetadataNode> extNodeList = this.getMExtNode(modelId, category);
        if (extNodeList != null) {
            extMetadataNodeList.addAll(extNodeList);
        }
        MetadataTree tree = new MetadataTree(nodes);
        tree.fillExtends(extMetadataNodeList);
        AbstractDataModelMetadata buildMetadata = this.buildMetadata(this.binder, tree);
        String mergeVer = this.buildMergeVer(tree);
        buildMetadata.setMergeVersion(mergeVer);
        return buildMetadata;
    }

    private List<ExtMetadataNode> getDExtNode(String modelId, DMMetaCategory category) {
        ArrayList<String> ids = new ArrayList<String>(1);
        ids.add(modelId);
        return this.getExtNode(ids, this.getDataEntityType(category));
    }

    private List<ExtMetadataNode> getMExtNode(String modelId, DMMetaCategory category) {
        ArrayList<String> ids = new ArrayList<String>(1);
        ids.add(modelId);
        return this.getExtNode(ids, this.getDataEntityType(category));
    }

    private List<ExtMetadataNode> getExtNode(List<String> modelIds, IDataEntityType designerMetaType) {
        if (designerMetaType == null) {
            return new ArrayList<ExtMetadataNode>();
        }
        String tableName = designerMetaType.getAlias();
        SqlBuilder sql = new SqlBuilder();
        sql.append("select FId,FMASTERID, FDATA, FVERSION from ", new Object[0]).append(tableName, new Object[0]).appendIn("where FMASTERID", modelIds.toArray());
        if (designerMetaType instanceof DeltaPDMEntityDesignMeta) {
            sql.append(" and fcreator = '", new Object[0]).append(RequestContext.get().getUserId(), new Object[0]).append("'", new Object[0]);
            sql.append(" and fismerge = '0' ", new Object[0]);
        }
        sql.append(" order by findex asc", new Object[0]);
        ResultSetHandler<List<ExtMetadataNode>> action = new ResultSetHandler<List<ExtMetadataNode>>(){

            public List<ExtMetadataNode> handle(ResultSet rs) throws Exception {
                ArrayList<ExtMetadataNode> list = new ArrayList<ExtMetadataNode>(10);
                while (rs.next()) {
                    String id = rs.getString("FId");
                    String masterId = rs.getString("FMASTERID");
                    String version = rs.getString("FVERSION");
                    ExtMetadataNode node = new ExtMetadataNode(masterId, id, masterId, rs.getString("FDATA"));
                    node.setVersion(version);
                    list.add(node);
                }
                return list;
            }
        };
        return (List)DB.query((DBRoute)this.getDbRoute(designerMetaType), (SqlBuilder)sql, (ResultSetHandler)action);
    }

    boolean modelExist(String modelId, IDataEntityType designerMetaType) {
        String tableName = designerMetaType.getAlias();
        String sql = String.format("select FId from %s where FID = ? ", tableName);
        Object[] params = new Object[]{modelId};
        ResultSetHandler<Boolean> action = new ResultSetHandler<Boolean>(){

            public Boolean handle(ResultSet rs) throws Exception {
                if (rs.next()) {
                    return true;
                }
                return false;
            }
        };
        return (Boolean)DB.query((DBRoute)this.getDbRoute(designerMetaType), (String)sql, (Object[])params, (ResultSetHandler)action);
    }

    public boolean modelExistExt(String modelId, IDataEntityType designerMetaType) {
        String tableName = designerMetaType.getAlias();
        String sql = String.format("select FId from %s where FMASTERID = ? ", tableName);
        Object[] params = new Object[]{modelId};
        ResultSetHandler<Boolean> action = new ResultSetHandler<Boolean>(){

            public Boolean handle(ResultSet rs) throws Exception {
                if (rs.next()) {
                    return true;
                }
                return false;
            }
        };
        return (Boolean)DB.query((DBRoute)this.getDbRoute(designerMetaType), (String)sql, (Object[])params, (ResultSetHandler)action);
    }

    public int getParalleExtCountByIsv(String modelId, String isv) {
        IDataEntityType mDesignMetaType = OrmUtils.getDataEntityType(PDMEntityDesignMeta.class);
        ORM orm = ORM.create();
        orm.setDataEntityType(mDesignMetaType.getName(), mDesignMetaType);
        QFilter[] qFilters = new QFilter[]{new QFilter("masterId", "=", (Object)modelId), new QFilter("isv", "=", (Object)isv)};
        return orm.count(mDesignMetaType.getName(), mDesignMetaType.getName(), qFilters);
    }

    private List<ExtMetadataNode> getExtendNodes(MetadataTree tree, IDataEntityType designerMetaType, String masterId, String isv) {
        final HashSet<String> inTreeIds = new HashSet<String>();
        inTreeIds.addAll(tree.getNodeIds());
        String ids = StringUtils.join((Object[])tree.getNodeIds().toArray(), (String)"','");
        String tableName = designerMetaType.getAlias();
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("SELECT FID, FMasterId, FData, FVERSION from ", new Object[0]).append(tableName, new Object[0]).append(" WHERE ", new Object[0]).appendIn("FMasterId", tree.getNodeIds().toArray()).append(" and FType = '2' order by fversion", new Object[0]);
        ResultSetHandler<List<ExtMetadataNode>> action = new ResultSetHandler<List<ExtMetadataNode>>(){

            public List<ExtMetadataNode> handle(ResultSet rs) throws Exception {
                ArrayList<ExtMetadataNode> list = new ArrayList<ExtMetadataNode>();
                while (rs.next()) {
                    String id = rs.getString("FId");
                    String masterId = rs.getString("FMasterId");
                    String version = rs.getString("FVERSION");
                    if (inTreeIds.contains(id)) continue;
                    inTreeIds.add(id);
                    ExtMetadataNode node = new ExtMetadataNode(masterId, id, masterId, rs.getString("FDATA"));
                    node.setVersion(version);
                    list.add(node);
                }
                return list;
            }
        };
        return (List)DB.query((DBRoute)this.getDbRoute(designerMetaType), (SqlBuilder)sqlBuilder, (ResultSetHandler)action);
    }

    private DBRoute getDbRoute(IDataEntityType metaType) {
        String dbRouteKey = metaType.getDBRouteKey();
        return StringUtils.isBlank((CharSequence)dbRouteKey) ? DBRoute.meta : DBRoute.of((String)dbRouteKey);
    }

    private AbstractDataModelMetadata buildMetadata(DcBinder binder, MetadataTree tree) {
        MetadataNode node = tree.getRootNode();
        if (node == null) {
            String treeinfo = SerializationUtils.toJsonString((Object)tree);
            String error = String.format(ResManager.loadKDString((String)"\u5143\u6570\u636e\u7684\u7ee7\u627f\u5173\u7cfb\u9519\u8bef\uff0c\u7236\u4e1a\u52a1\u5bf9\u8c61\u4e0d\u5b58\u5728.%1$sMetadataTree\uff1a%2$s", (String)"AbstractMetadataReader_2", (String)"bos-metadata", (Object[])new Object[0]), System.lineSeparator(), treeinfo);
            throw new KDException(BosErrorCode.metaNotFound, new Object[]{error});
        }
        DcxmlSerializer serializer = this.getDcxmlSerializer(binder);
        return (AbstractDataModelMetadata)((Object)this.deSerializer(serializer, tree, node, null));
    }

    private DcxmlSerializer getDcxmlSerializer(DcBinder pbinder) {
        if (this.xmlSerializer == null) {
            if (pbinder == null) {
                DcBinder dcBinder = this.getBinder();
                this.xmlSerializer = new DcxmlSerializer(dcBinder);
            } else {
                this.xmlSerializer = new DcxmlSerializer(pbinder);
            }
            this.xmlSerializer.setColloctionIgnorePKValue(this.isColloctionIgnorePKValue());
        }
        return this.xmlSerializer;
    }

    protected DcBinder getBinder() {
        if (StringUtils.isBlank((CharSequence)modelType)) {
            throw new KDException(BosErrorCode.variableNotValid, new Object[]{ResManager.loadKDString((String)"MetadataReader\u65b9\u6cd5\uff1acreateBinder\uff0c\u53c2\u6570ModelType\u4e3a\u7a7a\u65e0\u6cd5\u521d\u59cb\u5316\u7ed1\u5b9a\u5668\u3002", (String)"AbstractMetadataReader_0", (String)"bos-metadata", (Object[])new Object[0])});
        }
        if (this.binder == null) {
            DomainModelType domainModel = DomainModelType.getDomainModelType((String)modelType, (boolean)false);
            this.binder = new DomainModelBinder(domainModel);
        }
        return this.binder;
    }

    private Object deSerializer(DcxmlSerializer xmlSerializer, MetadataTree tree, MetadataNode node, Object baseMetadata) {
        DomainModelBinder dbinder = (DomainModelBinder)xmlSerializer.getBinder();
        dbinder.setLCId("zh_CN");
        dbinder.setInherit(node.isInherit());
        if (node instanceof ExtMetadataNode) {
            dbinder.setExt(true);
        } else {
            dbinder.setExt(false);
        }
        xmlSerializer.setOnlyLocaleVale(false);
        xmlSerializer.setResetLoacaleValueBy2052(true);
        Object metadata = xmlSerializer.deserializeFromString(node.getXml(), baseMetadata);
        xmlSerializer.setOnlyLocaleVale(true);
        for (Map.Entry entry : node.getLoacleXml().entrySet()) {
            String localeId = (String)entry.getKey();
            if ("en".equals(localeId)) continue;
            dbinder.setLCId(localeId);
            String localeXml = (String)node.getLoacleXml().getItem(localeId);
            if (!StringUtils.isNotBlank((CharSequence)localeXml)) continue;
            metadata = xmlSerializer.deserializeFromString(localeXml, metadata);
        }
        for (MetadataNode metadataNode : node.getExtendNodes()) {
            metadata = this.deSerializer(xmlSerializer, tree, metadataNode, metadata);
        }
        if (node.getChildNode() != null) {
            metadata = this.deSerializer(xmlSerializer, tree, node.getChildNode(), metadata);
        }
        return metadata;
    }

    private boolean isColloctionIgnorePKValue() {
        return this.colloctionIgnorePKValue;
    }

    private void setColloctionIgnorePKValue(boolean colloctionIgnorePKValue) {
        this.colloctionIgnorePKValue = colloctionIgnorePKValue;
    }

    private String buildMergeVer(MetadataTree tree) {
        ArrayList<MetadataNode> nodes = new ArrayList<MetadataNode>(10);
        nodes.addAll(tree.getNodes().values());
        nodes.addAll(tree.getExtNodes().values());
        StringBuilder mergeVer = new StringBuilder();
        int index = 0;
        for (int i = 0; i < nodes.size(); ++i) {
            String ver;
            MetadataNode node = (MetadataNode)nodes.get(i);
            String string = ver = node == null ? "" : node.getVersion();
            if (StringUtils.isBlank((CharSequence)ver)) continue;
            if (index == 0) {
                mergeVer.append(ver);
            } else {
                mergeVer.append(",").append(ver);
            }
            ++index;
        }
        return mergeVer.toString();
    }
}

