/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.datamodel.metadata.pdm;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.datamodel.metadata.AbstractDataModelMetadata;
import kd.bos.datamodel.metadata.DMClientMetadata;
import kd.bos.datamodel.metadata.DMMetaCategory;
import kd.bos.datamodel.metadata.DataModelDesignMeta;
import kd.bos.datamodel.metadata.pdm.DeltaPDMDiagramDesignMeta;
import kd.bos.datamodel.metadata.pdm.DeltaPDMEntityDesignMeta;
import kd.bos.datamodel.metadata.pdm.IPDMDesignMetaReader;
import kd.bos.datamodel.metadata.pdm.IPDMDesignMetaWriter;
import kd.bos.datamodel.metadata.pdm.PDMDesignMetaDao;
import kd.bos.datamodel.metadata.pdm.PDMDesignMetaReader;
import kd.bos.datamodel.metadata.pdm.PDMDesignMetaVisitFactory;
import kd.bos.datamodel.metadata.pdm.PDMDiagramDesignMeta;
import kd.bos.datamodel.metadata.pdm.PDMDiagramMetadata;
import kd.bos.datamodel.metadata.pdm.PDMEntityDesignMeta;
import kd.bos.datamodel.metadata.pdm.PDMEntityMetadata;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.isv.ISVService;
import kd.bos.metadata.dao.MetadataSerializer;
import kd.bos.metadata.domainmodel.DomainModelBinder;

class PDMDesignMetaWriter
implements IPDMDesignMetaWriter {
    private static final String ZH_CN = "zh_CN";
    private static final String DM_META = "dmmeta";
    private static final String modelType = "PhysicalDataModel";
    protected MetadataSerializer serializer = new MetadataSerializer("PhysicalDataModel");

    public PDMDesignMetaWriter() {
        if (this.serializer.getBinder() instanceof DomainModelBinder) {
            ((DomainModelBinder)this.serializer.getBinder()).setInheritFix(true);
        }
    }

    @Override
    public void save(List<DataModelDesignMeta> designMetaList) {
        for (DataModelDesignMeta designMeta : designMetaList) {
            BusinessDataWriter.delete((IDataEntityType)OrmUtils.getDataEntityType(((Object)((Object)designMeta)).getClass()), (Object[])new Object[]{designMeta.getId()});
            BusinessDataWriter.save((IDataEntityType)OrmUtils.getDataEntityType(((Object)((Object)designMeta)).getClass()), (Object[])new Object[]{designMeta});
        }
    }

    @Override
    public void delete(Object[] ids) {
        List<String> dataModelIdList = this.getDIdsByMasterIds(ids, OrmUtils.getDataEntityType(DeltaPDMEntityDesignMeta.class));
        List<String> diagramIdList = this.getDIdsByMasterIds(ids, OrmUtils.getDataEntityType(DeltaPDMDiagramDesignMeta.class));
        try (TXHandle tx = TX.requiresNew((String)"DataModel_Delete");){
            try {
                BusinessDataWriter.delete((IDataEntityType)OrmUtils.getDataEntityType(PDMEntityDesignMeta.class), (Object[])ids);
                BusinessDataWriter.delete((IDataEntityType)OrmUtils.getDataEntityType(PDMDiagramDesignMeta.class), (Object[])ids);
                BusinessDataWriter.delete((IDataEntityType)OrmUtils.getDataEntityType(DeltaPDMEntityDesignMeta.class), (Object[])dataModelIdList.toArray());
                BusinessDataWriter.delete((IDataEntityType)OrmUtils.getDataEntityType(DeltaPDMDiagramDesignMeta.class), (Object[])diagramIdList.toArray());
            }
            catch (Exception e) {
                tx.markRollback();
                throw e;
            }
        }
    }

    private boolean updateStatus(String id, boolean isMerge) {
        String sql = "update T_DM_PDMMODEL_D set fismerge = ? where fid = ?";
        Object[] sqlParameters = new SqlParameter[2];
        String merge = isMerge ? "1" : "0";
        sqlParameters[0] = new SqlParameter(":fismerge", 1, (Object)merge);
        sqlParameters[1] = new SqlParameter(":fid", 12, (Object)id);
        DB.execute((DBRoute)DBRoute.meta, (String)sql, (Object[])sqlParameters);
        sql = "update T_DM_PDMDIAGRAM_D set fismerge = ? where fid = ?";
        return DB.execute((DBRoute)DBRoute.meta, (String)sql, (Object[])sqlParameters);
    }

    @Override
    public boolean deleteDeltaData(String masterId) {
        String sql = "delete from T_DM_PDMMODEL_D where fmasterid=? and fcreator=? and fisv=?";
        Object[] sqlParameters = new SqlParameter[]{new SqlParameter(":fmasterid", 12, (Object)masterId), new SqlParameter(":fcreator", -5, (Object)RequestContext.get().getCurrUserId()), new SqlParameter(":fisv", 12, (Object)ISVService.getISVInfo().getId())};
        return DB.execute((DBRoute)DBRoute.meta, (String)sql, (Object[])sqlParameters);
    }

    @Override
    public PDMEntityMetadata convertToMetadata(Map<String, Object> content) {
        Map dmMeta = (Map)content.get(DM_META);
        String defaultLCid = this.getLang(content);
        this.serializer.getBinder().setLCId(defaultLCid);
        DMClientMetadata clientMetadata = (DMClientMetadata)((Object)this.serializer.deserializeFromMap(dmMeta, null));
        PDMEntityMetadata pdmMetadata = clientMetadata.convertToDataModelMeta();
        return pdmMetadata;
    }

    @Override
    public List<DataModelDesignMeta> convertToDeltaDesignMeta(PDMEntityMetadata pdmMetadata) {
        DataModelDesignMeta diagramDesignMeta;
        PDMDesignMetaReader dataModelReader = new PDMDesignMetaReader();
        DeltaPDMEntityDesignMeta dDataModelDesignMeta = dataModelReader.loadDDesignMeta(pdmMetadata.getId(), new DeltaPDMEntityDesignMeta());
        DeltaPDMDiagramDesignMeta deltaPDMDiagramDesignMeta = dataModelReader.loadDDesignMeta(pdmMetadata.getId(), new DeltaPDMDiagramDesignMeta());
        ArrayList<DataModelDesignMeta> designMetaList = new ArrayList<DataModelDesignMeta>(2);
        designMetaList.add(this.convertToDesignMeta(pdmMetadata, dDataModelDesignMeta, DMMetaCategory.MDataModel));
        PDMDiagramMetadata pdmDiagramMetadata = pdmMetadata.getPdmDiagramMetadata();
        if (pdmDiagramMetadata != null && (diagramDesignMeta = this.convertToDesignMeta(pdmDiagramMetadata, deltaPDMDiagramDesignMeta, DMMetaCategory.MDiagram)) != null) {
            designMetaList.add(diagramDesignMeta);
        }
        return designMetaList;
    }

    private DataModelDesignMeta convertToDesignMeta(AbstractDataModelMetadata dataModelMetadata, DeltaPDMEntityDesignMeta dDataModelDesignMeta, DMMetaCategory category) {
        String id;
        IPDMDesignMetaReader dataModelReader = PDMDesignMetaVisitFactory.getPDMDesignMetaReader();
        AbstractDataModelMetadata baseMetadata = dataModelReader.loadBaseMeta(id = dataModelMetadata.getId(), category);
        if (baseMetadata != null && StringUtils.isNotBlank((CharSequence)baseMetadata.getMasterId())) {
            PDMDesignMetaDao.resetParentId(baseMetadata, id);
        }
        PDMDesignMetaDao.clearRootChildParentId(dataModelMetadata);
        if (baseMetadata != null) {
            PDMDesignMetaDao.clearRootChildParentId(baseMetadata);
        }
        this.serializer.getBinder().setLCId(ZH_CN);
        String xml = this.serializer.buildDiffXml((Object)dataModelMetadata, (Object)baseMetadata, false);
        DeltaPDMEntityDesignMeta designMeta = (DeltaPDMEntityDesignMeta)dataModelMetadata.convertToDDesignMeta(xml, dDataModelDesignMeta);
        return designMeta;
    }

    @Override
    public List<DataModelDesignMeta> convertToMDesignMeta(PDMEntityMetadata pdmMetadata) {
        DataModelDesignMeta diagramDesignMeta;
        ArrayList<DataModelDesignMeta> designMetaList = new ArrayList<DataModelDesignMeta>(2);
        designMetaList.add(this.convertToMDesignMeta(pdmMetadata, null, DMMetaCategory.MDataModel));
        PDMDiagramMetadata pdmDiagramMetadata = pdmMetadata.getPdmDiagramMetadata();
        if (pdmDiagramMetadata != null && (diagramDesignMeta = this.convertToMDesignMeta(pdmDiagramMetadata, null, DMMetaCategory.MDiagram)) != null) {
            designMetaList.add(diagramDesignMeta);
        }
        return designMetaList;
    }

    @Override
    public DataModelDesignMeta convertToMDesignMeta(AbstractDataModelMetadata dataModelMetadata, PDMEntityDesignMeta designMeta, DMMetaCategory category) {
        this.serializer.getBinder().setLCId(ZH_CN);
        IPDMDesignMetaReader reader = PDMDesignMetaVisitFactory.getPDMDesignMetaReader();
        AbstractDataModelMetadata baseMeta = reader.loadBaseMeta(dataModelMetadata.getMasterId(), category);
        PDMDesignMetaDao.clearRootChildParentId(dataModelMetadata);
        if (baseMeta != null) {
            PDMDesignMetaDao.clearRootChildParentId(baseMeta);
        }
        String xml = this.serializer.buildDiffXml((Object)dataModelMetadata, (Object)baseMeta, false);
        return dataModelMetadata.convertMDesignMeta(xml, designMeta);
    }

    private String getLang(Map<String, Object> content) {
        String lang = (String)content.get("language");
        if (StringUtils.isBlank((CharSequence)lang)) {
            lang = ZH_CN;
        }
        return lang;
    }

    private List<String> getDIdsByMasterIds(Object[] modelIdList, IDataEntityType designerMetaType) {
        String tableName = designerMetaType.getAlias();
        SqlBuilder sql = new SqlBuilder();
        sql.append(String.format("select FId from %s where ", tableName), new Object[0]).append("fisv = ? ", new Object[]{new SqlParameter(":fisv", 12, (Object)ISVService.getISVInfo().getId())}).append("and ", new Object[0]).appendIn("FMASTERID", modelIdList);
        ResultSetHandler<List<String>> action = new ResultSetHandler<List<String>>(){

            public List<String> handle(ResultSet rs) throws Exception {
                ArrayList<String> ids = new ArrayList<String>(10);
                while (rs.next()) {
                    ids.add(rs.getString(1));
                }
                return ids;
            }
        };
        return (List)DB.query((DBRoute)this.getDbRoute(designerMetaType), (SqlBuilder)sql, (ResultSetHandler)action);
    }

    private DBRoute getDbRoute(IDataEntityType metaType) {
        String dbRouteKey = metaType.getDBRouteKey();
        return StringUtils.isBlank((CharSequence)dbRouteKey) ? DBRoute.meta : DBRoute.of((String)dbRouteKey);
    }
}

