/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.datamodel.metadata.pdm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.CollectionPropertyAttribute;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.datamodel.DMObject;
import kd.bos.datamodel.DataModel;
import kd.bos.datamodel.meta.element.BaseControl;
import kd.bos.datamodel.meta.element.DMPackageAp;
import kd.bos.datamodel.meta.element.DataModelAp;
import kd.bos.datamodel.meta.element.DataModelBaseElement;
import kd.bos.datamodel.meta.element.pdm.PhysicalDiagram;
import kd.bos.datamodel.metadata.AbstractDataModelMetadata;
import kd.bos.datamodel.metadata.DMClientMetadata;
import kd.bos.datamodel.metadata.DataModelDesignMeta;
import kd.bos.datamodel.metadata.pdm.DeltaPDMEntityDesignMeta;
import kd.bos.datamodel.metadata.pdm.PDMDiagramMetadata;
import kd.bos.datamodel.metadata.pdm.PDMEntityDesignMeta;
import kd.bos.datamodel.pdm.model.DataType;
import kd.bos.datamodel.pdm.model.PDModel;
import kd.bos.db.DB;
import kd.bos.metadata.dao.MetadataSerializer;
import kd.bos.metadata.domainmodel.DomainModelBinder;

public final class PDMEntityMetadata
extends AbstractDataModelMetadata {
    private List<DMPackageAp> packageAps = new ArrayList<DMPackageAp>(10);
    private List<BaseControl> items = new ArrayList<BaseControl>(10);
    private PDMDiagramMetadata pdmDiagramMetadata = new PDMDiagramMetadata();

    public void bindDiagramMetadata() {
        this.getPdmDiagramMetadata().setId(this.getId());
        this.getPdmDiagramMetadata().setNumber(this.getNumber());
        this.getPdmDiagramMetadata().setName(this.getName());
        this.getPdmDiagramMetadata().setBizappId(this.getBizappId());
        this.getPdmDiagramMetadata().setProduct(this.getProduct());
        this.getPdmDiagramMetadata().setIsv(this.getIsv());
        this.getPdmDiagramMetadata().setVersion(this.getVersion());
        this.getPdmDiagramMetadata().setCreator(this.getCreator());
        this.getPdmDiagramMetadata().setCreatedDate(this.getCreatedDate());
        this.getPdmDiagramMetadata().setMasterId(this.getMasterId());
        this.getPdmDiagramMetadata().setModelType(this.getModelType());
        this.getPdmDiagramMetadata().setModifierId(this.getModifierId());
        this.getPdmDiagramMetadata().setModifyDate(this.getModifyDate());
        this.getPdmDiagramMetadata().setDevType(this.getDevType());
        this.getPdmDiagramMetadata().setParentId(this.getParentId());
        this.getPdmDiagramMetadata().setDescription(this.getDescription());
    }

    public DataModel buildDataModel() {
        return this.createDataModel();
    }

    protected DataModel createDataModel() {
        PDModel model = new PDModel();
        model.setId(this.getId());
        model.setNumber(this.getNumber());
        model.setName(this.getName().getLocaleValue());
        for (DMPackageAp packageAp : this.packageAps) {
            DMObject pkg = packageAp.createDMO();
            model.getItems().add(pkg);
        }
        return model;
    }

    public Map<String, Object> buildDesignMeta(String lang) {
        HashMap<String, Object> clientMeta = new HashMap<String, Object>(16);
        MetadataSerializer ser = new MetadataSerializer(this.getModelType());
        DomainModelBinder binder = (DomainModelBinder)ser.getBinder();
        binder.setLCId(lang);
        binder.setWriteInheritFlag(true);
        clientMeta.put("dmmeta", ser.serializeToMap((Object)this.convertToClientMetadata()));
        clientMeta.put("datatype", this.getDataType());
        clientMeta.put("mergeVersion", this.getMergeVersion());
        return clientMeta;
    }

    private Map<Short, String> getDataType() {
        DataType[] dataTypes = DataType.values();
        HashMap<Short, String> dataType = new HashMap<Short, String>(dataTypes.length);
        for (DataType value : DataType.values()) {
            dataType.put(value.getValue(), value.name());
        }
        return dataType;
    }

    private DMClientMetadata convertToClientMetadata() {
        this.items.clear();
        DataModelAp dataModelAp = new DataModelAp();
        dataModelAp.setKey(this.getNumber());
        dataModelAp.setName(this.getName());
        dataModelAp.setId(this.getId());
        dataModelAp.setDescription(this.getDescription() == null ? "" : this.getDescription().getLocaleValue());
        this.items.add(dataModelAp);
        if (this.packageAps != null) {
            for (DMPackageAp packageAp : this.packageAps) {
                packageAp.setParentId(dataModelAp.getId());
                this.items.add(packageAp);
                packageAp.createIndex();
                this.items.addAll(packageAp.getItems());
            }
        }
        this.sortItems();
        if (this.getPdmDiagramMetadata() != null && this.getPdmDiagramMetadata().getPhysicalDiagramAps() != null) {
            List<PhysicalDiagram> physicalDiagramAps = this.getPdmDiagramMetadata().getPhysicalDiagramAps();
            for (PhysicalDiagram physicalDiagram : physicalDiagramAps) {
                this.items.add(physicalDiagram);
                physicalDiagram.createIndex();
                this.items.addAll(physicalDiagram.getItems());
            }
        }
        DMClientMetadata clientMetadata = new DMClientMetadata();
        clientMetadata.setId(this.getId());
        clientMetadata.setProduct(this.getProduct());
        clientMetadata.setBizappId(this.getBizappId());
        clientMetadata.setNumber(this.getNumber());
        clientMetadata.setName(this.getName());
        clientMetadata.setDescription(this.getDescription());
        clientMetadata.setCreator(this.getCreator());
        clientMetadata.setCreatedDate(this.getCreatedDate());
        clientMetadata.setVersion(this.getVersion());
        clientMetadata.setIsv(this.getIsv());
        clientMetadata.setParentId(this.getParentId());
        clientMetadata.setMasterId(this.getMasterId());
        clientMetadata.setModifierId(this.getModifierId());
        clientMetadata.setModifyDate(this.getModifyDate());
        clientMetadata.setItems(this.items);
        return clientMetadata;
    }

    @Override
    public DataModelDesignMeta convertToDDesignMeta(String xml, DataModelDesignMeta designMeta) {
        if (designMeta == null) {
            IDataEntityType dataEntityType = OrmUtils.getDataEntityType(DeltaPDMEntityDesignMeta.class);
            designMeta = (DeltaPDMEntityDesignMeta)((Object)dataEntityType.createInstance());
            designMeta.setId(DB.genStringIds((String)"", (int)1)[0]);
            designMeta.setMasterId(this.getId());
            designMeta.setCreatedDate(new Date());
            designMeta.setCreator(RequestContext.get().getCurrUserId());
        }
        this.setDesignMeta(designMeta, xml, true);
        ((DeltaPDMEntityDesignMeta)designMeta).setMerge(false);
        return designMeta;
    }

    @Override
    public DataModelDesignMeta convertMDesignMeta(String xml, DataModelDesignMeta designMeta) {
        if (designMeta == null) {
            IDataEntityType dataEntityType = OrmUtils.getDataEntityType(PDMEntityDesignMeta.class);
            designMeta = (PDMEntityDesignMeta)((Object)dataEntityType.createInstance());
        }
        this.setDesignMeta(designMeta, xml);
        return designMeta;
    }

    private void sortItems() {
        Collections.sort(this.items, new Comparator<BaseControl>(){

            @Override
            public int compare(BaseControl o1, BaseControl o2) {
                int compareValue = 0;
                compareValue = o1.getParentId() == null && o2.getParentId() == null ? 0 : (o1.getParentId() == null && o2.getParentId() != null ? -1 : (o1.getParentId() != null && o2.getParentId() == null ? 1 : o1.getParentId().compareTo(o2.getParentId())));
                if (compareValue != 0) {
                    return compareValue;
                }
                if (o1 instanceof DataModelBaseElement && o2 instanceof DataModelBaseElement) {
                    return Integer.compare(((DataModelBaseElement)o1).getSeq(), ((DataModelBaseElement)o2).getSeq());
                }
                return compareValue;
            }
        });
    }

    public List<BaseControl> getItems() {
        return this.items;
    }

    public void setItems(List<BaseControl> items) {
        this.items = items;
    }

    @CollectionPropertyAttribute(collectionItemPropertyType=DMPackageAp.class)
    public List<DMPackageAp> getPackageAps() {
        return this.packageAps;
    }

    public void setPackageAps(List<DMPackageAp> packageAps) {
        this.packageAps = packageAps;
    }

    public PDMDiagramMetadata getPdmDiagramMetadata() {
        return this.pdmDiagramMetadata;
    }

    public void setPdmDiagramMetadata(PDMDiagramMetadata pdmDiagramMetadata) {
        this.pdmDiagramMetadata = pdmDiagramMetadata;
    }

    public String getModelType() {
        return "PhysicalDataModel";
    }

    @Override
    public IDataEntityType getDesingerMetaType() {
        return OrmUtils.getDataEntityType(DataModelDesignMeta.class);
    }

    @Override
    public IDataEntityType getDesingerMetaLType() {
        return null;
    }
}

