/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.business;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.devportal.business.util.DevportalVerify;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.DeleteServiceHelper;

public class LockVerify {
    private String userName;
    private boolean isLock;
    private static final String FORMNUMBER = "formnumber";
    private static final String BOS_APP_LOCKING = "bos_app_locking";
    private List<String> lockItems = new ArrayList<String>(4);
    private static final String RESULT = "result";
    private static final String USER_NAME = "username";

    public LockVerify() {
    }

    public LockVerify(String userName, boolean isLock) {
        this.userName = userName;
        this.isLock = isLock;
        this.init();
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public boolean isLock() {
        return this.isLock;
    }

    public void setLock(boolean lock) {
        this.isLock = lock;
    }

    public final void init() {
        this.lockItems.add("addnewunit");
        this.lockItems.add("addnewpage");
        this.lockItems.add("importpage");
        this.lockItems.add("fastinherit");
    }

    public Map<String, Object> verify(String item) {
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        result.put(RESULT, false);
        Object devFormLock = DevportalVerify.getParameter("dev_form_lock");
        if (devFormLock == null || !((Boolean)devFormLock).booleanValue()) {
            return result;
        }
        if (item != null && this.lockItems.contains(item)) {
            return result;
        }
        if (this.isLock) {
            String currentUser = RequestContext.get().getUserName();
            if (this.userName != null && this.userName.equals(currentUser)) {
                result.put(RESULT, false);
            } else {
                result.put(RESULT, true);
                result.put(USER_NAME, this.userName);
            }
            return result;
        }
        return result;
    }

    public void deleteLock(String formNumber) {
        QFilter qFilter = new QFilter(FORMNUMBER, "=", (Object)formNumber);
        QFilter[] qFilters = new QFilter[]{qFilter};
        DeleteServiceHelper.delete((String)BOS_APP_LOCKING, (QFilter[])qFilters);
    }
}

