/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.business;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.devportal.business.util.DevportalVerify;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class PermissionVerify {
    public static final Log logger = LogFactory.getLog(PermissionVerify.class);
    private List<String> appItems = new ArrayList<String>(2);
    private Set<String> bizApps;
    private String item;
    private String bizAppId;

    public PermissionVerify() {
    }

    public PermissionVerify(Set<String> apps, String item, String bizAppId) {
        this.bizApps = apps;
        this.item = item;
        this.bizAppId = bizAppId;
        this.init();
    }

    public final void init() {
        this.appItems.add("ADDNEW");
        this.appItems.add("VIEW");
    }

    public boolean verify() {
        Object devPermission = DevportalVerify.getParameter("dev_permission");
        if (devPermission == null) {
            return true;
        }
        if (!((Boolean)devPermission).booleanValue()) {
            return true;
        }
        return this.checkUserPermission();
    }

    public boolean checkUserPermission() {
        if (this.item != null && this.appItems.contains(this.item) || this.bizAppId == null) {
            return true;
        }
        if (this.bizApps != null && this.bizApps.add(this.bizAppId)) {
            this.bizApps.remove(this.bizAppId);
            return false;
        }
        return true;
    }

    public String getBizAppId(String bizId) {
        QFilter qFilter = new QFilter("id", "=", (Object)bizId);
        QFilter[] qFilters = new QFilter[]{qFilter};
        DynamicObject appInfo = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_formmeta", (QFilter[])qFilters);
        if (appInfo == null) {
            return null;
        }
        return appInfo.getString("bizappid");
    }

    public boolean hasPermission() {
        long userId = RequestContext.get().getCurrUserId();
        String appId = "0MKR+6YKYTIV";
        String entityNumber = "bos_app_isolation";
        String permItemId = "2KWZJQMNT=PV";
        boolean isPermission = PermissionServiceHelper.checkPermission((Long)userId, (String)appId, (String)entityNumber, (String)permItemId);
        logger.info("PermissionVerify hasPermission() result: " + isPermission);
        return isPermission;
    }

    @Deprecated
    public boolean hasPermission(long userId) {
        String appId = "0MKR+6YKYTIV";
        String entityNumber = "bos_app_isolation";
        String permItemId = "2KWZJQMNT=PV";
        boolean isPermission = PermissionServiceHelper.checkPermission((Long)userId, (String)appId, (String)entityNumber, (String)permItemId);
        logger.info("PermissionVerify hasPermission result : " + isPermission);
        return isPermission;
    }
}

