/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.business.git;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import kd.bos.devportal.business.git.GitBase;
import org.eclipse.jgit.revwalk.RevCommit;

public class GitCommit
extends GitBase<RevCommit> {
    public GitCommit(RevCommit revCommit) {
        super(revCommit);
    }

    public String getName() {
        return ((RevCommit)this.getOrigin()).getName();
    }

    public String getAuthorName() {
        return ((RevCommit)this.getOrigin()).getAuthorIdent().getName();
    }

    public String getCommitterName() {
        return ((RevCommit)this.getOrigin()).getCommitterIdent().getName();
    }

    public String getAuthorEmailAddress() {
        return ((RevCommit)this.getOrigin()).getAuthorIdent().getEmailAddress();
    }

    public String getAuthorNameEmailAddress() {
        return ((RevCommit)this.getOrigin()).getAuthorIdent().toExternalString().split(">")[0] + ">";
    }

    public final String getCommitDateTime() {
        Instant commitInstant = Instant.ofEpochSecond(((RevCommit)this.getOrigin()).getCommitTime());
        ZoneId zoneId = ((RevCommit)this.getOrigin()).getAuthorIdent().getTimeZone().toZoneId();
        ZonedDateTime authorCommitDateTime = ZonedDateTime.ofInstant(commitInstant, zoneId);
        return authorCommitDateTime.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
    }

    public final String getShortMessage() {
        return ((RevCommit)this.getOrigin()).getShortMessage();
    }

    public final String getFormatFullMessage() {
        return ((RevCommit)this.getOrigin()).getFullMessage();
    }
}

