/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.business.git;

import com.alibaba.fastjson.JSONArray;
import java.io.File;
import java.util.List;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.devportal.business.git.GitContext;
import kd.bos.devportal.business.git.GitHandler;
import kd.bos.devportal.business.git.GitOperationUtils;
import kd.bos.devportal.business.hosting.GitOperationUtil;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.deploy.DeployFile;

public class GitCommitValidatorHandler
implements GitHandler {
    private static final String PAGE = "page";
    private static final String SCRIPT = "script";
    private static final String BOTP = "botp";
    private static final String BOTP_ConvertRule = "botp_cr";
    private static final String BOTP_WriteBackRule = "botp_wb";
    private static final String BOTP_BalanceUpdateRule = "botp_bur";
    private static final String CLOUD = "cloud";
    private static final Log log = LogFactory.getLog(GitCommitValidatorHandler.class);

    @Override
    public void handler(GitContext context, AbstractFormPlugin plugin) {
        String type;
        switch (type = context.getType()) {
            case "page": {
                this.validatorPage(context);
                break;
            }
            case "script": {
                this.validatorScript(context);
                break;
            }
            case "botp_cr": 
            case "botp_wb": 
            case "botp_bur": {
                this.validatorBotp(context, plugin);
                break;
            }
            case "cloud": {
                this.validatorCloud(context);
                break;
            }
        }
    }

    private void validatorPage(GitContext context) {
        String id = context.getId();
        try {
            List<DeployFile> list = MetadataDao.getFormDeployFile((String)id);
            list = list.stream().filter(f -> !GitOperationUtil.isIgnoreFile(f.getFileName())).collect(Collectors.toList());
            this.compareFileContent(list, context);
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
    }

    private void validatorScript(GitContext context) {
        String id = context.getId();
        try {
            List deployFileList = MetadataDao.getScriptDeployFile((String[])new String[]{id});
            DeployFile df = (DeployFile)deployFileList.get(0);
            String fileName = df.getFileName();
            String fileContent = df.getFileContent();
            String lastCommitFileContent = this.getLastCommitFileContent(context, fileName);
            if (StringUtils.isNotBlank((CharSequence)fileContent) && fileContent.equals(lastCommitFileContent)) {
                context.setNeedCommit(false);
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
    }

    private void validatorBotp(GitContext context, AbstractFormPlugin plugin) {
        String commitParams = plugin.getPageCache().get("ruleIds");
        try {
            JSONArray ruleIds = (JSONArray)JSONArray.parse((String)commitParams);
            List<Object> convertRuleDeployFiles = GitOperationUtil.getBotpDeployFiles(context.getType(), ruleIds);
            convertRuleDeployFiles = convertRuleDeployFiles.stream().filter(f -> !GitOperationUtil.isIgnoreFile(f.getFileName())).collect(Collectors.toList());
            this.compareFileContent(convertRuleDeployFiles, context);
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
    }

    private void validatorCloud(GitContext context) {
        String id = context.getId();
        try {
            List<DeployFile> list = MetadataDao.getCloudDeployFile((String)id);
            list = list.stream().filter(f -> !GitOperationUtil.isIgnoreFile(f.getFileName())).collect(Collectors.toList());
            this.compareFileContent(list, context);
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
    }

    private void compareFileContent(List<DeployFile> list, GitContext context) {
        int i = 0;
        for (DeployFile deployFile : list) {
            String fileName = deployFile.getFileName();
            String fileContent = deployFile.getFileContent();
            String lastCommitFileContent = this.getLastCommitFileContent(context, fileName);
            if (!StringUtils.isNotBlank((CharSequence)fileContent)) continue;
            String string = lastCommitFileContent = lastCommitFileContent == null ? null : lastCommitFileContent.trim();
            if (!fileContent.trim().equals(lastCommitFileContent)) continue;
            ++i;
        }
        if (i == list.size()) {
            context.setNeedCommit(false);
        }
    }

    private String getLastCommitFileContent(GitContext context, String name) {
        String rootPath = context.getGitRootPath();
        String metadataRootPath = this.getMetadataRootPath(rootPath);
        String personalRepository = context.getPersonalGitRepository();
        return GitOperationUtils.getLastCommitFile(personalRepository, metadataRootPath, name);
    }

    private String getMetadataRootPath(String gitRootpath) {
        String result = "";
        String separator = Matcher.quoteReplacement(File.separator);
        if (!StringUtils.isBlank((CharSequence)gitRootpath)) {
            result = !(gitRootpath = gitRootpath.replaceAll("\\\\", separator).replaceAll("/", separator)).startsWith(File.separator) ? File.separator + gitRootpath : gitRootpath;
        }
        return result;
    }
}

