/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.business.git;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.devportal.business.git.GitContext;
import kd.bos.devportal.business.git.GitHandler;
import kd.bos.devportal.business.git.GitOperationUtils;
import kd.bos.form.IFormView;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetadataDao;
import org.eclipse.jgit.api.CommitCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.RmCommand;
import org.eclipse.jgit.api.errors.GitAPIException;

public class GitDeleteHandler
implements GitHandler {
    private static final Log log = LogFactory.getLog(GitDeleteHandler.class);

    @Override
    public void handler(GitContext context, AbstractFormPlugin plugin) {
        String deleteId = context.getDeleteId();
        if (StringUtils.isBlank((CharSequence)deleteId)) {
            log.debug("delete file is bank");
            return;
        }
        String type = context.getType();
        if ("page".equals(type)) {
            this.deletePage(context, plugin);
        } else if ("script".equals(type)) {
            this.deleteScript(context, plugin);
        }
    }

    private void deleteScript(GitContext context, AbstractFormPlugin plugin) {
        try {
            List scriptDeployFile = MetadataDao.getScriptDeployFile((String[])new String[]{context.getDeleteId()});
            ArrayList<String> fileName = new ArrayList<String>(scriptDeployFile.size());
            scriptDeployFile.forEach(file -> fileName.add(file.getFileName()));
            this.gitRmFile(context, fileName, plugin);
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
    }

    private void deletePage(GitContext context, AbstractFormPlugin plugin) {
        try {
            String deleteId = context.getDeleteId();
            List formDeployFile = MetadataDao.getFormDeployFile((String)deleteId, (String)context.getBizAppId(), (String)context.getBizUnitId());
            ArrayList<String> fileName = new ArrayList<String>(formDeployFile.size());
            formDeployFile.forEach(file -> fileName.add(file.getFileName()));
            this.gitRmFile(context, fileName, plugin);
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
    }

    private void gitRmFile(GitContext context, List<String> fileName, AbstractFormPlugin plugin) {
        String personalGitRepository = context.getPersonalGitRepository();
        String path = personalGitRepository + File.separator + ".git";
        File file = new File(path);
        IFormView parentView = plugin.getView().getParentView();
        try (Git git = Git.open((File)file);){
            RmCommand rmCommand = git.rm();
            CommitCommand commitCommand = git.commit();
            ArrayList<String> list = new ArrayList<String>(fileName.size());
            for (String name : fileName) {
                if (!this.exitsFile(context, name)) continue;
                list.add(name);
                rmCommand.addFilepattern(context.getGitRootPath() + "/" + name);
            }
            if (list.size() < 1) {
                parentView.showTipNotification(ResManager.loadKDString((String)"Git\u4ed3\u5e93\u4e0d\u5b58\u5728\u8be5\u5143\u6570\u636e\uff0c\u65e0\u9700\u5220\u9664\u3002", (String)"GitDeleteHandler_0", (String)"bos-devportal-business", (Object[])new Object[0]));
                plugin.getView().sendFormAction(parentView);
                return;
            }
            rmCommand.call();
            for (String commitName : list) {
                commitCommand.setOnly(context.getGitRootPath() + "/" + commitName);
            }
            String email = git.getRepository().getConfig().getString("user", null, "email");
            if (StringUtils.isBlank((CharSequence)email)) {
                email = context.getUserName() + "@kingdee.com";
            }
            commitCommand.setMessage("Delete file " + fileName.get(0)).setAuthor(context.getUserName(), email).call();
        }
        catch (IOException | GitAPIException e) {
            parentView.showTipNotification(String.format(ResManager.loadKDString((String)"\u5220\u9664Git\u4ed3\u5e93\u5143\u6570\u636e\u5931\u8d25: %s", (String)"GitDeleteHandler_1", (String)"bos-devportal-business", (Object[])new Object[0]), e.getMessage()));
            plugin.getView().sendFormAction(parentView);
            context.setDeleteResult(false);
            log.error(e);
        }
    }

    private boolean exitsFile(GitContext context, String fileName) {
        String lastCommitFile = GitOperationUtils.getLastCommitFile(context.getPersonalGitRepository(), context.getGitRootPath(), fileName);
        if (lastCommitFile == null) {
            log.debug("file {} is not exists", (Object)fileName);
            return false;
        }
        return true;
    }
}

