/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.business.git;

import com.alibaba.fastjson.JSONObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.devportal.business.git.GitContext;
import kd.bos.devportal.business.git.GitSettingDao;
import kd.bos.devportal.business.git.UserCacheInfo;
import kd.bos.devportal.business.hosting.GitOperationUtil;
import kd.bos.encrypt.Encrypters;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;

public class GitLoginHandler {
    private static final Log log = LogFactory.getLog(GitLoginHandler.class);
    private static final String BIZ_APP_ID = "bizappid";
    private static final String GIT_URL = "giturl";
    private static final String GIT_GITBRANCH = "gitbranch";
    private static final String BIZUNITID = "bizunitid";
    private static final String BOS_DEVPORTAL_BUSINESS = "bos-devportal-business";
    private static final String DATA_MODEL = "dataModel";

    public static boolean hasLogin(GitContext context, AbstractFormPlugin plugin) {
        return GitLoginHandler.hasPopView(context, plugin);
    }

    private static boolean hasPopView(GitContext context, AbstractFormPlugin plugin) {
        UserCacheInfo userCacheInfo;
        JSONObject userInfo;
        DynamicObject setting;
        String bizAppId = context.getBizAppId();
        String bizUnitId = context.getBizUnitId();
        String sessionId = context.getSessionId();
        if (context.getType() != null && context.getType().startsWith("botp") && sessionId == null) {
            sessionId = SessionManager.getCurrent().get(GitOperationUtil.getSessionByRequestContext() + "gitusername");
            context.setSessionId(sessionId);
        }
        if (sessionId == null && DATA_MODEL.equals(context.getType())) {
            sessionId = SessionManager.getCurrent().get(GitOperationUtil.getSessionByRequestContext() + "gitusername");
            context.setSessionId(sessionId);
        }
        if (sessionId == null) {
            GitLoginHandler.showGitLoginPage(plugin, bizAppId, bizUnitId, context.getType());
            return true;
        }
        String userName = null;
        try {
            userName = Encrypters.decode((String)sessionId);
        }
        catch (Exception e) {
            log.error("git\u89e3\u5bc6\u5931\u8d25: " + e);
            GitLoginHandler.showGitLoginPage(plugin, bizAppId, bizUnitId, context.getType());
            return true;
        }
        GitSettingDao dao = new GitSettingDao();
        if (StringUtils.isBlank((CharSequence)bizUnitId) && StringUtils.isNotBlank((CharSequence)(bizUnitId = dao.getBizUnitId(context.getType(), context.getId())))) {
            context.setBizUnitId(bizUnitId);
        }
        if ((setting = dao.getSetting(bizAppId, bizUnitId, userName)) == null) {
            setting = dao.getSetting(bizAppId, null, userName);
            context.setBizUnitId(null);
            if (setting == null) {
                if (!DATA_MODEL.equals(context.getType())) {
                    plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5e94\u7528\u6ca1\u6709\u914d\u7f6egit\u4ed3\u5e93\uff0c\u8bf7\u5148\u914d\u7f6e\u3002", (String)"GitLoginHandler_0", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]));
                }
                GitLoginHandler.showGitLoginPage(plugin, bizAppId, bizUnitId, context.getType());
                return true;
            }
        }
        if ((userInfo = (userCacheInfo = new UserCacheInfo()).getUserInfo(sessionId)) == null || userInfo.get((Object)"password") == null) {
            String gitUrl = setting.getString(GIT_URL);
            String branch = setting.getString(GIT_GITBRANCH);
            plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u767b\u5f55\u4fe1\u606f\u5df2\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55\u3002", (String)"GitLoginHandler_1", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]));
            GitLoginHandler.showGitLoginInfo(gitUrl, branch, bizAppId, plugin, context);
            return true;
        }
        context.setUserName(userName);
        String passWord = (String)userInfo.get((Object)"password");
        context.setPassWord(passWord);
        return false;
    }

    private static void showGitLoginPage(AbstractFormPlugin plugin, String bizAppId, String bizUnitId, String type) {
        if (DATA_MODEL.equals(type)) {
            plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5e94\u7528\u6ca1\u6709\u914d\u7f6egit\u4ed3\u5e93\uff0c\u8bf7\u524d\u5f80\u5f00\u53d1\u5e73\u53f0\u5e94\u7528\u5361\u7247\u4e0a\u8fdb\u884c\u914d\u7f6e\u3002", (String)"GitLoginHandler_2", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]));
            return;
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("bos_devp_gitmanager_new");
        parameter.setCustomParam(BIZ_APP_ID, (Object)bizAppId);
        parameter.setCustomParam(BIZUNITID, (Object)bizUnitId);
        parameter.setCustomParam("type", (Object)type);
        String gitSessionId = plugin.getPageCache().get("gitSessionId");
        if (StringUtils.isNotBlank((CharSequence)gitSessionId)) {
            parameter.setCustomParam("gitSessionId", (Object)gitSessionId);
        }
        plugin.getView().showForm(parameter);
    }

    private static void showGitLoginInfo(String gitUrl, String gitBranch, String bizAppId, AbstractFormPlugin plugin, GitContext context) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("bos_devp_gitinfo");
        parameter.setCustomParam(GIT_URL, (Object)gitUrl);
        parameter.setCustomParam(GIT_GITBRANCH, (Object)gitBranch);
        parameter.setCustomParam(BIZ_APP_ID, (Object)bizAppId);
        parameter.setCustomParam("type", (Object)context.getType());
        parameter.setCustomParam("operateKey", (Object)context.getOperateKey());
        parameter.setCustomParam("id", (Object)context.getId());
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, "gitLoginInfoCallBack"));
        plugin.getView().showForm(parameter);
    }
}

