/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.business.git;

import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.devportal.business.git.GitCommitValidatorHandler;
import kd.bos.devportal.business.git.GitContext;
import kd.bos.devportal.business.git.GitDeleteHandler;
import kd.bos.devportal.business.git.GitHandler;
import kd.bos.devportal.business.git.GitLoginHandler;
import kd.bos.devportal.business.git.GitOperationUtils;
import kd.bos.devportal.business.git.GitRepositoryHelper;
import kd.bos.devportal.business.git.GitSaveFileHandler;
import kd.bos.devportal.business.git.GitSettingDao;
import kd.bos.devportal.business.git.UserCacheInfo;
import kd.bos.devportal.business.hosting.GitOperationUtil;
import kd.bos.devportal.common.util.AppUtils;
import kd.bos.encrypt.Encrypters;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.MergeResult;
import org.eclipse.jgit.api.PullResult;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.api.errors.CheckoutConflictException;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;

public class GitOperateHandler
implements GitHandler {
    private static final Log log = LogFactory.getLog(GitOperateHandler.class);
    public static final String GITURL = "giturl";
    public static final String GITREPOSITORY = "gitrepository";
    public static final String GITBRANCH = "gitbranch";
    public static final String GITROOTPATH = "gitrootpath";
    public static final String BIZAPPID = "bizappid";
    public static final String BIZUNITID = "bizunitid";
    public static final String PERSONALGITREPOSITORY = "personalgitrepository";
    public static final String PROJECTURL = "projecturl";
    public static final String USERNAME = "username";
    public static final String PSD = "password";
    public static final String METADATA = "metadata";
    private static final String ID = "id";
    private static final String TYPE = "type";
    private static final String DETAIL = "detail";
    public static final String IDE_PLUGINSCRIPT = "ide_pluginscript";
    public static final String TXT_SCRIPTCONTEXT_TAG = "txt_scriptcontext_tag";
    public static final String MASTERID = "masterid";
    public static final String GITOPERATEID = "gitoperateid";
    public static final String GITOPERATETYPE = "gitoperatetype";
    private static final String NOPERMISSION = "noPermission";
    private static final String SUCCESS = "success";
    private static final String GIT_COMMIT_NEW_CALLBACK = "gitCommitNewCallBack";
    private static final String GIT_PUSH_NEW_CALLBACK = "gitPushNewCallBack";
    public static final String BOTP = "botp";
    public static final String BOTP_ConvertRule = "botp_cr";
    public static final String BOTP_WriteBackRule = "botp_wb";
    public static final String BOTP_BalanceUpdateRule = "botp_bur";
    private static final String RULE_IDS = "ruleIds";
    private static final String BIZ_APP_NUMBER = "bos_devportal_bizapp";
    private static final String UNIT_REF_FORM_NUMBER = "bos_devportal_unitrelform";
    private static final String BIZ_UNIT = "bizunit";
    private static final String BIZAPP = "bizapp";
    private static final String FILENAME = "filename";
    private static final String TXT_SCRIPT_NUMBER = "txt_scriptnumber";
    private static final String SCRIPT_SUFFIX = ".ks";
    private static final String BOS_DEVPORTAL_BUSINESS = "bos-devportal-business";
    private static final String BOS_DEVPORTAL_PLUGIN = "bos-devportal-plugin";

    @Override
    public void handler(GitContext context, AbstractFormPlugin plugin) {
        boolean hasLogin;
        if (StringUtils.isBlank((CharSequence)context.getBizAppId())) {
            JSONObject result = GitOperateHandler.getBizAppIdAndFileNameByType(context.getType(), context.getId());
            String bizAppId = result.getString(BIZAPPID);
            context.setBizAppId(bizAppId);
        }
        if (hasLogin = GitLoginHandler.hasLogin(context, plugin)) {
            context.setDeleteResult(false);
            return;
        }
        this.beforeGitOperate(context, plugin);
        this.gitRepositoryOperate(context, plugin);
    }

    private void beforeGitOperate(GitContext context, AbstractFormPlugin plugin) {
        GitSettingDao dao = new GitSettingDao();
        DynamicObject setting = dao.getSetting(context.getBizAppId(), context.getBizUnitId(), context.getUserName());
        String gitBranch = setting.getString(GITBRANCH);
        String gitUrl = setting.getString(GITURL);
        String gitRepository = setting.getString(GITREPOSITORY);
        String gitRootPath = setting.getString(GITROOTPATH);
        String personalGitRepository = GitOperationUtil.getPersonalGitRepository(gitRepository, context.getUserName());
        UserCacheInfo userCacheInfo = new UserCacheInfo();
        JSONObject userInfo = userCacheInfo.getUserInfo(context.getSessionId());
        String passWord = Encrypters.decode((String)((String)userInfo.get((Object)PSD)));
        String userName = Encrypters.decode((String)((String)userInfo.get((Object)USERNAME)));
        context.setGitBranch(gitBranch);
        context.setGitUrl(gitUrl);
        context.setGitRootPath(gitRootPath);
        context.setPersonalGitRepository(personalGitRepository);
        context.setPassWord(passWord);
        context.setUserName(userName);
        context.setGitRepository(gitRepository);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void gitRepositoryOperate(GitContext context, AbstractFormPlugin plugin) {
        block17: {
            String gitBranch = context.getGitBranch();
            log.info(String.format("the service instance where git operations are performed: %s", Instance.getInstanceId()));
            String projectURL = context.getPersonalGitRepository() + File.separator + ".git";
            String checkProjectURL = AppUtils.checkFilePath((String)projectURL);
            File gitFile = new File(checkProjectURL);
            try (Git git = null;){
                if (!gitFile.exists()) {
                    if (StringUtils.equals((CharSequence)"pull", (CharSequence)context.getOperateKey())) {
                        context.setGitPullUrl(context.getGitUrl());
                        this.pull(context, plugin, true);
                    } else {
                        context.setDeleteResult(false);
                        plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u672c\u5730\u4ed3\u5e93\u4e0d\u5b58\u5728\uff0c\u8bf7\u5148\u70b9\u51fb\u62c9\u53d6\u5c06\u8fdc\u7a0b\u4ed3\u5e93\u62c9\u53d6\u81f3\u672c\u5730\u3002", (String)"GitOperateHandler_3", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]));
                    }
                    return;
                }
                git = Git.open((File)gitFile);
                this.disableSSL(git);
                this.setRemoteUrlConfig(git);
                Repository repository = git.getRepository();
                StoredConfig config = repository.getConfig();
                String gitPullUrl = config.getString("remote", "origin", "url");
                String gitPushUrl = config.getString("remote", "origin", "pushurl");
                gitPullUrl = StringUtils.isBlank((CharSequence)gitPullUrl) ? context.getGitUrl() : gitPullUrl;
                gitPushUrl = StringUtils.isBlank((CharSequence)gitPushUrl) ? context.getGitUrl() : gitPushUrl;
                context.setGitPullUrl(gitPullUrl);
                context.setGitPushUrl(gitPushUrl);
                String currentBranchName = repository.getBranch();
                if (StringUtils.isBlank((CharSequence)gitBranch) || gitBranch.equalsIgnoreCase(currentBranchName)) break block17;
                if (!this.branchNameExist(git, gitBranch)) {
                    if (StringUtils.equals((CharSequence)"pull", (CharSequence)context.getOperateKey())) {
                        this.gitOperate(context, plugin);
                    } else {
                        plugin.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5206\u652f%s\u5728\u672c\u5730\u4ed3\u5e93\u4e0d\u5b58\u5728\uff0c\u8bf7\u5148\u70b9\u51fb\u62c9\u53d6\u5c06\u8fdc\u7a0b\u4ed3\u5e93\u62c9\u53d6\u81f3\u672c\u5730\u3002", (String)"GitOperateHandler_5", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]), gitBranch));
                    }
                    return;
                }
                try {
                    git.checkout().setCreateBranch(false).setName(gitBranch).call();
                }
                catch (CheckoutConflictException e) {
                    plugin.getView().showTipNotification(e.getMessage());
                    if (git != null) {
                        git.close();
                    }
                    return;
                }
            }
        }
        this.gitOperate(context, plugin);
    }

    private void gitOperate(GitContext context, AbstractFormPlugin plugin) {
        String operateKey;
        switch (operateKey = context.getOperateKey()) {
            case "commit": {
                this.commit(context, plugin);
                break;
            }
            case "push": {
                this.push(context, plugin);
                break;
            }
            case "revert": {
                this.revert(context, plugin);
                break;
            }
            case "log": {
                this.showlog(context, plugin);
                break;
            }
            case "pull": {
                this.pull(context, plugin, false);
                break;
            }
            case "delete": {
                this.delete(context, plugin);
                break;
            }
            case "branchcompare": {
                this.setDataModelBranchCompare(context, plugin);
                break;
            }
        }
    }

    private void setDataModelBranchCompare(GitContext context, AbstractFormPlugin plugin) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("bos_dm_branchcompare");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam(PERSONALGITREPOSITORY, (Object)context.getPersonalGitRepository());
        parameter.setCustomParam(GITROOTPATH, (Object)context.getGitRootPath());
        parameter.setCustomParam(ID, (Object)plugin.getPageCache().get("compareModelId"));
        parameter.setCustomParam("bizAppId", (Object)context.getBizAppId());
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, "SQL_CALL_BACK"));
        plugin.getView().showForm(parameter);
    }

    private void setRemoteUrlConfig(Git git) throws IOException {
        Repository repository = git.getRepository();
        StoredConfig config = repository.getConfig();
        String gitPullUrl = config.getString("remote", "origin", "url");
        String gitPushUrl = config.getString("remote", "origin", "pushurl");
        if (StringUtils.isBlank((CharSequence)gitPushUrl) && StringUtils.isNotBlank((CharSequence)gitPullUrl)) {
            config.setString("remote", "origin", "pushurl", gitPullUrl);
            config.save();
        }
    }

    private void checkBranch(GitContext context, Git git, AbstractFormPlugin plugin) {
        try (Repository repository = git.getRepository();){
            String currentBranchName = repository.getBranch();
            String gitBranch = context.getGitBranch();
            if (!StringUtils.isBlank((CharSequence)gitBranch) && !gitBranch.equalsIgnoreCase(currentBranchName)) {
                git.checkout().setCreateBranch(true).setName(gitBranch).setStartPoint("remotes/origin/" + gitBranch).call();
            }
        }
        catch (Exception e) {
            plugin.getView().showTipNotification(e.getMessage());
        }
    }

    private void commit(GitContext context, AbstractFormPlugin plugin) {
        GitCommitValidatorHandler commitValidatorHandler = new GitCommitValidatorHandler();
        commitValidatorHandler.handler(context, plugin);
        if (!context.isNeedCommit()) {
            plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u5185\u5bb9\u6ca1\u6709\u53d8\u5316,\u65e0\u9700\u63d0\u4ea4\u3002", (String)"BizPageListPlugin_17", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("bos_devp_gitcommit_new");
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, GIT_COMMIT_NEW_CALLBACK));
        parameter.setCustomParam("gitContext", (Object)SerializationUtils.toJsonString((Object)context));
        if ("app".equals(context.getType())) {
            parameter.setCustomParam("commitParams", (Object)plugin.getPageCache().get("commitParams"));
        } else if (BOTP_ConvertRule.equals(context.getType()) || BOTP_WriteBackRule.equals(context.getType()) || BOTP_BalanceUpdateRule.equals(context.getType())) {
            parameter.setCustomParam(RULE_IDS, (Object)plugin.getPageCache().get(RULE_IDS));
        } else if ("dataModel".equals(context.getType())) {
            parameter.setCustomParam("modelId", (Object)plugin.getPageCache().get("modelId"));
        }
        plugin.getView().showForm(parameter);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void pull(GitContext context, AbstractFormPlugin plugin, boolean isClone) {
        String personalGitRepository = context.getPersonalGitRepository();
        if (isClone) {
            this.cloneRepository(context, plugin);
            return;
        }
        String path = personalGitRepository + File.separator + ".git";
        File file = new File(path);
        try (Repository repository = GitRepositoryHelper.openRepository(file);
             Git git = new Git(repository);){
            MergeResult mergeResult;
            this.setRemoteUrlConfig(git);
            Status status = git.status().call();
            Set conflictSet = status.getConflicting();
            if (!conflictSet.isEmpty()) {
                plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u62c9\u53d6\u6210\u529f\u3002\u62c9\u53d6\u540e\u7684\u5143\u6570\u636e\u548c\u672c\u5730\u4ed3\u5e93\u5143\u6570\u636e\u5b58\u5728\u51b2\u7a81\uff0c\u8bf7\u89e3\u51b3\u3002", (String)"GitOperateHandler_2", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]));
                this.showConflict(conflictSet, plugin, context);
                return;
            }
            GitOperationUtils.revert(git);
            GitOperationUtils.clean(git);
            Map<String, Object> result = GitOperationUtils.pull(context, path);
            if (StringUtils.isNotBlank((Object)result.get("errMsg"))) {
                plugin.getView().showTipNotification((String)result.get("errMsg"));
                return;
            }
            PullResult pullResult = (PullResult)result.get("pullResult");
            if (pullResult != null && !pullResult.isSuccessful() && (mergeResult = pullResult.getMergeResult()) != null) {
                status = git.status().call();
                conflictSet = status.getConflicting();
                if (!conflictSet.isEmpty()) {
                    plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u62c9\u53d6\u6210\u529f\u3002\u62c9\u53d6\u540e\u7684\u5143\u6570\u636e\u548c\u672c\u5730\u4ed3\u5e93\u5143\u6570\u636e\u5b58\u5728\u51b2\u7a81\uff0c\u8bf7\u89e3\u51b3\u3002", (String)"GitOperateHandler_2", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]));
                    this.showConflict(conflictSet, plugin, context);
                    return;
                }
                String errorTip = mergeResult.getMergeStatus().toString();
                plugin.getView().showErrorNotification(errorTip);
                return;
            }
            if ("app".equals(context.getType())) {
                GitSaveFileHandler saveFileHandler = new GitSaveFileHandler();
                boolean appFileStatus = saveFileHandler.getAppFileStatus(context);
                context.setCloneRepository(!appFileStatus);
            }
            String pullInfo = result.get("pullInfo").toString();
            status = git.status().call();
            conflictSet = status.getConflicting();
            if (!conflictSet.isEmpty()) {
                plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u62c9\u53d6\u6210\u529f\u3002\u62c9\u53d6\u540e\u7684\u5143\u6570\u636e\u548c\u672c\u5730\u4ed3\u5e93\u5143\u6570\u636e\u5b58\u5728\u51b2\u7a81\uff0c\u8bf7\u89e3\u51b3\u3002", (String)"GitOperateHandler_2", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]));
                this.showConflict(conflictSet, plugin, context);
                return;
            }
            this.showPullDetail(context, pullInfo, pullResult, plugin);
            this.checkBranch(context, git, plugin);
            return;
        }
        catch (IOException | GitAPIException e) {
            plugin.getView().showErrorNotification(e.getMessage());
            log.error(e);
        }
    }

    private void delete(GitContext context, AbstractFormPlugin plugin) {
        GitDeleteHandler deleteHandler = new GitDeleteHandler();
        deleteHandler.handler(context, plugin);
    }

    private void cloneRepository(GitContext context, AbstractFormPlugin plugin) {
        context.setCloneRepository(true);
        Map<String, Object> result = GitOperationUtils.cloneRepository(context);
        String status = (String)result.get("status");
        if (!SUCCESS.equals(status)) {
            if (NOPERMISSION.equals(status)) {
                plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u8fdc\u7a0b\u4ed3\u5e93\u7684\u6743\u9650\uff0c\u8bf7\u786e\u8ba4\u540e\u91cd\u8bd5\u3002", (String)"GitOperateHandler_1", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]));
                return;
            }
            plugin.getView().showTipNotification(status);
            return;
        }
        String cloneInfo = (String)result.get("cloneInfo");
        this.showPullDetail(context, cloneInfo, null, plugin);
    }

    private void showPullDetail(GitContext context, String pullInfo, PullResult pullResult, AbstractFormPlugin plugin) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("bos_devp_gitmessage");
        parameter.setCustomParam("gitContext", (Object)SerializationUtils.toJsonString((Object)context));
        String detail = GitOperationUtils.getPullResult(pullResult);
        if (StringUtils.isBlank((CharSequence)detail)) {
            parameter.setCustomParam(DETAIL, (Object)pullInfo);
        } else {
            parameter.setCustomParam(DETAIL, (Object)(pullInfo + "\n" + detail));
        }
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, "gitPullUpdateMetaCallBack"));
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        plugin.getView().showForm(parameter);
    }

    private void showConflict(Set<String> fileList, AbstractFormPlugin plugin, GitContext context) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("bos_devp_gitconflict");
        parameter.setCustomParam("fileList", (Object)SerializationUtils.toJsonString(fileList));
        parameter.setCustomParam("gitContext", (Object)SerializationUtils.toJsonString((Object)context));
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, "gitPullConflictCallBack"));
        plugin.getView().showForm(parameter);
    }

    private boolean branchNameExist(Git git, String branchName) throws GitAPIException {
        List refs = git.branchList().call();
        for (Ref ref : refs) {
            if (!ref.getName().contains(branchName)) continue;
            return true;
        }
        return false;
    }

    private synchronized void disableSSL(Git git) throws IOException {
        if (git == null || git.getRepository() == null) {
            return;
        }
        StoredConfig config = git.getRepository().getConfig();
        config.setBoolean("http", null, "sslVerify", false);
        config.save();
    }

    public static JSONObject getBizAppIdAndFileNameByType(String type, String id) {
        JSONObject result = new JSONObject();
        String bizAppId = null;
        String fileNumber = null;
        String bizUnitId = null;
        if ("script".equalsIgnoreCase(type)) {
            DynamicObject scriptObject = BusinessDataServiceHelper.loadSingleFromCache((Object)id, (String)IDE_PLUGINSCRIPT, (String)"txt_scriptnumber,bizappid");
            bizAppId = scriptObject.getString(BIZAPPID);
            fileNumber = scriptObject.getString(TXT_SCRIPT_NUMBER) + SCRIPT_SUFFIX;
        } else if ("page".equalsIgnoreCase(type)) {
            fileNumber = MetadataDao.getNumberById((String)id) + ".dym";
            bizAppId = MetadataDao.getAppIdByFormId((String)id);
            bizUnitId = MetadataDao.getUnitIdFromUnitrel((String)id);
            if (StringUtils.isEmpty((CharSequence)bizAppId)) {
                QFilter qFormId = new QFilter("form", "=", (Object)id);
                DynamicObject pageRelInfo = QueryServiceHelper.queryOne((String)UNIT_REF_FORM_NUMBER, (String)"bizapp,bizunit", (QFilter[])new QFilter[]{qFormId});
                bizAppId = pageRelInfo.getString(BIZAPP);
                bizUnitId = pageRelInfo.getString(BIZ_UNIT);
            }
        } else if ("app".equalsIgnoreCase(type)) {
            bizAppId = id;
            fileNumber = BusinessDataServiceHelper.loadSingle((Object)bizAppId, (String)BIZ_APP_NUMBER, (String)"number").getString("number") + ".app";
        } else if ("cloud".equalsIgnoreCase(type)) {
            DynamicObject cloudObject = BusinessDataServiceHelper.loadSingle((Object)id, (String)"bos_devportal_bizcloud", (String)"baseapp");
            bizAppId = cloudObject.getString("baseapp_id");
        } else if (type.startsWith(BOTP)) {
            bizAppId = id;
        }
        result.put(BIZAPPID, (Object)bizAppId);
        result.put(FILENAME, (Object)fileNumber);
        result.put(BIZUNITID, (Object)bizUnitId);
        return result;
    }

    private void push(GitContext context, AbstractFormPlugin plugin) {
        this.showForm(context, plugin, "bos_devp_gitpush_new", new CloseCallBack((IFormPlugin)plugin, GIT_PUSH_NEW_CALLBACK));
    }

    private void revert(GitContext context, AbstractFormPlugin plugin) {
        this.showForm(context, plugin, "bos_devp_gitrestore");
    }

    private void showlog(GitContext context, AbstractFormPlugin plugin) {
        this.showForm(context, plugin, "bos_devp_gitlog");
    }

    private void showForm(GitContext context, AbstractFormPlugin plugin, String formId) {
        this.showForm(context, plugin, formId, null);
    }

    private void showForm(GitContext context, AbstractFormPlugin plugin, String formId, CloseCallBack closeCallBack) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setShowFullScreen(true);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId(formId);
        parameter.setCustomParam(GITURL, (Object)context.getGitUrl());
        parameter.setCustomParam(GITREPOSITORY, (Object)context.getGitRepository());
        parameter.setCustomParam(GITBRANCH, (Object)context.getGitBranch());
        parameter.setCustomParam(GITROOTPATH, (Object)context.getGitRootPath());
        parameter.setCustomParam(BIZAPPID, (Object)context.getBizAppId());
        parameter.setCustomParam(PERSONALGITREPOSITORY, (Object)context.getPersonalGitRepository());
        String projectUrl = context.getPersonalGitRepository() + File.separator + ".git";
        parameter.setCustomParam(PROJECTURL, (Object)projectUrl);
        parameter.setCustomParam(USERNAME, (Object)context.getUserName());
        parameter.setCustomParam(PSD, (Object)context.getPassWord());
        parameter.setCustomParam(GITOPERATEID, (Object)context.getId());
        parameter.setCustomParam(GITOPERATETYPE, (Object)context.getType());
        parameter.setCustomParam("gitContext", (Object)SerializationUtils.toJsonString((Object)context));
        if ("bos_devp_gitrestore".equals(formId)) {
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, "gitRestoreCallBack"));
        }
        if (BOTP_ConvertRule.equals(context.getType()) || BOTP_WriteBackRule.equals(context.getType()) || BOTP_BalanceUpdateRule.equals(context.getType())) {
            parameter.setCustomParam(RULE_IDS, (Object)plugin.getPageCache().get(RULE_IDS));
        }
        if (closeCallBack != null) {
            parameter.setCloseCallBack(closeCallBack);
        }
        plugin.getView().showForm(parameter);
    }
}

