/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.business.git;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.devportal.business.git.GitCommit;
import kd.bos.devportal.business.git.GitContext;
import kd.bos.devportal.business.git.GitDiffEntry;
import kd.bos.devportal.business.git.GitRepositoryHelper;
import kd.bos.devportal.business.git.GitRevFilter;
import kd.bos.devportal.business.git.GitUpdateMetaHandler;
import kd.bos.devportal.business.git.factory.GitCommitFactory;
import kd.bos.devportal.common.util.AppUtils;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.eclipse.jgit.api.CheckoutCommand;
import org.eclipse.jgit.api.CleanCommand;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.LogCommand;
import org.eclipse.jgit.api.PullCommand;
import org.eclipse.jgit.api.PullResult;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.DiffFormatter;
import org.eclipse.jgit.diff.RawTextComparator;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.TextProgressMonitor;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.RevFilter;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.TransportHttp;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.eclipse.jgit.treewalk.EmptyTreeIterator;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;

public class GitOperationUtils {
    private static Log log = LogFactory.getLog(GitOperationUtils.class);
    private static final String SUCCESS = "success";
    private static final String NOPERMISSION = "noPermission";
    private static final String AUTHFAIL = "Auth fail";
    private static final String NOTAUTHORIZED = "not authorized";

    public static List<GitCommit> showLog(String repositoryPath, String path) throws GitAPIException {
        return GitOperationUtils.showLog(repositoryPath, path, null);
    }

    public static List<GitCommit> showLog(String repositoryPath, String path, GitRevFilter gitRevFilter) throws GitAPIException {
        return GitOperationUtils.showLog(repositoryPath, path, "", "", gitRevFilter);
    }

    public static List<GitCommit> showLog(String repositoryPath, String path, String since, String until) throws GitAPIException {
        return GitOperationUtils.showLog(repositoryPath, path, since, until, null);
    }

    public static List<GitCommit> showLog(String repositoryPath, String path, String since, String until, GitRevFilter gitRevFilter) throws GitAPIException {
        ArrayList<GitCommit> gitCommitList = new ArrayList<GitCommit>();
        try (Repository repository = GitRepositoryHelper.openRepository(repositoryPath);
             Git git = new Git(repository);){
            LogCommand logCommand = git.log().addPath(path).setMaxCount(5000);
            if (StringUtils.isNotBlank((CharSequence)since) && StringUtils.isNotBlank((CharSequence)until)) {
                ObjectId head = repository.resolve(since);
                ObjectId branch = repository.resolve(until);
                logCommand = logCommand.addRange((AnyObjectId)head, (AnyObjectId)branch);
            }
            if (gitRevFilter != null) {
                logCommand = logCommand.setRevFilter((RevFilter)gitRevFilter.getOrigin());
            }
            Iterable logIter = logCommand.call();
            for (RevCommit revCommit : logIter) {
                gitCommitList.add(GitCommitFactory.getInstance().create(revCommit));
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        return gitCommitList;
    }

    public static List<String> getChangedFilePaths(String repositoryPath, String metaPath, String commitId) {
        ArrayList<String> changedFilePaths = new ArrayList<String>();
        try (Repository repository = GitRepositoryHelper.openRepository(repositoryPath);){
            ObjectId resolve = repository.resolve(commitId);
            RevWalk revWalk = new RevWalk(repository);
            RevCommit commit = revWalk.parseCommit((AnyObjectId)resolve);
            RevCommit parent = null;
            if (commit.getParents().length > 0 && commit.getParent(0) != null) {
                parent = revWalk.parseCommit((AnyObjectId)commit.getParent(0).getId());
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            DiffFormatter df = new DiffFormatter((OutputStream)out);
            df.setRepository(repository);
            df.setDiffComparator(RawTextComparator.DEFAULT);
            df.setDetectRenames(true);
            df.setPathFilter((TreeFilter)PathFilter.create((String)metaPath));
            List diffs = parent != null ? df.scan(parent.getTree(), commit.getTree()) : df.scan((AbstractTreeIterator)new EmptyTreeIterator(), (AbstractTreeIterator)new CanonicalTreeParser(null, revWalk.getObjectReader(), (AnyObjectId)commit.getTree()));
            for (DiffEntry diff : diffs) {
                df.format(diff);
                if (DiffEntry.ChangeType.DELETE.equals((Object)diff.getChangeType())) {
                    changedFilePaths.add(diff.getOldPath());
                    continue;
                }
                changedFilePaths.add(diff.getNewPath());
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        return changedFilePaths;
    }

    public static GitDiffEntry getCommitDiffEntry(String repositoryPath, String metaPath, String commitId) {
        String oldContent = "";
        String newContent = "";
        String oldCommitId = "";
        String newCommitId = "";
        GitDiffEntry.ChangeType changeType = null;
        try (Repository repository = GitRepositoryHelper.openRepository(repositoryPath);){
            ObjectId resolve = repository.resolve(commitId);
            RevWalk revWalk = new RevWalk(repository);
            RevCommit commit = revWalk.parseCommit((AnyObjectId)resolve);
            RevCommit parent = null;
            if (commit.getParents().length > 0 && commit.getParent(0) != null) {
                parent = revWalk.parseCommit((AnyObjectId)commit.getParent(0).getId());
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            DiffFormatter df = new DiffFormatter((OutputStream)out);
            df.setRepository(repository);
            df.setDiffComparator(RawTextComparator.DEFAULT);
            df.setDetectRenames(true);
            df.setPathFilter((TreeFilter)PathFilter.create((String)metaPath));
            List diffs = parent != null ? df.scan(parent.getTree(), commit.getTree()) : df.scan((AbstractTreeIterator)new EmptyTreeIterator(), (AbstractTreeIterator)new CanonicalTreeParser(null, revWalk.getObjectReader(), (AnyObjectId)commit.getTree()));
            for (DiffEntry diff : diffs) {
                ObjectLoader loader;
                df.format(diff);
                if (DiffEntry.ChangeType.DELETE.equals((Object)diff.getChangeType())) {
                    loader = repository.open((AnyObjectId)diff.getOldId().toObjectId());
                    oldContent = new String(loader.getBytes(), StandardCharsets.UTF_8);
                    oldCommitId = diff.getOldId().toObjectId().getName();
                    changeType = GitDiffEntry.ChangeType.DELETE;
                    continue;
                }
                if (DiffEntry.ChangeType.ADD.equals((Object)diff.getChangeType())) {
                    ObjectLoader loader1 = repository.open((AnyObjectId)diff.getNewId().toObjectId());
                    newContent = new String(loader1.getBytes(), StandardCharsets.UTF_8);
                    newCommitId = diff.getNewId().toObjectId().getName();
                    changeType = GitDiffEntry.ChangeType.ADD;
                    continue;
                }
                loader = repository.open((AnyObjectId)diff.getOldId().toObjectId());
                oldContent = new String(loader.getBytes(), StandardCharsets.UTF_8);
                oldCommitId = diff.getOldId().toObjectId().getName();
                ObjectLoader loader1 = repository.open((AnyObjectId)diff.getNewId().toObjectId());
                newContent = new String(loader1.getBytes(), StandardCharsets.UTF_8);
                newCommitId = diff.getNewId().toObjectId().getName();
                changeType = GitDiffEntry.ChangeType.MODIFY;
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        return new GitDiffEntry(oldContent, newContent, oldCommitId, newCommitId, changeType);
    }

    /*
     * Exception decompiling
     */
    public static String getRemoteLastCommitFile(String repositoryPath, String filePath, String branch) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public static String getLastCommitFile(String repositoryPath, String metaPath, String fileName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public static String getCommitId(String repositoryPath) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static Map<String, Object> pull(GitContext context, String path) throws GitAPIException, IOException {
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        File file = new File(path);
        PullResult res = null;
        try (Repository repository = GitRepositoryHelper.openRepository(file);
             Git git = new Git(repository);){
            PullCommand pull = git.pull();
            StringWriter writer = new StringWriter();
            TextProgressMonitor progressMonitor = new TextProgressMonitor((Writer)writer);
            pull.setProgressMonitor((ProgressMonitor)progressMonitor);
            pull.setCredentialsProvider((CredentialsProvider)new UsernamePasswordCredentialsProvider(context.getUserName(), context.getPassWord()));
            res = pull.call();
            result.put("pullInfo", ((Object)writer).toString().trim());
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            result.put("errMsg", cause == null ? e.getMessage() : cause.getMessage());
            log.error((Throwable)e);
        }
        result.put("pullResult", res);
        return result;
    }

    public static void revert(Git git) {
        GitOperationUtils.revert(git, null);
    }

    public static void revert(Git git, List<String> path) {
        try {
            CheckoutCommand checkout = git.checkout();
            if (path != null) {
                checkout.addPaths(path).call();
            } else {
                checkout.setAllPaths(true).call();
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
    }

    public static void clean(Git git) {
        GitOperationUtils.clean(git, null);
    }

    public static void clean(Git git, Set<String> path) {
        try {
            CleanCommand cleanCommand = git.clean();
            if (path != null) {
                cleanCommand.setPaths(path).call();
            } else {
                cleanCommand.call();
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Object> cloneRepository(GitContext context) {
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        try (Git git = null;){
            String checkRepository = AppUtils.checkFilePath((String)context.getPersonalGitRepository());
            File rootPath = new File(checkRepository);
            AppUtils.deleteKd((File)rootPath);
            boolean mkdirs = rootPath.mkdirs();
            if (!mkdirs) {
                log.info("create git repository error");
            }
            CloneCommand cloneCommand = Git.cloneRepository();
            cloneCommand.setURI(context.getGitPullUrl());
            StringWriter writer = new StringWriter();
            TextProgressMonitor progressMonitor = new TextProgressMonitor((Writer)writer);
            cloneCommand.setProgressMonitor((ProgressMonitor)progressMonitor);
            cloneCommand.setCredentialsProvider((CredentialsProvider)new UsernamePasswordCredentialsProvider(context.getUserName(), context.getPassWord()));
            cloneCommand.setTransportConfigCallback(transport -> {
                if (transport instanceof TransportHttp && StringUtils.isNotBlank((CharSequence)context.getGitPullUrl()) && context.getGitPullUrl().startsWith("https")) {
                    try {
                        Field sslVerify = transport.getClass().getDeclaredField("sslVerify");
                        sslVerify.setAccessible(true);
                        sslVerify.set(transport, false);
                    }
                    catch (Exception e) {
                        log.error((Throwable)e);
                    }
                }
            });
            cloneCommand.setDirectory(new File(checkRepository));
            cloneCommand.setCloneAllBranches(true);
            cloneCommand.setBranch(context.getGitBranch());
            git = cloneCommand.call();
            result.put("cloneInfo", ((Object)writer).toString().trim());
        }
        result.put("status", SUCCESS);
        return result;
    }

    public static void updateMetadata(GitContext context, AbstractFormPlugin plugin) {
        GitUpdateMetaHandler handler = new GitUpdateMetaHandler();
        handler.handler(context, plugin);
    }

    public static String getPullResult(PullResult pullResult) {
        if (pullResult == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        if (pullResult.getFetchResult() != null) {
            sb.append(pullResult.getFetchResult().toString());
        } else {
            sb.append("No fetch result");
        }
        sb.append("\n");
        if (pullResult.getMergeResult() != null) {
            sb.append(pullResult.getMergeResult().toString());
            sb.append("\n");
        } else if (pullResult.getRebaseResult() != null) {
            sb.append(pullResult.getRebaseResult().toString());
            sb.append("\n");
        } else {
            sb.append("No update result");
            sb.append("\n");
        }
        return sb.toString().trim();
    }
}

