/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.business.git;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.devportal.business.git.GitBase;
import kd.bos.devportal.business.git.factory.GitRevFilterFactory;
import org.eclipse.jgit.revwalk.filter.AndRevFilter;
import org.eclipse.jgit.revwalk.filter.AuthorRevFilter;
import org.eclipse.jgit.revwalk.filter.CommitTimeRevFilter;
import org.eclipse.jgit.revwalk.filter.MaxCountRevFilter;
import org.eclipse.jgit.revwalk.filter.RevFilter;

public class GitRevFilter
extends GitBase<RevFilter> {
    public GitRevFilter(RevFilter revFilter) {
        super(revFilter);
    }

    public static GitRevFilter commitTimebetween(Date since, Date until) {
        return GitRevFilterFactory.getInstance().create(CommitTimeRevFilter.between((Date)since, (Date)until));
    }

    public static GitRevFilter authorMatch(String pattern) {
        return GitRevFilterFactory.getInstance().create(AuthorRevFilter.create((String)pattern));
    }

    public static GitRevFilter maxCount(int maxCount) {
        return GitRevFilterFactory.getInstance().create(MaxCountRevFilter.create((int)maxCount));
    }

    public static GitRevFilter and(GitRevFilter[] gitRevFilterList) {
        List revFilterList = Arrays.stream(gitRevFilterList).map(GitBase::getOrigin).collect(Collectors.toList());
        return GitRevFilterFactory.getInstance().create(AndRevFilter.create(revFilterList));
    }
}

