/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.business.git;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.devportal.business.git.GitContext;
import kd.bos.devportal.business.git.GitHandler;
import kd.bos.devportal.business.git.GitOperationUtils;
import kd.bos.devportal.business.hosting.GitOperationUtil;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.deploy.DeployFile;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.util.DevportalCommonUtil;

public class GitSaveFileHandler
implements GitHandler {
    private static final String APP = "app";
    private static final String BIZAPPID = "bizappid";
    private static final Log log = LogFactory.getLog(GitSaveFileHandler.class);
    private String gitRootPath;

    @Override
    public void handler(GitContext context, AbstractFormPlugin plugin) {
        this.setRepositoryPath(context);
        this.saveApp(context, plugin);
    }

    public boolean getAppFileStatus(GitContext context) {
        try {
            List deployFile = MetadataDao.getAppDeployFile((String)context.getBizAppId());
            deployFile = deployFile.stream().filter(f -> !GitOperationUtil.isIgnoreFile(f.getFileName())).collect(Collectors.toList());
            String lastCommitFile = GitOperationUtils.getLastCommitFile(context.getPersonalGitRepository(), context.getGitRootPath(), ((DeployFile)deployFile.get(0)).getFileName());
            return lastCommitFile != null;
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return true;
        }
    }

    private void saveApp(GitContext context, AbstractFormPlugin plugin) {
        if (DevportalCommonUtil.isExportMetaToLocal()) {
            this.exportAppFile(context.getBizAppId());
        }
    }

    private void setRepositoryPath(GitContext context) {
        String personalGitRepository = context.getPersonalGitRepository();
        this.gitRootPath = personalGitRepository + this.getMetadataRootPath(context.getGitRootPath());
    }

    private String getRepositoryPath() {
        return this.gitRootPath;
    }

    private void exportAppFile(String bizAppId) {
        try {
            List<DeployFile> deployFile = MetadataDao.getAppDeployFile((String)bizAppId);
            deployFile = deployFile.stream().filter(f -> !GitOperationUtil.isIgnoreFile(f.getFileName())).collect(Collectors.toList());
            this.saveFileToLocalRepository(deployFile);
            this.exportPageFile(bizAppId);
            this.exportScriptFile(bizAppId);
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
    }

    private void saveFileToLocalRepository(List<DeployFile> deployFileList) {
        String repositoryPath = this.getRepositoryPath();
        for (DeployFile file : deployFileList) {
            GitOperationUtil.saveFile(file.getFileName(), file.getFileContent(), repositoryPath);
        }
    }

    private void exportPageFile(String bizAppId) {
        List<Map<String, String>> mapList = this.getPage(bizAppId);
        ArrayList<DeployFile> fileList = new ArrayList<DeployFile>(mapList.size());
        for (Map<String, String> map : mapList) {
            List file = null;
            try {
                String id = map.get("id");
                String bizUnitId = map.get("unitId");
                file = MetadataDao.getFormDeployFile((String)id, (String)bizAppId, (String)bizUnitId);
                file = file.stream().filter(f -> !GitOperationUtil.isIgnoreFile(f.getFileName())).collect(Collectors.toList());
            }
            catch (Exception e) {
                log.error(map.get("id"), (Throwable)e);
            }
            if (file == null) continue;
            fileList.addAll(file);
        }
        this.saveFileToLocalRepository(fileList);
    }

    private void exportScriptFile(String bizAppId) {
        List<String> scripts = this.getKs(bizAppId);
        try {
            List scriptDeployFile = MetadataDao.getScriptDeployFile((String[])scripts.toArray(new String[0]));
            this.saveFileToLocalRepository(scriptDeployFile);
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
    }

    private List<Map<String, String>> getPage(String bizAppId) {
        QFilter qFilter = new QFilter("bizapp", "=", (Object)bizAppId);
        QFilter[] filters = new QFilter[]{qFilter};
        String unitFormFields = "bizapp,bizunit,form";
        String formFields = "id,number,name,type,parentid";
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>(10);
        try (DataSet unitFormDataSet = QueryServiceHelper.queryDataSet((String)"bos_devportal_unitrelform", (String)"bos_devportal_unitrelform", (String)unitFormFields, (QFilter[])filters, (String)"form asc");
             DataSet formDataSet = QueryServiceHelper.queryDataSet((String)"bos_formmeta", (String)"bos_formmeta", (String)formFields, null, (String)"number asc");
             DataSet result = unitFormDataSet.join(formDataSet, JoinType.INNER).on("form", "id").select(new String[]{"bizunit", "form"}, new String[]{"id", "number", "name", "type", "parentid"}).finish();){
            for (Row row : result) {
                HashMap<String, String> map = new HashMap<String, String>(2);
                map.put("id", row.getString("id"));
                map.put("unitId", row.getString("bizunit"));
                list.add(map);
            }
        }
        return list;
    }

    private List<String> getKs(String bizAppId) {
        String scriptFields = "id, txt_scriptnumber, txt_scriptname, bizunitid";
        QFilter scriptFilter_1 = new QFilter(BIZAPPID, "=", (Object)bizAppId);
        QFilter[] scriptFilters = new QFilter[]{scriptFilter_1};
        String scriptOrderBy = "txt_scriptnumber";
        ArrayList<String> list = new ArrayList<String>(10);
        DynamicObjectCollection scriptInfo = QueryServiceHelper.query((String)"ide_pluginscript", (String)scriptFields, (QFilter[])scriptFilters, (String)scriptOrderBy);
        for (DynamicObject obj : scriptInfo) {
            list.add(obj.getString("id"));
        }
        return list;
    }

    private String getMetadataRootPath(String gitRootpath) {
        String result = "";
        String separator = Matcher.quoteReplacement(File.separator);
        if (!StringUtils.isBlank((CharSequence)gitRootpath)) {
            result = !(gitRootpath = gitRootpath.replaceAll("\\\\", separator).replaceAll("/", separator)).startsWith(File.separator) ? File.separator + gitRootpath : gitRootpath;
        }
        return result;
    }
}

