/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.business.git;

import java.sql.ResultSet;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.devportal.BizScriptServiceHelper;
import kd.bos.servicehelper.util.DevportalCommonUtil;

public class GitSettingDao {
    private static final String BIZAPPID = "bizappid";
    private static final String BIZUNITID = "bizunitid";
    public static final String GIT_USERNAME = "gitusername";
    private static final String TYPE = "managetype";
    private static final String PAGE = "page";
    private static final String SCRIPT = "script";

    public DynamicObject getSetting(String bizAppId, String bizUnitId, String userName) {
        QFilter userFilter;
        QFilter qFilter = new QFilter(BIZAPPID, "=", (Object)bizAppId);
        if (StringUtils.isNotBlank((CharSequence)bizUnitId)) {
            QFilter qFilter1 = new QFilter(BIZUNITID, "=", (Object)bizUnitId);
            qFilter.and(qFilter1);
        }
        QFilter typeFilter = new QFilter(TYPE, "=", (Object)"git");
        qFilter.and(typeFilter);
        if (DevportalCommonUtil.isGitMultiParallel()) {
            userFilter = new QFilter(GIT_USERNAME, "=", (Object)userName);
            qFilter.and(userFilter);
        } else {
            userFilter = new QFilter(GIT_USERNAME, "=", (Object)"");
            qFilter.and(userFilter);
        }
        QFilter[] filters = new QFilter[]{qFilter};
        String selectFields = "id,giturl,gitrepository,gitbranch,gitrootpath,bizunitid,managetype,gitusername";
        DynamicObject[] settings = BusinessDataServiceHelper.load((String)"svnmanage", (String)selectFields, (QFilter[])filters);
        return settings == null || settings.length == 0 ? null : settings[0];
    }

    public boolean isNewGitOperate() {
        return DevportalCommonUtil.isEnableNewGit();
    }

    public String getBizUnitId(String type, String id) {
        String bizUnitId = null;
        if (PAGE.equals(type)) {
            bizUnitId = this.getUnitIdByFormId(id);
        } else if (SCRIPT.equals(type)) {
            DynamicObject object = BizScriptServiceHelper.getScriptByID((String)id);
            bizUnitId = object.getString(BIZUNITID);
        }
        return bizUnitId;
    }

    private String getUnitIdByFormId(String formId) {
        String sql = String.format("select FBIZUNITID from %s where FFormId = ? ", "t_meta_bizunitrelform");
        Object[] params = new SqlParameter[]{new SqlParameter(":FFormId", 12, (Object)formId)};
        ResultSetHandler<String> action = new ResultSetHandler<String>(){

            public String handle(ResultSet rs) throws Exception {
                if (rs.next()) {
                    return rs.getString(1);
                }
                return null;
            }
        };
        return (String)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, (ResultSetHandler)action);
    }
}

