/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.business.git;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcxmlSerializer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.devportal.business.git.GitContext;
import kd.bos.devportal.business.git.GitHandler;
import kd.bos.devportal.business.hosting.GITCodeHostingServiceImpl;
import kd.bos.devportal.business.hosting.GitOperationUtil;
import kd.bos.devportal.common.util.AppUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCacheUtils;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.deploy.DeployFile;
import kd.bos.metadata.deploy.DeployMetadata;
import kd.bos.metadata.deploy.DeployScript;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import org.eclipse.jgit.api.Git;

public class GitUpdateMetaHandler
implements GitHandler {
    private static final Log log = LogFactory.getLog(GitUpdateMetaHandler.class);
    private static final String UNIT_REF_FORM_NUMBER = "bos_devportal_unitrelform";
    private static final String BIZ_UNIT = "bizunit";
    private static final String NOFILE = "nofile";
    private static final String BOS_DEVPORTAL_BUSINESS = "bos-devportal-business";
    private static final String MASTERID = "masterid";
    private static final String IDE_PLUGINSCRIPT = "ide_pluginscript";
    private static final String BIZAPPID = "bizappid";
    private static final String BIZUNITID = "bizunitid";
    private static final String TXT_SCRIPT_NUMBER = "txt_scriptnumber";
    private static final String SCRIPT_SUFFIX = ".ks";
    private static final String CLASSNAME = "classname";
    private static final String TXT_SCRIPTCONTEXT_TAG = "txt_scriptcontext_tag";
    private static final String BIZ_APP_NUMBER = "bos_devportal_bizapp";
    private static final String PAGE = "page";
    private static final String SCRIPT = "script";
    private static final String APP = "app";
    private static final String BOTP = "botp";
    private static final String BOTP_ConvertRule = "botp_cr";
    private static final String BOTP_WriteBackRule = "botp_wb";
    private static final String BOTP_BalanceUpdateRule = "botp_bur";
    private static final String RULE_IDS = "ruleIds";
    private static final String DATA_MODEL = "dataModel";
    private boolean success = true;

    @Override
    public void handler(GitContext context, AbstractFormPlugin plugin) {
        String type;
        switch (type = context.getType()) {
            case "page": {
                this.updatePage(context, plugin);
                break;
            }
            case "script": {
                this.updateScript(context, plugin);
                break;
            }
            case "app": {
                this.updateApp(context, plugin);
                break;
            }
            case "botp_bur": 
            case "botp_cr": 
            case "botp_wb": {
                this.updateBotpConvertRule(context, plugin);
                break;
            }
            case "dataModel": {
                this.updateDataModel(context, plugin);
                break;
            }
        }
        if (this.success) {
            plugin.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4ece\u672c\u5730\u4ed3\u5e93\u66f4\u65b0\u5143\u6570\u636e\u6210\u529f\u3002", (String)"GitUpdateMetaHandler_0", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]));
        }
    }

    private void updateDataModel(GitContext context, AbstractFormPlugin plugin) {
        String gitRootPath = context.getGitRootPath();
        String number = BizAppServiceHelp.getAppNumByAppId((String)context.getBizAppId());
        String pdmPath = gitRootPath.split("main")[0] + "pdm/" + number;
        String personalGitRepository = context.getPersonalGitRepository();
        String path = personalGitRepository + File.separator + pdmPath;
        String resPath = path.replace('\\', File.separatorChar).replace('/', File.separatorChar);
        File file = new File(resPath);
        if (!file.exists() || file.listFiles() == null) {
            log.info("pdm file not exists");
            return;
        }
        File[] files = file.listFiles();
        ArrayList<String> errorPdm = new ArrayList<String>(10);
        if (files != null) {
            for (File f : files) {
                if (f.isDirectory() || !f.getName().endsWith("kpdm")) continue;
                try {
                    String kpdm = GitOperationUtil.getContent(f);
                    MetadataDao.deployMetadata((String)kpdm, (String)"", (String)context.getBizAppId());
                }
                catch (Exception e) {
                    errorPdm.add(f.getName());
                    this.success = false;
                    log.error("deploy kpdm error", (Throwable)e);
                }
            }
        }
        if (!errorPdm.isEmpty()) {
            String errorPdmName = StringUtils.join((Object[])errorPdm.toArray(), (String)",");
            String message = String.format(ResManager.loadKDString((String)"\u66f4\u65b0\u6a21\u578b\u6587\u4ef6%s\u5931\u8d25\uff0c\u8be6\u7ec6\u539f\u56e0\u8bf7\u67e5\u770b\u65e5\u5fd7\u3002", (String)"GitUpdateMetaHandler_5", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]), errorPdmName);
            plugin.getView().showErrorNotification(message);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updatePage(GitContext context, AbstractFormPlugin plugin) {
        block20: {
            block18: {
                block19: {
                    id = context.getId();
                    qfilter = new QFilter("form", "=", (Object)id);
                    filters = new QFilter[]{qfilter};
                    dynamicObject = BusinessDataServiceHelper.loadSingle((String)"bos_devportal_unitrelform", (String)"bizunit,form,bizapp", (QFilter[])filters);
                    if (dynamicObject == null) {
                        return;
                    }
                    bizAppId = dynamicObject.getString("bizapp_id");
                    bizUnitId = dynamicObject.getString("bizunit");
                    list = GitOperationUtil.filterPageDeployFiles(id);
                    name = list.get(0).getFileName();
                    h = TX.required();
                    var12_12 = null;
                    try lbl-1000:
                    // 2 sources

                    {
                        for (DeployFile deployFile : list) {
                            fileName = deployFile.getFileName();
                            fileContent = null;
                            metadataGitRepository = this.getMetadataRootPath(context);
                            fileContent = GITCodeHostingServiceImpl.readFromRepository(metadataGitRepository, fileName);
                            if ("nofile".equals(fileContent)) {
                                plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u672c\u5730\u4ed3\u5e93\u4e2d\u6ca1\u6709\u8be5\u6587\u4ef6\u8d44\u6e90\uff0c\u65e0\u6cd5\u66f4\u65b0\u3002", (String)"GitOperationUtil_36", (String)"bos-devportal-business", (Object[])new Object[0]));
                                if (h == null) return;
                                if (var12_12 == null) break block18;
                                break block19;
                            }
                            ** GOTO lbl-1000
                        }
                        ** GOTO lbl59
                    }
                    catch (Exception e) {
                        h.markRollback();
                        this.success = false;
                        plugin.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u66f4\u65b0\u8868\u5355\u5143\u6570\u636e %1$s \u5931\u8d25\uff1a%2$s", (String)"GitUpdateMetaHandler_1", (String)"bos-devportal-business", (Object[])new Object[0]), new Object[]{name, e.getMessage()}));
                        break block20;
                    }
                    catch (Throwable var13_16) {
                        try {
                            var12_12 = var13_16;
                            throw var13_16;
                        }
                        catch (Throwable var19_22) {
                            if (h == null) throw var19_22;
                            if (var12_12 == null) {
                                h.close();
                                throw var19_22;
                            }
                            try {
                                h.close();
                                throw var19_22;
                            }
                            catch (Throwable var20_23) {
                                var12_12.addSuppressed(var20_23);
                                throw var19_22;
                            }
                        }
                    }
                }
                try {
                    h.close();
                    return;
                }
                catch (Throwable var18_21) {
                    var12_12.addSuppressed(var18_21);
                    return;
                }
            }
            h.close();
            return;
lbl-1000:
            // 1 sources

            {
                MetadataDao.deployMetadata((String)fileContent, (String)bizUnitId, (String)bizAppId);
                ** GOTO lbl-1000
lbl59:
                // 1 sources

                loadSingle = BusinessDataServiceHelper.loadSingle((Object)id, (String)"bos_formmeta", (String)"masterid");
                masterId = StringUtils.isBlank((CharSequence)loadSingle.getString("masterid")) != false ? id : loadSingle.getString("masterid");
                MetadataDao.rebuildRuntimeMetaById((String)masterId);
            }
        }
        if (h == null) return;
        if (var12_12 != null) {
            try {
                h.close();
                return;
            }
            catch (Throwable var13_15) {
                var12_12.addSuppressed(var13_15);
                return;
            }
        }
        h.close();
    }

    private void updateScript(GitContext context, AbstractFormPlugin plugin) {
        String fileContent;
        Throwable throwable;
        TXHandle h;
        String fileName;
        String bizUnitId;
        String bizAppId;
        DynamicObject dynamicObject;
        String id;
        block18: {
            block19: {
                block20: {
                    id = context.getId();
                    dynamicObject = BusinessDataServiceHelper.loadSingle((Object)id, (String)IDE_PLUGINSCRIPT, (String)"txt_scriptnumber,bizunitid,bizappid,classname");
                    bizAppId = dynamicObject.getString(BIZAPPID);
                    bizUnitId = dynamicObject.getString(BIZUNITID);
                    fileName = dynamicObject.getString(TXT_SCRIPT_NUMBER) + SCRIPT_SUFFIX;
                    h = TX.required();
                    throwable = null;
                    fileContent = null;
                    String metadataGitRepository = this.getMetadataRootPath(context);
                    fileContent = GITCodeHostingServiceImpl.readFromRepository(metadataGitRepository, fileName);
                    if (!NOFILE.equals(fileContent)) break block18;
                    plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u672c\u5730\u4ed3\u5e93\u65e0\u8be5\u6587\u4ef6\u8d44\u6e90\uff0c\u65e0\u6cd5\u66f4\u65b0\u3002", (String)"GitOperationUtil_34", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]));
                    if (h == null) break block19;
                    if (throwable == null) break block20;
                    try {
                        h.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block19;
                }
                h.close();
            }
            return;
        }
        try {
            try {
                MetadataDao.deployScript((String)fileContent, (String)bizUnitId, (String)bizAppId);
                MetaCacheUtils.removeDistributeCache((String[])new String[]{dynamicObject.getString(CLASSNAME)});
                if ("kd.bos.devportal.script.plugin.KDEPlugin".equals(plugin.getPluginName())) {
                    String scriptContent = BusinessDataServiceHelper.loadSingle((Object)id, (String)IDE_PLUGINSCRIPT, (String)TXT_SCRIPTCONTEXT_TAG).getString(TXT_SCRIPTCONTEXT_TAG);
                    JSONObject scriptInfo = new JSONObject();
                    scriptInfo.put("id", (Object)id);
                    scriptInfo.put("content", (Object)scriptContent);
                    ((IClientViewProxy)plugin.getView().getService(IClientViewProxy.class)).addAction("REFRESHSCRIPTCONTENT_KDEMARK", (Object)scriptInfo);
                }
            }
            catch (Exception e) {
                h.markRollback();
                this.success = false;
                plugin.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u66f4\u65b0\u811a\u672c\u5143\u6570\u636e %1$s \u5931\u8d25\uff1a%2$s", (String)"GitUpdateMetaHandler_2", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]), fileName, e.getMessage()));
            }
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
        catch (Throwable throwable4) {
            throw throwable4;
        }
        finally {
            if (h != null) {
                if (throwable != null) {
                    try {
                        h.close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                } else {
                    h.close();
                }
            }
        }
    }

    private void updateApp(GitContext context, AbstractFormPlugin plugin) {
        String bizAppId = context.getBizAppId();
        log.debug("updateApp: personalGitRepository: " + context.getPersonalGitRepository() + " gitRootpath: " + context.getGitRootPath() + " bizAppId: " + bizAppId);
        try (TXHandle h = TX.required();){
            try {
                ILocaleString name = null;
                List<DeployFile> list = GitOperationUtil.filterAppDeployFiles(bizAppId);
                if (list != null && !list.isEmpty()) {
                    DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)bizAppId, (String)BIZ_APP_NUMBER);
                    for (DeployFile deployFile : list) {
                        String fileName = deployFile.getFileName();
                        String fileContent = null;
                        String metadataGitRepository = this.getMetadataRootPath(context);
                        fileContent = GITCodeHostingServiceImpl.readFromRepository(metadataGitRepository, fileName);
                        if (NOFILE.equals(fileContent)) continue;
                        String bizCloudId = dynamicObject.getString("bizcloud_id");
                        MetadataDao.deployAppMetadata((String)fileContent, (String)bizCloudId);
                    }
                    DynamicObject appObj = BusinessDataServiceHelper.loadSingle((Object)bizAppId, (String)BIZ_APP_NUMBER, (String)"id,type,name,masterid");
                    name = appObj.getLocaleString("name");
                    if (appObj.getString("type").equals("2") && StringUtils.isNotBlank((CharSequence)appObj.getString(MASTERID))) {
                        bizAppId = dynamicObject.getString(MASTERID);
                    }
                    MetadataDao.rebuildRuntimeAppMetaById((String)bizAppId);
                }
                if (name == null) {
                    plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u66f4\u65b0\u5931\u8d25\uff1a\u5e94\u7528\u4fe1\u606f\uff08\u83dc\u5355\u3001\u529f\u80fd\u5206\u7ec4\uff09", (String)"GitOperationUtil_21", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]));
                }
            }
            catch (Exception e) {
                h.markRollback();
                this.success = false;
                plugin.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u66f4\u65b0\u5e94\u7528\u5143\u6570\u636e %1$s \u5931\u8d25\uff1a%2$s", (String)"GitUpdateMetaHandler_3", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]), bizAppId, e, e.getMessage()));
            }
        }
        this.updatePageWithApp(context, plugin);
        this.updateScriptWithApp(context, plugin);
    }

    private void updatePageWithApp(GitContext context, AbstractFormPlugin plugin) {
        String appNumber = BizAppServiceHelp.getAppNumByAppId((String)context.getBizAppId());
        String projectURL = context.getPersonalGitRepository() + File.separator + ".git";
        String checkProjectURL = AppUtils.checkFilePath((String)projectURL);
        String name = null;
        log.debug("updatePageWithApp: projectURL: " + projectURL + " checkProjectURL: " + checkProjectURL);
        File gitFile = new File(checkProjectURL);
        try (Git git = Git.open((File)gitFile);){
            File workTree = git.getRepository().getWorkTree();
            if (workTree.isDirectory()) {
                String metadataRootPath = GitUpdateMetaHandler.getMetadataRootPath(context.getGitRootPath()).trim();
                String[] metaPathSplit = StringUtils.split((String)metadataRootPath, (String)"/");
                for (File rootFile : Objects.requireNonNull(workTree.listFiles())) {
                    if (!rootFile.getAbsolutePath().endsWith(metaPathSplit[0])) continue;
                    ArrayList<File> files = new ArrayList<File>();
                    GitOperationUtil.getMetaFiles(rootFile, files, metadataRootPath);
                    for (File file : files) {
                        String path = file.getPath();
                        name = file.getName();
                        if (!path.contains(appNumber)) continue;
                        HashMap<String, String> errorMap = new HashMap<String, String>();
                        if (!path.endsWith(".dym") && !path.endsWith(".dymx")) continue;
                        this.readAndDeployFormMetadata(path, file.getName(), errorMap);
                    }
                }
            }
        }
        catch (Exception e) {
            this.success = false;
            plugin.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u66f4\u65b0\u8868\u5355\u5143\u6570\u636e %1$s \u5931\u8d25\uff1a%2$s", (String)"GitUpdateMetaHandler_1", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]), name, e.getMessage()));
        }
    }

    private void updateScriptWithApp(GitContext context, AbstractFormPlugin plugin) {
        String appNumber = BizAppServiceHelp.getAppNumByAppId((String)context.getBizAppId());
        String projectURL = context.getPersonalGitRepository() + File.separator + ".git";
        String checkProjectURL = AppUtils.checkFilePath((String)projectURL);
        String name = null;
        log.debug("updateScriptWithApp: projectURL: " + projectURL + " checkProjectURL: " + checkProjectURL);
        File gitFile = new File(checkProjectURL);
        try (Git git = Git.open((File)gitFile);){
            File workTree = git.getRepository().getWorkTree();
            if (workTree.isDirectory()) {
                String metadataRootPath = GitUpdateMetaHandler.getMetadataRootPath(context.getGitRootPath()).trim();
                String[] metaPathSplit = StringUtils.split((String)metadataRootPath, (String)"/");
                for (File rootFile : Objects.requireNonNull(workTree.listFiles())) {
                    if (!rootFile.getAbsolutePath().endsWith(metaPathSplit[0])) continue;
                    ArrayList<File> files = new ArrayList<File>();
                    GitOperationUtil.getMetaFiles(rootFile, files, metadataRootPath);
                    for (File file : files) {
                        String path = file.getPath();
                        name = file.getName();
                        if (!path.contains(appNumber) || !path.endsWith(SCRIPT_SUFFIX)) continue;
                        this.readAndDeployKsMetadata(path);
                    }
                }
            }
        }
        catch (Exception e) {
            this.success = false;
            plugin.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u66f4\u65b0\u811a\u672c\u5143\u6570\u636e %1$s \u5931\u8d25\uff1a%2$s", (String)"GitUpdateMetaHandler_2", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]), name, e.getMessage()));
        }
    }

    private void updateBotpConvertRule(GitContext context, AbstractFormPlugin plugin) {
        String ruleIds = plugin.getPageCache().get(RULE_IDS);
        JSONArray idsArray = (JSONArray)JSONArray.parse((String)ruleIds);
        List<Object> convertRuleDeployFiles = GitOperationUtil.getBotpDeployFiles(context.getType(), idsArray);
        convertRuleDeployFiles = convertRuleDeployFiles.stream().filter(f -> !GitOperationUtil.isIgnoreFile(f.getFileName())).collect(Collectors.toList());
        String metadataGitRepository = this.getMetadataRootPath(context);
        String name = null;
        try (TXHandle h = TX.required();){
            try {
                for (DeployFile deployFile : convertRuleDeployFiles) {
                    String fileName = deployFile.getFileName();
                    name = deployFile.getFileName();
                    String fileContent = GITCodeHostingServiceImpl.readFromRepository(metadataGitRepository, fileName);
                    if (NOFILE.equals(fileContent)) {
                        plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u672c\u5730\u4ed3\u5e93\u4e2d\u6ca1\u6709\u8be5\u6587\u4ef6\u8d44\u6e90\uff0c\u65e0\u6cd5\u66f4\u65b0\u3002", (String)"GitOperationUtil_36", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]));
                        continue;
                    }
                    DcxmlSerializer serializer = new DcxmlSerializer(DeployMetadata.getDCBinder());
                    serializer.setColloctionIgnorePKValue(true);
                    DeployMetadata deployNew = (DeployMetadata)serializer.deserializeFromString(fileContent, null);
                    MetadataDao.deployMetadata((DeployMetadata)deployNew, null, null);
                }
            }
            catch (Exception e) {
                h.markRollback();
                this.success = false;
                plugin.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u66f4\u65b0botp\u5143\u6570\u636e %1$s \u5931\u8d25\uff1a%2$s", (String)"GitUpdateMetaHandler_4", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]), name, e.getMessage()));
            }
        }
    }

    private void readAndDeployFormMetadata(String filePath, String sourceNum, Map<String, String> errorMap) {
        block28: {
            try (TXHandle h = TX.required();){
                File file = new File(filePath);
                Path zipPath = Paths.get(AppUtils.checkFilePath((String)filePath), new String[0]);
                try (InputStream in = Files.newInputStream(zipPath, new OpenOption[0]);){
                    long length = file.length();
                    byte[] fileByte = new byte[(int)length];
                    int count = 0;
                    String fileContent = "";
                    while ((count = in.read(fileByte)) > 0) {
                        fileContent = new String(fileByte, StandardCharsets.UTF_8);
                    }
                    List ids = MetadataDao.deployMetadata((String)fileContent);
                    ids.forEach(MetadataDao::rebuildRuntimeMetaById);
                }
                catch (Exception e) {
                    h.markRollback();
                    String errorInfo = errorMap.get(sourceNum);
                    if (errorInfo != null) {
                        String message = errorInfo + "\n" + e.getMessage();
                        errorMap.put(sourceNum, message);
                        break block28;
                    }
                    errorMap.put(sourceNum, e.getMessage());
                }
            }
        }
    }

    private void readAndDeployKsMetadata(String path) {
        try (TXHandle h = TX.required();){
            try {
                File file = new File(path);
                String content = GitOperationUtil.getContent(file);
                DcxmlSerializer serializer = new DcxmlSerializer(DeployScript.getDCBinder());
                serializer.setColloctionIgnorePKValue(true);
                DeployScript deployNew = (DeployScript)serializer.deserializeFromString(content, null);
                List scripts = deployNew.getScripts();
                String bizappId = ((DynamicObject)scripts.get(0)).getString(BIZAPPID);
                String bizunitId = ((DynamicObject)scripts.get(0)).getString(BIZUNITID);
                MetadataDao.deployScript((String)content, (String)bizunitId, (String)bizappId);
            }
            catch (Exception e) {
                h.markRollback();
                log.error((Throwable)e);
                throw new KDBizException(e.getMessage());
            }
        }
    }

    private String getMetadataRootPath(GitContext context) {
        String gitRootPath = context.getGitRootPath();
        String personalGitRepository = context.getPersonalGitRepository();
        String result = "";
        String separator = Matcher.quoteReplacement(File.separator);
        if (!StringUtils.isBlank((CharSequence)gitRootPath)) {
            result = !(gitRootPath = gitRootPath.replaceAll("\\\\", separator).replaceAll("/", separator)).startsWith(File.separator) ? File.separator + gitRootPath : gitRootPath;
        }
        return personalGitRepository + result;
    }

    private static String getMetadataRootPath(String gitRootpath) {
        String result = "";
        if (!StringUtils.isBlank((CharSequence)gitRootpath)) {
            result = !(gitRootpath = gitRootpath.replace("\\", "/")).startsWith("/") ? "/" + gitRootpath : gitRootpath;
        }
        return result;
    }
}

