/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.business.git;

import com.alibaba.fastjson.JSONObject;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class UserCacheInfo {
    private static final DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("git_userInfo", new DistributeCacheHAPolicy());
    private static final Log log = LogFactory.getLog(UserCacheInfo.class);
    private static final String GIT = "git";
    private String userName;
    private String passWord;

    public UserCacheInfo() {
    }

    public UserCacheInfo(String userName, String passWord) {
        this.userName = userName;
        this.passWord = passWord;
    }

    public void saveUserInfo(String sessionId) {
        this.saveUserInfo(sessionId, 3600);
    }

    public void saveUserInfo(String sessionId, int seconds) {
        JSONObject userInfo = new JSONObject();
        userInfo.put("username", (Object)this.userName);
        userInfo.put("password", (Object)this.passWord);
        userInfo.put("sessionid", (Object)sessionId);
        String key = this.getAcctId() + sessionId;
        String userCache = userInfo.toJSONString();
        cache.put(key, (Object)userCache, seconds);
    }

    public JSONObject getUserInfo(String sessionId) {
        String key = this.getAcctId() + sessionId;
        String userCache = (String)cache.get(key);
        if (StringUtils.isNotBlank((CharSequence)userCache)) {
            return JSONObject.parseObject((String)userCache);
        }
        return null;
    }

    public void removeUserInfo(String sessionId) {
        String key = this.getAcctId() + sessionId;
        cache.remove(key);
    }

    private String getAcctId() {
        String key = Instance.getClusterName() + "." + RequestContext.get().getAccountId() + "." + GIT + ".";
        log.debug(String.format("git_key: %s", key));
        return key;
    }
}

