/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.business.hosting;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.devportal.business.hosting.GitOperationUtil;
import kd.bos.devportal.common.util.AppUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.deploy.DeployFile;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import org.eclipse.jgit.api.AddCommand;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.CommitCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.LsRemoteCommand;
import org.eclipse.jgit.api.PullCommand;
import org.eclipse.jgit.api.PullResult;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.api.TransportConfigCallback;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.Transport;
import org.eclipse.jgit.transport.TransportHttp;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.eclipse.jgit.treewalk.TreeWalk;

public class GITCodeHostingServiceImpl {
    public static final Log logger = LogFactory.getLog(GITCodeHostingServiceImpl.class);
    private static final String NOPERMISSION = "noPermission";
    private static final String AUTHFAIL = "Auth fail";
    private static final String NOTAUTHORIZED = "not authorized";
    private static final String SUCCESS = "success";
    private static final String NOFILE = "nofile";
    private static final String CHECJPROJECTURL = ";checkProjectURL:";
    private static final String PUSHSAVEFILE = "push.saveFile{fileName:";
    private static final String METADATAGITREPOSITORY = ";metaDataGitRepository:";
    private static final String BOS_DEVPORTAL_BUSINESS = "bos-devportal-business";
    private static final String IOEXCEPTION = "IOException";
    private static final String GITAPIEXCEPTION = "GitAPIException";

    private GITCodeHostingServiceImpl() {
        throw new IllegalStateException("GITCodeHostingServiceImpl cannot be instantiated");
    }

    private static String buildErrorInfo() {
        return String.format(ResManager.loadKDString((String)"\u8d26\u53f7\u4e0d\u5bf9\u6216\u6ca1\u6709\u6743\u9650\uff0c\u8bf7\u786e\u8ba4\u5f53\u524d\u8d26\u53f7\u662f\u5426\u6b63\u786e\u3002", (String)"GITCodeHostingServiceImpl_6", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]), new Object[0]);
    }

    public static void checkRemoteAccount(String gitUrl, String userName, String passWord) throws GitAPIException {
        try {
            UsernamePasswordCredentialsProvider credentialsProvider = new UsernamePasswordCredentialsProvider(userName, passWord);
            ((LsRemoteCommand)((LsRemoteCommand)((LsRemoteCommand)Git.lsRemoteRepository().setRemote(gitUrl).setCredentialsProvider((CredentialsProvider)credentialsProvider)).setTransportConfigCallback(transport -> {
                if (transport instanceof TransportHttp && StringUtils.isNotBlank((CharSequence)gitUrl) && gitUrl.startsWith("https")) {
                    try {
                        Field sslVerify = transport.getClass().getDeclaredField("sslVerify");
                        sslVerify.setAccessible(true);
                        sslVerify.set(transport, false);
                    }
                    catch (Exception e) {
                        GITCodeHostingServiceImpl.setErrorLog(e);
                    }
                }
            })).setTimeout(30)).callAsMap();
        }
        catch (GitAPIException e) {
            if (e.getMessage().contains(NOTAUTHORIZED)) {
                logger.error(GITCodeHostingServiceImpl.buildErrorInfo(), (Throwable)e);
            } else {
                GITCodeHostingServiceImpl.setErrorLog((Exception)((Object)e));
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkAccount(String gitUrl, String gitRepository, String gitBranch, String gitRootpath, String userName, String passWord) throws GitAPIException {
        String ret;
        try {
            UsernamePasswordCredentialsProvider credentialsProvider = new UsernamePasswordCredentialsProvider(userName, passWord);
            Map map = ((LsRemoteCommand)Git.lsRemoteRepository().setRemote(gitUrl).setCredentialsProvider((CredentialsProvider)credentialsProvider)).callAsMap();
        }
        catch (GitAPIException e) {
            logger.error(GITCodeHostingServiceImpl.buildErrorInfo(), (Throwable)e);
            return false;
        }
        catch (Exception e) {
            logger.info(e.getMessage());
            return false;
        }
        String checkGitRepository = AppUtils.checkFilePath((String)gitRepository);
        File file = new File(checkGitRepository);
        String projectURL = checkGitRepository + File.separator + ".git";
        File gitFile = new File(projectURL);
        if (!(file.exists() && gitFile.exists() || (ret = GITCodeHostingServiceImpl.cloneRepository(gitUrl, gitRepository, gitBranch, gitRootpath, userName, passWord)) == null || !NOPERMISSION.equals(ret))) {
            GITCodeHostingServiceImpl.setInfoLog();
            return false;
        }
        try (Git git = null;){
            git = Git.open((File)gitFile);
            PullCommand pull = git.pull();
            pull.setCredentialsProvider((CredentialsProvider)new UsernamePasswordCredentialsProvider(userName, passWord));
            PullResult pullResult = pull.call();
            pullResult.isSuccessful();
        }
        return true;
    }

    private static void setInfoLog() {
        logger.info(GITCodeHostingServiceImpl.buildErrorInfo());
    }

    private static void setErrorLog(Exception e) {
        logger.error((Throwable)e);
    }

    public static List<String> getBranchs(final String gitUrl, String userName, String passWord) throws GitAPIException {
        try {
            ArrayList<String> result = new ArrayList<String>();
            UsernamePasswordCredentialsProvider credentialsProvider = new UsernamePasswordCredentialsProvider(userName, passWord);
            Map asMap = ((LsRemoteCommand)((LsRemoteCommand)Git.lsRemoteRepository().setRemote(gitUrl).setHeads(true).setTransportConfigCallback(new TransportConfigCallback(){

                public void configure(Transport transport) {
                    if (transport instanceof TransportHttp && StringUtils.isNotBlank((CharSequence)gitUrl) && gitUrl.startsWith("https")) {
                        try {
                            Field sslVerify = transport.getClass().getDeclaredField("sslVerify");
                            sslVerify.setAccessible(true);
                            sslVerify.set(transport, false);
                        }
                        catch (Exception e) {
                            GITCodeHostingServiceImpl.setErrorLog(e);
                        }
                    }
                }
            })).setCredentialsProvider((CredentialsProvider)credentialsProvider)).callAsMap();
            for (Map.Entry entry : asMap.entrySet()) {
                String branch;
                String key = (String)entry.getKey();
                if ("HEAD".equals(key) || !key.startsWith("refs/heads/") || StringUtils.isBlank((CharSequence)(branch = key.replace("refs/heads/", "")))) continue;
                result.add(branch);
            }
            return result;
        }
        catch (GitAPIException e) {
            logger.error(GITCodeHostingServiceImpl.buildErrorInfo(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.info(e.getMessage());
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String cloneRepository(String gitUrl, String repository, String gitBranch, String gitRootpath, String userName, String passWord) {
        try (Git git = null;){
            String checkRepository = AppUtils.checkFilePath((String)repository);
            File rootPath = new File(checkRepository);
            AppUtils.deleteKd((File)rootPath);
            rootPath.mkdir();
            CloneCommand cloneCommand = Git.cloneRepository();
            cloneCommand.setURI(gitUrl);
            cloneCommand.setCredentialsProvider((CredentialsProvider)new UsernamePasswordCredentialsProvider(userName, passWord));
            cloneCommand.setDirectory(new File(checkRepository));
            if (!StringUtils.isBlank((CharSequence)gitBranch)) {
                cloneCommand.setBranch(gitBranch);
            } else {
                cloneCommand.setCloneAllBranches(true);
            }
            git = cloneCommand.call();
        }
        return SUCCESS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String commit(String personalGitRepository, String annotation, List<String> fileNames, String userName) {
        block23: {
            String projectURL = personalGitRepository + File.separator + ".git";
            String checkProjectURL = AppUtils.checkFilePath((String)projectURL);
            try (Git git = null;){
                String fileName;
                String[] splitFileNames;
                logger.debug("commit{projectURL:" + projectURL + CHECJPROJECTURL + checkProjectURL + "}");
                git = Git.open((File)new File(checkProjectURL));
                List diffEntries = git.diff().call();
                if (diffEntries == null || diffEntries.size() == 0) {
                    String string = "nochange";
                    return string;
                }
                ArrayList<String> addFiles = new ArrayList<String>();
                ArrayList<String> diffFiles = new ArrayList<String>();
                boolean needCommit = false;
                for (DiffEntry diffEntry : diffEntries) {
                    DiffEntry.ChangeType changeType = diffEntry.getChangeType();
                    switch (changeType) {
                        case ADD: {
                            addFiles.add(diffEntry.getNewPath());
                            break;
                        }
                        case COPY: {
                            diffFiles.add(diffEntry.getNewPath());
                            break;
                        }
                        case DELETE: {
                            diffFiles.add(diffEntry.getOldPath());
                            break;
                        }
                        case MODIFY: {
                            diffFiles.add(diffEntry.getOldPath());
                            break;
                        }
                        case RENAME: {
                            diffFiles.add(diffEntry.getNewPath());
                            break;
                        }
                    }
                }
                if (!fileNames.isEmpty()) {
                    boolean flag = false;
                    AddCommand addCmd = git.add();
                    for (String addfileName : addFiles) {
                        splitFileNames = addfileName.replaceAll("\\\\", "/").split("/");
                        fileName = splitFileNames[splitFileNames.length - 1];
                        if (!fileNames.contains(fileName)) continue;
                        addCmd.addFilepattern(addfileName);
                        flag = true;
                    }
                    if (flag) {
                        needCommit = true;
                        addCmd.call();
                    }
                }
                CommitCommand commitCmd = git.commit();
                boolean isSetOnly = false;
                for (String diffFileName : diffFiles) {
                    splitFileNames = diffFileName.replaceAll("\\\\", "/").split("/");
                    fileName = splitFileNames[splitFileNames.length - 1];
                    if (!fileNames.contains(fileName)) continue;
                    commitCmd.setOnly(diffFileName);
                    isSetOnly = true;
                }
                if (isSetOnly) {
                    needCommit = true;
                    for (String addfileName : addFiles) {
                        splitFileNames = addfileName.replaceAll("\\\\", "/").split("/");
                        fileName = splitFileNames[splitFileNames.length - 1];
                        if (!fileNames.contains(fileName)) continue;
                        commitCmd.setOnly(addfileName);
                    }
                }
                if (needCommit) {
                    commitCmd.setMessage(annotation).setAuthor(userName, userName + "@kingdee.com").call();
                    break block23;
                }
                Iterator iterator = "nochange";
                return iterator;
            }
        }
        return SUCCESS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String resolve(String bizAppId, String personalGitRepository, String gitBranch, String gitRootpath, List<String> resolveFile) {
        String projectURL = personalGitRepository + File.separator + ".git";
        HashMap<String, String> filePathMap = new HashMap<String, String>();
        Git git = null;
        Object repository = null;
        try {
            String metaDataGitRepository;
            String checkProjectURL = AppUtils.checkFilePath((String)projectURL);
            logger.debug("push{projectURL:" + projectURL + CHECJPROJECTURL + checkProjectURL + "}");
            git = Git.open((File)new File(checkProjectURL));
            HashSet<String> scriptSet = new HashSet<String>();
            HashSet<String> pageSet = new HashSet<String>();
            for (String filePath : resolveFile) {
                String[] spl = filePath.split("/");
                String fileName = spl[spl.length - 1];
                filePathMap.put(fileName, filePath);
                if (fileName.endsWith("ks")) {
                    String scriptName = fileName.split("\\.")[0];
                    scriptSet.add(scriptName);
                    continue;
                }
                if (!fileName.contains("dym")) continue;
                String pageName = fileName.split("\\.")[0];
                pageSet.add(pageName);
            }
            QFilter qFilter = new QFilter("txt_scriptnumber", "in", scriptSet);
            DynamicObject[] dym = BusinessDataServiceHelper.load((String)"ide_pluginscript", (String)"id", (QFilter[])new QFilter[]{qFilter});
            String[] scriptIds = new String[dym.length];
            for (int i = 0; i < dym.length; ++i) {
                scriptIds[i] = dym[i].getString("id");
            }
            List deployFileList = MetadataDao.getScriptDeployFile((String[])scriptIds);
            ArrayList<String> fileNames = new ArrayList<String>(deployFileList.size());
            for (DeployFile df : deployFileList) {
                String fileName = df.getFileName();
                String fileContent = df.getFileContent();
                metaDataGitRepository = GitOperationUtil.getMetadataGitRepository(personalGitRepository, bizAppId, gitRootpath);
                GITCodeHostingServiceImpl.saveFile(fileName, fileContent, metaDataGitRepository);
                fileNames.add(fileName);
                logger.debug(PUSHSAVEFILE + fileName + METADATAGITREPOSITORY + metaDataGitRepository + "}");
            }
            qFilter = new QFilter("number", "in", pageSet);
            dym = BusinessDataServiceHelper.load((String)"bos_formmeta", (String)"ID,bizappid", (QFilter[])new QFilter[]{qFilter});
            String[] pageIds = new String[dym.length];
            for (int i = 0; i < dym.length; ++i) {
                pageIds[i] = dym[i].getString("id");
            }
            for (String pageId : pageIds) {
                List list = MetadataDao.getFormDeployFile((String)pageId);
                for (int i = 0; i < list.size(); ++i) {
                    String fileName = ((DeployFile)list.get(i)).getFileName();
                    if (GitOperationUtil.isIgnoreFile(fileName)) continue;
                    String fileContent = ((DeployFile)list.get(i)).getFileContent();
                    metaDataGitRepository = GitOperationUtil.getMetadataGitRepository(personalGitRepository, bizAppId, gitRootpath);
                    GITCodeHostingServiceImpl.saveFile(fileName, fileContent, metaDataGitRepository);
                    fileNames.add(fileName);
                    logger.debug(PUSHSAVEFILE + fileName + METADATAGITREPOSITORY + metaDataGitRepository + "}");
                }
            }
            if (!fileNames.isEmpty()) {
                AddCommand addCmd = git.add();
                CommitCommand commitCmd = git.commit();
                for (String addfileName : fileNames) {
                    String filePath = (String)filePathMap.get(addfileName);
                    addCmd.addFilepattern(filePath);
                }
                addCmd.call();
                commitCmd.setMessage(ResManager.loadKDString((String)"\u4ee5\u6587\u4ef6\u6bd4\u8f83\u7ed3\u679c\u81ea\u52a8\u5904\u7406\u6587\u4ef6\u51b2\u7a81", (String)"GITCodeHostingServiceImpl_3", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0])).call();
            }
        }
        catch (Exception e) {
            logger.info("\u63d0\u4ea4\u5931\u8d25:" + e.getMessage());
            String string = e.getMessage();
            return string;
        }
        finally {
            if (git != null) {
                git.close();
            }
            if (repository != null) {
                repository.close();
            }
        }
        return SUCCESS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String push(String bizAppId, String personalGitRepository, String gitBranch, String gitRootpath, String userName, String passWord, Set<String> pushFile) {
        String projectURL = personalGitRepository + File.separator + ".git";
        Git git = null;
        Object repository = null;
        try {
            String checkProjectURL = AppUtils.checkFilePath((String)projectURL);
            logger.debug("push{projectURL:" + projectURL + CHECJPROJECTURL + checkProjectURL + "}");
            git = Git.open((File)new File(checkProjectURL));
            PushCommand push = git.push();
            push.setCredentialsProvider((CredentialsProvider)new UsernamePasswordCredentialsProvider(userName, passWord));
            push.call();
        }
        catch (Exception e) {
            logger.info("\u63a8\u9001\u5931\u8d25:" + e.getMessage());
            String string = e.getMessage();
            return string;
        }
        finally {
            if (git != null) {
                git.close();
            }
            if (repository != null) {
                repository.close();
            }
        }
        return SUCCESS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String commitAndPush(String personalGitRepository, String userName, String passWord, String annotation, List<String> fileNames) {
        String projectURL = personalGitRepository + File.separator + ".git";
        try (Git git = null;){
            String checkProjectURL = AppUtils.checkFilePath((String)projectURL);
            git = Git.open((File)new File(checkProjectURL));
            PullCommand pull = git.pull();
            pull.setCredentialsProvider((CredentialsProvider)new UsernamePasswordCredentialsProvider(userName, passWord));
            pull.call();
            GITCodeHostingServiceImpl.commit(personalGitRepository, annotation, fileNames, userName);
            PushCommand push = git.push();
            push.setCredentialsProvider((CredentialsProvider)new UsernamePasswordCredentialsProvider(userName, passWord));
            push.call();
        }
        return "success_commitandpush";
    }

    public static String revertRepository(String gitUrl, String gitRepository, String userName, String passWord) {
        String checkGitRepository = AppUtils.checkFilePath((String)gitRepository);
        try {
            logger.debug("revertRepository{gitUrl:" + gitUrl + ";gitRepository:" + gitRepository + ";checkGitRepository:" + checkGitRepository + "}");
            AppUtils.deleteKd((File)new File(checkGitRepository));
            CloneCommand cloneCommand = Git.cloneRepository();
            cloneCommand.setURI(gitUrl);
            cloneCommand.setCredentialsProvider((CredentialsProvider)new UsernamePasswordCredentialsProvider(userName, passWord));
            cloneCommand.setDirectory(new File(checkGitRepository)).setCloneAllBranches(true).call();
        }
        catch (Exception e) {
            if (e.getMessage().contains(AUTHFAIL) || e.getMessage().contains(NOTAUTHORIZED)) {
                logger.info(GITCodeHostingServiceImpl.buildErrorInfo());
                return NOPERMISSION;
            }
            if (e.getMessage().contains("already exists and is not an empty directory")) {
                logger.info("\u6587\u4ef6\u6ca1\u6709\u5220\u9664\u6210\u529f\uff0c\u8bf7\u624b\u5de5\u5220\u9664\u8fd9\u4e2a\u6587\u4ef6\u5939\u518d\u8bd5\uff1a" + checkGitRepository);
                return "deletefilefail";
            }
            logger.info("\u8fd8\u539fgit\u672c\u5730\u4ed3\u5e93\u5931\u8d25\uff1a" + e.getMessage());
            return String.format(ResManager.loadKDString((String)"\u8fd8\u539fgit\u672c\u5730\u4ed3\u5e93\u5931\u8d25\uff1a%s", (String)"GITCodeHostingServiceImpl_7", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]), e.getMessage());
        }
        return SUCCESS;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String readFromRepository(String metadataGitRepository, String fileName) {
        byte[] filecontent = null;
        String filePath = metadataGitRepository + File.separator + fileName;
        File file = new File(filePath);
        try (FileInputStream in = new FileInputStream(file);){
            Long filelength = file.length();
            filecontent = new byte[filelength.intValue()];
            int count = 0;
            String formRepository = "";
            while ((count = in.read(filecontent)) > 0) {
                formRepository = new String(filecontent, StandardCharsets.UTF_8);
            }
            String string = formRepository;
            return string;
        }
        catch (FileNotFoundException e) {
            return NOFILE;
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pull(String gitUrl, String tempGirRepository, String gitBranch, String gitRootpath, String userName, String passWord) throws IOException, GitAPIException {
        String r;
        String checkTempGirRepository = AppUtils.checkFilePath((String)tempGirRepository);
        File file = new File(checkTempGirRepository);
        String projectURL = checkTempGirRepository + File.separator + ".git";
        File gitFile = new File(projectURL);
        if (!(file.exists() && gitFile.exists() || SUCCESS.equals(r = GITCodeHostingServiceImpl.cloneRepository(gitUrl, checkTempGirRepository, gitBranch, gitRootpath, userName, passWord)))) {
            throw new KDBizException(r);
        }
        logger.debug("pull{gitUrl:" + gitUrl + ";tempGirRepository:" + tempGirRepository + ";checkTempGirRepository:" + checkTempGirRepository + ";projectURL:" + projectURL + ";gitFile:" + gitFile + "}");
        try (Git git = null;){
            git = Git.open((File)gitFile);
            PullCommand pull = git.pull();
            pull.setCredentialsProvider((CredentialsProvider)new UsernamePasswordCredentialsProvider(userName, passWord));
            pull.call();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFormGitUrl1(String gitRepository, String userName, String passWord, String fileName) {
        String string;
        String fileContent = null;
        Repository repository = null;
        Git git = null;
        RevWalk walk = null;
        try {
            String checkGitRepository = AppUtils.checkFilePath((String)gitRepository);
            git = Git.open((File)new File(checkGitRepository));
            repository = git.getRepository();
            walk = new RevWalk(repository);
            ObjectId objId = repository.resolve("HEAD");
            RevCommit revCommit = walk.parseCommit((AnyObjectId)objId);
            if (revCommit == null) {
                String string2 = NOFILE;
                return string2;
            }
            RevTree revTree = revCommit.getTree();
            TreeWalk treeWalk = TreeWalk.forPath((Repository)repository, (String)fileName, (RevTree)revTree);
            if (treeWalk == null) {
                String string3 = NOFILE;
                return string3;
            }
            ObjectId blobId = treeWalk.getObjectId(0);
            ObjectLoader loader = repository.open((AnyObjectId)blobId);
            byte[] bytes = loader.getBytes();
            if (bytes != null) {
                fileContent = new String(bytes, StandardCharsets.UTF_8);
            }
        }
        catch (FileNotFoundException e) {
            string = NOFILE;
            return string;
        }
        catch (Exception e) {
            logger.info("\u8bfb\u53d6git\u8fdc\u7a0b\u6587\u4ef6\u51fa\u9519\uff1a" + e.getMessage());
            string = String.format(ResManager.loadKDString((String)"\u8bfb\u53d6git\u8fdc\u7a0b\u6587\u4ef6\u51fa\u9519\uff1a%s", (String)"GITCodeHostingServiceImpl_8", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]), e.getMessage());
            return string;
        }
        finally {
            if (repository != null) {
                repository.close();
            }
            if (git != null) {
                git.close();
            }
            if (walk != null) {
                walk.close();
            }
        }
        return fileContent;
    }

    public static String readFormGitUrl(String metadataGitRepository, String fileName) {
        String fileContent = GITCodeHostingServiceImpl.readFromRepository(metadataGitRepository, fileName);
        return fileContent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void revertFile(String personalGitRepository, String filePath) {
        String projectURL = personalGitRepository + File.separator + ".git";
        try (Git git = null;){
            String checkProjectURL = AppUtils.checkFilePath((String)projectURL);
            git = Git.open((File)new File(checkProjectURL));
            git.checkout().addPath(filePath).call();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void revertFile(String personalGitRepository, List<String> filePath) {
        String projectURL = personalGitRepository + File.separator + ".git";
        try (Git git = null;){
            String checkProjectURL = AppUtils.checkFilePath((String)projectURL);
            git = Git.open((File)new File(checkProjectURL));
            git.checkout().addPaths(filePath).call();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void revertPersonalRepository(String personalGitRepository) {
        String projectURL = personalGitRepository + File.separator + ".git";
        Git git = null;
        Repository repository = null;
        RevWalk walk = null;
        try {
            String checkProjectURL = AppUtils.checkFilePath((String)projectURL);
            git = Git.open((File)new File(checkProjectURL));
            repository = git.getRepository();
            Iterable logResult = git.log().setMaxCount(1).call();
            RevCommit commit = (RevCommit)logResult.iterator().next();
            String commitId = commit.getName();
            walk = new RevWalk(repository);
            ObjectId objId = repository.resolve(commitId);
            RevCommit revCommit = walk.parseCommit((AnyObjectId)objId);
            git.reset().setMode(ResetCommand.ResetType.HARD).setRef(revCommit.getName()).call();
        }
        catch (Exception e) {
            GITCodeHostingServiceImpl.setErrorLog(e);
        }
        finally {
            if (git != null) {
                git.close();
            }
            if (repository != null) {
                repository.close();
            }
            if (walk != null) {
                walk.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pull(String personalGitRepository, String gitBranch, String gitRootpath, String userName, String passWord) throws IOException, GitAPIException {
        String projectURL = personalGitRepository + File.separator + ".git";
        try (Git git = null;){
            String checkProjectURL = AppUtils.checkFilePath((String)projectURL);
            git = Git.open((File)new File(checkProjectURL));
            PullCommand pull = git.pull();
            pull.setCredentialsProvider((CredentialsProvider)new UsernamePasswordCredentialsProvider(userName, passWord));
            pull.call();
        }
    }

    public static void saveFile(String fileName, String content, String exportPath) {
        block30: {
            String checkGitRepository = AppUtils.checkFilePath((String)(exportPath + File.separator + fileName));
            try {
                String checkExportPath = AppUtils.checkFilePath((String)exportPath);
                File fileAbovePath = new File(checkExportPath);
                if (!fileAbovePath.exists()) {
                    fileAbovePath.mkdirs();
                }
                File jsFile = new File(checkGitRepository);
                boolean isSuccess = false;
                if (jsFile.exists()) {
                    boolean isDelete = jsFile.delete();
                    if (isDelete) {
                        isSuccess = jsFile.createNewFile();
                    }
                } else {
                    isSuccess = jsFile.createNewFile();
                }
                if (!isSuccess) break block30;
                Path path = Paths.get(checkGitRepository, new String[0]);
                try (OutputStream outputStream = Files.newOutputStream(path, new OpenOption[0]);
                     OutputStreamWriter writer = new OutputStreamWriter(outputStream, StandardCharsets.UTF_8);){
                    writer.write(content);
                }
            }
            catch (IOException e) {
                logger.error(String.format("build file error, file: %s, path: %s", fileName, exportPath), (Throwable)e);
                throw new KDBizException(e.getMessage());
            }
        }
    }
}

