/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.business.hosting;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.DcxmlSerializer;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.devportal.business.git.GitContext;
import kd.bos.devportal.business.git.GitOperateHandler;
import kd.bos.devportal.business.git.GitSettingDao;
import kd.bos.devportal.business.hosting.GITCodeHostingServiceImpl;
import kd.bos.devportal.common.util.AppUtils;
import kd.bos.encrypt.Encrypters;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.AbstractDesignMeta;
import kd.bos.metadata.balance.DesignBalanceRuleMeta;
import kd.bos.metadata.balance.DesignBalanceRuleMetaL;
import kd.bos.metadata.dao.MetaCacheUtils;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.deploy.DeployFile;
import kd.bos.metadata.deploy.DeployMetadata;
import kd.bos.metadata.deploy.DeployScript;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.util.DevportalCommonUtil;
import kd.bos.session.SessionDAO;
import kd.bos.session.SessionDAOFactory;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.BranchTrackingStatus;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;

public class GitOperationUtil {
    private static final long LIMITSIZ = 0x100000L;
    public static final String GITOPERATEID = "gitoperateid";
    public static final String GITOPERATETYPE = "gitoperatetype";
    public static final String GITOPERATEKEY = "gitoperatekey";
    public static final String SCRIPT = "script";
    public static final String BOTP = "botp";
    public static final String BOTP_ConvertRule = "botp_cr";
    public static final String BOTP_WriteBackRule = "botp_wb";
    public static final String BOTP_BalanceUpdateRule = "botp_bur";
    public static final String BIZAPPID = "bizappid";
    public static final String BIZUNITID = "bizunitid";
    public static final String GITURL = "giturl";
    public static final String GITREPOSITORY = "gitrepository";
    public static final String GITBRANCH = "gitbranch";
    public static final String GITROOTPATH = "gitrootpath";
    public static final String PERSONALGITREPOSITORY = "personalgitrepository";
    public static final String PROJECTURL = "projecturl";
    public static final String USERNAME = "username";
    public static final String PSD = "password";
    public static final String METADATA = "metadata";
    public static final String IDE_PLUGINSCRIPT = "ide_pluginscript";
    public static final String TXT_SCRIPTCONTEXT_TAG = "txt_scriptcontext_tag";
    public static final String MASTERID = "masterid";
    public static final String GIT_USERNAME = "gitusername";
    public static final String GIT_PASSWORD = "gitpassword";
    public static final String GIT_CACHE_REGIONINFO = "GIT_LOGININFO";
    private static final String BOS_DEVPORTAL_BUSINESS = "bos-devportal-business";
    private static final String NOFILE = "nofile";
    private static final String IGTOPERATIONUTIL_21 = "GitOperationUtil_21";
    private static final String CLASSNAME = "classname";
    private static final String SAVE_FILE = "saveFile";
    private static final String COMMIT = "commit";
    private static final String RULE_IDS = "ruleIds";
    private static final String BIZ_APP_NUMBER = "bos_devportal_bizapp";
    private static final String TXT_SCRIPT_NUMBER = "txt_scriptnumber";
    private static final String SCRIPT_SUFFIX = ".ks";
    private static final String GIT_OPERATION_UNIT_35 = "GitOperationUtil_35";
    private static final String UNIT_REF_FORM_NUMBER = "bos_devportal_unitrelform";
    private static final String BIZ_UNIT = "bizunit";
    private static final String BOS_DEVPORTAL_PLUGIN = "bos-devportal-plugin";
    private static final String BIZAPP = "bizapp";
    private static final String FILENAME = "filename";
    public static final String PAGE_APP_GIT_COMMIT = "bos_devp_gitchoose";
    public static final String CALLBACK_APP_GIT_CHECK_IN = "callback_app_git_check_in";
    public static final Log logger = LogFactory.getLog(GitOperationUtil.class);

    private static String getMsgUpdateFailed() {
        return ResManager.loadKDString((String)"\u66f4\u65b0\u5931\u8d25\uff1a", (String)"GitOperationUtil_22", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]);
    }

    public static void gitConfirmOperate(String id, String type, String operateKey, String sessionId, AbstractFormPlugin plugin) {
        JSONObject gitInfo = new JSONObject();
        gitInfo.put(GITOPERATEID, (Object)id);
        gitInfo.put(GITOPERATETYPE, (Object)type);
        gitInfo.put(GITOPERATEKEY, (Object)operateKey);
        gitInfo.put("gitoperatesessionid", (Object)sessionId);
        plugin.getPageCache().put("gitinfo", gitInfo.toJSONString());
        String resourceMsg = null;
        if (SCRIPT.equalsIgnoreCase(type)) {
            resourceMsg = ResManager.loadKDString((String)"\u811a\u672c", (String)"GitOperationUtil_0", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]);
        } else if ("page".equalsIgnoreCase(type)) {
            resourceMsg = ResManager.loadKDString((String)"\u9875\u9762", (String)"GitOperationUtil_1", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]);
        } else if ("app".equalsIgnoreCase(type)) {
            resourceMsg = ResManager.loadKDString((String)"\u5e94\u7528", (String)"GitOperationUtil_38", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]);
        } else if ("cloud".equalsIgnoreCase(type)) {
            resourceMsg = ResManager.loadKDString((String)"\u4e1a\u52a1\u4e91", (String)"GitOperationUtil_42", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]);
        } else if (type.startsWith(BOTP)) {
            resourceMsg = ResManager.loadKDString((String)"\u5355\u636e\u8f6c\u6362", (String)"GitOperationUtil_39", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]);
        }
        String showMsg = null;
        if (COMMIT.equals(operateKey)) {
            showMsg = String.format(ResManager.loadKDString((String)"\u786e\u5b9a\u8981\u5c06%s\u63d0\u4ea4\u5230\u672c\u5730\u4ed3\u5e93\u5417?", (String)"GitOperationUtil_43", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]), resourceMsg);
        } else if ("push".equals(operateKey)) {
            showMsg = String.format(ResManager.loadKDString((String)"\u786e\u5b9a\u8981\u5c06\u672c\u5730\u4ed3\u5e93\u91cc\u7684%s\u63a8\u9001\u5230\u8fdc\u7a0b\u4ed3\u5417?", (String)"GitOperationUtil_44", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]), resourceMsg);
        } else if ("revert".equals(operateKey)) {
            showMsg = String.format(ResManager.loadKDString((String)"\u786e\u5b9a\u8981\u5c06%s\u8fd8\u539f\u81f3\u672c\u5730\u4ed3\u5e93\u7248\u672c\u5417?", (String)"GitOperationUtil_45", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]), resourceMsg);
        } else if ("pull".equals(operateKey)) {
            showMsg = ResManager.loadKDString((String)"\u786e\u5b9a\u62c9\u53d6\u8fdc\u7a0b\u4ed3\u5e93\u5e76\u66f4\u65b0\u672c\u5730\u4ed3\u5e93\u5417?", (String)"GitOperationUtil_6", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]);
        }
        plugin.getView().showConfirm(showMsg, MessageBoxOptions.YesNo, new ConfirmCallBackListener("gitOperateCallBack"));
    }

    public static void beforeGitOperate(String operateKey, String id, String type, String sessionId, AbstractFormPlugin plugin) {
        DynamicObject gitSetting;
        JSONObject result = GitOperationUtil.getBizAppIdAndFileNameByType(type, id);
        String bizAppId = result.getString(BIZAPPID);
        String bizUnitId = result.getString(BIZUNITID);
        GitSettingDao settingDao = new GitSettingDao();
        if (settingDao.isNewGitOperate()) {
            GitOperateHandler handler = new GitOperateHandler();
            GitContext context = new GitContext();
            context.setBizAppId(bizAppId);
            context.setBizUnitId(bizUnitId);
            context.setOperateKey(operateKey);
            context.setId(id);
            context.setType(type);
            context.setSessionId(sessionId);
            handler.handler(context, plugin);
            return;
        }
        if (StringUtils.isBlank((CharSequence)sessionId)) {
            GitOperationUtil.showGitLoginPage(operateKey, id, type, plugin, bizAppId, bizUnitId);
            return;
        }
        String userName = plugin.getPageCache().get(USERNAME);
        String passWord = plugin.getPageCache().get(PSD);
        if (StringUtils.isBlank((CharSequence)userName) || StringUtils.isBlank((CharSequence)passWord)) {
            JSONObject cachedLoginInfo = GitOperationUtil.getCachedLoginInfo(bizAppId, bizUnitId, sessionId);
            if (cachedLoginInfo == null || StringUtils.isBlank((CharSequence)cachedLoginInfo.getString(USERNAME)) || StringUtils.isBlank((CharSequence)cachedLoginInfo.getString(PSD))) {
                GitOperationUtil.showGitLoginPage(operateKey, id, type, plugin, bizAppId, bizUnitId);
                return;
            }
            userName = cachedLoginInfo.getString(USERNAME);
            passWord = cachedLoginInfo.getString(PSD);
        }
        if ((gitSetting = GitOperationUtil.getGitSetting(bizAppId, bizUnitId, userName)) == null) {
            String appNumber = MetadataDao.getAppNumberByAppId((String)bizAppId);
            plugin.getView().showMessage(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u5e94\u7528[%s]\u6ca1\u6709\u914dgit\u5730\u5740\uff0c\u8bf7\u5148\u5230\u5e94\u7528\u5361\u7247\u4e0a\u914d\u7f6e\u3002", (String)"GitOperationUtil_7", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]), appNumber));
            return;
        }
        String gitUrl = gitSetting.getString(GITURL);
        if (StringUtils.isBlank((CharSequence)gitUrl)) {
            plugin.getView().showMessage(ResManager.loadKDString((String)"\u5f53\u524d\u5e94\u7528git\u5730\u5740\u4e3a\u7a7a\uff0c\u8bf7\u5148\u5230\u5e94\u7528\u5361\u7247\u4e0a\u914d\u7f6e\u3002", (String)"GitOperationUtil_8", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]));
            return;
        }
        String gitRepository = gitSetting.getString(GITREPOSITORY);
        if (StringUtils.isBlank((CharSequence)gitRepository)) {
            plugin.getView().showMessage(ResManager.loadKDString((String)"\u5f53\u524d\u5e94\u7528\u4ed3\u5e93\u5730\u5740\u4e3a\u7a7a\uff0c\u8bf7\u5148\u5230\u5e94\u7528\u5361\u7247\u4e0a\u914d\u7f6e\u3002", (String)"GitOperationUtil_9", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]));
            return;
        }
        File gitRepositoryFile = new File(gitRepository);
        String gitBranch = gitSetting.getString(GITBRANCH);
        if (StringUtils.isBlank((CharSequence)gitBranch)) {
            plugin.getView().showMessage(ResManager.loadKDString((String)"Git\u8fdc\u7a0b\u5206\u652f\u672a\u914d\u7f6e\u3002", (String)"GitOperationUtil_41", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]));
            return;
        }
        String gitRootpath = gitSetting.getString(GITROOTPATH);
        String personalGitRepository = GitOperationUtil.getPersonalGitRepository(gitRepository, userName);
        GitOperationUtil.gitOperate(bizAppId, gitUrl, gitRepository, gitBranch, gitRootpath, personalGitRepository, userName, passWord, operateKey, id, type, plugin);
    }

    private static boolean branchNameExist(Git git, String branchName) throws GitAPIException {
        List refs = git.branchList().call();
        for (Ref ref : refs) {
            if (!ref.getName().contains(branchName)) continue;
            return true;
        }
        return false;
    }

    public static String getPersonalGitRepository(String gitRepository, String username) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)RequestContext.get().getUserId(), (String)"bos_user", (String)"phone");
        String phoneNumber = dynamicObject.getString("phone");
        if (StringUtils.isBlank((CharSequence)phoneNumber)) {
            phoneNumber = username;
        }
        return gitRepository + File.separator + phoneNumber + File.separator + RequestContext.get().getAccountId() + File.separator + username;
    }

    public static String getTempRepository(String gitRepository, String username) {
        return GitOperationUtil.getPersonalGitRepository(gitRepository, username) + "temp";
    }

    public static String getMetadataGitRepository(String gitRepository, String bizAppId, String gitRootpath) {
        String appNumber = MetadataDao.getAppNumberByAppId((String)bizAppId);
        if (StringUtils.isBlank((CharSequence)appNumber)) {
            appNumber = bizAppId;
        }
        String metadataRootPath = GitOperationUtil.getMetadataRootPath(gitRootpath, appNumber);
        return gitRepository + metadataRootPath;
    }

    private static String getMetadataRootPath(String gitRootpath, String appNumber) {
        String result = "";
        if (!StringUtils.isBlank((CharSequence)gitRootpath)) {
            result = !(gitRootpath = gitRootpath.replace("\\", "/")).startsWith("/") ? "/" + gitRootpath : gitRootpath;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void gitOperate(String bizAppId, String gitUrl, String gitRepository, String gitBranch, String gitRootpath, String personalGitRepository, String userName, String passWord, String operateKey, String id, String type, AbstractFormPlugin plugin) {
        try {
            passWord = Encrypters.decode((String)passWord);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        String projectURL = personalGitRepository + File.separator + ".git";
        try (Git git = null;){
            plugin.getPageCache().put(GITOPERATEKEY, operateKey);
            plugin.getPageCache().put("id", id);
            plugin.getPageCache().put("type", type);
            String checkProjectURL = AppUtils.checkFilePath((String)projectURL);
            File gitFile = new File(checkProjectURL);
            if (!gitFile.exists()) {
                GITCodeHostingServiceImpl.cloneRepository(gitUrl, personalGitRepository, gitBranch, gitRootpath, userName, passWord);
            }
            git = Git.open((File)gitFile);
            GitOperationUtil.disableSSL(git);
            Repository repository = git.getRepository();
            String currentBranchName = repository.getBranch();
            if (!StringUtils.isBlank((CharSequence)gitBranch) && !gitBranch.equalsIgnoreCase(currentBranchName)) {
                if (GitOperationUtil.branchNameExist(git, gitBranch)) {
                    git.checkout().setCreateBranch(false).setName(gitBranch).call();
                } else {
                    git.checkout().setCreateBranch(true).setName(gitBranch).setStartPoint("origin/" + gitBranch).call();
                }
            }
            Status status = git.status().call();
            Set conflictSet = status.getConflicting();
            JSONArray arr = new JSONArray();
            arr.addAll((Collection)conflictSet);
            if (!conflictSet.isEmpty()) {
                plugin.getPageCache().put(GITURL, gitUrl);
                plugin.getPageCache().put(GITREPOSITORY, gitRepository);
                plugin.getPageCache().put(GITBRANCH, gitBranch);
                plugin.getPageCache().put(GITROOTPATH, gitRootpath);
                plugin.getPageCache().put(PERSONALGITREPOSITORY, personalGitRepository);
                plugin.getPageCache().put(PROJECTURL, projectURL);
                plugin.getPageCache().put(USERNAME, userName);
                plugin.getPageCache().put(BIZAPPID, bizAppId);
                plugin.getPageCache().put(PSD, passWord);
                plugin.getPageCache().put("arr", arr.toJSONString());
                plugin.getView().showConfirm(ResManager.loadKDString((String)"\u5f53\u524d\u4ed3\u5e93\u5b58\u5728\u51b2\u7a81\uff0c\u662f\u5426\u524d\u5f80\u89e3\u51b3\u51b2\u7a81\uff1f", (String)"GitOperationUtil_27", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("gitConflictCallBack"));
                return;
            }
            logger.debug("beforeGitOperate:{projectURL:" + projectURL + ";checkProjectURL:" + checkProjectURL + "}");
        }
        switch (operateKey) {
            case "commit": {
                String checkProjectURL = AppUtils.checkFilePath((String)projectURL);
                File gitFile = new File(checkProjectURL);
                if (!gitFile.exists()) {
                    GITCodeHostingServiceImpl.cloneRepository(gitUrl, personalGitRepository, gitBranch, gitRootpath, userName, passWord);
                }
                GitOperationUtil.commit(bizAppId, gitUrl, gitRepository, gitBranch, gitRootpath, personalGitRepository, projectURL, userName, passWord, id, type, plugin);
                break;
            }
            case "push": {
                JSONArray fileArray = new JSONArray();
                Boolean flag = GitOperationUtil.beforePush(fileArray, gitUrl, personalGitRepository, gitBranch, gitRootpath, id, type, plugin, userName, passWord);
                if (!flag.booleanValue()) break;
                GitOperationUtil.push(bizAppId, gitUrl, gitRepository, gitBranch, gitRootpath, personalGitRepository, projectURL, userName, passWord, type, plugin, fileArray);
                break;
            }
            case "revert": {
                GitOperationUtil.revert(gitRepository, gitBranch, gitRootpath, personalGitRepository, userName, passWord, id, type, plugin, GITREPOSITORY);
                break;
            }
            case "pull": {
                String tempGirRepository = personalGitRepository + "temp";
                try {
                    GITCodeHostingServiceImpl.pull(gitUrl, tempGirRepository, gitBranch, gitRootpath, userName, passWord);
                    GITCodeHostingServiceImpl.pull(personalGitRepository, gitBranch, gitRootpath, userName, passWord);
                    GitOperationUtil.afterPull(bizAppId, gitUrl, personalGitRepository, gitRepository, gitBranch, gitRootpath, userName, passWord, plugin, id, type);
                }
                catch (IOException e) {
                    logger.error(e.getMessage());
                    plugin.getView().showErrorNotification(e.getMessage());
                }
                catch (GitAPIException e) {
                    logger.error(e.getMessage());
                    plugin.getView().showErrorNotification(e.getMessage());
                }
                break;
            }
        }
    }

    public static void revert(String gitRepository, String gitBranch, String gitRootpath, String personalGitRepository, String userName, String passWord, String id, String type, AbstractFormPlugin plugin, String updateType) {
        String appNumber;
        String appNumber2;
        String bizAppId;
        if ("page".equals(type)) {
            List list = MetadataDao.getFormDeployFile((String)id);
            bizAppId = BusinessDataServiceHelper.loadSingle((Object)id, (String)"bos_formmeta", (String)BIZAPPID).getString(BIZAPPID);
            appNumber2 = BizAppServiceHelp.getAppNumByAppId((String)bizAppId);
            ArrayList<String> filePath = new ArrayList<String>(list.size());
            for (DeployFile file : list) {
                String fileName = file.getFileName();
                if (GitOperationUtil.isIgnoreFile(fileName)) continue;
                filePath.add(GitOperationUtil.getMetadataRootPath(gitRootpath, appNumber2) + "/" + appNumber2 + "/" + file.getFileName());
            }
            GITCodeHostingServiceImpl.revertFile(personalGitRepository, filePath);
            GitOperationUtil.updatePage(gitRepository, gitBranch, gitRootpath, personalGitRepository, userName, passWord, id, plugin, updateType);
        } else if (SCRIPT.equals(type)) {
            DynamicObject dym = BusinessDataServiceHelper.loadSingle((Object)id, (String)IDE_PLUGINSCRIPT, (String)"txt_scriptnumber,bizappid");
            bizAppId = dym.getString(BIZAPPID);
            appNumber2 = BizAppServiceHelp.getAppNumByAppId((String)bizAppId);
            List list = MetadataDao.getScriptDeployFile((String[])new String[]{id});
            String filePath = GitOperationUtil.getMetadataRootPath(gitRootpath, appNumber2) + "/" + appNumber2 + "/" + ((DeployFile)list.get(0)).getFileName();
            GITCodeHostingServiceImpl.revertFile(personalGitRepository, filePath);
            GitOperationUtil.updateScript(gitRepository, gitBranch, gitRootpath, personalGitRepository, userName, passWord, id, plugin, updateType);
        } else if ("app".equals(type)) {
            appNumber = BizAppServiceHelp.getAppNumByAppId((String)id);
            GITCodeHostingServiceImpl.revertPersonalRepository(personalGitRepository);
            GitOperationUtil.updateApp(personalGitRepository, gitBranch, gitRootpath, id, plugin, updateType);
            GitOperationUtil.updatePageWithApp(personalGitRepository, gitBranch, gitRootpath, appNumber, id);
            GitOperationUtil.updateScriptWithApp(personalGitRepository, gitRootpath, appNumber, id);
        } else if (BOTP_ConvertRule.equals(type) || BOTP_WriteBackRule.equals(type) || BOTP_BalanceUpdateRule.equals(type)) {
            appNumber = BizAppServiceHelp.getAppNumByAppId((String)id);
            String ruleIds = plugin.getPageCache().get(RULE_IDS);
            JSONArray idsArray = (JSONArray)JSONArray.parse((String)ruleIds);
            List<DeployFile> convertRuleDeployFiles = GitOperationUtil.getBotpDeployFiles(type, idsArray);
            convertRuleDeployFiles = GitOperationUtil.filterBotpConvertRuleFiles(convertRuleDeployFiles);
            ArrayList<String> filePath = new ArrayList<String>(convertRuleDeployFiles.size());
            for (DeployFile file : convertRuleDeployFiles) {
                filePath.add(GitOperationUtil.getMetadataRootPath(gitRootpath, appNumber) + "/" + appNumber + "/" + file.getFileName());
            }
            GITCodeHostingServiceImpl.revertFile(personalGitRepository, filePath);
            GitOperationUtil.updateBotpConvertRule(gitRepository, gitBranch, gitRootpath, personalGitRepository, userName, passWord, id, plugin, updateType, filePath, convertRuleDeployFiles);
        }
        String result = null;
        result = GITREPOSITORY.equals(updateType) ? ResManager.loadKDString((String)"\u4ece\u672c\u5730\u4ed3\u5e93\u66f4\u65b0\u6210\u529f\u3002", (String)"GitOperationUtil_32", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]) : ResManager.loadKDString((String)"\u62c9\u53d6\u6210\u529f\uff0c\u8d44\u6e90\u5df2\u66f4\u65b0\u3002", (String)"GitOperationUtil_33", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]);
        plugin.getView().showMessage(result);
        MultiLangEnumBridge opName = new MultiLangEnumBridge("\u66f4\u65b0", "GitOperationUtil_47", BOS_DEVPORTAL_BUSINESS);
        MultiLangEnumBridge opDescription = new MultiLangEnumBridge("Git\u66f4\u65b0", "GitOperationUtil_17", BOS_DEVPORTAL_BUSINESS);
        AppUtils.addOpLog((String)id, (String)"revert", (String)id, (String)"1", (MultiLangEnumBridge)opName, (MultiLangEnumBridge)opDescription, (String[])new String[0]);
    }

    private static void updatePageWithApp(String personalGitRepository, String gitBranch, String gitRootpath, String appNumber, String bizAppId) {
        String appPath = personalGitRepository + GitOperationUtil.getMetadataRootPath(gitRootpath, appNumber) + File.separator + appNumber;
        Git git = null;
        String projectURL = personalGitRepository + File.separator + ".git";
        String checkProjectURL = AppUtils.checkFilePath((String)projectURL);
        logger.debug("updatePageWithApp: projectURL: " + projectURL + " checkProjectURL: " + checkProjectURL);
        File gitFile = new File(checkProjectURL);
        try {
            git = Git.open((File)gitFile);
            File workTree = git.getRepository().getWorkTree();
            if (workTree.isDirectory()) {
                String metadataRootPath = GitOperationUtil.getMetadataRootPath(gitRootpath, appNumber).trim();
                String[] metaPathSplit = StringUtils.split((String)metadataRootPath, (String)"/");
                for (File rootFile : Objects.requireNonNull(workTree.listFiles())) {
                    if (!rootFile.getAbsolutePath().endsWith(metaPathSplit[0])) continue;
                    ArrayList<File> files = new ArrayList<File>();
                    GitOperationUtil.getMetaFiles(rootFile, files, metadataRootPath);
                    for (File file : files) {
                        String path = file.getPath();
                        if (!path.contains(appNumber)) continue;
                        HashMap<String, String> errorMap = new HashMap<String, String>();
                        if (!path.endsWith(".dym") && !path.endsWith(".dymx")) continue;
                        GitOperationUtil.readAndDeployFormMetadata(path, file.getName(), errorMap);
                    }
                }
            }
        }
        catch (IOException e) {
            throw new KDBizException(e.getMessage());
        }
        finally {
            if (git != null) {
                git.close();
            }
        }
    }

    public static void getMetaFiles(File file, List<File> files, String metaRootPath) throws IOException {
        File[] fileList;
        if (!file.isDirectory()) {
            if (GitOperationUtil.containsPath(file.getCanonicalPath(), metaRootPath)) {
                files.add(file);
            }
        } else if (file.isDirectory() && (fileList = file.listFiles()) != null) {
            for (File file1 : fileList) {
                GitOperationUtil.getMetaFiles(file1, files, metaRootPath);
            }
        }
    }

    private static boolean containsPath(String source, String target) {
        String newSource = source.replace("\\", "/");
        String newTarget = target.replace("\\", "/");
        return newSource.contains(newTarget);
    }

    private static void readAndDeployFormMetadata(String filePath, String sourceNum, Map<String, String> errorMap) {
        File file = new File(filePath);
        Path zipPath = Paths.get(AppUtils.checkFilePath((String)filePath), new String[0]);
        try (InputStream in = Files.newInputStream(zipPath, new OpenOption[0]);){
            long length = file.length();
            byte[] fileByte = new byte[(int)length];
            int count = 0;
            String fileContent = "";
            while ((count = in.read(fileByte)) > 0) {
                fileContent = new String(fileByte, StandardCharsets.UTF_8);
            }
            MetadataDao.deployMetadata((String)fileContent);
        }
        catch (Exception e) {
            String errorInfo = errorMap.get(sourceNum);
            if (errorInfo != null) {
                String message = errorInfo + "\n" + e.getMessage();
                errorMap.put(sourceNum, message);
            }
            errorMap.put(sourceNum, e.getMessage());
        }
    }

    private static void updateApp(String personalGitRepository, String gitBranch, String gitRootpath, String bizAppId, AbstractFormPlugin plugin, String updateType) {
        logger.debug("updateApp: personalGitRepository: " + personalGitRepository + " gitRootpath: " + gitRootpath + " bizAppId: " + bizAppId);
        try (TXHandle h = TX.required();){
            try {
                ILocaleString name = null;
                List<DeployFile> list = GitOperationUtil.filterAppDeployFiles(bizAppId);
                if (list != null && !list.isEmpty()) {
                    DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)bizAppId, (String)BIZ_APP_NUMBER);
                    for (DeployFile deployFile : list) {
                        String fileName = deployFile.getFileName();
                        String fileContent = null;
                        String metadataGitRepository = GitOperationUtil.getMetadataGitRepository(personalGitRepository, bizAppId, gitRootpath);
                        fileContent = GITCodeHostingServiceImpl.readFromRepository(metadataGitRepository, fileName);
                        if (NOFILE.equals(fileContent)) continue;
                        String bizCloudId = dynamicObject.getString("bizcloud_id");
                        MetadataDao.deployAppMetadata((String)fileContent, (String)bizCloudId);
                    }
                    DynamicObject appObj = BusinessDataServiceHelper.loadSingle((Object)bizAppId, (String)BIZ_APP_NUMBER, (String)"id,type,name,masterid");
                    name = appObj.getLocaleString("name");
                    if (appObj.getString("type").equals("2") && StringUtils.isNotBlank((CharSequence)appObj.getString(MASTERID))) {
                        bizAppId = dynamicObject.getString(MASTERID);
                    }
                    MetadataDao.rebuildRuntimeAppMetaById((String)bizAppId);
                }
                if (name == null) {
                    plugin.getView().showMessage(ResManager.loadKDString((String)"\u66f4\u65b0\u5931\u8d25\uff1a\u5e94\u7528\u4fe1\u606f\uff08\u83dc\u5355\u3001\u529f\u80fd\u5206\u7ec4\uff09", (String)IGTOPERATIONUTIL_21, (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]));
                }
            }
            catch (Exception e) {
                h.markRollback();
                plugin.getView().showMessage(GitOperationUtil.getMsgUpdateFailed() + e.getMessage());
            }
        }
    }

    private static void updateScriptWithApp(String personalGitRepository, String gitRootpath, String appNumber, String appId) {
        String appPath = personalGitRepository + GitOperationUtil.getMetadataRootPath(gitRootpath, appNumber) + File.separator + appNumber;
        Git git = null;
        String projectURL = personalGitRepository + File.separator + ".git";
        String checkProjectURL = AppUtils.checkFilePath((String)projectURL);
        logger.debug("updateScriptWithApp: projectURL: " + projectURL + " checkProjectURL: " + checkProjectURL);
        File gitFile = new File(checkProjectURL);
        try {
            git = Git.open((File)gitFile);
            File workTree = git.getRepository().getWorkTree();
            if (workTree.isDirectory()) {
                String metadataRootPath = GitOperationUtil.getMetadataRootPath(gitRootpath, appNumber).trim();
                String[] metaPathSplit = StringUtils.split((String)metadataRootPath, (String)"/");
                for (File rootFile : Objects.requireNonNull(workTree.listFiles())) {
                    if (!rootFile.getAbsolutePath().endsWith(metaPathSplit[0])) continue;
                    ArrayList<File> files = new ArrayList<File>();
                    GitOperationUtil.getMetaFiles(rootFile, files, metadataRootPath);
                    for (File file : files) {
                        String path = file.getPath();
                        if (!path.contains(appNumber) || !path.endsWith(SCRIPT_SUFFIX)) continue;
                        GitOperationUtil.readAndDeployKsMetadata(path);
                    }
                }
            }
        }
        catch (IOException e) {
            throw new KDBizException(e.getMessage());
        }
        finally {
            if (git != null) {
                git.close();
            }
        }
    }

    private static void readAndDeployKsMetadata(String path) {
        try {
            File file = new File(path);
            String content = GitOperationUtil.getContent(file);
            DcxmlSerializer serializer = new DcxmlSerializer(DeployScript.getDCBinder());
            serializer.setColloctionIgnorePKValue(true);
            DeployScript deployNew = (DeployScript)serializer.deserializeFromString(content, null);
            List scripts = deployNew.getScripts();
            String bizappId = ((DynamicObject)scripts.get(0)).getString(BIZAPPID);
            String bizunitId = ((DynamicObject)scripts.get(0)).getString(BIZUNITID);
            MetadataDao.deployScript((String)content, (String)bizunitId, (String)bizappId);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw new KDBizException(e.getMessage());
        }
    }

    public static String getContent(File file) {
        String fileContent = "";
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            Long length = file.length();
            byte[] bytes = new byte[length.intValue()];
            int count = 0;
            while ((count = ((InputStream)in).read(bytes)) > 0) {
                fileContent = new String(bytes, StandardCharsets.UTF_8);
            }
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
        finally {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException e) {
                    logger.error((Throwable)e);
                }
            }
        }
        return fileContent;
    }

    private static void updateScript(String gitRepository, String gitBranch, String gitRootpath, String personalGitRepository, String userName, String passWord, String id, AbstractFormPlugin plugin, String updateType) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)id, (String)IDE_PLUGINSCRIPT, (String)"txt_scriptnumber,bizunitid,bizappid,classname");
        String bizAppId = dynamicObject.getString(BIZAPPID);
        String bizUnitId = dynamicObject.getString(BIZUNITID);
        String fileName = dynamicObject.getString(TXT_SCRIPT_NUMBER) + SCRIPT_SUFFIX;
        String fileContent = null;
        String metadataGitRepository = GitOperationUtil.getMetadataGitRepository(personalGitRepository, bizAppId, gitRootpath);
        fileContent = GITCodeHostingServiceImpl.readFromRepository(metadataGitRepository, fileName);
        if (NOFILE.equals(fileContent)) {
            if (GITREPOSITORY.equals(updateType)) {
                plugin.getView().showMessage(ResManager.loadKDString((String)"\u672c\u5730\u4ed3\u5e93\u65e0\u8be5\u6587\u4ef6\u8d44\u6e90\uff0c\u65e0\u6cd5\u66f4\u65b0\u3002", (String)"GitOperationUtil_34", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]));
            } else {
                plugin.getView().showMessage(ResManager.loadKDString((String)"\u8fdc\u7a0b\u3001\u672c\u5730\u4ed3\u5e93\u6ca1\u6709\u8be5\u6587\u4ef6\u8d44\u6e90\uff0c\u65e0\u6cd5\u66f4\u65b0\u3002", (String)GIT_OPERATION_UNIT_35, (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]));
            }
            return;
        }
        MetadataDao.deployScript((String)fileContent, (String)bizUnitId, (String)bizAppId);
        MetaCacheUtils.removeDistributeCache((String[])new String[]{dynamicObject.getString(CLASSNAME)});
        if ("kd.bos.devportal.script.plugin.KDEPlugin".equals(plugin.getPluginName())) {
            String scriptContent = BusinessDataServiceHelper.loadSingle((Object)id, (String)IDE_PLUGINSCRIPT, (String)TXT_SCRIPTCONTEXT_TAG).getString(TXT_SCRIPTCONTEXT_TAG);
            JSONObject scriptInfo = new JSONObject();
            scriptInfo.put("id", (Object)id);
            scriptInfo.put("content", (Object)scriptContent);
            ((IClientViewProxy)plugin.getView().getService(IClientViewProxy.class)).addAction("REFRESHSCRIPTCONTENT_KDEMARK", (Object)scriptInfo);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void updatePage(String gitRepository, String gitBranch, String gitRootpath, String personalGitRepository, String userName, String passWord, String id, AbstractFormPlugin plugin, String updateType) {
        block21: {
            block19: {
                block20: {
                    qfilter = new QFilter("form", "=", (Object)id);
                    filters = new QFilter[]{qfilter};
                    dynamicObject = BusinessDataServiceHelper.loadSingle((String)"bos_devportal_unitrelform", (String)"bizunit,form,bizapp", (QFilter[])filters);
                    bizAppId = dynamicObject.getString("bizapp_id");
                    bizUnitId = dynamicObject.getString("bizunit");
                    list = GitOperationUtil.filterPageDeployFiles(id);
                    h = TX.required();
                    var16_16 = null;
                    try lbl-1000:
                    // 2 sources

                    {
                        for (DeployFile deployFile : list) {
                            fileName = deployFile.getFileName();
                            fileContent = null;
                            metadataGitRepository = GitOperationUtil.getMetadataGitRepository(personalGitRepository, bizAppId, gitRootpath);
                            fileContent = GITCodeHostingServiceImpl.readFromRepository(metadataGitRepository, fileName);
                            if ("nofile".equals(fileContent)) {
                                if ("gitrepository".equals(updateType)) {
                                    plugin.getView().showMessage(ResManager.loadKDString((String)"\u672c\u5730\u4ed3\u5e93\u4e2d\u6ca1\u6709\u8be5\u6587\u4ef6\u8d44\u6e90\uff0c\u65e0\u6cd5\u66f4\u65b0\u3002", (String)"GitOperationUtil_36", (String)"bos-devportal-business", (Object[])new Object[0]));
                                } else {
                                    plugin.getView().showMessage(ResManager.loadKDString((String)"\u8fdc\u7a0b\u3001\u672c\u5730\u4ed3\u5e93\u6ca1\u6709\u8be5\u6587\u4ef6\u8d44\u6e90\uff0c\u65e0\u6cd5\u66f4\u65b0\u3002", (String)"GitOperationUtil_35", (String)"bos-devportal-business", (Object[])new Object[0]));
                                }
                                if (h == null) return;
                                if (var16_16 == null) break block19;
                                break block20;
                            }
                            ** GOTO lbl-1000
                        }
                        ** GOTO lbl57
                    }
                    catch (Exception e) {
                        h.markRollback();
                        plugin.getView().showMessage(GitOperationUtil.getMsgUpdateFailed() + e.getMessage());
                        break block21;
                    }
                    catch (Throwable var17_20) {
                        try {
                            var16_16 = var17_20;
                            throw var17_20;
                        }
                        catch (Throwable var23_26) {
                            if (h == null) throw var23_26;
                            if (var16_16 == null) {
                                h.close();
                                throw var23_26;
                            }
                            try {
                                h.close();
                                throw var23_26;
                            }
                            catch (Throwable var24_27) {
                                var16_16.addSuppressed(var24_27);
                                throw var23_26;
                            }
                        }
                    }
                }
                try {
                    h.close();
                    return;
                }
                catch (Throwable var22_25) {
                    var16_16.addSuppressed(var22_25);
                    return;
                }
            }
            h.close();
            return;
lbl-1000:
            // 1 sources

            {
                MetadataDao.deployMetadata((String)fileContent, (String)bizUnitId, (String)bizAppId);
                ** GOTO lbl-1000
lbl57:
                // 1 sources

                loadSingle = BusinessDataServiceHelper.loadSingle((Object)id, (String)"bos_formmeta", (String)"masterid");
                masterId = StringUtils.isBlank((CharSequence)loadSingle.getString("masterid")) != false ? id : loadSingle.getString("masterid");
                MetadataDao.rebuildRuntimeMetaById((String)masterId);
            }
        }
        if (h == null) return;
        if (var16_16 != null) {
            try {
                h.close();
                return;
            }
            catch (Throwable var17_19) {
                var16_16.addSuppressed(var17_19);
                return;
            }
        }
        h.close();
    }

    private static void updateBotpConvertRule(String gitRepository, String gitBranch, String gitRootpath, String personalGitRepository, String userName, String passWord, String id, AbstractFormPlugin plugin, String updateType, List<String> filePath, List<DeployFile> convertRuleDeployFiles) {
        if (filePath == null || filePath.size() == 0) {
            return;
        }
        String metadataGitRepository = GitOperationUtil.getMetadataGitRepository(personalGitRepository, id, gitRootpath);
        try (TXHandle h = TX.required();){
            try {
                for (DeployFile deployFile : convertRuleDeployFiles) {
                    String fileName = deployFile.getFileName();
                    String fileContent = GITCodeHostingServiceImpl.readFromRepository(metadataGitRepository, fileName);
                    if (NOFILE.equals(fileContent)) {
                        if (GITREPOSITORY.equals(updateType)) {
                            plugin.getView().showMessage(ResManager.loadKDString((String)"\u672c\u5730\u4ed3\u5e93\u4e2d\u6ca1\u6709\u8be5\u6587\u4ef6\u8d44\u6e90\uff0c\u65e0\u6cd5\u66f4\u65b0\u3002", (String)"GitOperationUtil_36", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]));
                            continue;
                        }
                        plugin.getView().showMessage(ResManager.loadKDString((String)"\u8fdc\u7a0b\u3001\u672c\u5730\u4ed3\u5e93\u6ca1\u6709\u8be5\u6587\u4ef6\u8d44\u6e90\uff0c\u65e0\u6cd5\u66f4\u65b0\u3002", (String)GIT_OPERATION_UNIT_35, (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]));
                        continue;
                    }
                    DcxmlSerializer serializer = new DcxmlSerializer(DeployMetadata.getDCBinder());
                    serializer.setColloctionIgnorePKValue(true);
                    DeployMetadata deployNew = (DeployMetadata)serializer.deserializeFromString(fileContent, null);
                    AbstractDesignMeta designConvertRuleMeta = (AbstractDesignMeta)deployNew.getDesignMetas().get(0);
                    MetadataDao.deployMetadata((DeployMetadata)deployNew, null, null);
                }
            }
            catch (Exception e) {
                h.markRollback();
                plugin.getView().showMessage(GitOperationUtil.getMsgUpdateFailed() + e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Boolean beforePush(JSONArray fileArray, String gitUrl, String personalGitRepository, String gitBranch, String gitRootpath, String id, String type, AbstractFormPlugin plugin, String userName, String passWord) {
        String projectURL = personalGitRepository + File.separator + ".git";
        JSONObject result = GitOperationUtil.getBizAppIdAndFileNameByType(type, id);
        String bizAppId = result.getString(BIZAPPID);
        String checkPersonalGitRepository = AppUtils.checkFilePath((String)personalGitRepository);
        String metaDataGitRepository = GitOperationUtil.getMetadataGitRepository(checkPersonalGitRepository, bizAppId, gitRootpath);
        Git git = null;
        String checkProjectURL = AppUtils.checkFilePath((String)projectURL);
        File gitFile = new File(checkProjectURL);
        File metaFile = new File(metaDataGitRepository);
        logger.debug("beforePush{gitUrl:" + gitUrl + ";personalGitRepository:" + personalGitRepository + ";projectURL:" + projectURL + ";checkPersonalGitRepository:" + checkPersonalGitRepository + ";metaDataGitRepository:" + metaDataGitRepository + ";gitFile:" + gitFile + ";metaFile:" + metaFile + "}");
        if (!gitFile.exists() || !metaFile.exists()) {
            plugin.getView().showMessage(ResManager.loadKDString((String)"\u63a8\u9001\u5931\u8d25\uff1a\u8bf7\u5148\u63d0\u4ea4\u6587\u4ef6\uff0c\u518d\u8fdb\u884c\u63a8\u9001\u3002", (String)"GitOperationUtil_29", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]));
            return Boolean.FALSE;
        }
        try {
            git = Git.open((File)new File(checkProjectURL));
            Repository repository = git.getRepository();
            String branchName = repository.getBranch();
            BranchTrackingStatus trackingStatus = BranchTrackingStatus.of((Repository)repository, (String)branchName);
            repository.close();
            if (trackingStatus == null || trackingStatus.getAheadCount() == 0) {
                plugin.getView().showMessage(ResManager.loadKDString((String)"\u63a8\u9001\u5931\u8d25\uff1a\u5185\u5bb9\u6ca1\u6709\u53d8\u5316\uff0c\u65e0\u9700\u63a8\u9001\u3002", (String)"GitOperationUtil_30", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]));
                Boolean bl = Boolean.FALSE;
                return bl;
            }
            Iterable iterable = git.log().setMaxCount(trackingStatus.getAheadCount()).call();
            Iterator iter = iterable.iterator();
            FileRepositoryBuilder builder = new FileRepositoryBuilder();
            while (iter.hasNext()) {
                RevCommit commit = (RevCommit)iter.next();
                String versionCommit = commit.getName();
                builder.setMustExist(true);
                builder.addCeilingDirectory(new File(checkPersonalGitRepository));
                builder.findGitDir(new File(checkPersonalGitRepository));
                Repository repo = builder.build();
                RevWalk walk = new RevWalk(repo);
                RevCommit verCommit = walk.parseCommit((AnyObjectId)repo.resolve(versionCommit));
                List<DiffEntry> diffFix = GitOperationUtil.getChangedFileList(verCommit, repo);
                for (DiffEntry entry : diffFix) {
                    JSONObject fileObj = new JSONObject();
                    String changeType = entry.getChangeType().name();
                    fileObj.put("type", (Object)changeType);
                    String filePath = "DELETE".equals(changeType) ? entry.getOldPath() : entry.getNewPath();
                    fileObj.put("filepath", (Object)filePath);
                    if (fileArray.contains((Object)fileObj)) continue;
                    fileArray.add((Object)fileObj);
                }
                walk.close();
                repo.close();
            }
            GITCodeHostingServiceImpl.revertPersonalRepository(personalGitRepository);
            String tempGirRepository = personalGitRepository + "temp";
            GITCodeHostingServiceImpl.pull(gitUrl, tempGirRepository, gitBranch, gitRootpath, userName, passWord);
        }
        catch (Exception e) {
            if (e.getMessage().contains("not authorized")) {
                plugin.getView().showMessage(ResManager.loadKDString((String)"\u7528\u6237\u540d\u6216\u5bc6\u7801\u4e0d\u6b63\u786e\uff0c\u8bf7\u786e\u8ba4\u540e\u91cd\u8bd5\u3002", (String)"GITLoginPlugin_4", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            } else {
                plugin.getView().showMessage(String.format(ResManager.loadKDString((String)"\u63a8\u9001\u5931\u8d25\uff1a%s", (String)"GitOperationUtil_24", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]), e.getMessage()));
            }
            Boolean bl = Boolean.FALSE;
            return bl;
        }
        finally {
            if (git != null) {
                git.close();
            }
        }
        if (fileArray.isEmpty()) {
            plugin.getView().showMessage(ResManager.loadKDString((String)"\u63a8\u9001\u5931\u8d25\uff1a\u5185\u5bb9\u6ca1\u6709\u53d8\u5316\uff0c\u65e0\u9700\u63a8\u9001\u3002", (String)"GitOperationUtil_30", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]));
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public static void push(String bizAppId, String gitUrl, String gitRepository, String gitBranch, String gitRootpath, String personalGitRepository, String projectURL, String userName, String passWord, String type, AbstractFormPlugin plugin, JSONArray arr) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("bos_devp_gitpush");
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, "gitpushcallback"));
        parameter.setCustomParam(BIZAPPID, (Object)bizAppId);
        parameter.setCustomParam(GITURL, (Object)gitUrl);
        parameter.setCustomParam(GITREPOSITORY, (Object)gitRepository);
        parameter.setCustomParam(GITBRANCH, (Object)gitBranch);
        parameter.setCustomParam(GITROOTPATH, (Object)gitRootpath);
        parameter.setCustomParam(PERSONALGITREPOSITORY, (Object)personalGitRepository);
        parameter.setCustomParam(PROJECTURL, (Object)projectURL);
        parameter.setCustomParam("filearr", (Object)arr.toJSONString());
        parameter.setCustomParam(USERNAME, (Object)userName);
        parameter.setCustomParam(PSD, (Object)passWord);
        plugin.getView().showForm(parameter);
    }

    private static void commit(String bizAppId, String gitUrl, String gitRepository, String gitBranch, String gitRootpath, String personalGitRepository, String projectURL, String userName, String passWord, String id, String type, AbstractFormPlugin plugin) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("bos_devp_gitcommit");
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, "gitcommitcallback"));
        parameter.setCustomParam(GITURL, (Object)gitUrl);
        parameter.setCustomParam(GITREPOSITORY, (Object)gitRepository);
        parameter.setCustomParam(GITBRANCH, (Object)gitBranch);
        parameter.setCustomParam(GITROOTPATH, (Object)gitRootpath);
        parameter.setCustomParam(BIZAPPID, (Object)bizAppId);
        parameter.setCustomParam(PERSONALGITREPOSITORY, (Object)personalGitRepository);
        parameter.setCustomParam(PROJECTURL, (Object)projectURL);
        parameter.setCustomParam(USERNAME, (Object)userName);
        parameter.setCustomParam(PSD, (Object)passWord);
        parameter.setCustomParam(GITOPERATEID, (Object)id);
        parameter.setCustomParam(GITOPERATETYPE, (Object)type);
        if ("app".equals(type)) {
            parameter.setCustomParam("commitParams", (Object)plugin.getPageCache().get("commitParams"));
        } else if (BOTP_ConvertRule.equals(type) || BOTP_WriteBackRule.equals(type) || BOTP_BalanceUpdateRule.equals(type)) {
            parameter.setCustomParam(RULE_IDS, (Object)plugin.getPageCache().get(RULE_IDS));
        }
        plugin.getView().showForm(parameter);
    }

    public static void commitByApp(String bizAppId, String gitUrl, String gitRepository, String gitBranch, String gitRootpath, String sessionId, AbstractFormPlugin plugin, String username, String password) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId(PAGE_APP_GIT_COMMIT);
        parameter.setCaption(ResManager.loadKDString((String)"\u7b7e\u5165Git", (String)"GitOperationUtil_26", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]));
        parameter.setCustomParam("type", (Object)"APP_TYPE");
        parameter.setCustomParam(GITOPERATEKEY, (Object)COMMIT);
        parameter.setCustomParam(GITOPERATETYPE, (Object)"app");
        parameter.setCustomParam("gitmsg", (Object)sessionId);
        parameter.setCustomParam(BIZAPPID, (Object)bizAppId);
        parameter.setCustomParam(GITURL, (Object)gitUrl);
        parameter.setCustomParam(GITREPOSITORY, (Object)gitRepository);
        parameter.setCustomParam(GITBRANCH, (Object)gitBranch);
        parameter.setCustomParam(GITROOTPATH, (Object)gitRootpath);
        parameter.setCustomParam(USERNAME, (Object)username);
        parameter.setCustomParam(PSD, (Object)password);
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)plugin, CALLBACK_APP_GIT_CHECK_IN);
        parameter.setCloseCallBack(callBack);
        plugin.getView().showForm(parameter);
    }

    private static void showGitLoginPage(String operateKey, String id, String type, AbstractFormPlugin plugin, String bizAppId, String bizUnitId) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("bos_devp_gitlogin");
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, "gitlogincallback"));
        parameter.setCustomParam(GITOPERATEKEY, (Object)operateKey);
        parameter.setCustomParam(GITOPERATEID, (Object)id);
        parameter.setCustomParam(GITOPERATETYPE, (Object)type);
        parameter.setCustomParam("gitmsg", (Object)UUID.randomUUID().toString());
        parameter.setCustomParam(BIZAPPID, (Object)bizAppId);
        parameter.setCustomParam(BIZUNITID, (Object)bizUnitId);
        plugin.getView().showForm(parameter);
    }

    public static String getSessionKey(String gitUrl, String sessionId) {
        String userId = RequestContext.get().getUserId();
        return gitUrl + userId + sessionId;
    }

    public static String getSessionByRequestContext() {
        String sessionId = RequestContext.get().getGlobalSessionId();
        return sessionId;
    }

    public static String getSessionKeyByApp(String bizAppId, String bizUnitId, String sessionId) {
        String userId = RequestContext.get().getUserId();
        String r = bizAppId + userId + sessionId;
        if (StringUtils.isNotBlank((CharSequence)bizUnitId)) {
            r = r + bizUnitId;
        }
        return r;
    }

    public static void saveFile(String fileName, String content, String exportPath) {
        block30: {
            String checkGitRepository = AppUtils.checkFilePath((String)(exportPath + File.separator + fileName));
            try {
                String checkExportPath = AppUtils.checkFilePath((String)exportPath);
                File fileAbovePath = new File(checkExportPath);
                if (!fileAbovePath.exists()) {
                    fileAbovePath.mkdirs();
                }
                File jsFile = new File(checkGitRepository);
                boolean isSuccess = false;
                if (jsFile.exists()) {
                    boolean isDelete = jsFile.delete();
                    if (isDelete) {
                        isSuccess = jsFile.createNewFile();
                    }
                } else {
                    isSuccess = jsFile.createNewFile();
                }
                if (!isSuccess) break block30;
                Path path = Paths.get(checkGitRepository, new String[0]);
                try (OutputStream outputStream = Files.newOutputStream(path, new OpenOption[0]);
                     OutputStreamWriter writer = new OutputStreamWriter(outputStream, StandardCharsets.UTF_8);){
                    writer.write(content);
                }
            }
            catch (IOException e) {
                logger.error(String.format("build file error, file: %s, path: %s", fileName, exportPath), (Throwable)e);
                throw new KDBizException(e.getMessage());
            }
        }
    }

    private static List<DiffEntry> getChangedFileList(RevCommit revCommit, Repository repo) {
        List returnDiffs = null;
        try {
            RevCommit previsouCommit = GitOperationUtil.getPrevHash(revCommit, repo);
            if (previsouCommit == null) {
                return Collections.emptyList();
            }
            ObjectId head = revCommit.getTree().getId();
            ObjectId oldHead = previsouCommit.getTree().getId();
            try (ObjectReader reader = repo.newObjectReader();){
                CanonicalTreeParser oldTreeIter = new CanonicalTreeParser();
                oldTreeIter.reset(reader, (AnyObjectId)oldHead);
                CanonicalTreeParser newTreeIter = new CanonicalTreeParser();
                newTreeIter.reset(reader, (AnyObjectId)head);
                try (Git git = new Git(repo);){
                    List diffs;
                    returnDiffs = diffs = git.diff().setNewTree((AbstractTreeIterator)newTreeIter).setOldTree((AbstractTreeIterator)oldTreeIter).call();
                }
                catch (GitAPIException e) {
                    logger.error("getChangedFileList error", (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            logger.error("getChangedFileList error", (Throwable)e);
        }
        return returnDiffs;
    }

    private static RevCommit getPrevHash(RevCommit commit, Repository repo) throws IOException {
        try (RevWalk walk = new RevWalk(repo);){
            walk.markStart(commit);
            int count = 0;
            for (RevCommit rev : walk) {
                if (count == 1) {
                    RevCommit revCommit = rev;
                    return revCommit;
                }
                ++count;
            }
            walk.dispose();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getScriptFile(String localFilePath) {
        InputStream inStream = null;
        try {
            String checkLocalFilePath = AppUtils.checkFilePath((String)localFilePath);
            Path path = Paths.get(checkLocalFilePath, new String[0]);
            inStream = Files.newInputStream(path, new OpenOption[0]);
            byte[] bt = new byte[0x100000];
            int len = inStream.read(bt);
            String content = new String(bt, 0, len);
            DcxmlSerializer serializer = new DcxmlSerializer(DeployScript.getDCBinder());
            serializer.setColloctionIgnorePKValue(true);
            DeployScript deployNew = (DeployScript)serializer.deserializeFromString(content, null);
            List dynamicObjects = deployNew.getScripts();
            DynamicObject dynamicObject = (DynamicObject)dynamicObjects.get(0);
            String string = dynamicObject.getString("context");
            return string;
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        finally {
            try {
                if (inStream != null) {
                    inStream.close();
                }
            }
            catch (Exception e2) {
                logger.error((Throwable)e2);
            }
        }
        return null;
    }

    public static String getPageFile(String filePath) {
        int i;
        int position = 0;
        String[] bufstring = new String[1024];
        String checkFilePath = AppUtils.checkFilePath((String)filePath);
        try (BufferedReader br = new BufferedReader(new FileReader(checkFilePath));){
            String line = null;
            while ((line = br.readLine()) != null) {
                bufstring[position] = line;
                ++position;
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        StringBuilder positionBuilder = new StringBuilder();
        for (i = 0; i < position - 1; ++i) {
            positionBuilder.append(bufstring[i]);
            positionBuilder.append('\n');
        }
        String remoteCon = positionBuilder.toString();
        remoteCon = remoteCon + bufstring[i];
        return remoteCon;
    }

    public static void updateFileToLocal(String type, String id, String content) {
        if (SCRIPT.equalsIgnoreCase(type)) {
            DynamicObject scriptInfo = BusinessDataServiceHelper.loadSingle((Object)id, (String)IDE_PLUGINSCRIPT);
            scriptInfo.set(TXT_SCRIPTCONTEXT_TAG, (Object)content);
            scriptInfo.set("modifier", (Object)Long.valueOf(RequestContext.get().getUserId()));
            scriptInfo.set("modifydate", (Object)Timestamp.valueOf(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date())));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{scriptInfo});
            MetaCacheUtils.removeDistributeCache((String[])new String[]{scriptInfo.getString(CLASSNAME)});
        } else if ("page".equalsIgnoreCase(type)) {
            QFilter qFormId = new QFilter("form", "=", (Object)id);
            DynamicObject pageRelInfo = QueryServiceHelper.queryOne((String)UNIT_REF_FORM_NUMBER, (String)"bizunit,bizapp", (QFilter[])new QFilter[]{qFormId});
            String bizUnitId = pageRelInfo.getString(BIZ_UNIT);
            String bizAppId = pageRelInfo.getString(BIZAPP);
            MetadataDao.deployMetadata((String)content, (String)bizUnitId, (String)bizAppId);
            MetadataDao.rebuildRuntimeMetaById((String)id);
        } else if (BOTP_ConvertRule.endsWith(type)) {
            DcxmlSerializer serializer = new DcxmlSerializer(DeployMetadata.getDCBinder());
            serializer.setColloctionIgnorePKValue(true);
            DeployMetadata deployNew = (DeployMetadata)serializer.deserializeFromString(content, null);
            AbstractDesignMeta designConvertRuleMeta = (AbstractDesignMeta)deployNew.getDesignMetas().get(0);
            designConvertRuleMeta.deployMetadata();
        } else if (BOTP_WriteBackRule.endsWith(type)) {
            DcxmlSerializer serializer = new DcxmlSerializer(DeployMetadata.getDCBinder());
            serializer.setColloctionIgnorePKValue(true);
            DeployMetadata deployNew = (DeployMetadata)serializer.deserializeFromString(content, null);
            AbstractDesignMeta designWriteBackRuleMeta = (AbstractDesignMeta)deployNew.getDesignMetas().get(0);
            designWriteBackRuleMeta.deployMetadata();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void afterPull(String bizAppId, String gitUrl, String personalGitRepository, String gitRepository, String gitBranch, String gitRootpath, String userName, String passWord, AbstractFormPlugin plugin, String id, String type) {
        Git git = null;
        String projectURL = personalGitRepository + File.separator + ".git";
        String checkProjectURL = AppUtils.checkFilePath((String)projectURL);
        try {
            git = Git.open((File)new File(checkProjectURL));
            Status status = git.status().call();
            Set conflictSet = status.getConflicting();
            if (conflictSet.isEmpty()) {
                GitOperationUtil.revert(gitRepository, gitBranch, gitRootpath, personalGitRepository, userName, passWord, id, type, plugin, GITURL);
            } else {
                FormShowParameter parameter = new FormShowParameter();
                parameter.getOpenStyle().setShowType(ShowType.Modal);
                parameter.setFormId("bos_devp_gitresolve");
                parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, "gitpushcallback"));
                parameter.setCustomParam(GITURL, (Object)gitUrl);
                parameter.setCustomParam(GITREPOSITORY, (Object)gitRepository);
                parameter.setCustomParam(GITBRANCH, (Object)gitBranch);
                parameter.setCustomParam(GITROOTPATH, (Object)gitRootpath);
                parameter.setCustomParam(BIZAPPID, (Object)bizAppId);
                parameter.setCustomParam(PERSONALGITREPOSITORY, (Object)personalGitRepository);
                parameter.setCustomParam(PROJECTURL, (Object)projectURL);
                JSONArray arr = new JSONArray();
                arr.addAll((Collection)conflictSet);
                parameter.setCustomParam("filearr", (Object)arr.toJSONString());
                parameter.setCustomParam(USERNAME, (Object)userName);
                parameter.setCustomParam(PSD, (Object)passWord);
                parameter.setCustomParam("id", (Object)id);
                parameter.setCustomParam("type", (Object)type);
                plugin.getView().showForm(parameter);
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        finally {
            if (git != null) {
                git.close();
            }
        }
    }

    public static void delete(String operateKey, String id, String type, AbstractFormPlugin plugin, String sessionId) {
        DynamicObject gitSetting;
        JSONObject result = GitOperationUtil.getBizAppIdAndFileNameByType(type, id);
        String bizAppId = result.getString(BIZAPPID);
        String bizUnitId = result.getString(BIZUNITID);
        String username = plugin.getPageCache().get(USERNAME);
        String password = plugin.getPageCache().get(PSD);
        if (StringUtils.isBlank((CharSequence)username) || StringUtils.isBlank((CharSequence)username)) {
            JSONObject cachedLoginInfo = GitOperationUtil.getCachedLoginInfo(bizAppId, bizUnitId, sessionId);
            if (cachedLoginInfo == null) {
                return;
            }
            username = cachedLoginInfo.getString(USERNAME);
            password = cachedLoginInfo.getString(PSD);
        }
        if ((gitSetting = GitOperationUtil.getGitSetting(bizAppId, bizUnitId, username)) == null) {
            return;
        }
        String gitUrl = gitSetting.getString(GITURL);
        if (StringUtils.isBlank((CharSequence)gitUrl)) {
            return;
        }
        String gitRepository = gitSetting.getString(GITREPOSITORY);
        if (StringUtils.isBlank((CharSequence)gitRepository)) {
            return;
        }
        String gitRootpath = gitSetting.getString(GITROOTPATH);
        try {
            password = Encrypters.decode((String)password);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        String personalGitRepository = GitOperationUtil.getPersonalGitRepository(gitRepository, username);
        String metaGitRepository = GitOperationUtil.getMetadataGitRepository(personalGitRepository, bizAppId, gitRootpath);
        ArrayList<String> fileNames = new ArrayList<String>();
        if (SCRIPT.equals(type)) {
            boolean deleteScriptFlag;
            fileNames.add(result.getString(FILENAME));
            String filePath = metaGitRepository + File.separator + result.getString(FILENAME);
            String checkFilePath = AppUtils.checkFilePath((String)filePath);
            File file = new File(checkFilePath);
            if (file.exists() && !(deleteScriptFlag = file.delete())) {
                logger.warn("delete file error, fileName: {}", (Object)file.getName());
            }
        }
        if ("page".equals(type)) {
            List list = MetadataDao.getFormDeployFile((String)id);
            for (int i = 0; i < list.size(); ++i) {
                boolean deletePageFlag;
                String fileName = ((DeployFile)list.get(i)).getFileName();
                if (GitOperationUtil.isIgnoreFile(fileName)) continue;
                fileNames.add(fileName);
                String filePath = metaGitRepository + File.separator + fileName;
                String checkFilePath = AppUtils.checkFilePath((String)filePath);
                File file = new File(checkFilePath);
                if (!file.exists() || (deletePageFlag = file.delete())) continue;
                logger.warn("delete file:{} error", (Object)file.getName());
            }
        }
        GITCodeHostingServiceImpl.commitAndPush(personalGitRepository, username, password, ResManager.loadKDString((String)"\u5220\u9664\u5143\u6570\u636e\u3002", (String)"ConfirmDelPlugin_4", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), fileNames);
    }

    public static List<DeployFile> filterPageDeployFiles(String pageId) {
        List files = MetadataDao.getFormDeployFile((String)pageId);
        return files.stream().filter(f -> !GitOperationUtil.isIgnoreFile(f.getFileName())).collect(Collectors.toList());
    }

    public static List<DeployFile> filterAppDeployFiles(String appId) {
        List files = AppMetaServiceHelper.getAppDeployFile((String)appId);
        return files.stream().filter(f -> !GitOperationUtil.isIgnoreFile(f.getFileName())).collect(Collectors.toList());
    }

    private static List<DeployFile> filterBotpConvertRuleFiles(List<DeployFile> files) {
        return files.stream().filter(f -> !GitOperationUtil.isIgnoreFile(f.getFileName())).collect(Collectors.toList());
    }

    public static List<String> getBranchs(String gitUrl, String userName, String passWord) throws GitAPIException {
        return GITCodeHostingServiceImpl.getBranchs(gitUrl, userName, passWord);
    }

    public static JSONObject getBizAppIdAndFileNameByType(String type, String id) {
        JSONObject result = new JSONObject();
        String bizAppId = null;
        String fileNumber = null;
        String bizUnitId = null;
        if (SCRIPT.equalsIgnoreCase(type)) {
            DynamicObject scriptObject = BusinessDataServiceHelper.loadSingleFromCache((Object)id, (String)IDE_PLUGINSCRIPT, (String)"txt_scriptnumber,bizappid");
            bizAppId = scriptObject.getString(BIZAPPID);
            fileNumber = scriptObject.getString(TXT_SCRIPT_NUMBER) + SCRIPT_SUFFIX;
        } else if ("page".equalsIgnoreCase(type)) {
            fileNumber = MetadataDao.getNumberById((String)id) + ".dym";
            bizAppId = MetadataDao.getAppIdByFormId((String)id);
            bizUnitId = MetadataDao.getUnitIdFromUnitrel((String)id);
            if (StringUtils.isEmpty((CharSequence)bizAppId)) {
                QFilter qFormId = new QFilter("form", "=", (Object)id);
                DynamicObject pageRelInfo = QueryServiceHelper.queryOne((String)UNIT_REF_FORM_NUMBER, (String)"bizapp,bizunit", (QFilter[])new QFilter[]{qFormId});
                bizAppId = pageRelInfo.getString(BIZAPP);
                bizUnitId = pageRelInfo.getString(BIZ_UNIT);
            }
        } else if ("app".equalsIgnoreCase(type)) {
            bizAppId = id;
            fileNumber = BusinessDataServiceHelper.loadSingle((Object)bizAppId, (String)BIZ_APP_NUMBER, (String)"number").getString("number") + ".app";
        } else if ("cloud".equalsIgnoreCase(type)) {
            DynamicObject cloudObject = BusinessDataServiceHelper.loadSingle((Object)id, (String)"bos_devportal_bizcloud", (String)"baseapp");
            bizAppId = cloudObject.getString("baseapp_id");
        } else if (type.startsWith(BOTP)) {
            bizAppId = id;
        } else if ("dataModel".equals(type)) {
            bizAppId = id;
        }
        result.put(BIZAPPID, (Object)bizAppId);
        result.put(FILENAME, (Object)fileNumber);
        result.put(BIZUNITID, (Object)bizUnitId);
        return result;
    }

    public static List<DeployFile> getBotpDeployFiles(String ruleType, JSONArray ruleIds) {
        ArrayList<DeployFile> result = new ArrayList<DeployFile>();
        for (int i = 0; i < ruleIds.size(); ++i) {
            String ruleId = ruleIds.getString(i);
            List<DeployFile> ruleFiles = GitOperationUtil.getRuleFile(ruleType, ruleId);
            result.addAll(ruleFiles);
        }
        return result;
    }

    public static List<DeployFile> getRuleFile(String ruleType, String ruleId) {
        List list = null;
        if (ruleType.equals(BOTP_ConvertRule)) {
            list = MetadataDao.getConvertRuleDeployFile((String)ruleId);
        } else if (ruleType.equals(BOTP_WriteBackRule)) {
            list = MetadataDao.getWriteBackRuleDeployFile((String)ruleId);
        } else if (ruleType.equals(BOTP_BalanceUpdateRule)) {
            IDataEntityType designMetaType = OrmUtils.getDataEntityType(DesignBalanceRuleMeta.class);
            IDataEntityType designMetaType_Lang = OrmUtils.getDataEntityType(DesignBalanceRuleMetaL.class);
            list = MetadataDao.getCustMetadataDeployFile((String)ruleId, (IDataEntityType)designMetaType, (IDataEntityType)designMetaType_Lang, (String)"bur");
        }
        return list;
    }

    public static JSONObject getCachedLoginInfo(String gitUrl, String sessionId) {
        String sessionKey;
        SessionDAO sessionDao;
        String attribute;
        if (StringUtils.isNotBlank((CharSequence)sessionId) && StringUtils.isNotBlank((CharSequence)(attribute = (sessionDao = SessionDAOFactory.getSessionDAO((String)sessionId)).getAttribute(sessionKey = GitOperationUtil.getSessionKey(gitUrl, sessionId))))) {
            return JSONObject.parseObject((String)attribute);
        }
        return GitOperationUtil.getCachedLoginInfoFromSessionManager();
    }

    public static JSONObject getCachedLoginInfo(String sessionId, String bizAppId, String bizUnitId) {
        String sessionKey;
        SessionDAO sessionDao;
        String attribute;
        if (StringUtils.isNotBlank((CharSequence)sessionId) && StringUtils.isNotBlank((CharSequence)(attribute = (sessionDao = SessionDAOFactory.getSessionDAO((String)sessionId)).getAttribute(sessionKey = GitOperationUtil.getSessionKeyByApp(bizAppId, bizUnitId, sessionId))))) {
            return JSONObject.parseObject((String)attribute);
        }
        return GitOperationUtil.getCachedLoginInfoFromSessionManager();
    }

    public static JSONObject getCachedLoginInfoFromSessionManager() {
        String username = SessionManager.getCurrent().get(GitOperationUtil.getSessionByRequestContext() + GIT_USERNAME);
        String password = SessionManager.getCurrent().get(GitOperationUtil.getSessionByRequestContext() + GIT_PASSWORD);
        JSONObject r = new JSONObject();
        r.put(USERNAME, (Object)username);
        r.put(PSD, (Object)password);
        return r;
    }

    public static DynamicObject getGitSetting(String bizAppId, String bizUnitId, String gitUserName) {
        QFilter userFilter;
        QFilter appidFilter = new QFilter(BIZAPPID, "=", (Object)bizAppId);
        Object[] filters = new QFilter[]{appidFilter};
        if (!StringUtils.isBlank((CharSequence)gitUserName) && DevportalCommonUtil.isGitMultiParallel()) {
            userFilter = new QFilter(GIT_USERNAME, "=", (Object)gitUserName);
            filters = (QFilter[])ArrayUtils.add((Object[])filters, (Object)userFilter);
        } else {
            userFilter = new QFilter(GIT_USERNAME, "=", (Object)Character.valueOf(' '));
            filters = (QFilter[])ArrayUtils.add((Object[])filters, (Object)userFilter);
        }
        String selectFields = "id,giturl,gitrepository,gitbranch,gitrootpath,bizunitid,managetype,gitusername";
        DynamicObject[] settings = BusinessDataServiceHelper.load((String)"svnmanage", (String)selectFields, (QFilter[])filters);
        if (settings == null || settings.length == 0) {
            return null;
        }
        DynamicObject setting = null;
        for (DynamicObject dynamicObject : settings) {
            String unitId = dynamicObject.getString(BIZUNITID);
            if (!StringUtils.isBlank((CharSequence)bizUnitId)) {
                if (!bizUnitId.equalsIgnoreCase(unitId)) continue;
                setting = dynamicObject;
                break;
            }
            if (!StringUtils.isBlank((CharSequence)unitId)) continue;
            setting = dynamicObject;
            break;
        }
        if (setting == null) {
            setting = settings[0];
        }
        return setting;
    }

    public static boolean isIgnoreFile(String fileName) {
        if (fileName.endsWith(".dymx") && !fileName.endsWith(".zh_CN.dymx")) {
            return true;
        }
        if (fileName.endsWith(".appx") && !fileName.endsWith(".zh_CN.appx")) {
            return true;
        }
        if (fileName.endsWith(".cldx") && !fileName.endsWith(".zh_CN.cldx")) {
            return true;
        }
        if (fileName.endsWith(".crx") && !fileName.endsWith(".zh_CN.crx")) {
            return true;
        }
        if (fileName.endsWith(".wbx") && !fileName.endsWith(".zh_CN.wbx")) {
            return true;
        }
        return fileName.endsWith(".burx") && !fileName.endsWith(".zh_CN.burx");
    }

    private static synchronized void disableSSL(Git git) throws IOException {
        if (git == null || git.getRepository() == null) {
            return;
        }
        StoredConfig config = git.getRepository().getConfig();
        config.setBoolean("http", null, "sslVerify", false);
        config.save();
    }
}

