/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.business.hosting;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.BufferedOutputStream;
import java.io.File;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.devportal.business.hosting.CodeHostingService;
import kd.bos.devportal.business.hosting.ResultMessage;
import kd.bos.devportal.common.hosting.SVNCommonUtil;
import kd.bos.devportal.common.util.AppUtils;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import org.tmatesoft.svn.core.ISVNLogEntryHandler;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNOptions;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.SVNCopyClient;
import org.tmatesoft.svn.core.wc.SVNCopySource;
import org.tmatesoft.svn.core.wc.SVNDiffClient;
import org.tmatesoft.svn.core.wc.SVNInfo;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNStatus;
import org.tmatesoft.svn.core.wc.SVNWCClient;
import org.tmatesoft.svn.core.wc.SVNWCUtil;

public class SVNCodeHostingServiceImpl
implements CodeHostingService {
    public static final String PAGETYPE = "PAGE_TYPE";
    public static final String SCRIPTTYPE = "SCRIPT_TYPE";
    public static final String CARDTYPE = "CARD_TYPE";
    public static final String APPTYPE = "APP_TYPE";
    private static final String SUCCESS = "success";
    private static final String FAILED = "failed";
    private static final String COMMITINFO = "commitInfo";
    private static final String NUMBER = "number";

    public Map<String, Object> getStatus(String url, File localPath, String userName, String passWord) {
        SVNClientManager clientManager = SVNCommonUtil.authSvn((String)url, (String)userName, (String)passWord);
        SVNStatus svnStatus = SVNCommonUtil.showStatus((SVNClientManager)clientManager, (File)localPath, (boolean)false);
        String svnStatusType = svnStatus.getContentsStatus().toString();
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        if ("modified".equals(svnStatusType) || "none".equals(svnStatusType)) {
            retMap.put(ResultMessage.STATUS.toString(), 0);
            retMap.put(ResultMessage.RESULT.toString(), svnStatusType);
            retMap.put(ResultMessage.MESSAGE.toString(), SUCCESS);
        }
        return retMap;
    }

    public Map<String, Object> checkoutAppMetadata(File localPath, String originSvnUrl, File[] files, String username, String password) {
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        long retValue = 0L;
        try {
            SVNClientManager clientManager = SVNCommonUtil.authSvn((String)originSvnUrl, (String)username, (String)password);
            SVNRevision revision = SVNRevision.HEAD;
            boolean allowUnversionedObstructions = true;
            SVNURL srcURL = SVNURL.parseURIEncoded((String)originSvnUrl);
            if (files == null) {
                retValue = SVNCommonUtil.checkout((SVNClientManager)clientManager, (SVNURL)srcURL, (SVNRevision)revision, (File)localPath, (SVNDepth)SVNDepth.INFINITY, (boolean)false);
            } else {
                retValue = SVNCommonUtil.checkout((SVNClientManager)clientManager, (SVNURL)srcURL, (SVNRevision)revision, (File)localPath, (SVNDepth)SVNDepth.EMPTY, (boolean)false);
                SVNCommonUtil.update((SVNClientManager)clientManager, (File[])files, (SVNRevision)revision, (SVNDepth)SVNDepth.EMPTY, (boolean)allowUnversionedObstructions);
            }
            retMap.put(ResultMessage.STATUS.toString(), 0);
            retMap.put(ResultMessage.MESSAGE.toString(), SUCCESS);
            HashMap<String, Long> resultMap = new HashMap<String, Long>();
            resultMap.put("checkVal", retValue);
            retMap.put(ResultMessage.RESULT.toString(), resultMap);
        }
        catch (SVNException e) {
            retMap.put(ResultMessage.STATUS.toString(), 1);
            retMap.put(ResultMessage.MESSAGE.toString(), FAILED);
        }
        return retMap;
    }

    public Map<String, Object> commitAppMetadata(File localPath, String dstSvnUrl, String username, String password, String commitMessage) {
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        SVNClientManager clientManager = SVNCommonUtil.authSvn((String)dstSvnUrl, (String)username, (String)password);
        boolean flag = SVNCommonUtil.isWorkingCopy((File)localPath);
        if (flag) {
            boolean keepLocks = true;
            SVNCommonUtil.addEntry((SVNClientManager)clientManager, (File)localPath);
            SVNCommitInfo commitInfo = SVNCommonUtil.commit((SVNClientManager)clientManager, (File)localPath, (boolean)keepLocks, (String)commitMessage);
            retMap.put(ResultMessage.STATUS.toString(), 0);
            retMap.put(ResultMessage.MESSAGE.toString(), SUCCESS);
            resultMap.put(COMMITINFO, commitInfo);
            resultMap.put("clientmanager", clientManager);
            retMap.put(ResultMessage.RESULT.toString(), resultMap);
        } else {
            retMap.put(ResultMessage.STATUS.toString(), 1);
            retMap.put(ResultMessage.MESSAGE.toString(), "faild");
        }
        return retMap;
    }

    public Map<String, Object> commitSelectedMetadata(File[] files, String svnUrl, String username, String password, String commitMessage) throws SVNException {
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        SVNClientManager clientManager = SVNCommonUtil.authSvn((String)svnUrl, (String)username, (String)password);
        SVNCommitInfo commitInfo = SVNCommonUtil.commitSelectedMetadata((SVNClientManager)clientManager, (File[])files, (String)commitMessage);
        retMap.put(ResultMessage.STATUS.toString(), 0);
        retMap.put(ResultMessage.MESSAGE.toString(), SUCCESS);
        return retMap;
    }

    public Map<String, Object> getSvnFileDir(String url, String userName, String passWord) {
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        HashMap<String, List> resultMap = new HashMap<String, List>();
        List listInfo = null;
        try {
            SVNURL srcUrl = SVNURL.parseURIEncoded((String)url);
            listInfo = SVNCommonUtil.listSvnFile((SVNURL)srcUrl, (String)userName, (String)passWord);
            retMap.put(ResultMessage.STATUS.toString(), 0);
            retMap.put(ResultMessage.MESSAGE.toString(), SUCCESS);
            resultMap.put("svnfileinfos", listInfo);
            retMap.put(ResultMessage.RESULT.toString(), resultMap);
        }
        catch (SVNException e) {
            retMap.put(ResultMessage.STATUS.toString(), 1);
            retMap.put(ResultMessage.MESSAGE.toString(), FAILED);
        }
        return retMap;
    }

    public Map<String, Object> doFiff(String svnPath, String filePath, String userName, String passWord, BufferedOutputStream result) {
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        SVNClientManager clientManager = SVNCommonUtil.authSvn((String)svnPath, (String)userName, (String)passWord);
        DefaultSVNOptions options = SVNWCUtil.createDefaultOptions((boolean)true);
        String checkFilePath = AppUtils.checkFilePath((String)filePath);
        File compFile = new File(checkFilePath);
        SVNDiffClient diff = clientManager.getDiffClient();
        SVNCommonUtil.doDiff((SVNClientManager)clientManager, (File)compFile, (BufferedOutputStream)result);
        retMap.put(ResultMessage.STATUS.toString(), 0);
        retMap.put(ResultMessage.MESSAGE.toString(), SUCCESS);
        return retMap;
    }

    public Map<String, Object> doLog(String svnPath, String url, String[] paths, String userName, String passWord) {
        final JSONArray jsonArray = new JSONArray();
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        SVNClientManager clientManager = SVNCommonUtil.authSvn((String)svnPath, (String)userName, (String)passWord);
        ISVNLogEntryHandler handler = new ISVNLogEntryHandler(){

            public void handleLogEntry(SVNLogEntry logEntry) {
                JSONObject jsonObject = new JSONObject();
                long version = logEntry.getRevision();
                String author = logEntry.getAuthor();
                Date date = logEntry.getDate();
                String message = logEntry.getMessage();
                jsonObject.put("version", (Object)version);
                jsonObject.put("author", (Object)author);
                jsonObject.put("date", (Object)date);
                jsonObject.put("message", (Object)message);
                jsonArray.add((Object)jsonObject);
            }
        };
        long log = SVNCommonUtil.doLog((SVNClientManager)clientManager, (String)userName, (String)passWord, (String)url, (String[])paths, (ISVNLogEntryHandler)handler);
        retMap.put(ResultMessage.MESSAGE.toString(), SUCCESS);
        retMap.put(ResultMessage.STATUS.toString(), 0);
        resultMap.put("doLogVal", log);
        resultMap.put("doLogMsg", jsonArray.toJSONString());
        retMap.put(ResultMessage.RESULT.toString(), resultMap);
        return retMap;
    }

    private Map<String, Object> doInfo(String svnPath, String userName, String passWord, File file) {
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        HashMap<String, SVNInfo> resultMap = new HashMap<String, SVNInfo>();
        SVNClientManager clientManager = SVNCommonUtil.authSvn((String)svnPath, (String)userName, (String)passWord);
        SVNInfo svnInfo = SVNCommonUtil.doInfo((SVNClientManager)clientManager, (File)file);
        retMap.put(ResultMessage.STATUS.toString(), 0);
        retMap.put(ResultMessage.MESSAGE.toString(), SUCCESS);
        resultMap.put("svnInfo", svnInfo);
        retMap.put(ResultMessage.RESULT.toString(), resultMap);
        return retMap;
    }

    private Map<String, Object> doInfo(String svnPath, String userName, String passWord) throws SVNException {
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        HashMap<String, SVNInfo> resultMap = new HashMap<String, SVNInfo>();
        SVNClientManager clientManager = SVNCommonUtil.authSvn((String)svnPath, (String)userName, (String)passWord);
        SVNURL svnUrl = SVNURL.parseURIEncoded((String)svnPath);
        SVNInfo svnInfo = SVNCommonUtil.doInfo((SVNClientManager)clientManager, (SVNURL)svnUrl);
        retMap.put(ResultMessage.STATUS.toString(), 0);
        retMap.put(ResultMessage.MESSAGE.toString(), SUCCESS);
        resultMap.put("svnInfo", svnInfo);
        retMap.put(ResultMessage.RESULT.toString(), resultMap);
        return retMap;
    }

    public Map<String, Object> moveModel(String modelName, String src, String dir, String svnPath, String userName, String passWord) {
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        HashMap<String, SVNCommitInfo> resultMap = new HashMap<String, SVNCommitInfo>();
        try {
            SVNClientManager clientManager = SVNCommonUtil.authSvn((String)svnPath, (String)userName, (String)passWord);
            SVNCopyClient copyClient = clientManager.getCopyClient();
            copyClient.setIgnoreExternals(false);
            SVNURL srcUrl = SVNURL.parseURIEncoded((String)(src + "/" + modelName));
            SVNURL dirUrl = SVNURL.parseURIEncoded((String)(dir + "/" + modelName));
            SVNCopySource[] copySources = new SVNCopySource[]{new SVNCopySource(SVNRevision.HEAD, SVNRevision.HEAD, srcUrl)};
            SVNCommitInfo commitInfo = SVNCommonUtil.doMove((SVNClientManager)clientManager, (SVNCopySource[])copySources, (SVNURL)dirUrl);
            retMap.put(ResultMessage.STATUS.toString(), 0);
            retMap.put(ResultMessage.MESSAGE.toString(), SUCCESS);
            resultMap.put(COMMITINFO, commitInfo);
            retMap.put(ResultMessage.RESULT.toString(), resultMap);
        }
        catch (SVNException e) {
            retMap.put(ResultMessage.STATUS.toString(), 1);
            retMap.put(ResultMessage.MESSAGE.toString(), FAILED);
        }
        return retMap;
    }

    public Map<String, Object> cleanUp(File workingCopy, String svnPath, String userName, String passWord) {
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        SVNClientManager clientManager = SVNCommonUtil.authSvn((String)svnPath, (String)userName, (String)passWord);
        SVNWCClient client = clientManager.getWCClient();
        retMap.put(ResultMessage.STATUS.toString(), 0);
        retMap.put(ResultMessage.MESSAGE.toString(), SUCCESS);
        return retMap;
    }

    public Map<String, Object> revert(String svnPath, String userName, String passWord, File ... workingCopy) {
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        SVNClientManager clientManager = SVNCommonUtil.authSvn((String)svnPath, (String)userName, (String)passWord);
        SVNCommonUtil.revert((SVNClientManager)clientManager, (File[])workingCopy);
        retMap.put(ResultMessage.STATUS.toString(), 0);
        retMap.put(ResultMessage.MESSAGE.toString(), SUCCESS);
        return retMap;
    }

    public Map<String, Object> deleteSVN(String svnPath, String userName, String passWord, List<String> formUrls, String deleteMessage) {
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        HashMap<String, SVNCommitInfo> resultMap = new HashMap<String, SVNCommitInfo>();
        SVNClientManager clientManager = SVNCommonUtil.authSvn((String)svnPath, (String)userName, (String)passWord);
        SVNURL[] deleteUrls = new SVNURL[formUrls.size()];
        try {
            for (int i = 0; i < formUrls.size(); ++i) {
                String deleteUrl = formUrls.get(i);
                deleteUrls[i] = SVNURL.parseURIEncoded((String)deleteUrl);
            }
            SVNCommitInfo commitInfo = SVNCommonUtil.deleteSVN((SVNClientManager)clientManager, (SVNURL[])deleteUrls, (String)deleteMessage);
            retMap.put(ResultMessage.STATUS.toString(), 0);
            retMap.put(ResultMessage.MESSAGE.toString(), SUCCESS);
            resultMap.put(COMMITINFO, commitInfo);
            retMap.put(ResultMessage.RESULT.toString(), resultMap);
        }
        catch (SVNException e) {
            retMap.put(ResultMessage.STATUS.toString(), 1);
            retMap.put(ResultMessage.MESSAGE.toString(), FAILED);
        }
        return retMap;
    }

    public Map<String, Object> deleteWK(String svnPath, String userName, String passWord, File workingCopy, boolean deleteFiles) {
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        SVNClientManager clientManager = SVNCommonUtil.authSvn((String)svnPath, (String)userName, (String)passWord);
        SVNCommonUtil.deleteWK((SVNClientManager)clientManager, (File)workingCopy, (boolean)deleteFiles);
        retMap.put(ResultMessage.STATUS.toString(), 0);
        retMap.put(ResultMessage.MESSAGE.toString(), SUCCESS);
        return retMap;
    }

    public Map<String, Object> lockWk(String svnPath, String userName, String passWord, String lockMessage, File ... workingCopy) {
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        SVNClientManager clientManager = SVNCommonUtil.authSvn((String)svnPath, (String)userName, (String)passWord);
        SVNCommonUtil.lockWk((SVNClientManager)clientManager, (String)lockMessage, (File[])workingCopy);
        retMap.put(ResultMessage.STATUS.toString(), 0);
        retMap.put(ResultMessage.MESSAGE.toString(), SUCCESS);
        return retMap;
    }

    public Map<String, Object> lockSvn(String svnPath, String userName, String passWord, String lockMessage, List<String> formUrls) {
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        SVNClientManager clientManager = SVNCommonUtil.authSvn((String)svnPath, (String)userName, (String)passWord);
        SVNURL[] deleteUrls = new SVNURL[formUrls.size()];
        try {
            for (int i = 0; i < formUrls.size(); ++i) {
                String deleteUrl = formUrls.get(i);
                deleteUrls[i] = SVNURL.parseURIEncoded((String)deleteUrl);
            }
            SVNCommonUtil.lockSvn((SVNClientManager)clientManager, (SVNURL[])deleteUrls, (boolean)true, (String)lockMessage);
            retMap.put(ResultMessage.STATUS.toString(), 0);
            retMap.put(ResultMessage.MESSAGE.toString(), SUCCESS);
        }
        catch (SVNException ex) {
            retMap.put(ResultMessage.STATUS.toString(), 1);
            retMap.put(ResultMessage.MESSAGE.toString(), FAILED);
        }
        return retMap;
    }

    public Map<String, Object> unlock(String svnPath, String userName, String passWord, File ... workingCopy) {
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        SVNClientManager clientManager = SVNCommonUtil.authSvn((String)svnPath, (String)userName, (String)passWord);
        SVNCommonUtil.doUnLock((SVNClientManager)clientManager, (File[])workingCopy);
        retMap.put(ResultMessage.STATUS.toString(), 0);
        retMap.put(ResultMessage.MESSAGE.toString(), SUCCESS);
        return retMap;
    }

    public Map<String, Object> createApp(String tenantSvnRootUrl, String path, String username, String password, String appNumber) {
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        try {
            SVNClientManager clientManager = SVNCommonUtil.authSvn((String)tenantSvnRootUrl, (String)username, (String)password);
            String checkPath = AppUtils.checkFilePath((String)path);
            SVNURL appSvnRootUrl = clientManager.getAdminClient().doCreateRepository(new File(checkPath), appNumber, false, false);
            retMap.put(ResultMessage.STATUS.toString(), 0);
            retMap.put(ResultMessage.MESSAGE.toString(), SUCCESS);
            HashMap<String, SVNURL> resultMap = new HashMap<String, SVNURL>();
            resultMap.put("appSvnRootUrl", appSvnRootUrl);
            retMap.put(ResultMessage.RESULT.toString(), resultMap);
        }
        catch (SVNException e) {
            retMap.put(ResultMessage.STATUS.toString(), 1);
            retMap.put(ResultMessage.MESSAGE.toString(), FAILED);
        }
        return retMap;
    }

    public Map<String, Object> importAppMetadata(File localPath, String dstSvnUrl, String username, String password, String commitMessage, boolean isRecursive) {
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        try {
            SVNClientManager clientManager = SVNCommonUtil.authSvn((String)dstSvnUrl, (String)username, (String)password);
            SVNURL dstURL = SVNURL.parseURIEncoded((String)dstSvnUrl);
            SVNCommitInfo commitInfo = SVNCommonUtil.importDirectory((SVNClientManager)clientManager, (File)localPath, (SVNURL)dstURL, (String)commitMessage, (boolean)isRecursive);
            retMap.put(ResultMessage.STATUS.toString(), 0);
            retMap.put(ResultMessage.MESSAGE.toString(), SUCCESS);
            HashMap<String, SVNCommitInfo> resultMap = new HashMap<String, SVNCommitInfo>();
            resultMap.put(COMMITINFO, commitInfo);
            retMap.put(ResultMessage.RESULT.toString(), resultMap);
        }
        catch (SVNException e) {
            retMap.put(ResultMessage.STATUS.toString(), 1);
            retMap.put(ResultMessage.MESSAGE.toString(), FAILED);
        }
        return retMap;
    }

    public Map<String, Object> importAppMetadata(String username, String password, String appNumber, String commitMessage, boolean isRecursive, File localPath) {
        String rootPath = "http://192.168.16.99/svn/kingdee_bos/branches/kd_bos_dev_20170724/datamodel/bos/0.3/main";
        String dstSvnUrl = rootPath + "/" + appNumber;
        return this.importAppMetadata(localPath, dstSvnUrl, username, password, commitMessage, isRecursive);
    }

    public Map<String, Object> exportAppMetadata(File localPath, String[] filenames, String originSvnUrl, String username, String password) {
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        try {
            SVNClientManager clientManager = SVNCommonUtil.authSvn((String)originSvnUrl, (String)username, (String)password);
            SVNRevision pegRevision = SVNRevision.HEAD;
            SVNRevision revision = SVNRevision.HEAD;
            String eolStyle = "eolStyle";
            SVNDepth depth = SVNDepth.INFINITY;
            SVNDepth emptyDepth = SVNDepth.EMPTY;
            boolean overwrite = true;
            long retValue = 0L;
            if (filenames != null && filenames.length > 0) {
                for (String filename : filenames) {
                    SVNURL oriUrl = SVNURL.parseURIEncoded((String)(originSvnUrl + "/" + filename));
                    retValue = clientManager.getUpdateClient().doExport(oriUrl, localPath, pegRevision, revision, eolStyle, overwrite, depth);
                }
            } else {
                SVNURL oriUrl = SVNURL.parseURIEncoded((String)originSvnUrl);
                retValue = clientManager.getUpdateClient().doExport(oriUrl, localPath, pegRevision, revision, eolStyle, overwrite, emptyDepth);
            }
            retMap.put(ResultMessage.STATUS.toString(), 0);
            retMap.put(ResultMessage.MESSAGE.toString(), SUCCESS);
            HashMap<String, Long> resultMap = new HashMap<String, Long>();
            resultMap.put("exportVal", retValue);
            retMap.put(ResultMessage.RESULT.toString(), resultMap);
        }
        catch (SVNException e) {
            retMap.put(ResultMessage.STATUS.toString(), 1);
            retMap.put(ResultMessage.MESSAGE.toString(), FAILED);
        }
        return retMap;
    }

    public Map<String, Object> checkSvnPath(String svnPath, String userName, String passWord) {
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        try {
            SVNURL url = SVNURL.parseURIEncoded((String)svnPath);
            boolean flag = SVNCommonUtil.isURLExist((SVNURL)url, (String)userName, (String)passWord);
            if (flag) {
                retMap.put(ResultMessage.STATUS.toString(), 0);
                retMap.put(ResultMessage.MESSAGE.toString(), SUCCESS);
                HashMap<String, Boolean> resultMap = new HashMap<String, Boolean>();
                resultMap.put(COMMITINFO, flag);
                retMap.put(ResultMessage.RESULT.toString(), resultMap);
            } else {
                retMap.put(ResultMessage.STATUS.toString(), 1);
                retMap.put(ResultMessage.MESSAGE.toString(), FAILED);
            }
        }
        catch (SVNException e) {
            retMap.put(ResultMessage.STATUS.toString(), 1);
            retMap.put(ResultMessage.MESSAGE.toString(), FAILED);
        }
        return retMap;
    }

    public String getLockUser(String sourceId, String sourceType, String svnPath, String userName, String passWord) {
        String svnFilePath = null;
        if (PAGETYPE.equals(sourceType)) {
            String formNumber = BusinessDataServiceHelper.loadSingleFromCache((Object)sourceId, (String)"bos_formmeta", (String)NUMBER).getString(NUMBER);
            svnFilePath = String.format("%s/metadata/%s.dym", svnPath, formNumber);
        } else if (SCRIPTTYPE.equals(sourceType)) {
            String scriptNumber = BusinessDataServiceHelper.loadSingleFromCache((Object)sourceId, (String)"ide_pluginscript", (String)"txt_scriptnumber").getString("txt_scriptnumber");
            svnFilePath = String.format("%s/metadata/%s.ks", svnPath, scriptNumber);
        } else if (APPTYPE.equals(sourceType)) {
            String cardNumber = BusinessDataServiceHelper.loadSingleFromCache((Object)sourceId, (String)"bos_devportal_bizapp", (String)NUMBER).getString(NUMBER);
            svnFilePath = String.format("%s/metadata/%s.app", svnPath, cardNumber);
        } else {
            return "";
        }
        Map<String, Object> appMetaMsg = this.checkSvnPath(svnFilePath, userName, passWord);
        String message = (String)appMetaMsg.get("message");
        if (!SUCCESS.equals(message)) {
            return "";
        }
        SVNClientManager clientManager = SVNCommonUtil.authSvn((String)svnFilePath, (String)userName, (String)passWord);
        SVNURL svnurl = null;
        try {
            svnurl = SVNURL.parseURIEncoded((String)svnFilePath);
        }
        catch (SVNException e) {
            throw new KDBizException(e.getMessage());
        }
        String lockUser = null;
        SVNInfo doInfo = SVNCommonUtil.doInfo((SVNClientManager)clientManager, (SVNURL)svnurl);
        if (doInfo != null && doInfo.getLock() != null) {
            lockUser = doInfo.getLock().getOwner();
        }
        return lockUser;
    }
}

