/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.business.hosting;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcxmlSerializer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.devportal.business.util.ScriptOperationUtil;
import kd.bos.devportal.common.hosting.SVNCommonUtil;
import kd.bos.devportal.common.hosting.SVNUtil;
import kd.bos.devportal.common.util.AppUtils;
import kd.bos.encrypt.Encrypters;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCacheUtils;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.deploy.DeployFile;
import kd.bos.metadata.deploy.DeployScript;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.session.SessionDAO;
import kd.bos.session.SessionDAOFactory;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.SVNInfo;

public class SvnOperationUtil {
    private static final Log logger = LogFactory.getLog(SvnOperationUtil.class);
    private static final String SCRIPT = "script";
    private static final String BOS_DEVPORTAL_BUSINESS = "bos-devportal-business";
    private static final String SVN_REVERT = "svnrevert";
    private static final String SVN_DELETE = "svndelete";
    private static final String SVN_LOCK = "svnlock";
    private static final String SVN_UNLOCK = "svnunlock";
    private static final String SVNCLEAN = "svnclean";
    private static final String BIZAPPID = "bizappid";
    private static final String USERNAME = "username";
    private static final String P = "password";
    private static final String NOFILE = "nofile";
    private static final String FILENAME = "filename";
    private static final String SVNPATH = "svnpath";
    private static String metadata = "%s/metadata/%s";
    private static final String BOS_DEVPORTAL_BIZAPP = "bos_devportal_bizapp";
    private static final String MASTERID = "masterid";
    private static final String BIZAPP = "bizapp";
    private static final String BOS_FORMMETA = "bos_formmeta";
    private static final String DATEFM = "yyyy-MM-dd HH:mm:ss";
    private static final String OUTPUT = "output";
    private static final String CONSOLE_KDEMARK = "CONSOLE_KDEMARK";
    private static final String IDE_PLUGINSCRIPT = "ide_pluginscript";
    private static final String TXT_SCRIPTNUMBER = "txt_scriptnumber";
    private static final String AUTHENTICATIONREQUIRED = "Authentication required";
    private static final String FORBIDDEN = "403 Forbidden";
    private static final String SVNOPERATIONUTIL_40 = "SvnOperationUtil_40";
    private static final String ERROR = "error";

    public static void svnConfirmOperate(String id, String type, String operateKey, String sessionId, AbstractFormPlugin plugin) {
        JSONObject svnInfo = new JSONObject();
        svnInfo.put("svnoperateid", (Object)id);
        svnInfo.put("svnoperatetype", (Object)type);
        svnInfo.put("svnoperatekey", (Object)operateKey);
        svnInfo.put("svnoperatesessionid", (Object)sessionId);
        plugin.getPageCache().put("svninfo", svnInfo.toJSONString());
        String resourceMsg = null;
        if (SCRIPT.equalsIgnoreCase(type)) {
            resourceMsg = ResManager.loadKDString((String)"\u811a\u672c", (String)"SvnOperationUtil_0", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]);
        } else if ("page".equalsIgnoreCase(type)) {
            resourceMsg = ResManager.loadKDString((String)"\u9875\u9762", (String)"SvnOperationUtil_1", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]);
        }
        String showMsg = null;
        if (SVN_REVERT.equals(operateKey)) {
            showMsg = String.format(ResManager.loadKDString((String)"\u786e\u5b9a\u8981\u5c06%s\u6062\u590d\u5230svn\u6700\u65b0\u7248\u672c\u5417?", (String)"SvnOperationUtil_2", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]), resourceMsg);
        } else if (SVN_DELETE.equals(operateKey)) {
            showMsg = String.format(ResManager.loadKDString((String)"\u786e\u5b9a\u8981\u5220\u9664svn\u4e0a\u7684%s\u6587\u4ef6\u5417?", (String)"SvnOperationUtil_4", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]), resourceMsg);
        } else if (SVN_LOCK.equals(operateKey)) {
            showMsg = String.format(ResManager.loadKDString((String)"\u662f\u5426\u786e\u8ba4\u9501\u5b9a\u8fd9\u4e2a%s?", (String)"SvnOperationUtil_6", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]), resourceMsg);
        } else if (SVN_UNLOCK.equals(operateKey)) {
            showMsg = String.format(ResManager.loadKDString((String)"\u662f\u5426\u786e\u8ba4\u89e3\u9501\u8fd9\u4e2a%s?", (String)"SvnOperationUtil_8", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]), resourceMsg);
        } else if (SVNCLEAN.equals(operateKey)) {
            showMsg = ResManager.loadKDString((String)"\u786e\u5b9a\u8981\u6e05\u7406svn\u5de5\u4f5c\u533a\u95f4\u5417?", (String)"SvnOperationUtil_9", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]);
        }
        plugin.getView().showConfirm(showMsg, MessageBoxOptions.YesNo, new ConfirmCallBackListener("svnOperateCallBack"));
    }

    public static void beforeSvnOperate(String key, String id, String type, String sessionId, boolean isNeedSaveSvnMsg, AbstractFormPlugin plugin) {
        boolean hasUserInfo;
        JSONObject result = SvnOperationUtil.getBizAppIdAndFileNameByType(type, id);
        String bizAppId = result.getString(BIZAPPID);
        String svnPath = null;
        svnPath = StringUtils.equals((CharSequence)"app", (CharSequence)type) ? AppUtils.getSVNPathByAppId((String)bizAppId) : AppUtils.getSVNPathByAppId((String)bizAppId, (String)id);
        if (svnPath == null) {
            plugin.getView().showMessage(ResManager.loadKDString((String)"svn\u8def\u5f84\u4e3a\u7a7a\uff0c\u8bf7\u5148\u5230\u5f00\u53d1\u5e73\u53f0\u914d\u7f6esvn\u8def\u5f84\u3002", (String)"SvnOperationUtil_10", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]));
            return;
        }
        String userName = plugin.getPageCache().get(USERNAME);
        String passWord = plugin.getPageCache().get(P);
        boolean bl = hasUserInfo = StringUtils.isNotBlank((CharSequence)userName) && StringUtils.isNotBlank((CharSequence)passWord);
        if (!hasUserInfo && (StringUtils.isBlank((CharSequence)sessionId) || "undefined".equals(sessionId))) {
            SvnOperationUtil.showSvnLoginPage(key, id, type, plugin, bizAppId, sessionId);
            return;
        }
        if (!hasUserInfo) {
            String sessionKey = AppUtils.getSessionKey((String)svnPath, (String)sessionId);
            SessionDAO sessionDao = SessionDAOFactory.getSessionDAO((String)sessionId);
            String userInfoString = sessionDao.getAttribute(sessionKey);
            if (userInfoString == null) {
                SvnOperationUtil.showSvnLoginPage(key, id, type, plugin, bizAppId, sessionId);
                return;
            }
            JSONObject userInfo = JSONObject.parseObject((String)userInfoString);
            userName = userInfo.getString(USERNAME);
            passWord = userInfo.getString(P);
        }
        boolean bl2 = hasUserInfo = StringUtils.isNotBlank((CharSequence)userName) && StringUtils.isNotBlank((CharSequence)passWord);
        if (!hasUserInfo) {
            SvnOperationUtil.showSvnLoginPage(key, id, type, plugin, bizAppId, sessionId);
            return;
        }
        String lockUser = SvnOperationUtil.getSVNLockUser(id, type, userName, passWord);
        if (lockUser != null) {
            if ("error_username".equals(lockUser)) {
                SvnOperationUtil.showSvnLoginPage(key, id, type, plugin, bizAppId, sessionId);
                return;
            }
            String showMessage = SvnOperationUtil.getOperateMsgByKey(key);
            if (NOFILE.equals(lockUser) && !"svndiff".equals(key) && !"checkin".equals(key)) {
                plugin.getView().showMessage(String.format(ResManager.loadKDString((String)"SVN\u4e0a\u6ca1\u6709\u8d44\u6e90\uff0c\u65e0\u6cd5%s\u3002", (String)"SvnOperationUtil_11", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]), showMessage));
                return;
            }
            if (!NOFILE.equals(lockUser)) {
                if (SVN_LOCK.equals(key) && lockUser.equals(userName)) {
                    plugin.getView().showMessage(ResManager.loadKDString((String)"\u8d44\u6e90\u5df2\u7ecf\u9501\u5b9a\uff0c\u65e0\u9700\u518d\u6b21\u9501\u5b9a\u3002", (String)"SvnOperationUtil_12", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]));
                    return;
                }
                if (SVN_DELETE.equals(key) || SVN_LOCK.equals(key)) {
                    plugin.getView().showMessage(String.format(ResManager.loadKDString((String)"\u8d44\u6e90\u5df2\u88ab%1$s\u9501\u5b9a\uff0c\u65e0\u6cd5%2$s\uff0c\u8bf7\u4f18\u5148\u89e3\u9501\u3002", (String)"SvnOperationUtil_13", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]), lockUser, showMessage));
                    return;
                }
                if (SVN_UNLOCK.equals(key) && !lockUser.equals(userName)) {
                    plugin.getView().showMessage(String.format(ResManager.loadKDString((String)"\u8d44\u6e90\u5df2\u88ab%1$s\u9501\u5b9a\uff0c\u65e0\u6cd5%2$s\uff0c\u8bf7\u4f18\u5148\u89e3\u9501\u3002", (String)"SvnOperationUtil_13", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]), lockUser, showMessage));
                    return;
                }
            }
        } else if (SVN_UNLOCK.equals(key)) {
            plugin.getView().showMessage(ResManager.loadKDString((String)"\u8d44\u6e90\u6ca1\u6709\u9501\u5b9a\uff0c\u65e0\u9700\u89e3\u9501\u3002", (String)"SvnOperationUtil_16", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]));
        }
        SvnOperationUtil.svnOperate(key, id, type, userName, passWord, isNeedSaveSvnMsg, plugin, sessionId);
    }

    public static String getOperateMsgByKey(String operateKey) {
        String operateMsg = null;
        switch (operateKey) {
            case "svnrevert": {
                operateMsg = ResManager.loadKDString((String)"\u66f4\u65b0", (String)"SvnOperationUtil_17", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]);
                break;
            }
            case "svndelete": {
                operateMsg = ResManager.loadKDString((String)"\u5220\u9664", (String)"SvnOperationUtil_18", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]);
                break;
            }
            case "svnlock": {
                operateMsg = ResManager.loadKDString((String)"\u9501\u5b9a", (String)"SvnOperationUtil_19", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]);
                break;
            }
            case "svnunlock": {
                operateMsg = ResManager.loadKDString((String)"\u89e3\u9501", (String)"SvnOperationUtil_20", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]);
                break;
            }
            case "svnclean": {
                operateMsg = ResManager.loadKDString((String)"\u6e05\u7406", (String)"SvnOperationUtil_21", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]);
                break;
            }
            case "svnlog": {
                operateMsg = ResManager.loadKDString((String)"\u67e5\u770b\u65e5\u5fd7", (String)"SvnOperationUtil_22", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]);
                break;
            }
        }
        return operateMsg;
    }

    private static void showSvnLoginPage(String key, String id, String type, AbstractFormPlugin plugin, String bizAppId, String oldSessionId) {
        String svnMsg = UUID.randomUUID().toString();
        plugin.getPageCache().put("old_svnmsg", oldSessionId);
        plugin.getPageCache().put("svnmsg", svnMsg);
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam(BIZAPPID, (Object)bizAppId);
        parameter.setFormId("bos_devp_svnlogin");
        parameter.setCaption(ResManager.loadKDString((String)"\u767b\u5f55SVN", (String)"SvnOperationUtil_23", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]));
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, "svnlogincallback"));
        parameter.setCustomParam("svnoperate", (Object)Boolean.TRUE);
        parameter.setCustomParam("svnoperatekey", (Object)key);
        parameter.setCustomParam("svnoperateid", (Object)id);
        parameter.setCustomParam("svnoperatetype", (Object)type);
        plugin.getView().showForm(parameter);
    }

    public static String getSVNLockUser(String id, String type, String userName, String passWord) {
        JSONObject result = SvnOperationUtil.getBizAppIdAndFileNameByType(type, id);
        String bizAppId = result.getString(BIZAPPID);
        String fileName = result.getString(FILENAME);
        JSONObject svnMsg = null;
        svnMsg = StringUtils.equals((CharSequence)"app", (CharSequence)type) ? SVNUtil.getSVNMsgByAppId((String)bizAppId) : SVNUtil.getSVNMsgByAppId((String)bizAppId, (String)id);
        svnMsg.put(USERNAME, (Object)userName);
        svnMsg.put(P, (Object)passWord);
        String svnPath = svnMsg.getString(SVNPATH);
        String svnFilePath = String.format(metadata, svnPath, fileName);
        Map commitClient = SVNUtil.getRepositoryAndCommitClient((JSONObject)svnMsg);
        SVNRepository repository = (SVNRepository)commitClient.get("repository");
        String root = null;
        try {
            root = String.valueOf(repository.getRepositoryRoot(true));
        }
        catch (SVNException e) {
            logger.error(e.getMessage());
        }
        if (root == null) {
            return "error_username";
        }
        try {
            passWord = Encrypters.decode((String)passWord);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        boolean fileIsExist = SvnOperationUtil.isExitsFile(svnFilePath, userName, passWord);
        if (!fileIsExist) {
            return NOFILE;
        }
        SVNClientManager clientManager = SVNCommonUtil.authSvn((String)svnFilePath, (String)userName, (String)passWord);
        SVNURL svnurl = null;
        try {
            svnurl = SVNURL.parseURIEncoded((String)svnFilePath);
        }
        catch (SVNException e) {
            logger.error(e.getMessage());
        }
        String lockUser = null;
        SVNInfo doInfo = SVNCommonUtil.doInfo((SVNClientManager)clientManager, (SVNURL)svnurl);
        if (doInfo != null && doInfo.getLock() != null) {
            lockUser = doInfo.getLock().getOwner();
        }
        return lockUser;
    }

    public static boolean isExitsFile(String svnFile, String userName, String password) {
        try {
            SVNURL svnUrl = SVNURL.parseURIEncoded((String)svnFile);
            return SVNCommonUtil.isURLExist((SVNURL)svnUrl, (String)userName, (String)password);
        }
        catch (Exception e) {
            logger.error("SvnOperationUtil : file does not exits", (Throwable)e);
            return false;
        }
    }

    public static void svnOperate(String key, String id, String type, String userName, String passWord, Boolean isNeedSaveSvnMsg, AbstractFormPlugin plugin, String sessionId) {
        if (isNeedSaveSvnMsg.booleanValue()) {
            JSONObject saveSvnMsg = new JSONObject();
            saveSvnMsg.put("svnmsg", (Object)sessionId);
            ((IClientViewProxy)plugin.getView().getService(IClientViewProxy.class)).addAction("SAVE_JSESSION_ID", (Object)saveSvnMsg);
        }
        switch (key) {
            case "checkin": {
                SvnOperationUtil.checkIn(id, type, plugin);
                break;
            }
            case "svndiff": {
                SvnOperationUtil.svnDiff(id, type, plugin);
                break;
            }
            case "svnlog": {
                SvnOperationUtil.svnLog(id, type, userName, passWord, plugin, sessionId);
                break;
            }
            case "svnrevert": {
                SvnOperationUtil.svnRevert(id, type, userName, passWord, plugin);
                break;
            }
            case "svndelete": {
                SvnOperationUtil.svnDelete(id, type, userName, passWord, plugin);
                break;
            }
            case "svnmove": {
                SvnOperationUtil.svnMove(id, type, plugin);
                break;
            }
            case "svnlock": {
                SvnOperationUtil.svnLock(id, type, userName, passWord, plugin);
                break;
            }
            case "svnunlock": {
                SvnOperationUtil.svnUnlock(id, type, userName, passWord, plugin);
                break;
            }
            case "svnclean": {
                SvnOperationUtil.svnCleanUp(id, type, plugin);
                break;
            }
        }
    }

    public static void checkIn(String id, String type, AbstractFormPlugin plugin) {
        plugin.getView().showMessage(ResManager.loadKDString((String)"\u6b63\u5728\u52aa\u529b\u5f00\u53d1\u4e2d\uff0c\u656c\u8bf7\u671f\u5f85\u3002", (String)"SvnOperationUtil_24", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]));
    }

    public static void svnDiff(String id, String type, AbstractFormPlugin plugin) {
        JSONObject result = SvnOperationUtil.getBizAppIdAndFileNameByType(type, id);
        String bizAppId = result.getString(BIZAPPID);
        String fileNumber = result.getString(FILENAME);
        JSONObject svnMsg = SVNUtil.getSVNMsgByAppId((String)bizAppId, (String)id);
        if (StringUtils.isNotBlank((Object)svnMsg.get((Object)"ERROR"))) {
            plugin.getView().showMessage(svnMsg.get((Object)"ERROR").toString());
            return;
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("bos_devp_svndiff");
        parameter.setPageId(UUID.randomUUID().toString());
        parameter.setCustomParam(BIZAPPID, (Object)bizAppId);
        parameter.setCustomParam("type", (Object)type);
        parameter.setCustomParam("id", (Object)id);
        if ("page".equals(type)) {
            fileNumber = fileNumber.substring(0, fileNumber.length() - 4);
        }
        parameter.setCaption(String.format(ResManager.loadKDString((String)"svn\u5dee\u5f02\u6bd4\u8f83(%s)", (String)"SvnOperationUtil_25", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]), fileNumber));
        parameter.setCustomParam(SVNPATH, (Object)svnMsg.getString(SVNPATH));
        parameter.setCustomParam("oldversion", (Object)"locale");
        parameter.setCustomParam("newversion", (Object)"head");
        OpenStyle style = new OpenStyle();
        StyleCss cssStyle = new StyleCss();
        cssStyle.setHeight("760");
        cssStyle.setWidth("1200");
        style.setInlineStyleCss(cssStyle);
        style.setShowType(ShowType.Modal);
        parameter.setOpenStyle(style);
        plugin.getView().showForm(parameter);
    }

    public static void svnLog(String id, String type, String userName, String passWord, AbstractFormPlugin plugin, String sessionId) {
        if (SCRIPT.equalsIgnoreCase(type)) {
            SvnOperationUtil.showSvnLog(id, type, userName, passWord, "bos_devp_svnlog", plugin, sessionId);
        } else if ("page".equalsIgnoreCase(type)) {
            SvnOperationUtil.showSvnLog(id, type, userName, passWord, "bos_devp_pagesvnlog", plugin, sessionId);
        } else if ("card".equalsIgnoreCase(type)) {
            SvnOperationUtil.showSvnLog(id, type, userName, passWord, "bos_devp_svnlog", plugin, sessionId);
        }
    }

    private static void showSvnLog(String id, String type, String userName, String passWord, String svnLogFormId, AbstractFormPlugin plugin, String sessionId) {
        JSONObject result = SvnOperationUtil.getBizAppIdAndFileNameByType(type, id);
        String bizAppId = result.getString(BIZAPPID);
        String fileNumber = result.getString(FILENAME);
        JSONObject svnMsg = SVNUtil.getSVNMsgByAppId((String)bizAppId, (String)id);
        if (StringUtils.isNotBlank((Object)svnMsg.get((Object)"ERROR"))) {
            plugin.getView().showMessage(svnMsg.get((Object)"ERROR").toString());
            return;
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId(svnLogFormId);
        parameter.setCaption(String.format(ResManager.loadKDString((String)"svn\u65e5\u5fd7(%s)", (String)"SvnOperationUtil_26", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]), fileNumber));
        parameter.setCustomParam("type", (Object)type);
        parameter.setCustomParam("id", (Object)id);
        parameter.setCustomParam(SVNPATH, (Object)svnMsg.get((Object)SVNPATH).toString());
        parameter.setCustomParam(USERNAME, (Object)userName);
        parameter.setCustomParam(P, (Object)passWord);
        parameter.setCustomParam("sessionid", (Object)sessionId);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, "svnlogcallback"));
        plugin.getView().showForm(parameter);
    }

    public static void svnRevert(String id, String type, String userName, String passWord, AbstractFormPlugin plugin) {
        try {
            passWord = Encrypters.decode((String)passWord);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        if (SCRIPT.equalsIgnoreCase(type)) {
            SvnOperationUtil.svnRevertScript(id, userName, passWord, plugin);
        } else if ("page".equalsIgnoreCase(type)) {
            SvnOperationUtil.svnRevertPage(id, userName, passWord, plugin);
        } else if ("app".equalsIgnoreCase(type)) {
            SvnOperationUtil.svnRevertAppMetadata(id, userName, passWord, plugin);
        }
    }

    private static void svnRevertAppMetadata(String bizAppId, String userName, String passWord, AbstractFormPlugin plugin) {
        DynamicObject obj = BusinessDataServiceHelper.loadSingleFromCache((Object)bizAppId, (String)BOS_DEVPORTAL_BIZAPP);
        String bizCloudId = obj.getString("bizcloud_id");
        JSONObject svnMsg = SVNUtil.getSVNMsgByAppId((String)bizAppId);
        String svnPath = svnMsg.getString(SVNPATH);
        List list = MetadataDao.getAppDeployFile((String)bizAppId);
        ILocaleString name = null;
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                String fileName = ((DeployFile)list.get(i)).getFileName();
                String svnFilePath = String.format(metadata, svnPath, fileName);
                ByteArrayOutputStream output = new ByteArrayOutputStream();
                SVNClientManager clientManager = SVNCommonUtil.authSvn((String)svnFilePath, (String)userName, (String)passWord);
                try {
                    SVNCommonUtil.doGetFileContent((SVNClientManager)clientManager, null, (String)svnFilePath, (OutputStream)output);
                }
                catch (Exception e) {
                    continue;
                }
                byte[] byteArr = output.toByteArray();
                String svnFilecontent = new String(byteArr, StandardCharsets.UTF_8);
                MetadataDao.deployAppMetadata((String)svnFilecontent, (String)bizCloudId);
            }
            DynamicObject appObj = BusinessDataServiceHelper.loadSingle((Object)bizAppId, (String)BOS_DEVPORTAL_BIZAPP, (String)"id,type,name,masterid");
            name = appObj.getLocaleString("name");
            if (appObj.getString("type").equals("2") && StringUtils.isNotBlank((CharSequence)appObj.getString(MASTERID))) {
                bizAppId = obj.getString(MASTERID);
            }
            MetadataDao.rebuildRuntimeAppMetaById((String)bizAppId);
        }
        if (name != null) {
            plugin.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5df2\u6210\u529f\u5c06\u5e94\u7528\u4fe1\u606f\uff08\u83dc\u5355\u3001\u529f\u80fd\u5206\u7ec4\uff09\u6062\u590d\u5230svn\u6700\u65b0\u7248\u672c\u3002", (String)"SvnOperationUtil_27", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]));
        } else {
            plugin.getView().showErrorNotification(ResManager.loadKDString((String)"\u5e94\u7528\u4fe1\u606f\uff08\u83dc\u5355\u3001\u529f\u80fd\u5206\u7ec4\uff09\u6062\u590d\u5230svn\u6700\u65b0\u7248\u672c\u5931\u8d25\u3002", (String)"SvnOperationUtil_28", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]));
        }
    }

    private static void svnRevertPage(String formId, String userName, String passWord, AbstractFormPlugin plugin) {
        QFilter qFormId = new QFilter("form", "=", (Object)formId);
        DynamicObject pageRelInfo = QueryServiceHelper.queryOne((String)"bos_devportal_unitrelform", (String)"bizunit,bizapp", (QFilter[])new QFilter[]{qFormId});
        String bizUnitId = pageRelInfo.getString("bizunit");
        String bizAppId = pageRelInfo.getString(BIZAPP);
        JSONObject svnMsg = SVNUtil.getSVNMsgByAppId((String)bizAppId, (String)formId);
        String svnPath = svnMsg.getString(SVNPATH);
        List list = MetadataDao.getFormDeployFile((String)formId);
        ILocaleString name = null;
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                String fileName = ((DeployFile)list.get(i)).getFileName();
                String svnFilePath = String.format(metadata, svnPath, fileName);
                ByteArrayOutputStream output = new ByteArrayOutputStream();
                SVNClientManager clientManager = SVNCommonUtil.authSvn((String)svnFilePath, (String)userName, (String)passWord);
                try {
                    SVNCommonUtil.doGetFileContent((SVNClientManager)clientManager, null, (String)svnFilePath, (OutputStream)output);
                }
                catch (Exception e) {
                    continue;
                }
                byte[] byteArr = output.toByteArray();
                String svnFilecontent = new String(byteArr, StandardCharsets.UTF_8);
                MetadataDao.deployMetadata((String)svnFilecontent, (String)bizUnitId, (String)bizAppId);
            }
            DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)formId, (String)BOS_FORMMETA, (String)"id,type,name,masterid");
            name = obj.getLocaleString("name");
            if (obj.getString("type").equals("2") && StringUtils.isNotBlank((CharSequence)obj.getString(MASTERID))) {
                formId = obj.getString(MASTERID);
            }
            MetadataDao.rebuildRuntimeMetaById((String)formId);
        }
        String consoleString = null;
        if (name != null) {
            plugin.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5df2\u6210\u529f\u5c06\u9875\u9762\u6062\u590d\u5230svn\u6700\u65b0\u7248\u672c\u3002", (String)"SvnOperationUtil_29", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]));
            consoleString = String.format(ResManager.loadKDString((String)"\u6210\u529f\u5c06\u9875\u9762\u201c%s\u201d\u6062\u590d\u5230SVN\u6700\u65b0\u7248\u672c\u3002", (String)"SvnOperationUtil_30", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]), name.getLocaleValue());
        } else {
            plugin.getView().showErrorNotification(ResManager.loadKDString((String)"\u9875\u9762\u6062\u590d\u5230svn\u6700\u65b0\u7248\u672c\u5931\u8d25\u3002", (String)"SvnOperationUtil_32", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]));
            consoleString = ResManager.loadKDString((String)"\u9875\u9762\u6062\u590d\u5230svn\u6700\u65b0\u7248\u672c\u5931\u8d25\u3002", (String)"SvnOperationUtil_32", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]);
        }
        JSONObject consoleData = new JSONObject();
        consoleData.put("date", (Object)new SimpleDateFormat(DATEFM).format(new Date()));
        consoleData.put(OUTPUT, (Object)consoleString);
        ((IClientViewProxy)plugin.getView().getService(IClientViewProxy.class)).addAction(CONSOLE_KDEMARK, (Object)consoleData);
    }

    private static void svnRevertScript(String id, String userName, String passWord, AbstractFormPlugin plugin) {
        DynamicObject scriptInfo = BusinessDataServiceHelper.loadSingle((Object)id, (String)IDE_PLUGINSCRIPT);
        String scriptNumber = scriptInfo.getString(TXT_SCRIPTNUMBER);
        String bizAppId = scriptInfo.getString(BIZAPPID);
        JSONObject svnMsg = SVNUtil.getSVNMsgByAppId((String)bizAppId, (String)id);
        String svnPath = svnMsg.getString(SVNPATH);
        String svnFilePath = String.format("%s/metadata/%s.ks", svnPath, scriptNumber);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        SVNClientManager clientManager = SVNCommonUtil.authSvn((String)svnFilePath, (String)userName, (String)passWord);
        SVNCommonUtil.doGetFileContent((SVNClientManager)clientManager, null, (String)svnFilePath, (OutputStream)output);
        byte[] byteArr = output.toByteArray();
        String svnFilecontent = new String(byteArr, StandardCharsets.UTF_8);
        DcxmlSerializer serializer = new DcxmlSerializer(DeployScript.getDCBinder());
        serializer.setColloctionIgnorePKValue(true);
        DeployScript deployNew = (DeployScript)serializer.deserializeFromString(svnFilecontent, null);
        List dynamicObjects = deployNew.getScripts();
        scriptInfo.set("txt_scriptcontext_tag", ((DynamicObject)dynamicObjects.get(0)).get("context"));
        scriptInfo.set("modifier", (Object)Long.valueOf(RequestContext.get().getUserId()));
        scriptInfo.set("modifydate", (Object)Timestamp.valueOf(new SimpleDateFormat(DATEFM).format(new Date())));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{scriptInfo});
        MetaCacheUtils.removeDistributeCache((String[])new String[]{scriptInfo.getString("classname")});
        plugin.getView().showMessage(ResManager.loadKDString((String)"\u5df2\u6210\u529f\u5c06\u811a\u672c\u6062\u590d\u5230svn\u6700\u65b0\u7248\u672c\u3002", (String)"SvnOperationUtil_34", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]));
        JSONObject consoleData = new JSONObject();
        consoleData.put("date", (Object)new SimpleDateFormat(DATEFM).format(new Date()));
        consoleData.put(OUTPUT, (Object)String.format(ResManager.loadKDString((String)"\u6210\u529f\u5c06\u811a\u672c\u201c%s.ks\u201d\u6062\u590d\u5230SVN\u6700\u65b0\u7248\u672c\u3002", (String)"SvnOperationUtil_35", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]), scriptNumber));
        ((IClientViewProxy)plugin.getView().getService(IClientViewProxy.class)).addAction(CONSOLE_KDEMARK, (Object)consoleData);
    }

    public static void svnDelete(String id, String type, String userName, String passWord, AbstractFormPlugin plugin) {
        if (SCRIPT.equalsIgnoreCase(type)) {
            SvnOperationUtil.svnDeleteScript(id, userName, passWord, plugin);
        } else if ("page".equalsIgnoreCase(type)) {
            SvnOperationUtil.svnDeletePage(id, userName, passWord, plugin);
        }
    }

    private static void svnDeletePage(String formId, String userName, String passWord, AbstractFormPlugin plugin) {
        String bizAppId = MetadataDao.getAppIdByFormId((String)formId);
        String formNumber = MetadataDao.getNumberById((String)formId);
        JSONObject svnMsg = SVNUtil.getSVNMsgByAppId((String)bizAppId, (String)formId);
        svnMsg.put(USERNAME, (Object)userName);
        svnMsg.put(P, (Object)passWord);
        svnMsg.put("annotation", (Object)ResManager.loadKDString((String)"svn \u64cd\u4f5c-\u5220\u9664", (String)"SvnOperationUtil_37", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]));
        JSONArray forms = new JSONArray();
        JSONObject form = new JSONObject();
        form.put("formid", (Object)formId);
        form.put("formnumber", (Object)formNumber);
        forms.add((Object)form);
        JSONObject checkInMsg = SVNUtil.deleteSVN((JSONObject)svnMsg, (JSONArray)forms);
        JSONObject consoleData = new JSONObject();
        consoleData.put("date", (Object)new SimpleDateFormat(DATEFM).format(new Date()));
        String consoleString = "";
        if (checkInMsg.get((Object)"ERROR") != null) {
            if (checkInMsg.get((Object)"ERROR") != null && checkInMsg.get((Object)"ERROR").toString().indexOf("Locked") != -1) {
                plugin.getView().showMessage(ResManager.loadKDString((String)"svn\u4e0a\u9875\u9762\u5143\u6570\u636e\u88ab\u9501\u5b9a\uff0c\u65e0\u6cd5\u5220\u9664\uff0c\u8bf7\u627e\u9501\u5b9a\u4eba\u5148\u89e3\u9501\u3002", (String)"SvnOperationUtil_38", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]));
                consoleString = ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25\uff0c\u539f\u56e0\uff1aSVN\u4e0a\u7684\u9875\u9762\u5143\u6570\u636e\u5df2\u9501\u5b9a\uff0c\u65e0\u6cd5\u5220\u9664\u3002\u8bf7\u5148\u8054\u7cfb\u9501\u5b9a\u4eba\u89e3\u9501\u3002", (String)"SvnOperationUtil_39", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]);
            } else if (checkInMsg.get((Object)"ERROR") != null && (checkInMsg.get((Object)"ERROR").toString().indexOf(AUTHENTICATIONREQUIRED) != -1 || checkInMsg.get((Object)"ERROR").toString().indexOf(FORBIDDEN) != -1)) {
                String msg = ResManager.loadKDString((String)"svn\u7528\u6237\u540d\u5bc6\u7801\u9519\u8bef\u6216\u6ca1\u6709\u5199\u6743\u9650\uff0c\u8bf7\u68c0\u67e5\u540e\u518d\u8bd5\u3002", (String)SVNOPERATIONUTIL_40, (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]);
                plugin.getView().showMessage(msg);
                consoleString = ResManager.loadKDString((String)"SVN\u5220\u9664\u5931\u8d25\u3002\u539f\u56e0\uff1aSVN\u7528\u6237\u540d\u5bc6\u7801\u9519\u8bef\u6216\u6ca1\u6709\u5199\u6743\u9650\uff0c\u8bf7\u68c0\u67e5\u540e\u518d\u8bd5\u3002", (String)"SvnOperationUtil_41", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]);
            } else {
                plugin.getView().showMessage(ResManager.loadKDString((String)"svn\u4e0a\u9875\u9762\u5143\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"SvnOperationUtil_42", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]));
                consoleString = ResManager.loadKDString((String)"SVN\u5220\u9664\u5931\u8d25\uff0c\u539f\u56e0\uff1aSVN\u4e0a\u9875\u9762\u5143\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"SvnOperationUtil_43", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]);
            }
        } else {
            plugin.getView().showMessage(ResManager.loadKDString((String)"\u5df2\u6210\u529f\u5220\u9664svn\u4e0a\u7684\u9875\u9762\u6587\u4ef6\u3002", (String)"SvnOperationUtil_44", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]));
            consoleString = ResManager.loadKDString((String)"\u6210\u529f\u5220\u9664SVN\u4e0a\u7684\u9875\u9762\u6587\u4ef6\u3002", (String)"SvnOperationUtil_45", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]);
        }
        consoleData.put(OUTPUT, (Object)consoleString);
        ((IClientViewProxy)plugin.getView().getService(IClientViewProxy.class)).addAction(CONSOLE_KDEMARK, (Object)consoleData);
    }

    private static void svnDeleteScript(String id, String userName, String passWord, AbstractFormPlugin plugin) {
        DynamicObject scriptInfo = BusinessDataServiceHelper.loadSingle((Object)id, (String)IDE_PLUGINSCRIPT);
        String bizAppId = scriptInfo.getString(BIZAPPID);
        JSONObject svnMsg = SVNUtil.getSVNMsgByAppId((String)bizAppId, (String)id);
        svnMsg.put(USERNAME, (Object)userName);
        svnMsg.put(P, (Object)passWord);
        svnMsg.put("annotation", (Object)ResManager.loadKDString((String)"svn \u64cd\u4f5c-\u5220\u9664", (String)"SvnOperationUtil_37", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]));
        JSONArray scriptIds = new JSONArray();
        scriptIds.add((Object)id);
        JSONObject checkInMsg = ScriptOperationUtil.deleteScript(svnMsg, scriptIds);
        JSONObject consoleData = new JSONObject();
        consoleData.put("date", (Object)new SimpleDateFormat(DATEFM).format(new Date()));
        String consoleString = "";
        if (checkInMsg.get((Object)ERROR) != null) {
            if (checkInMsg.get((Object)"ERROR") != null && checkInMsg.get((Object)"ERROR").toString().indexOf("Locked") != -1) {
                plugin.getView().showMessage(ResManager.loadKDString((String)"svn\u4e0a\u9875\u9762\u5143\u6570\u636e\u88ab\u9501\u5b9a\uff0c\u65e0\u6cd5\u5220\u9664\uff0c\u8bf7\u627e\u9501\u5b9a\u4eba\u5148\u89e3\u9501\u3002", (String)"SvnOperationUtil_38", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]));
                consoleString = ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25\uff0c\u539f\u56e0\uff1aSVN\u4e0a\u7684\u9875\u9762\u5143\u6570\u636e\u5df2\u9501\u5b9a\uff0c\u65e0\u6cd5\u5220\u9664\u3002\u8bf7\u5148\u8054\u7cfb\u9501\u5b9a\u4eba\u89e3\u9501\u3002", (String)"SvnOperationUtil_39", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]);
            } else if (checkInMsg.get((Object)"ERROR") != null && (checkInMsg.get((Object)"ERROR").toString().indexOf(AUTHENTICATIONREQUIRED) != -1 || checkInMsg.get((Object)"ERROR").toString().indexOf(FORBIDDEN) != -1)) {
                String msg = ResManager.loadKDString((String)"svn\u7528\u6237\u540d\u5bc6\u7801\u9519\u8bef\u6216\u6ca1\u6709\u5199\u6743\u9650\uff0c\u8bf7\u68c0\u67e5\u540e\u518d\u8bd5\u3002", (String)SVNOPERATIONUTIL_40, (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]);
                plugin.getView().showMessage(msg);
                consoleString = ResManager.loadKDString((String)"SVN\u5220\u9664\u5931\u8d25\u3002\u539f\u56e0\uff1aSVN\u7528\u6237\u540d\u5bc6\u7801\u9519\u8bef\u6216\u6ca1\u6709\u5199\u6743\u9650\uff0c\u8bf7\u68c0\u67e5\u540e\u518d\u8bd5\u3002", (String)"SvnOperationUtil_41", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]);
            } else {
                plugin.getView().showMessage(String.format(ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25\uff1a%s", (String)"SvnOperationUtil_46", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]), checkInMsg.get((Object)ERROR)));
                consoleString = String.format(ResManager.loadKDString((String)"svn\u5220\u9664\u5931\u8d25,\u539f\u56e0:%s", (String)"SvnOperationUtil_47", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]), checkInMsg.get((Object)ERROR));
            }
        } else {
            plugin.getView().showMessage(ResManager.loadKDString((String)"\u5df2\u6210\u529f\u5220\u9664svn\u4e0a\u7684\u811a\u672c\u6587\u4ef6\u3002", (String)"SvnOperationUtil_48", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]));
            consoleString = ResManager.loadKDString((String)"\u6210\u529f\u5220\u9664SVN\u4e0a\u7684\u811a\u672c\u6587\u4ef6\u3002", (String)"SvnOperationUtil_49", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]);
        }
        consoleData.put(OUTPUT, (Object)consoleString);
        ((IClientViewProxy)plugin.getView().getService(IClientViewProxy.class)).addAction(CONSOLE_KDEMARK, (Object)consoleData);
    }

    public static void svnMove(String id, String type, AbstractFormPlugin plugin) {
        plugin.getView().showMessage(ResManager.loadKDString((String)"\u5f00\u53d1\u4e2d\u3002\u3002\u3002", (String)"SvnOperationUtil_50", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]));
    }

    public static void svnLock(String id, String type, String userName, String passWord, AbstractFormPlugin plugin) {
        try {
            passWord = Encrypters.decode((String)passWord);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        if (SCRIPT.equalsIgnoreCase(type)) {
            SvnOperationUtil.svnLockScript(id, userName, passWord, plugin);
        } else if ("page".equalsIgnoreCase(type)) {
            SvnOperationUtil.svnLockPage(id, userName, passWord, plugin);
        }
    }

    private static void svnLockPage(String formId, String userName, String passWord, AbstractFormPlugin plugin) {
        String bizAppId = MetadataDao.getAppIdByFormId((String)formId);
        JSONObject svnMsg = SVNUtil.getSVNMsgByAppId((String)bizAppId, (String)formId);
        String svnPath = svnMsg.getString(SVNPATH);
        List list = MetadataDao.getFormDeployFile((String)formId);
        SVNURL[] lockUrls = new SVNURL[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            String fileName = ((DeployFile)list.get(i)).getFileName();
            String svnFilePath = String.format(metadata, svnPath, fileName);
            try {
                lockUrls[i] = SVNURL.parseURIEncoded((String)svnFilePath);
                continue;
            }
            catch (SVNException e) {
                logger.error((Throwable)e);
            }
        }
        SVNClientManager clientManager = SVNCommonUtil.authSvn((String)svnPath, (String)userName, (String)passWord);
        JSONObject consoleData = new JSONObject();
        consoleData.put("date", (Object)new SimpleDateFormat(DATEFM).format(new Date()));
        String consoleString = "";
        try {
            SVNCommonUtil.lockSvn((SVNClientManager)clientManager, (SVNURL[])lockUrls, (boolean)true, (String)ResManager.loadKDString((String)"svn \u64cd\u4f5c-\u9501\u5b9a", (String)"SvnOperationUtil_51", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]));
        }
        catch (Exception e) {
            if (e.getMessage() != null && (e.getMessage().indexOf(AUTHENTICATIONREQUIRED) != -1 || e.getMessage().indexOf(FORBIDDEN) != -1)) {
                String msg = ResManager.loadKDString((String)"svn\u7528\u6237\u540d\u5bc6\u7801\u9519\u8bef\u6216\u6ca1\u6709\u5199\u6743\u9650\uff0c\u8bf7\u68c0\u67e5\u540e\u518d\u8bd5\u3002", (String)SVNOPERATIONUTIL_40, (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]);
                plugin.getView().showMessage(msg);
                consoleString = ResManager.loadKDString((String)"SVN\u9501\u5b9a\u5931\u8d25\u3002\u539f\u56e0\uff1aSVN\u7528\u6237\u540d\u5bc6\u7801\u9519\u8bef\u6216\u6ca1\u6709\u5199\u6743\u9650\uff0c\u8bf7\u68c0\u67e5\u540e\u518d\u8bd5\u3002", (String)"SvnOperationUtil_52", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]);
            } else {
                plugin.getView().showMessage(e.getMessage());
                consoleString = String.format(ResManager.loadKDString((String)"svn\u9501\u5b9a\u5931\u8d25,\u539f\u56e0:%s", (String)"SvnOperationUtil_53", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]), e.getMessage());
            }
            consoleData.put(OUTPUT, (Object)consoleString);
            ((IClientViewProxy)plugin.getView().getService(IClientViewProxy.class)).addAction(CONSOLE_KDEMARK, (Object)consoleData);
            return;
        }
        plugin.getView().showMessage(ResManager.loadKDString((String)"\u5df2\u6210\u529f\u9501\u5b9a\u8be5\u9875\u9762\u3002", (String)"SvnOperationUtil_54", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]));
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)formId, (String)BOS_FORMMETA, (String)"name");
        ILocaleString name = obj.getLocaleString("name");
        consoleString = String.format(ResManager.loadKDString((String)"\u6210\u529f\u89e3\u9501\u9875\u9762\u201c%s\u201d\u3002", (String)"SvnOperationUtil_55", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]), name.getLocaleValue());
        consoleData.put(OUTPUT, (Object)consoleString);
        ((IClientViewProxy)plugin.getView().getService(IClientViewProxy.class)).addAction(CONSOLE_KDEMARK, (Object)consoleData);
    }

    private static void svnLockScript(String id, String userName, String passWord, AbstractFormPlugin plugin) {
        DynamicObject scriptInfo = BusinessDataServiceHelper.loadSingleFromCache((Object)id, (String)IDE_PLUGINSCRIPT);
        String scriptNumber = scriptInfo.getString(TXT_SCRIPTNUMBER);
        String fileName = String.format("%s.ks", scriptNumber);
        String bizAppId = scriptInfo.getString(BIZAPPID);
        JSONObject svnMsg = SVNUtil.getSVNMsgByAppId((String)bizAppId, (String)id);
        String svnPath = svnMsg.getString(SVNPATH);
        SVNURL[] lockUrls = new SVNURL[1];
        String svnFilePath = String.format(metadata, svnPath, fileName);
        try {
            lockUrls[0] = SVNURL.parseURIEncoded((String)svnFilePath);
        }
        catch (SVNException e) {
            logger.error((Throwable)e);
        }
        SVNClientManager clientManager = SVNCommonUtil.authSvn((String)svnPath, (String)userName, (String)passWord);
        JSONObject consoleData = new JSONObject();
        consoleData.put("date", (Object)new SimpleDateFormat(DATEFM).format(new Date()));
        String consoleString = "";
        try {
            SVNCommonUtil.lockSvn((SVNClientManager)clientManager, (SVNURL[])lockUrls, (boolean)true, (String)ResManager.loadKDString((String)"svn \u64cd\u4f5c-\u9501\u5b9a", (String)"SvnOperationUtil_51", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]));
        }
        catch (Exception e) {
            if (e.getMessage() != null && (e.getMessage().indexOf(AUTHENTICATIONREQUIRED) != -1 || e.getMessage().indexOf(FORBIDDEN) != -1)) {
                String msg = ResManager.loadKDString((String)"svn\u7528\u6237\u540d\u5bc6\u7801\u9519\u8bef\u6216\u6ca1\u6709\u5199\u6743\u9650\uff0c\u8bf7\u68c0\u67e5\u540e\u518d\u8bd5\u3002", (String)SVNOPERATIONUTIL_40, (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]);
                plugin.getView().showMessage(msg);
                consoleString = ResManager.loadKDString((String)"SVN\u9501\u5b9a\u5931\u8d25\u3002\u539f\u56e0\uff1aSVN\u7528\u6237\u540d\u5bc6\u7801\u9519\u8bef\u6216\u6ca1\u6709\u5199\u6743\u9650\uff0c\u8bf7\u68c0\u67e5\u540e\u518d\u8bd5\u3002", (String)"SvnOperationUtil_52", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]);
            } else {
                plugin.getView().showMessage(e.getMessage());
                consoleString = String.format(ResManager.loadKDString((String)"svn\u9501\u5b9a\u5931\u8d25,\u539f\u56e0:%s", (String)"SvnOperationUtil_53", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]), e.getMessage());
            }
            consoleData.put(OUTPUT, (Object)consoleString);
            ((IClientViewProxy)plugin.getView().getService(IClientViewProxy.class)).addAction(CONSOLE_KDEMARK, (Object)consoleData);
            return;
        }
        plugin.getView().showMessage(ResManager.loadKDString((String)"\u5df2\u6210\u529f\u9501\u5b9a\u8be5\u811a\u672c\u3002", (String)"SvnOperationUtil_56", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]));
        consoleString = String.format(ResManager.loadKDString((String)"\u6210\u529f\u9501\u5b9a\u811a\u672c\u201c%s\u201d\u3002", (String)"SvnOperationUtil_57", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]), fileName);
        consoleData.put(OUTPUT, (Object)consoleString);
        ((IClientViewProxy)plugin.getView().getService(IClientViewProxy.class)).addAction(CONSOLE_KDEMARK, (Object)consoleData);
    }

    public static void svnUnlock(String id, String type, String userName, String passWord, AbstractFormPlugin plugin) {
        try {
            passWord = Encrypters.decode((String)passWord);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        if (SCRIPT.equalsIgnoreCase(type)) {
            SvnOperationUtil.svnUnlockScript(id, userName, passWord, plugin);
        } else if ("page".equalsIgnoreCase(type)) {
            SvnOperationUtil.svnUnlockPage(id, userName, passWord, plugin);
        }
    }

    private static void svnUnlockPage(String formId, String userName, String passWord, AbstractFormPlugin plugin) {
        String bizAppId = MetadataDao.getAppIdByFormId((String)formId);
        JSONObject svnMsg = SVNUtil.getSVNMsgByAppId((String)bizAppId, (String)formId);
        String svnPath = svnMsg.getString(SVNPATH);
        List list = MetadataDao.getFormDeployFile((String)formId);
        JSONArray lockUrls = new JSONArray();
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                String fileName = ((DeployFile)list.get(i)).getFileName();
                String svnFilePath = String.format(metadata, svnPath, fileName);
                SVNURL url = null;
                try {
                    url = SVNURL.parseURIEncoded((String)svnFilePath);
                }
                catch (SVNException e1) {
                    logger.error((Throwable)e1);
                }
                boolean urlExist = SVNCommonUtil.isURLExist((SVNURL)url, (String)userName, (String)passWord);
                if (!urlExist) continue;
                lockUrls.add((Object)url);
            }
        }
        SVNURL[] fileUrls = new SVNURL[lockUrls.size()];
        for (int i = 0; i < lockUrls.size(); ++i) {
            fileUrls[i] = (SVNURL)lockUrls.get(i);
        }
        SVNClientManager clientManager = SVNCommonUtil.authSvn((String)svnPath, (String)userName, (String)passWord);
        JSONObject consoleData = new JSONObject();
        consoleData.put("date", (Object)new SimpleDateFormat(DATEFM).format(new Date()));
        String consoleString = "";
        try {
            SVNCommonUtil.doUnLock((SVNClientManager)clientManager, (SVNURL[])fileUrls, (boolean)true);
        }
        catch (Exception e) {
            if (e.getMessage() != null && e.getMessage().indexOf(AUTHENTICATIONREQUIRED) != -1) {
                String msg = ResManager.loadKDString((String)"svn\u7528\u6237\u540d\u5bc6\u7801\u9519\u8bef\u6216\u6ca1\u6709\u5199\u6743\u9650\uff0c\u8bf7\u68c0\u67e5\u540e\u518d\u8bd5\u3002", (String)SVNOPERATIONUTIL_40, (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]);
                plugin.getView().showMessage(msg);
                consoleString = ResManager.loadKDString((String)"SVN\u89e3\u9501\u5931\u8d25\uff0c\u539f\u56e0\uff1aSVN\u7528\u6237\u540d\u5bc6\u7801\u9519\u8bef\u6216\u6ca1\u6709\u5199\u6743\u9650\uff0c\u8bf7\u68c0\u67e5\u540e\u518d\u8bd5\u3002", (String)"SvnOperationUtil_58", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]);
            } else {
                plugin.getView().showMessage(e.getMessage());
                consoleString = String.format(ResManager.loadKDString((String)"svn\u89e3\u9501\u5931\u8d25,\u539f\u56e0:%s", (String)"SvnOperationUtil_59", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]), e.getMessage());
            }
            consoleData.put(OUTPUT, (Object)consoleString);
            ((IClientViewProxy)plugin.getView().getService(IClientViewProxy.class)).addAction(CONSOLE_KDEMARK, (Object)consoleData);
            return;
        }
        plugin.getView().showMessage(ResManager.loadKDString((String)"\u5df2\u6210\u529f\u89e3\u9501\u8be5\u9875\u9762\u3002", (String)"SvnOperationUtil_60", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]));
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)formId, (String)BOS_FORMMETA, (String)"name");
        ILocaleString name = obj.getLocaleString("name");
        consoleString = String.format(ResManager.loadKDString((String)"\u6210\u529f\u89e3\u9501\u9875\u9762\u201c%s\u201d\u3002", (String)"SvnOperationUtil_61", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]), name.getLocaleValue());
        consoleData.put(OUTPUT, (Object)consoleString);
        ((IClientViewProxy)plugin.getView().getService(IClientViewProxy.class)).addAction(CONSOLE_KDEMARK, (Object)consoleData);
    }

    private static void svnUnlockScript(String id, String userName, String passWord, AbstractFormPlugin plugin) {
        DynamicObject scriptInfo = BusinessDataServiceHelper.loadSingleFromCache((Object)id, (String)IDE_PLUGINSCRIPT);
        String scriptNumber = scriptInfo.getString(TXT_SCRIPTNUMBER);
        String fileName = String.format("%s.ks", scriptNumber);
        String bizAppId = scriptInfo.getString(BIZAPPID);
        JSONObject svnMsg = SVNUtil.getSVNMsgByAppId((String)bizAppId, (String)id);
        String svnPath = svnMsg.getString(SVNPATH);
        SVNURL[] lockUrls = new SVNURL[1];
        String svnFilePath = String.format(metadata, svnPath, fileName);
        try {
            lockUrls[0] = SVNURL.parseURIEncoded((String)svnFilePath);
        }
        catch (SVNException e) {
            logger.error((Throwable)e);
        }
        SVNClientManager clientManager = SVNCommonUtil.authSvn((String)svnPath, (String)userName, (String)passWord);
        JSONObject consoleData = new JSONObject();
        String consoleString = "";
        consoleData.put("date", (Object)new SimpleDateFormat(DATEFM).format(new Date()));
        try {
            SVNCommonUtil.doUnLock((SVNClientManager)clientManager, (SVNURL[])lockUrls, (boolean)true);
        }
        catch (Exception e) {
            if (e.getMessage() != null && e.getMessage().indexOf(AUTHENTICATIONREQUIRED) != -1) {
                String msg = ResManager.loadKDString((String)"svn\u7528\u6237\u540d\u5bc6\u7801\u9519\u8bef\u6216\u6ca1\u6709\u5199\u6743\u9650\uff0c\u8bf7\u68c0\u67e5\u540e\u518d\u8bd5\u3002", (String)SVNOPERATIONUTIL_40, (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]);
                plugin.getView().showMessage(msg);
                consoleString = ResManager.loadKDString((String)"SVN\u89e3\u9501\u5931\u8d25\uff0c\u539f\u56e0\uff1aSVN\u7528\u6237\u540d\u5bc6\u7801\u9519\u8bef\u6216\u6ca1\u6709\u5199\u6743\u9650\uff0c\u8bf7\u68c0\u67e5\u540e\u518d\u8bd5\u3002", (String)"SvnOperationUtil_58", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]);
            } else {
                plugin.getView().showMessage(e.getMessage());
                consoleString = String.format(ResManager.loadKDString((String)"svn\u89e3\u9501\u5931\u8d25,\u539f\u56e0:%s", (String)"SvnOperationUtil_59", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]), e.getMessage());
            }
            consoleData.put(OUTPUT, (Object)consoleString);
            ((IClientViewProxy)plugin.getView().getService(IClientViewProxy.class)).addAction(CONSOLE_KDEMARK, (Object)consoleData);
            return;
        }
        plugin.getView().showMessage(ResManager.loadKDString((String)"\u5df2\u6210\u529f\u89e3\u9501\u8be5\u811a\u672c\u3002", (String)"SvnOperationUtil_62", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]));
        consoleString = String.format(ResManager.loadKDString((String)"\u6210\u529f\u89e3\u9501\u811a\u672c\u201c%s\u201d\u3002", (String)"SvnOperationUtil_63", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]), fileName);
        consoleData.put(OUTPUT, (Object)consoleString);
        ((IClientViewProxy)plugin.getView().getService(IClientViewProxy.class)).addAction(CONSOLE_KDEMARK, (Object)consoleData);
    }

    public static void svnCleanUp(String id, String type, AbstractFormPlugin plugin) {
        JSONObject result = SvnOperationUtil.getBizAppIdAndFileNameByType(type, id);
        String bizAppId = result.getString(BIZAPPID);
        JSONObject svnMsg = SVNUtil.getSVNMsgByAppId((String)bizAppId, (String)id);
        String localPath = svnMsg.getString("localpath");
        String checkLocalPath = AppUtils.checkFilePath((String)localPath);
        File file = new File(checkLocalPath);
        AppUtils.deleteKd((File)file);
        plugin.getView().showMessage(ResManager.loadKDString((String)"\u5df2\u6210\u529f\u6e05\u7406svn\u5de5\u4f5c\u533a\u95f4\u3002", (String)"SvnOperationUtil_64", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]));
        JSONObject consoleData = new JSONObject();
        consoleData.put("date", (Object)new SimpleDateFormat(DATEFM).format(new Date()));
        consoleData.put(OUTPUT, (Object)ResManager.loadKDString((String)"\u5df2\u6210\u529f\u6e05\u7406svn\u5de5\u4f5c\u533a\u95f4\u3002", (String)"SvnOperationUtil_64", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]));
        ((IClientViewProxy)plugin.getView().getService(IClientViewProxy.class)).addAction(CONSOLE_KDEMARK, (Object)consoleData);
    }

    public static JSONObject getBizAppIdAndFileNameByType(String type, String id) {
        JSONObject result = new JSONObject();
        String bizAppId = null;
        String fileNumber = null;
        String bizUnitId = null;
        if (SCRIPT.equalsIgnoreCase(type)) {
            DynamicObject scriptObject = BusinessDataServiceHelper.loadSingleFromCache((Object)id, (String)IDE_PLUGINSCRIPT, (String)"txt_scriptnumber,bizappid");
            bizAppId = scriptObject.getString(BIZAPPID);
            fileNumber = scriptObject.getString(TXT_SCRIPTNUMBER) + ".ks";
        } else if ("page".equalsIgnoreCase(type)) {
            fileNumber = MetadataDao.getNumberById((String)id) + ".dym";
            bizAppId = MetadataDao.getAppIdByFormId((String)id);
            bizUnitId = MetadataDao.getUnitIdFromUnitrel((String)id);
            if (StringUtils.isEmpty((CharSequence)bizAppId)) {
                QFilter qFormId = new QFilter("form", "=", (Object)id);
                DynamicObject pageRelInfo = QueryServiceHelper.queryOne((String)"bos_devportal_unitrelform", (String)"bizapp,bizunit", (QFilter[])new QFilter[]{qFormId});
                bizAppId = pageRelInfo.getString(BIZAPP);
                bizUnitId = pageRelInfo.getString("bizunit");
            }
        } else if ("app".equalsIgnoreCase(type)) {
            bizAppId = id;
            fileNumber = BusinessDataServiceHelper.loadSingle((Object)bizAppId, (String)BOS_DEVPORTAL_BIZAPP, (String)"number").getString("number") + ".app";
        }
        result.put(BIZAPPID, (Object)bizAppId);
        result.put(FILENAME, (Object)fileNumber);
        result.put("bizunitid", (Object)bizUnitId);
        return result;
    }
}

