/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.business.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dataentity.utils.Uuid16;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.devportal.business.util.ScriptOperationUtil;
import kd.bos.devportal.common.hosting.SVNUtil;
import kd.bos.devportal.common.util.AppUtils;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.deploy.DeployFile;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.UnitTestServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.util.FileUtils;

public class BizPageOperationUtil {
    private static final String PAGETYPE = "PAGE_TYPE";
    private static final String BIZAPPID = "bizappid";
    private static final String BOS_DEVPORTAL_BUSINESS = "bos-devportal-business";
    private static final String NODEID = "nodeid";
    private static final String NODE_TYPE = "nodetype";
    private static final String BIZUNITID = "bizunitid";
    private static final String SVNMSG = "svnmsg";
    private static final String BOS_FORMMETA = "bos_formmeta";
    private static final String BOS_DEVPORTAL_UNITRELFORM = "bos_devportal_unitrelform";
    private static final String BIZUNIT = "bizunit";
    private static final String FORMID = "formid";
    private static final String BIZPAGEOPERATIONUTIL_2 = "BizPageOperationUtil_2";
    private static final String BIZID = "bizid";
    private static final String MODELTYPE = "modeltype";
    private static final String NUMBER = "number";
    private static final String BAI = "bizAppId";
    private static final String ISINHERIT = "isinherit";

    public static void addNewPage(JSONObject arg, AbstractFormPlugin plugin) {
        String bizAppId = (String)plugin.getView().getFormShowParameter().getCustomParam(BIZAPPID);
        if (!AppUtils.checkResourceBelongsToCurDeveloper((String)bizAppId)) {
            plugin.getView().showTipNotification(AppUtils.getNoPermissionTips());
            return;
        }
        boolean isHasPermisson = AppUtils.checkPagePermission((String)"bos_devportal_bizpagelist", (String)"47156aff000000ac");
        if (!isHasPermisson) {
            plugin.getView().showMessage(ResManager.loadKDString((String)"\u6ca1\u6709\u6743\u9650\uff0c\u8bf7\u6dfb\u52a0\u6743\u9650\u540e\u518d\u8bd5\u3002", (String)"BizPageOperationUtil_0", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]));
            return;
        }
        String nodeId = arg.getString(NODEID);
        String nodeType = arg.getString(NODE_TYPE);
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("bos_devp_entrance");
        parameter.setCaption(ResManager.loadKDString((String)"\u521b\u5efa\u5411\u5bfc", (String)"BizPageOperationUtil_1", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]));
        String bizUnitId = BizPageOperationUtil.configParamById(nodeId, nodeType, parameter, plugin);
        plugin.getPageCache().put(BIZUNITID, bizUnitId);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)plugin, "newPageWindowClose");
        parameter.setCloseCallBack(callBack);
        parameter.setStatus(OperationStatus.ADDNEW);
        plugin.getView().showForm(parameter);
    }

    public static void deletePageConfirm(JSONObject arg, AbstractFormPlugin plugin) {
        String bizAppId = (String)plugin.getView().getFormShowParameter().getCustomParam(BIZAPPID);
        if (!AppUtils.checkResourceBelongsToCurDeveloper((String)bizAppId)) {
            plugin.getView().showTipNotification(AppUtils.getNoPermissionTips());
            return;
        }
        boolean isHasPermisson = AppUtils.checkPagePermission((String)"bos_devportal_bizpagelist", (String)"4715e1f1000000ac");
        if (!isHasPermisson) {
            plugin.getView().showMessage(ResManager.loadKDString((String)"\u6ca1\u6709\u6743\u9650\uff0c\u8bf7\u6dfb\u52a0\u6743\u9650\u540e\u518d\u8bd5\u3002", (String)"BizPageOperationUtil_0", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]));
            return;
        }
        String formId = arg.getString(NODEID);
        String jSessionId = arg.getString(SVNMSG);
        String type = (String)arg.get((Object)NODE_TYPE);
        boolean checkDeleteResource = AppUtils.checkDeleteResource((String)formId, (String)bizAppId, (IFormView)plugin.getView(), (String)"page", (String)"KDE");
        if (!checkDeleteResource) {
            return;
        }
        DynamicObject formInfo = BusinessDataServiceHelper.loadSingle((Object)formId, (String)BOS_FORMMETA);
        String formName = formInfo.getString("name");
        QFilter qUser = new QFilter("user", "=", (Object)Long.valueOf(RequestContext.get().getUserId()));
        QFilter qForm = new QFilter("bizpage", "=", (Object)formId);
        String isCollection = "false";
        if (QueryServiceHelper.exists((String)"bos_devportal_shortcut", (QFilter[])new QFilter[]{qUser, qForm})) {
            isCollection = "true";
        }
        String source = formId + "-" + isCollection;
        JSONArray pageArray = new JSONArray();
        pageArray.add((Object)source);
        qForm = new QFilter("form", "=", (Object)formId);
        DynamicObject pageInfo = QueryServiceHelper.queryOne((String)BOS_DEVPORTAL_UNITRELFORM, (String)BIZUNIT, (QFilter[])new QFilter[]{qForm});
        String bizUnitId = pageInfo.getString(BIZUNIT);
        plugin.getPageCache().put(FORMID, formId);
        plugin.getPageCache().put(BIZUNITID, bizUnitId);
        plugin.getPageCache().put("iscollection", isCollection);
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("bos_devportal_confirmdel");
        parameter.setCaption(String.format(ResManager.loadKDString((String)"\u5220\u9664\"%s\"", (String)"BizPageOperationUtil_23", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]), formName));
        parameter.setCustomParam("message", (Object)String.format(ResManager.loadKDString((String)"\u786e\u5b9a\u5220\u9664\u9875\u9762%s\u5417\uff1f", (String)"BizPageOperationUtil_3", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]), formName));
        parameter.setCustomParam(FORMID, (Object)formId);
        parameter.setCustomParam(BIZAPPID, (Object)bizAppId);
        parameter.setCustomParam("formNumber", (Object)formName);
        parameter.setCustomParam("source", (Object)pageArray.toJSONString());
        parameter.setCustomParam("type", (Object)type);
        parameter.setCustomParam("jsessionid", (Object)jSessionId);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, "pageDeleteCallBack"));
        plugin.getView().showForm(parameter);
    }

    public static Map<String, Object> deletePage(String formId, String bizUnitId, boolean isCollected) {
        Map<String, Object> result = new HashMap<String, Object>(16);
        try (TXHandle tx = TX.required();){
            try {
                QFilter[] filters = null;
                QFilter f1 = new QFilter(BIZUNIT, "=", (Object)bizUnitId);
                QFilter f2 = new QFilter("form", "=", (Object)formId);
                filters = new QFilter[]{f1, f2};
                DeleteServiceHelper.delete((String)BOS_DEVPORTAL_UNITRELFORM, (QFilter[])filters);
                MultiLangEnumBridge opName = new MultiLangEnumBridge("\u5220\u9664", BIZPAGEOPERATIONUTIL_2, BOS_DEVPORTAL_BUSINESS);
                MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u5220\u9664\u8868\u5355\u548c\u529f\u80fd\u5206\u7ec4\u7684\u5173\u8054\u5173\u7cfb", "BizPageOperationUtil_4", BOS_DEVPORTAL_BUSINESS);
                AppUtils.addOpLog((String)BOS_FORMMETA, (String)"delete", (String)BOS_FORMMETA, (String)"1", (MultiLangEnumBridge)opName, (MultiLangEnumBridge)opDesc, (String[])new String[0]);
                if (isCollected) {
                    QFilter f3 = new QFilter("user", "=", (Object)Long.valueOf(RequestContext.get().getUserId()));
                    QFilter f4 = new QFilter("bizpage", "=", (Object)formId);
                    QFilter[] filterssc = new QFilter[]{f3, f4};
                    DeleteServiceHelper.delete((String)"bos_devportal_shortcut", (QFilter[])filterssc);
                    MultiLangEnumBridge opNameFormCollect = new MultiLangEnumBridge("\u5220\u9664", BIZPAGEOPERATIONUTIL_2, BOS_DEVPORTAL_BUSINESS);
                    MultiLangEnumBridge opDescFormCollect = new MultiLangEnumBridge("\u5220\u9664\u8868\u5355\u7684\u6536\u85cf", "BizPageOperationUtil_5", BOS_DEVPORTAL_BUSINESS);
                    AppUtils.addOpLog((String)BOS_FORMMETA, (String)"delete", (String)BOS_FORMMETA, (String)"1", (MultiLangEnumBridge)opNameFormCollect, (MultiLangEnumBridge)opDescFormCollect, (String[])new String[0]);
                }
                DynamicObject obj = BizPageOperationUtil.createRecycleBinFormData(formId, ResManager.loadKDString((String)"\u5728KDE\u4e2d\u901a\u8fc7\u8868\u5355\u5220\u9664\u64cd\u4f5c", (String)"BizPageOperationUtil_6", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]));
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj});
                MultiLangEnumBridge opNameForm = new MultiLangEnumBridge("\u5220\u9664", BIZPAGEOPERATIONUTIL_2, BOS_DEVPORTAL_BUSINESS);
                MultiLangEnumBridge opDescForm = new MultiLangEnumBridge("\u5220\u9664\u8868\u5355", "BizPageOperationUtil_7", BOS_DEVPORTAL_BUSINESS);
                AppUtils.addOpLog((String)BOS_FORMMETA, (String)"delete", (String)BOS_FORMMETA, (String)"1", (MultiLangEnumBridge)opNameForm, (MultiLangEnumBridge)opDescForm, (String[])new String[0]);
                DynamicObject formInfo = BusinessDataServiceHelper.loadSingle((Object)formId, (String)BOS_FORMMETA);
                String devType = formInfo.getString("type");
                String masterId = formInfo.getString("masterid");
                result = MetadataDao.delFormMetadata((String)formId);
                if ("2".equals(devType) && QueryServiceHelper.exists((String)BOS_FORMMETA, (Object)masterId)) {
                    MetadataDao.rebuildRuntimeMetaById((String)masterId);
                }
                if (!((Boolean)result.get("success")).booleanValue()) {
                    throw new KDException(BosErrorCode.deleteFailed, new Object[]{ResManager.loadKDString((String)"\u5143\u6570\u636e\u6709\u4f9d\u8d56\uff0c\u5220\u9664\u5931\u8d25\u3002", (String)"BizPageOperationUtil_8", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0])});
                }
                QFilter qFilter = new QFilter("pageid", "=", (Object)formId);
                DeleteServiceHelper.delete((String)"bos_devp_pagerelscript", (QFilter[])new QFilter[]{qFilter});
            }
            catch (Exception e) {
                tx.markRollback();
            }
        }
        return result;
    }

    public static void checkInPage(JSONObject arg, AbstractFormPlugin plugin) {
        String formId = arg.getString(NODEID);
        String svnmsg = arg.getString(SVNMSG);
        BizPageOperationUtil.checkInResource(formId, PAGETYPE, svnmsg, plugin);
    }

    public static void checkInResource(String formId, String type, String svnMsg, AbstractFormPlugin plugin) {
        String bizAppId = (String)plugin.getView().getFormShowParameter().getCustomParam(BIZAPPID);
        JSONObject pathMsg = SVNUtil.getSVNMsgByAppId((String)bizAppId);
        if (StringUtils.isNotBlank((Object)pathMsg.get((Object)"ERROR"))) {
            plugin.getView().showErrorNotification((String)pathMsg.get((Object)"ERROR"));
            return;
        }
        plugin.getPageCache().put("pathmsg", pathMsg.toJSONString());
        plugin.getPageCache().put(BIZID, formId);
        plugin.getPageCache().put("checkintype", type);
        String message = UnitTestServiceHelper.canCheckIn((String)formId);
        JSONObject jsonMsg = (JSONObject)JSONObject.parse((String)message);
        String msg = jsonMsg.getString("msg");
        String code = jsonMsg.getString("code");
        if (!"0".equals(code)) {
            plugin.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u7b7e\u5165\u5931\u8d25\u3002\u5931\u8d25\u539f\u56e0\uff1a%s", (String)"BizPageOperationUtil_24", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]), msg));
            return;
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.setCustomParam(BIZAPPID, (Object)bizAppId);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack callBack = null;
        if (StringUtils.isBlank((CharSequence)svnMsg) || "undefined".equals(svnMsg)) {
            svnMsg = UUID.randomUUID().toString();
            plugin.getPageCache().put("old_svnmsg", plugin.getPageCache().get(SVNMSG));
            parameter.setFormId("bos_devp_svnlogin");
            parameter.setCaption(ResManager.loadKDString((String)"\u767b\u5f55SVN", (String)"BizPageOperationUtil_10", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]));
            callBack = new CloseCallBack((IFormPlugin)plugin, "svnlogincallback");
        } else {
            parameter.setFormId("bos_devp_svnchoose");
            parameter.setCustomParam(BIZID, (Object)formId);
            parameter.setCaption(ResManager.loadKDString((String)"\u7b7e\u5165SVN", (String)"BizPageOperationUtil_11", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]));
            parameter.setCustomParam("type", (Object)type);
            callBack = new CloseCallBack((IFormPlugin)plugin, "svncheckincallback");
        }
        plugin.getPageCache().put(SVNMSG, svnMsg);
        parameter.setCloseCallBack(callBack);
        plugin.getView().showForm(parameter);
    }

    public static void updatePage(JSONObject arg, AbstractFormPlugin plugin) {
        if (!AppUtils.checkResourceBelongsToCurDeveloper((String)ScriptOperationUtil.getCurrentBizAppId(plugin))) {
            plugin.getView().showTipNotification(AppUtils.getNoPermissionTips());
            return;
        }
        String formId = arg.getString(NODEID);
        plugin.getPageCache().put(FORMID, formId);
        plugin.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u5b9a\u4eceSVN\u66f4\u65b0\u5143\u6570\u636e?", (String)"BizPageOperationUtil_12", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("updateSVNCallBack"));
    }

    public static void updateSVNCallBack(String formId, AbstractFormPlugin plugin) {
        JSONObject msg = new JSONObject();
        String svnPath = AppUtils.getSVNPathByAppId((String)ScriptOperationUtil.getCurrentBizAppId(plugin));
        if (StringUtils.isBlank((CharSequence)svnPath)) {
            plugin.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u914d\u7f6eSVN\u8def\u5f84\u3002", (String)"BizPageOperationUtil_13", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]));
            return;
        }
        svnPath = svnPath + "/metadata";
        List list = MetadataDao.getFormDeployFile((String)formId);
        String localPath = AppUtils.USER_HOME + File.separator + "KINGDEEUPDATEDOWNLOAD";
        String checkLocalPath = AppUtils.checkFilePath((String)localPath);
        File filePath = new File(FileUtils.cleanString((String)checkLocalPath));
        if (!filePath.exists()) {
            filePath.mkdirs();
        }
        if (list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                String dymFileName = ((DeployFile)list.get(i)).getFileName();
                msg = SVNUtil.doExport((String)svnPath, (String)dymFileName, (File)filePath);
                String errMsg = msg.getString("ERROR");
                if (!StringUtils.isNotBlank((CharSequence)errMsg)) continue;
                AppUtils.deleteFile((String)localPath);
                plugin.getView().showMessage(errMsg);
                return;
            }
        }
        AppUtils.getMetadataContent((File)filePath, (JSONObject)msg);
        AppUtils.deleteFile((String)localPath);
        plugin.getView().showMessage(ResManager.loadKDString((String)"\u66f4\u65b0SVN\u5143\u6570\u636e\u6210\u529f\u3002", (String)"BizPageOperationUtil_14", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]));
    }

    public static void extendPage(JSONObject arg, AbstractFormPlugin plugin) {
        boolean isInHerit;
        String bizAppId = (String)plugin.getView().getFormShowParameter().getCustomParam(BIZAPPID);
        String formId = arg.getString(NODEID);
        DynamicObject formInfo = BusinessDataServiceHelper.loadSingle((Object)formId, (String)BOS_FORMMETA);
        boolean bl = isInHerit = formInfo == null || formInfo.getBoolean(ISINHERIT);
        if (!isInHerit) {
            plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u672c\u9875\u9762\u4e0d\u5141\u8bb8\u88ab\u7ee7\u627f\u3002", (String)"BizPageOperationUtil_22", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]));
            return;
        }
        QFilter qForm = new QFilter("form", "=", (Object)formId);
        DynamicObject unitInfo = QueryServiceHelper.queryOne((String)BOS_DEVPORTAL_UNITRELFORM, (String)BIZUNIT, (QFilter[])new QFilter[]{qForm});
        String bizUnitId = unitInfo.getString(BIZUNIT);
        FormShowParameter parameter = new FormShowParameter();
        if (formInfo != null) {
            String modeltype = formInfo.getString(MODELTYPE);
            String parentName = formInfo.getString("name");
            String parentNumber = formInfo.getString(NUMBER);
            parameter.setCustomParam(MODELTYPE, (Object)modeltype);
            parameter.setCustomParam("parentName", (Object)parentName);
            parameter.setCustomParam("parentNumber", (Object)parentNumber);
        }
        parameter.setFormId("bos_devp_pageinherit");
        parameter.setCustomParam(BAI, (Object)bizAppId);
        parameter.setCustomParam(BIZUNITID, (Object)bizUnitId);
        parameter.setCustomParam("parentId", (Object)formId);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCaption(ResManager.loadKDString((String)"\u7ee7\u627f\u9875\u9762", (String)"BizPageOperationUtil_15", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]));
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)plugin, "inheritPageWindowClose");
        parameter.setCloseCallBack(callBack);
        plugin.getView().showForm(parameter);
    }

    public static void copyPage(JSONObject arg, AbstractFormPlugin plugin) {
        String bizAppId = (String)plugin.getView().getFormShowParameter().getCustomParam(BIZAPPID);
        String formId = arg.getString(NODEID);
        DynamicObject formInfo = BusinessDataServiceHelper.loadSingle((Object)formId, (String)BOS_FORMMETA);
        QFilter qForm = new QFilter("form", "=", (Object)formId);
        DynamicObject unitInfo = QueryServiceHelper.queryOne((String)BOS_DEVPORTAL_UNITRELFORM, (String)BIZUNIT, (QFilter[])new QFilter[]{qForm});
        String bizUnitId = unitInfo.getString(BIZUNIT);
        String formName = formInfo.getString("name");
        String formNumber = formInfo.getString(NUMBER);
        FormShowParameter parameter = new FormShowParameter();
        String modelType = "";
        if (formInfo != null) {
            modelType = formInfo.getString(MODELTYPE);
        }
        if (StringUtils.equals((CharSequence)"PrintModel", (CharSequence)modelType)) {
            parameter.setFormId("bos_devportal_copypage");
        } else {
            parameter.setFormId("bos_devportal_formcopy");
        }
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam("pagename", (Object)formName);
        parameter.setCustomParam("pagenumber", (Object)formNumber);
        parameter.setCustomParam(BIZAPPID, (Object)bizAppId);
        parameter.setCustomParam(BIZUNITID, (Object)bizUnitId);
        parameter.setCustomParam("bizformid", (Object)formId);
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)plugin, "copyPageWindowClose");
        parameter.setCloseCallBack(callBack);
        plugin.getView().showForm(parameter);
    }

    public static void movePage(JSONObject arg, AbstractFormPlugin plugin) {
        String bizAppId = (String)plugin.getView().getFormShowParameter().getCustomParam(BIZAPPID);
        String formId = arg.getString(NODEID);
        DynamicObject formInfo = BusinessDataServiceHelper.loadSingle((Object)formId, (String)BOS_FORMMETA);
        QFilter qForm = new QFilter("form", "=", (Object)formId);
        DynamicObject unitInfo = QueryServiceHelper.queryOne((String)BOS_DEVPORTAL_UNITRELFORM, (String)BIZUNIT, (QFilter[])new QFilter[]{qForm});
        String bizUnitId = unitInfo.getString(BIZUNIT);
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("bos_devportal_movepage");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam(BIZAPPID, (Object)bizAppId);
        parameter.setCustomParam(BIZUNITID, (Object)bizUnitId);
        parameter.setCustomParam("bizformid", (Object)formId);
        parameter.setCustomParam("bizentityid", (Object)formInfo.getString("basedatafield"));
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)plugin, "movepagecallback");
        parameter.setCloseCallBack(callBack);
        plugin.getView().showForm(parameter);
        plugin.getPageCache().put(BIZUNITID, bizUnitId);
    }

    public static void importPage(JSONObject arg, AbstractFormPlugin plugin) {
        String bizAppId = (String)plugin.getView().getFormShowParameter().getCustomParam(BIZAPPID);
        String bizUnitId = arg.getString(NODEID);
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("bos_devp_importpage");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam(BIZUNITID, (Object)bizUnitId);
        parameter.setCustomParam(BIZAPPID, (Object)bizAppId);
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)plugin, "importpagecallback");
        parameter.setCloseCallBack(callBack);
        plugin.getView().showForm(parameter);
    }

    public static void exportPage(JSONObject arg, AbstractFormPlugin plugin) {
        String bizAppId = (String)plugin.getView().getFormShowParameter().getCustomParam(BIZAPPID);
        String bizFormid = arg.getString(NODEID);
        QFilter qForm = new QFilter("form", "=", (Object)bizFormid);
        DynamicObject unitInfo = QueryServiceHelper.queryOne((String)BOS_DEVPORTAL_UNITRELFORM, (String)BIZUNIT, (QFilter[])new QFilter[]{qForm});
        String bizUnitId = unitInfo.getString(BIZUNIT);
        DynamicObject formInfo = BusinessDataServiceHelper.loadSingle((Object)bizFormid, (String)BOS_FORMMETA);
        String bizFormNumber = formInfo.getString(NUMBER);
        FormShowParameter parameter = new FormShowParameter();
        parameter.setCaption(ResManager.loadKDString((String)"\u5bfc\u51fa\u9875\u9762", (String)"BizPageOperationUtil_16", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]));
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("bos_devp_exportsource");
        parameter.setCustomParam(BIZAPPID, (Object)bizAppId);
        parameter.setCustomParam(BIZUNITID, (Object)bizUnitId);
        parameter.setCustomParam(BIZID, (Object)bizFormid);
        parameter.setCustomParam("bizformnumber", (Object)bizFormNumber);
        parameter.setCustomParam("type", (Object)PAGETYPE);
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)plugin, "exportsourcecallback");
        parameter.setCloseCallBack(callBack);
        plugin.getView().showForm(parameter);
    }

    public static void printTemplate(JSONObject arg, AbstractFormPlugin plugin) {
        String bizAppId = (String)plugin.getView().getFormShowParameter().getCustomParam(BIZAPPID);
        String formId = arg.getString(NODEID);
        QFilter qForm = new QFilter("form", "=", (Object)formId);
        DynamicObject unitInfo = QueryServiceHelper.queryOne((String)BOS_DEVPORTAL_UNITRELFORM, (String)BIZUNIT, (QFilter[])new QFilter[]{qForm});
        String bizUnitId = unitInfo.getString(BIZUNIT);
        DynamicObject formInfo = BusinessDataServiceHelper.loadSingle((Object)formId, (String)BOS_FORMMETA);
        String entityId = formInfo.getString("basedatafield.id");
        String pageName = formInfo.getString("name");
        String pageNumber = formInfo.getString(NUMBER);
        plugin.getPageCache().put(BIZUNITID, bizUnitId);
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("bos_devp_pageprint");
        parameter.setCustomParam(BAI, (Object)bizAppId);
        parameter.setCustomParam(BIZUNITID, (Object)bizUnitId);
        parameter.setCustomParam("entityId", (Object)entityId);
        parameter.setCustomParam("pagename", (Object)pageName);
        parameter.setCustomParam("pagenumber", (Object)pageNumber);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCaption(ResManager.loadKDString((String)"\u6253\u5370\u9875\u9762", (String)"BizPageOperationUtil_17", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]));
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)plugin, "pringPageWindowClose");
        parameter.setCloseCallBack(callBack);
        plugin.getView().showForm(parameter);
    }

    public static void doLayout(JSONObject arg, AbstractFormPlugin plugin) {
        String bizAppId = (String)plugin.getView().getFormShowParameter().getCustomParam(BIZAPPID);
        String formId = arg.getString(NODEID);
        QFilter qForm = new QFilter("form", "=", (Object)formId);
        DynamicObject unitInfo = QueryServiceHelper.queryOne((String)BOS_DEVPORTAL_UNITRELFORM, (String)BIZUNIT, (QFilter[])new QFilter[]{qForm});
        String bizUnitId = unitInfo.getString(BIZUNIT);
        DynamicObject formInfo = BusinessDataServiceHelper.loadSingle((Object)formId, (String)BOS_FORMMETA);
        String modelType = formInfo.getString(MODELTYPE);
        String entityId = formInfo.getString("basedatafield.id");
        String pageName = formInfo.getString("name");
        String pageNumber = formInfo.getString(NUMBER);
        plugin.getPageCache().put(BIZUNITID, bizUnitId);
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("bos_devp_pagelayout");
        parameter.setCustomParam(BIZAPPID, (Object)bizAppId);
        parameter.setCustomParam(BIZUNITID, (Object)bizUnitId);
        parameter.setCustomParam(MODELTYPE, (Object)modelType);
        parameter.setCustomParam("entityid", (Object)entityId);
        parameter.setCustomParam("pagename", (Object)pageName);
        parameter.setCustomParam("pagenumber", (Object)pageNumber);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCaption(ResManager.loadKDString((String)"\u9875\u9762\u5e03\u5c40", (String)"BizPageOperationUtil_18", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]));
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)plugin, "layoutPageWindowClose");
        parameter.setCloseCallBack(callBack);
        plugin.getView().showForm(parameter);
    }

    public static void expandPage(JSONObject arg, AbstractFormPlugin plugin) {
        String formId = arg.getString(NODEID);
        String extbizAppId = ScriptOperationUtil.getCurrentBizAppId(plugin);
        QFilter qForm = new QFilter("form", "=", (Object)formId);
        DynamicObject unitInfo = QueryServiceHelper.queryOne((String)BOS_DEVPORTAL_UNITRELFORM, (String)BIZUNIT, (QFilter[])new QFilter[]{qForm});
        String bizUnitId = unitInfo.getString(BIZUNIT);
        DynamicObject formInfo = BusinessDataServiceHelper.loadSingle((Object)formId, (String)BOS_FORMMETA);
        String bizPageName = formInfo.getString("name");
        String bizPageNumber = formInfo.getString(NUMBER);
        String modelType = formInfo.getString(MODELTYPE);
        String entityId = formInfo.getString("basedatafield_id");
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("bos_devp_extappextpage");
        parameter.setCustomParam("extBizAppId", (Object)extbizAppId);
        parameter.setCustomParam("oriBizunitId", (Object)bizUnitId);
        parameter.setCustomParam("oriFormId", (Object)formId);
        parameter.setCustomParam("oriBizPageName", (Object)bizPageName);
        parameter.setCustomParam("oriBizPageNumber", (Object)bizPageNumber);
        parameter.setCustomParam("modelType", (Object)modelType);
        parameter.setCustomParam("entityid", (Object)entityId);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCaption(ResManager.loadKDString((String)"\u6269\u5c55\u9875\u9762", (String)"BizPageOperationUtil_19", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]));
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)plugin, "expandPageWindowClose");
        parameter.setCloseCallBack(callBack);
        plugin.getView().showForm(parameter);
    }

    public static void previewPage(JSONObject arg, AbstractFormPlugin plugin) {
        HashMap<String, String> map = new HashMap<String, String>(16);
        String nodeId = arg.getString(NODEID);
        DynamicObject formInfo = BusinessDataServiceHelper.loadSingle((Object)nodeId, (String)BOS_FORMMETA);
        String devType = formInfo.getString("type");
        if ("2".equals(devType)) {
            String masterId = formInfo.getString("masterid");
            DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)masterId, (String)BOS_FORMMETA, (String)"id,name,number,modeltype,basedatafield");
            if (obj != null) {
                map.put(FORMID, obj.getString("id"));
                map.put("formname", obj.getString("name"));
                map.put("formnumber", obj.getString(NUMBER));
                map.put(MODELTYPE, obj.getString(MODELTYPE));
                map.put("devtype", devType);
            }
        } else {
            map.put(FORMID, formInfo.getString("id"));
            map.put("formname", formInfo.getString("name"));
            map.put("formnumber", formInfo.getString(NUMBER));
            map.put(MODELTYPE, formInfo.getString(MODELTYPE));
            map.put("devtype", devType);
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("bos_devp_pagepreview");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParams(map);
        parameter.setCaption(ResManager.loadKDString((String)"\u9884\u89c8\u4e0e\u8c03\u8bd5", (String)"BizPageOperationUtil_20", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]));
        plugin.getView().showForm(parameter);
    }

    public static void pageView(JSONObject arg, AbstractFormPlugin plugin) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("bos_devportal_hierarchy");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam(FORMID, arg.get((Object)NODEID));
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)plugin, "viewcallback");
        parameter.setCloseCallBack(callBack);
        plugin.getView().showForm(parameter);
    }

    public static void debugPage(String debugPageId, AbstractFormPlugin plugin) {
        String prefix = UrlService.getDomainContextUrl();
        String url = String.format("%s/devtools/debug-page/?pageId=%s", prefix, debugPageId);
        plugin.getView().openUrl(url);
    }

    private static String configParamById(String nodeId, String nodeType, FormShowParameter parameter, AbstractFormPlugin plugin) {
        String bizAppId = (String)plugin.getView().getFormShowParameter().getCustomParam(BIZAPPID);
        String bizUnitId = "";
        if ("unit".equals(nodeType)) {
            parameter.setCustomParam("type", (Object)"unit");
            parameter.setCustomParam(BIZAPPID, (Object)bizAppId);
            parameter.setCustomParam(BIZUNITID, (Object)nodeId);
            bizUnitId = nodeId;
        } else if ("page".equals(nodeType)) {
            QFilter qFormId = new QFilter("form", "=", (Object)nodeId);
            DynamicObjectCollection pageInfo = QueryServiceHelper.query((String)BOS_DEVPORTAL_UNITRELFORM, (String)BIZUNIT, (QFilter[])new QFilter[]{qFormId});
            parameter.setCustomParam("type", (Object)"unit");
            parameter.setCustomParam(BIZAPPID, (Object)bizAppId);
            parameter.setCustomParam(BIZUNITID, ((DynamicObject)pageInfo.get(0)).get(BIZUNIT));
            bizUnitId = ((DynamicObject)pageInfo.get(0)).get(BIZUNIT).toString();
        } else if ("script".equals(nodeType)) {
            DynamicObject scriptInfo = BusinessDataServiceHelper.loadSingle((Object)nodeId, (String)"ide_pluginscript");
            parameter.setCustomParam("type", (Object)"unit");
            parameter.setCustomParam(BIZAPPID, (Object)bizAppId);
            parameter.setCustomParam(BIZUNITID, scriptInfo.get(BIZUNITID));
            bizUnitId = scriptInfo.get(BIZUNITID).toString();
        }
        return bizUnitId;
    }

    public static DynamicObject createRecycleBinFormData(String formId, String operation) {
        try {
            DynamicObject newDynamicObject = new DynamicObject();
            JSONObject obj = new JSONObject();
            List list = MetadataDao.getFormDeployFile((String)formId);
            if (list != null && list.size() > 0) {
                String dymMeta = ((DeployFile)list.get(0)).getFileContent();
                String dymFileName = ((DeployFile)list.get(0)).getFileName();
                obj.put(dymFileName, (Object)dymMeta);
                for (int i = 1; i < list.size(); ++i) {
                    String dymLangMeta = ((DeployFile)list.get(i)).getFileContent();
                    String dymLangFileName = ((DeployFile)list.get(i)).getFileName();
                    obj.put(dymLangFileName, (Object)dymLangMeta);
                }
                newDynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"bos_devp_recyclebin");
                String id = Uuid16.create().toString();
                newDynamicObject.set("id", (Object)id);
                newDynamicObject.set("delid", (Object)formId);
                newDynamicObject.set("delnumber", (Object)BusinessDataServiceHelper.loadSingle((Object)formId, (String)BOS_FORMMETA, (String)NUMBER).getString(NUMBER));
                newDynamicObject.set("operation", (Object)String.format(ResManager.loadKDString((String)"%s,\u5c06\u8868\u5355\u5220\u9664", (String)"BizPageOperationUtil_25", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]), operation));
                newDynamicObject.set("type", (Object)"form");
                newDynamicObject.set("operator", (Object)Long.valueOf(RequestContext.get().getUserId()));
                newDynamicObject.set("createdate", (Object)Timestamp.valueOf(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date())));
                newDynamicObject.set("deldata", (Object)obj);
            }
            return newDynamicObject;
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
    }
}

