/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.business.util;

import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.param.AppParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.orm.query.QFilter;
import kd.bos.param.service.IParameterHelperService;
import kd.bos.service.ServiceSvcFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;

public class DevportalVerify {
    public static final Log logger = LogFactory.getLog(DevportalVerify.class);
    public final String RESULT = "result";
    public final String USERNAME = "username";
    private static final String BOS_DEVPORTAL_BUSINESS = "bos-devportal-business";
    private static final String BOS_DEVPORTAL_BIZAPP = "bos_devportal_bizapp";

    public static Object getParameter(String item) {
        Map<String, Object> args = DevportalVerify.getSystemAppParameter();
        if (args.get(item) == null) {
            return null;
        }
        logger.info("DevportalVerify getParameter() param: " + item + " result: " + args.get(item));
        return args.get(item);
    }

    private static Map<String, Object> getSystemAppParameter() {
        AppParam param = new AppParam();
        param.setAppId("83bfebc800003dac");
        long rootOrgId = ((IParameterHelperService)ServiceSvcFactory.getService(IParameterHelperService.class)).getParamRootOrgId();
        param.setOrgId(Long.valueOf(rootOrgId));
        param.setViewType("15");
        HashMap map = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)param);
        if (map == null) {
            map = new HashMap(2);
        }
        return map;
    }

    public static boolean isApart() {
        String apart = "apart";
        String mode = (String)DevportalVerify.getParameter("dev_governance_mode");
        return apart.equals(mode);
    }

    public static String getBizAppId(JSONObject arg) {
        String bizAppId = arg.getString("bizappid");
        if (bizAppId == null && (bizAppId = arg.getString("appid")) == null) {
            String appId = arg.getString("id");
            QFilter qFilter = new QFilter("id", "=", (Object)appId);
            QFilter[] qFilters = new QFilter[]{qFilter};
            DynamicObject appInfo = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_formmeta", (QFilter[])qFilters);
            if (appInfo == null) {
                return null;
            }
            return appInfo.getString("bizappid");
        }
        logger.info("getBizAppId() appId: " + bizAppId);
        return bizAppId;
    }

    public static Set<String> getAppByUser(Long user) {
        HashSet<String> bizApp = new HashSet<String>(16);
        QFilter qFilter = new QFilter("creater", "=", (Object)user);
        QFilter[] qFilters = new QFilter[]{qFilter};
        String select = "id";
        Map apps = BusinessDataServiceHelper.loadFromCache((String)BOS_DEVPORTAL_BIZAPP, (String)select, (QFilter[])qFilters);
        for (Map.Entry app : apps.entrySet()) {
            String id;
            DynamicObject appInfo = (DynamicObject)app.getValue();
            if (appInfo == null || (id = appInfo.getString("id")) == null) continue;
            bizApp.add(id);
        }
        return bizApp;
    }

    public static String getBizNumber(JSONObject arg, String item) {
        String bizNumber = arg.getString("biznumber");
        if (StringUtils.equals((CharSequence)"gitoperate", (CharSequence)item)) {
            String bizId = arg.getString("id");
            bizNumber = MetadataDao.getNumberById((String)bizId);
        }
        logger.debug("getBizNumber() bizNumber: " + bizNumber);
        return bizNumber;
    }

    public static String getNoPermissionTip() {
        return ResManager.loadKDString((String)"\u62b1\u6b49\uff0c\u60a8\u6ca1\u6709\u5f00\u53d1\u5e73\u53f0\u4e0a\u8be5\u5e94\u7528\u7684\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"DevportalVerify_0", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]);
    }

    public static String getLockTip(String userName) {
        return String.format(ResManager.loadKDString((String)"\u8be5\u9875\u9762\u5df2\u88ab\u3010%s\u3011\u9501\u5b9a\u3002", (String)"DevportalVerify_1", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]), userName);
    }
}

