/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.business.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dataentity.utils.Uuid16;
import kd.bos.devportal.common.hosting.SVNUtil;
import kd.bos.devportal.common.util.AppUtils;
import kd.bos.encrypt.Encrypters;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.deploy.DeployFile;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.BasicAuthenticationManager;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.auth.SVNAuthentication;
import org.tmatesoft.svn.core.auth.SVNPasswordAuthentication;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.SVNRepositoryFactory;
import org.tmatesoft.svn.core.wc.SVNCommitClient;

public class ScriptOperationUtil {
    public static final String SCRIPTTYPE = "SCRIPT_TYPE";
    private static final Log logger = LogFactory.getLog((String)"ScriptOperationUtil");
    private static final String NODEID = "nodeid";
    private static final String NODETYPE = "nodetype";
    private static final String BIZAPPID = "bizappid";
    private static final String BOS_DEVPORTAL_BUSINESS = "bos-devportal-business";
    private static final String SCRIPT = "script";
    private static final String TXT_SCRIPTNAME = "txt_scriptname";
    private static final String IDE_PLUGINSCRIPT = "ide_pluginscript";
    private static final String TXT_SCRIPTNUMBER = "txt_scriptnumber";
    private static final String ERROR = "error";
    private static final String UNOPEN = "unopen";
    private static final String SCRIPTID = "scriptid";
    private static final String BIZUNITID = "bizunitid";
    private static final String NUMBER = "number";
    private static final String BIZUNIT = "bizunit";

    public static void addNewScript(JSONObject arg, AbstractFormPlugin plugin) {
        String nodeId = arg.getString(NODEID);
        String nodeType = arg.getString(NODETYPE);
        String appId = arg.getString(BIZAPPID);
        FormShowParameter parameter = new FormShowParameter();
        ScriptOperationUtil.configParamById(nodeId, nodeType, appId, parameter, plugin);
        parameter.setFormId("bos_devp_newscript");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, "newscriptcloseaction"));
        parameter.setCaption(ResManager.loadKDString((String)"\u65b0\u5efa\u63d2\u4ef6\u811a\u672c", (String)"ScriptOperationUtil_0", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]));
        parameter.setCustomParam("scene", (Object)"newscript");
        parameter.setCustomParam(NODEID, (Object)nodeId);
        plugin.getView().showForm(parameter);
        plugin.getPageCache().put(NODETYPE, nodeType);
        if ("page".equals(nodeType)) {
            plugin.getPageCache().put(NODEID, nodeId);
        }
    }

    public static void addNewBlankScript(JSONObject arg, AbstractFormPlugin plugin) {
        String nodeId = arg.getString(NODEID);
        String nodeType = arg.getString(NODETYPE);
        String appId = arg.getString(BIZAPPID);
        FormShowParameter parameter = new FormShowParameter();
        ScriptOperationUtil.configParamById(nodeId, nodeType, appId, parameter, plugin);
        parameter.setFormId("bos_devp_newblankscript");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, "newblankscriptcloseaction"));
        parameter.setCaption(ResManager.loadKDString((String)"\u65b0\u5efa\u5de5\u5177\u7c7b\u811a\u672c", (String)"ScriptOperationUtil_1", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]));
        plugin.getView().showForm(parameter);
        plugin.getPageCache().put(NODETYPE, nodeType);
        if ("page".equals(nodeType)) {
            plugin.getPageCache().put(NODEID, nodeId);
        }
    }

    public static void deleteScript(JSONObject arg, AbstractFormPlugin plugin) {
        String bizAppId = (String)plugin.getView().getFormShowParameter().getCustomParam(BIZAPPID);
        if (!AppUtils.checkResourceBelongsToCurDeveloper((String)bizAppId)) {
            plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5f00\u53d1\u5546\u6ca1\u6709\u8be5\u8d44\u6e90\u6743\u9650\u3002", (String)"ScriptOperationUtil_2", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]));
            return;
        }
        boolean isHasPermisson = AppUtils.checkPagePermission((String)"bos_devportal_bizpagelist", (String)"4715e1f1000000ac");
        if (!isHasPermisson) {
            plugin.getView().showMessage(ResManager.loadKDString((String)"\u6ca1\u6709\u6743\u9650\uff0c\u8bf7\u6dfb\u52a0\u6743\u9650\u540e\u518d\u8bd5\u3002", (String)"ScriptOperationUtil_3", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]));
            return;
        }
        String scriptId = arg.getString(NODEID);
        boolean checkDeleteResource = AppUtils.checkDeleteResource((String)scriptId, (String)bizAppId, (IFormView)plugin.getView(), (String)SCRIPT, (String)"KDE");
        if (!checkDeleteResource) {
            return;
        }
        String scriptName = BusinessDataServiceHelper.loadSingleFromCache((Object)scriptId, (String)IDE_PLUGINSCRIPT, (String)TXT_SCRIPTNAME).getString(TXT_SCRIPTNAME);
        String jSessionId = arg.getString("svnmsg");
        JSONArray scriptIds = new JSONArray();
        scriptIds.add((Object)scriptId);
        String scriptPos = arg.getString("scriptpos");
        plugin.getPageCache().put("scriptpos", scriptPos);
        plugin.getPageCache().put("formid", arg.getString("formid"));
        plugin.getPageCache().put("curdeletescriptid", scriptId);
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("bos_devportal_confirmdel");
        parameter.setCaption(ResManager.loadKDString((String)"\u5220\u9664\u811a\u672c", (String)"ScriptOperationUtil_4", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]));
        parameter.setCustomParam("message", (Object)String.format(ResManager.loadKDString((String)"\u662f\u5426\u786e\u5b9a\u5220\u9664\u811a\u672c\u201c%s\u201d\uff1f", (String)"ScriptOperationUtil_5", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]), scriptName));
        parameter.setCustomParam("source", (Object)scriptIds.toJSONString());
        parameter.setCustomParam("type", (Object)SCRIPT);
        parameter.setCustomParam(BIZAPPID, (Object)bizAppId);
        parameter.setCustomParam("jsessionid", (Object)jSessionId);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, "deleteScriptCloseCallBack"));
        plugin.getView().showForm(parameter);
    }

    public static String getNumberById(String scriptId) {
        ORM orm = ORM.create();
        String selectFields = "id,txt_scriptnumber";
        QFilter[] filter = new QFilter[]{new QFilter("id", "=", (Object)scriptId)};
        DynamicObject queryOne = orm.queryOne(IDE_PLUGINSCRIPT, selectFields, filter);
        return queryOne.getString(TXT_SCRIPTNUMBER);
    }

    public static JSONObject deleteScript(JSONObject svnMsg, JSONArray scriptIds) {
        String svnPath = svnMsg.getString("svnpath");
        String username = svnMsg.getString("username");
        String password = svnMsg.getString("password");
        String annotation = svnMsg.getString("annotation");
        SVNUtil.setupLibrary();
        SVNRepository repository = null;
        SVNURL repositoryURL = null;
        JSONObject commitSVNMsg = new JSONObject();
        ArrayList<String> list = new ArrayList<String>(3);
        for (int i = 0; i < scriptIds.size(); ++i) {
            String scriptId = scriptIds.getString(i);
            String scriptNumber = ScriptOperationUtil.getNumberById(scriptId);
            if (StringUtils.isNotBlank((Object)(svnMsg = SVNUtil.getClientManager((String)svnPath, (JSONObject)svnMsg)).get((Object)"ERROR"))) {
                return svnMsg;
            }
            SVNCommitClient commitClient = (SVNCommitClient)svnMsg.get((Object)"commitClient");
            commitClient.setIgnoreExternals(false);
            try {
                password = Encrypters.decode((String)password);
                repositoryURL = SVNURL.parseURIEncoded((String)svnPath);
                repository = SVNRepositoryFactory.create((SVNURL)repositoryURL);
                BasicAuthenticationManager authManager = new BasicAuthenticationManager(new SVNAuthentication[]{new SVNPasswordAuthentication(username, password, false, repositoryURL, false)});
                repository.setAuthenticationManager((ISVNAuthenticationManager)authManager);
            }
            catch (Exception e) {
                logger.error(e.getMessage());
            }
            list.add(String.format("%s/dbschema/%s_script.sql", svnPath, scriptNumber.toLowerCase()));
            list.add(String.format("%s/metadata/%s.js", svnPath, scriptNumber.toLowerCase()));
            list.add(String.format("%s/metadata/%s.ks", svnPath, scriptNumber.toLowerCase()));
            ArrayList oldDoc = new ArrayList();
            for (int j = 0; j < list.size(); ++j) {
                String svnUrl = (String)list.get(j);
                SVNUtil.checkSvnPath((String)svnUrl, (SVNRepository)repository, oldDoc, (JSONObject)commitSVNMsg);
            }
            list.clear();
            if (oldDoc.size() > 0) {
                SVNURL[] deleteUrls = new SVNURL[oldDoc.size()];
                for (int j = 0; j < oldDoc.size(); ++j) {
                    try {
                        String deleteUrl = (String)oldDoc.get(j);
                        deleteUrls[j] = SVNURL.parseURIEncoded((String)deleteUrl);
                        continue;
                    }
                    catch (SVNException e) {
                        commitSVNMsg.put(ERROR, (Object)e);
                    }
                }
                try {
                    commitClient.doDelete(deleteUrls, annotation);
                }
                catch (SVNException e) {
                    commitSVNMsg.put(ERROR, (Object)ResManager.loadKDString((String)"\u8bf7\u6821\u9a8c\u7528\u6237\u540d\u6216\u5bc6\u7801\u662f\u5426\u6b63\u786e\u3002", (String)"ScriptOperationUtil_7", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]));
                }
                continue;
            }
            commitSVNMsg.put(ERROR, (Object)ResManager.loadKDString((String)"svn\u811a\u672c\u4e0d\u5b58\u5728\uff0c\u8bf7\u52ff\u52fe\u9009\u3002", (String)"ScriptOperationUtil_8", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]));
        }
        return commitSVNMsg;
    }

    public static void moveScript(JSONObject arg, AbstractFormPlugin plugin) {
        if (arg.getBoolean(UNOPEN) != null && arg.getBoolean(UNOPEN).booleanValue()) {
            if (AppUtils.isScriptBeReferenced((String)arg.getString("id"))) {
                plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u811a\u672c\u5df2\u5f15\u7528\uff0c\u65e0\u6cd5\u79fb\u52a8\u3002", (String)"ScriptOperationUtil_9", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]));
                return;
            }
            DynamicObject scriptInfo = BusinessDataServiceHelper.loadSingle((Object)arg.getString("id"), (String)IDE_PLUGINSCRIPT);
            FormShowParameter parameter = new FormShowParameter();
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setFormId("bos_devp_scriptmoving");
            parameter.setCustomParam(SCRIPTID, (Object)arg.getString("id"));
            parameter.setCustomParam(BIZAPPID, scriptInfo.get(BIZAPPID));
            parameter.setCustomParam(BIZUNITID, scriptInfo.get(BIZUNITID));
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, "moveScriptCallBack"));
            plugin.getView().showForm(parameter);
            plugin.getPageCache().put(BIZUNITID, scriptInfo.getString(BIZUNITID));
        } else {
            String scriptId = arg.getString("id");
            String content = arg.getString("content");
            QFilter filter1 = new QFilter("id", "=", (Object)scriptId);
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)scriptId, (String)IDE_PLUGINSCRIPT);
            boolean exists = false;
            if (content != null && content.equals(dynamicObject.getString("txt_scriptcontext_tag"))) {
                exists = true;
            }
            if (exists) {
                if (AppUtils.isScriptBeReferenced((String)scriptId)) {
                    plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u811a\u672c\u5df2\u5f15\u7528\uff0c\u65e0\u6cd5\u79fb\u52a8\u3002", (String)"ScriptOperationUtil_9", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]));
                    return;
                }
                DynamicObject scriptInfo = QueryServiceHelper.queryOne((String)IDE_PLUGINSCRIPT, (String)"bizappid,bizunitid", (QFilter[])new QFilter[]{filter1});
                FormShowParameter parameter = new FormShowParameter();
                parameter.getOpenStyle().setShowType(ShowType.Modal);
                parameter.setFormId("bos_devp_scriptmoving");
                parameter.setCustomParam(SCRIPTID, (Object)scriptId);
                parameter.setCustomParam(BIZAPPID, scriptInfo.get(0));
                parameter.setCustomParam(BIZUNITID, scriptInfo.get(1));
                parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, "moveScriptCallBack"));
                plugin.getView().showForm(parameter);
                plugin.getPageCache().put(BIZUNITID, scriptInfo.getString(BIZUNITID));
            } else {
                plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u811a\u672c\u3002", (String)"ScriptOperationUtil_10", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]));
            }
        }
    }

    public static void renameScript(JSONObject arg, AbstractFormPlugin plugin) {
        if (arg.getBoolean(UNOPEN) != null && arg.getBoolean(UNOPEN).booleanValue()) {
            if (AppUtils.isScriptBeReferenced((String)arg.getString("id"))) {
                plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u811a\u672c\u5df2\u5f15\u7528\uff0c\u4e0d\u80fd\u8fdb\u884c\u91cd\u547d\u540d\u3002", (String)"ScriptOperationUtil_11", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]));
                return;
            }
            DynamicObject scriptInfo = BusinessDataServiceHelper.loadSingle((Object)arg.getString("id"), (String)IDE_PLUGINSCRIPT);
            FormShowParameter parameter = new FormShowParameter();
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setFormId("bos_devp_scriptrename");
            parameter.setCustomParam(SCRIPTID, (Object)arg.getString("id"));
            parameter.setCustomParam(NUMBER, scriptInfo.get(TXT_SCRIPTNUMBER));
            parameter.setCustomParam("name", scriptInfo.get(TXT_SCRIPTNAME));
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, "renameScriptCallBack"));
            plugin.getView().showForm(parameter);
        } else {
            String scriptId = arg.getString("id");
            DynamicObject scriptInfo = BusinessDataServiceHelper.loadSingle((Object)scriptId, (String)IDE_PLUGINSCRIPT);
            String content = arg.getString("content");
            String number = arg.getString(NUMBER);
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)scriptId, (String)IDE_PLUGINSCRIPT);
            boolean exists = false;
            if (content != null && content.equals(dynamicObject.getString("txt_scriptcontext_tag"))) {
                exists = true;
            }
            if (exists) {
                if (AppUtils.isScriptBeReferenced((String)scriptId)) {
                    plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u811a\u672c\u5df2\u5f15\u7528\uff0c\u4e0d\u80fd\u8fdb\u884c\u91cd\u547d\u540d\u3002", (String)"ScriptOperationUtil_11", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]));
                    return;
                }
                FormShowParameter parameter = new FormShowParameter();
                parameter.getOpenStyle().setShowType(ShowType.Modal);
                parameter.setFormId("bos_devp_scriptrename");
                parameter.setCustomParam(SCRIPTID, (Object)scriptId);
                parameter.setCustomParam(NUMBER, (Object)number);
                parameter.setCustomParam("name", scriptInfo.get(TXT_SCRIPTNAME));
                parameter.setCustomParam("description", scriptInfo.get("description"));
                parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, "renameScriptCallBack"));
                plugin.getView().showForm(parameter);
            } else {
                plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u811a\u672c\u3002", (String)"ScriptOperationUtil_10", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]));
            }
        }
    }

    public static void importScript(JSONObject arg, AbstractFormPlugin plugin) {
        String bizAppId = ScriptOperationUtil.getCurrentBizAppId(plugin);
        if (!AppUtils.checkResourceBelongsToCurDeveloper((String)bizAppId)) {
            plugin.getView().showTipNotification(AppUtils.getNoPermissionTips());
            return;
        }
        String bizUnitId = arg.getString(NODEID);
        FormShowParameter parameter = new FormShowParameter();
        parameter.setCustomParam(BIZAPPID, (Object)bizAppId);
        parameter.setCustomParam(BIZUNITID, (Object)bizUnitId);
        parameter.setFormId("bos_devp_scriptimport");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)plugin, "importscriptcallback");
        parameter.setCloseCallBack(callBack);
        plugin.getView().showForm(parameter);
    }

    public static void exportScript(JSONObject arg, AbstractFormPlugin plugin) {
        String bizAppId = plugin.getPageCache().get(BIZAPPID);
        DynamicObject scriptInfo = BusinessDataServiceHelper.loadSingle((Object)arg.getString("id"), (String)IDE_PLUGINSCRIPT);
        String scriptId = scriptInfo.getString("id");
        String scriptNumber = scriptInfo.getString(TXT_SCRIPTNUMBER);
        String bizUnitId = scriptInfo.getString(BIZUNITID);
        if (bizAppId == null) {
            bizAppId = scriptInfo.getString(BIZAPPID);
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.setCaption(ResManager.loadKDString((String)"\u5bfc\u51fa\u811a\u672c", (String)"ScriptOperationUtil_12", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]));
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("bos_devp_exportsource");
        parameter.setCustomParam(BIZAPPID, (Object)bizAppId);
        parameter.setCustomParam(BIZUNITID, (Object)bizUnitId);
        parameter.setCustomParam("bizid", (Object)scriptId);
        parameter.setCustomParam("bizformnumber", (Object)scriptNumber);
        parameter.setCustomParam("type", (Object)SCRIPTTYPE);
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)plugin, "exportsourcecallback");
        parameter.setCloseCallBack(callBack);
        plugin.getView().showForm(parameter);
    }

    public static void previewScriptDetail(JSONObject arg, AbstractFormPlugin plugin) {
        String scriptId = arg.getString(NODEID);
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("bos_devp_scriptdetails");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCaption(ResManager.loadKDString((String)"\u811a\u672c\u8be6\u60c5", (String)"ScriptOperationUtil_13", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]));
        parameter.setCustomParam(SCRIPTID, (Object)scriptId);
        plugin.getView().showForm(parameter);
    }

    private static String configParamById(String nodeId, String nodeType, String bizAppId, FormShowParameter parameter, AbstractFormPlugin plugin) {
        String bizUnitId = "";
        if ("unit".equals(nodeType)) {
            parameter.setCustomParam("type", (Object)"unit");
            parameter.setCustomParam(BIZAPPID, (Object)bizAppId);
            parameter.setCustomParam(BIZUNITID, (Object)nodeId);
            bizUnitId = nodeId;
        } else if ("page".equals(nodeType)) {
            QFilter qFormId = new QFilter("form", "=", (Object)nodeId);
            DynamicObjectCollection pageInfo = QueryServiceHelper.query((String)"bos_devportal_unitrelform", (String)BIZUNIT, (QFilter[])new QFilter[]{qFormId});
            parameter.setCustomParam("type", (Object)"unit");
            parameter.setCustomParam(BIZAPPID, (Object)bizAppId);
            parameter.setCustomParam(BIZUNITID, ((DynamicObject)pageInfo.get(0)).get(BIZUNIT));
            bizUnitId = ((DynamicObject)pageInfo.get(0)).get(BIZUNIT).toString();
        } else if (SCRIPT.equals(nodeType)) {
            DynamicObject scriptInfo = BusinessDataServiceHelper.loadSingle((Object)nodeId, (String)IDE_PLUGINSCRIPT);
            parameter.setCustomParam("type", (Object)"unit");
            parameter.setCustomParam(BIZAPPID, (Object)bizAppId);
            parameter.setCustomParam(BIZUNITID, scriptInfo.get(BIZUNITID));
            bizUnitId = scriptInfo.get(BIZUNITID).toString();
        }
        parameter.setCustomParam(NODETYPE, (Object)nodeType);
        return bizUnitId;
    }

    public static DynamicObject createRecycleBinScriptData(String scriptId, String operation) {
        try {
            List deployFileList = MetadataDao.getScriptDeployFile((String[])new String[]{scriptId});
            DeployFile df = (DeployFile)deployFileList.get(0);
            String content = df.getFileContent();
            DynamicObject newDynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"bos_devp_recyclebin");
            String id = Uuid16.create().toString();
            newDynamicObject.set("id", (Object)id);
            newDynamicObject.set("delid", (Object)scriptId);
            newDynamicObject.set("delnumber", (Object)BusinessDataServiceHelper.loadSingle((Object)scriptId, (String)IDE_PLUGINSCRIPT, (String)TXT_SCRIPTNUMBER).getString(TXT_SCRIPTNUMBER));
            newDynamicObject.set("operation", (Object)String.format(ResManager.loadKDString((String)"%s,\u5c06\u811a\u672c\u5220\u9664", (String)"ScriptOperationUtil_17", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]), operation));
            newDynamicObject.set("type", (Object)SCRIPT);
            newDynamicObject.set("operator", (Object)Long.valueOf(RequestContext.get().getUserId()));
            newDynamicObject.set("createdate", (Object)Timestamp.valueOf(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date())));
            newDynamicObject.set("deldata", (Object)content);
            return newDynamicObject;
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
    }

    public static String getCurrentBizAppId(AbstractFormPlugin plugin) {
        String bizAppId = plugin.getPageCache().get(BIZAPPID);
        if (bizAppId == null) {
            bizAppId = (String)plugin.getView().getFormShowParameter().getCustomParam(BIZAPPID);
        }
        return bizAppId;
    }
}

