/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.newdevportal.app;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.devportal.common.util.AppUtils;
import kd.bos.devportal.util.DevportalUtil;
import kd.bos.entity.devportal.AppFunctionPacketElement;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.container.Tab;
import kd.bos.form.container.TabPage;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.SelectRowsEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.mservice.svc.picture.IImage;
import kd.bos.mvc.cache.PageCache;
import kd.bos.newdevportal.entity.EntityDetailPlugIn;
import kd.bos.newdevportal.util.QueryUtils;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;

public class AppDetailPlugin
extends AbstractFormPlugin
implements RowClickEventListener,
SelectRowsEventListener {
    private static final String BIZ_UNIT_TREE = "bizUnitTree";
    private static final String BIZUNITCARDLIST = "bizunitcardlist";
    private static final String PARENT_NODE = "parentNode";
    private static final String ENTITYMANAGERENTITY = "entitymanagerentity";
    private static final String LAYOUTMANAGERENTITY = "layoutmanagerentity";
    private static final String OPEN_NODE = "openNode";
    private static final String BIZUNITCARDLIST_ROW = "bizunitcardlistrow";

    public void afterCreateNewData(EventObject e) {
        String id = (String)this.getView().getFormShowParameter().getCustomParam("pkId");
        if (id == null) {
            return;
        }
        DynamicObjectCollection formMetas = QueryUtils.getFormMetasByAppId(id);
        DynamicObjectCollection entityMetas = QueryUtils.getBaseOrBillEntityMetasByAppId(id);
        this.getModel().deleteEntryData(ENTITYMANAGERENTITY);
        this.getModel().setValue("entitycntval", (Object)entityMetas.size());
        DynamicObject appinfo = QueryUtils.getBizAppDetail(id);
        this.getModel().setValue("name", appinfo.get("name"));
        Label deploystatus = (Label)this.getControl("deploystatus");
        deploystatus.setText(this.toDeployStatusName(appinfo.getString("deploystatus")));
        if ("1".equals(appinfo.getString("deploystatus"))) {
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("fc", "#666666");
            this.getView().updateControlMetadata("deploystatus", paramMap);
        }
        Label type = (Label)this.getControl("type");
        type.setText(this.toTypeName(appinfo.getString("type")));
        if (StringUtils.isNotBlank((CharSequence)appinfo.getString("simplenumber"))) {
            this.getModel().setValue("simplenumber", (Object)String.format("(%s)", appinfo.getString("simplenumber")));
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"simplenumber"});
        }
        this.getModel().setValue("bizcloud", QueryUtils.getBizCloudName(appinfo.getString("bizcloud")).get("name"));
        IImage image = (IImage)this.getControl("imageAp");
        image.setUrl(appinfo.getString("image"));
        Tab tab = (Tab)this.getControl("tabap");
        TabPage entityPage = (TabPage)tab.getItems().get(0);
        TabPage formPage = (TabPage)tab.getItems().get(1);
        this.setTabPageCountInfo(entityPage, entityMetas.size());
        this.setTabPageCountInfo(formPage, formMetas.size());
        Map<String, DynamicObject> formMetaMap = formMetas.stream().collect(Collectors.toMap(s -> s.get("basedatafield").toString(), s -> s, (k1, k2) -> k1));
        if (!entityMetas.isEmpty()) {
            this.getModel().batchCreateNewEntryRow(ENTITYMANAGERENTITY, entityMetas.size());
            DynamicObjectCollection entityMetaGrid = this.getModel().getEntryEntity(ENTITYMANAGERENTITY);
            for (int i = 0; i < entityMetas.size(); ++i) {
                DynamicObject entityMeta = (DynamicObject)entityMetas.get(i);
                DynamicObject entityMetaRow = (DynamicObject)entityMetaGrid.get(i);
                entityMetaRow.set("entityname", entityMeta.get("name"));
                entityMetaRow.set("modeltype", entityMeta.get("modeltype"));
                entityMetaRow.set("entitynumber", entityMeta.get("number"));
                entityMetaRow.set("entitycreatedate", entityMeta.get("createdate"));
                try {
                    this.getModel().setValue("entitymodifier", formMetaMap.get(entityMeta.get("id")).get("modifierid"), i);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.showBizUnitList();
        this.showPageList();
    }

    private void refreshPageList() {
        String bizAppId = (String)this.getView().getFormShowParameter().getCustomParam("pkId");
        String thisUnit = this.getPageCache().get("bizunitid");
        JSONArray pageItems = DevportalUtil.getSelectedUnitPages((String)bizAppId, (String)thisUnit, null, null, null);
        ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("REFRESH_IMPORTPAGE_LIST", (Object)pageItems);
        ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("RESET_RESOURCEFILTER", (Object)new JSONArray());
        this.refreshListFormLayout(pageItems, thisUnit, bizAppId, "all", "AllFormModel", "number");
    }

    private void refreshListFormLayout(JSONArray pageArray, String bizUnitId, String bizAppId, String deviceType, String bizPageModelType, String sortBizPageGroupType) {
        if (this.getPageCache().get("pagelistpageid") != null) {
            String pageListPageId = this.getPageCache().get("pagelistpageid");
            IFormView view = this.getView().getView(pageListPageId);
            if (view != null) {
                view.getFormShowParameter().setCustomParam("tabledata", (Object)pageArray.toJSONString());
                IPageCache cache = (IPageCache)view.getService(IPageCache.class);
                cache.put("bizunitid", bizUnitId);
                cache.put("bizappid", bizAppId);
                cache.put("bizcloudid", this.getPageCache().get("bizCloudId"));
                cache.put("devicetype", deviceType);
                cache.put("pagetype", bizPageModelType);
                cache.put("sortrule", sortBizPageGroupType);
                view.getModel().beginInit();
                view.getModel().createNewData();
                view.getModel().endInit();
                view.updateView();
                this.getView().sendFormAction(view);
            }
        }
    }

    private void showBizUnitList() {
        JSONArray unitList = DevportalUtil.getUnitListData((String)((String)this.getView().getFormShowParameter().getCustomParam("pkId")));
        this.getPageCache().put("bizunitlist", unitList.toJSONString());
        TreeNode bizUnitTree = this.createBizUnitTree(unitList);
        this.getPageCache().put(BIZ_UNIT_TREE, SerializationUtils.toJsonString((Object)bizUnitTree));
        this.refreshBizUnitList(bizUnitTree);
    }

    private void refreshBizUnitList(TreeNode bizUnitTree) {
        int i;
        JSONArray actualUnitList = new JSONArray();
        List<String> openNodes = this.getPageCacheList(OPEN_NODE);
        bizUnitTree.iterate(10, t -> {
            boolean pass = false;
            if (StringUtils.isBlank((CharSequence)t.getId())) {
                pass = true;
            }
            String parentId = t.getParentid();
            if (!pass && StringUtils.isBlank((CharSequence)parentId)) {
                actualUnitList.add((Object)new JSONObject((Map)t.getData()));
                pass = true;
            }
            if (!pass && openNodes.contains(t.getParentid())) {
                actualUnitList.add((Object)new JSONObject((Map)t.getData()));
            }
        });
        this.getPageCache().put("actualUnitList", actualUnitList.toJSONString());
        this.getModel().deleteEntryData(BIZUNITCARDLIST);
        this.getModel().batchCreateNewEntryRow(BIZUNITCARDLIST, actualUnitList.size());
        DynamicObjectCollection bizUnitcardlist = this.getModel().getEntryEntity(BIZUNITCARDLIST);
        List<String> parentNodeIds = this.getPageCacheList(PARENT_NODE);
        List<String> openNodeIds = this.getPageCacheList(OPEN_NODE);
        CardEntry cardEntry = (CardEntry)this.getControl(BIZUNITCARDLIST);
        for (i = 0; i < actualUnitList.size(); ++i) {
            this.getModel().setValue("bizunitname", (Object)actualUnitList.getJSONObject(i).getString("name"), i);
            this.getModel().setValue("id", (Object)actualUnitList.getJSONObject(i).getString("id"), i);
        }
        for (i = 0; i < actualUnitList.size(); ++i) {
            cardEntry.setChildVisible(false, i, new String[]{"expand"});
            cardEntry.setChildVisible(false, i, new String[]{"collapsed"});
        }
        for (i = 0; i < actualUnitList.size(); ++i) {
            String id = actualUnitList.getJSONObject(i).getString("id");
            if (!parentNodeIds.contains(id)) continue;
            if (openNodeIds.contains(id)) {
                cardEntry.setChildVisible(true, i, new String[]{"collapsed"});
                continue;
            }
            cardEntry.setChildVisible(true, i, new String[]{"expand"});
        }
    }

    List<String> getPageCacheList(String key) {
        String str = this.getPageCache().get(key);
        if (str == null) {
            this.getPageCache().put(key, "[]");
            return new ArrayList<String>();
        }
        return (List)SerializationUtils.fromJsonString((String)str, List.class);
    }

    private TreeNode createBizUnitTree(JSONArray unitList) {
        boolean matched;
        TreeNode root = new TreeNode("", "", "root");
        Map<String, List<Object>> collect = unitList.stream().sorted(Comparator.comparing(s -> ((JSONObject)s).getInteger("seq"))).collect(Collectors.groupingBy(s -> ((JSONObject)s).getString("parentid")));
        ArrayList<String> deleteList = new ArrayList<String>(10);
        do {
            matched = false;
            for (Map.Entry<String, List<Object>> entry : collect.entrySet()) {
                TreeNode node = root.getTreeNode(entry.getKey(), 10);
                if (node == null) continue;
                node.setLeaf(false);
                node.addChildren(entry.getValue().stream().map(s -> this.toTreeNode((String)entry.getKey(), (JSONObject)s)).collect(Collectors.toList()));
                deleteList.add(entry.getKey());
                matched = true;
            }
            List<String> parentNodes = this.getPageCacheList(PARENT_NODE);
            parentNodes.addAll(deleteList);
            this.getPageCache().put(PARENT_NODE, SerializationUtils.toJsonString(parentNodes));
            deleteList.forEach(s -> {
                List cfr_ignored_0 = (List)collect.remove(s);
            });
            deleteList.clear();
        } while (matched);
        return root;
    }

    private TreeNode toTreeNode(String parentId, JSONObject s) {
        TreeNode node = new TreeNode(parentId, s.getString("id"), s.getString("name"), (Object)s);
        node.setLeaf(true);
        return node;
    }

    private void showPageList() {
        FormShowParameter parameter = new FormShowParameter();
        String pageListPageId = UUID.randomUUID().toString();
        parameter.setFormId("bos_devpn_pagelist");
        parameter.setPageId(pageListPageId);
        this.getPageCache().put("pagelistpageid", pageListPageId);
        parameter.getOpenStyle().setShowType(ShowType.InContainer);
        parameter.getOpenStyle().setTargetKey("pagelist");
        String bizAppId = (String)this.getView().getFormShowParameter().getCustomParam("pkId");
        JSONArray unitList = JSONArray.parseArray((String)this.getPageCache().get("bizunitlist"));
        JSONArray pageItems = DevportalUtil.getSelectedUnitPages((String)bizAppId, (String)unitList.getJSONObject(0).getString("id"), null, null, null);
        parameter.setCustomParam("tabledata", (Object)pageItems.toJSONString());
        PageCache iPageCache = new PageCache(pageListPageId);
        iPageCache.put("bizappid", (String)this.getView().getFormShowParameter().getCustomParam("pkId"));
        iPageCache.put("bizunitid", unitList.getJSONObject(0).getString("id"));
        this.getView().showForm(parameter);
    }

    private void setTabPageCountInfo(TabPage page, int size) {
        StringBuilder stringBuilder = new StringBuilder();
        if ("entitymanager".equals(page.getKey())) {
            stringBuilder.append(ResManager.loadKDString((String)"\u5b9e\u4f53\u7ba1\u7406", (String)"AppDetailPlugin_0", (String)"bos-devportal-new-plugin", (Object[])new Object[0]));
        } else if ("formmanager".equals(page.getKey())) {
            stringBuilder.append(ResManager.loadKDString((String)"\u9875\u9762\u7ba1\u7406", (String)"AppDetailPlugin_1", (String)"bos-devportal-new-plugin", (Object[])new Object[0]));
        }
        stringBuilder.append(String.format(" (%d)", size));
        page.setText(new LocaleString(stringBuilder.toString()));
    }

    private String toDeployStatusName(String deployStatus) {
        if (StringUtils.isBlank((CharSequence)deployStatus)) {
            return deployStatus;
        }
        Integer integer = Integer.parseInt(deployStatus);
        if (integer.equals(1)) {
            return ResManager.loadKDString((String)"\u25cf \u672a\u542f\u7528", (String)"AppDetailPlugin_2", (String)"bos-devportal-new-plugin", (Object[])new Object[0]);
        }
        if (integer.equals(2)) {
            return ResManager.loadKDString((String)"\u25cf \u5df2\u542f\u7528", (String)"AppDetailPlugin_3", (String)"bos-devportal-new-plugin", (Object[])new Object[0]);
        }
        return deployStatus;
    }

    private String toTypeName(String type) {
        if (StringUtils.isBlank((CharSequence)type)) {
            return type;
        }
        Integer integer = Integer.parseInt(type);
        if (integer.equals(0)) {
            return ResManager.loadKDString((String)"\u539f\u5382", (String)"AppDetailPlugin_4", (String)"bos-devportal-new-plugin", (Object[])new Object[0]);
        }
        if (integer.equals(2)) {
            return ResManager.loadKDString((String)"\u6269\u5c55", (String)"AppDetailPlugin_5", (String)"bos-devportal-new-plugin", (Object[])new Object[0]);
        }
        return type;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTITYMANAGERENTITY);
        entryGrid.addRowClickListener((RowClickEventListener)this);
        CardEntry cardEntry = (CardEntry)this.getControl(BIZUNITCARDLIST);
        cardEntry.addRowClickListener((RowClickEventListener)this);
        this.addClickListeners(new String[]{"expand", "collapsed", "modifybizunit", "addbizunit"});
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        String r = this.getPageCache().get(BIZUNITCARDLIST_ROW);
        Integer row = r == null ? 0 : Integer.parseInt(r);
        TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(BIZ_UNIT_TREE), TreeNode.class);
        List<String> openNodeIds = this.getPageCacheList(OPEN_NODE);
        if ("expand".equals(key)) {
            openNodeIds.add(this.getModel().getValue("id", row.intValue()).toString());
            this.getPageCache().put(OPEN_NODE, SerializationUtils.toJsonString(openNodeIds));
            this.refreshBizUnitList(root);
        } else if ("collapsed".equals(key)) {
            openNodeIds.removeIf(s -> this.getModel().getValue("id", row.intValue()).toString().equals(s));
            this.getPageCache().put(OPEN_NODE, SerializationUtils.toJsonString(openNodeIds));
            this.refreshBizUnitList(root);
        } else if ("modifybizunit".equals(key)) {
            String bizAppId = (String)this.getView().getFormShowParameter().getCustomParam("pkId");
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId("bos_devp_metadataunit");
            parameter.setCustomParam("bizappid", (Object)bizAppId);
            this.getPageCache().put("bizappid", bizAppId);
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "unitWindowClose");
            parameter.setCloseCallBack(callBack);
            parameter.setCaption(ResManager.loadKDString((String)"\u4fee\u6539\u529f\u80fd\u5206\u7ec4", (String)"AppDetailPlugin_6", (String)"bos-devportal-new-plugin", (Object[])new Object[0]));
            parameter.setStatus(OperationStatus.EDIT);
            parameter.setCustomParam("thisunitid", (Object)this.getModel().getValue("id", row.intValue()).toString());
            this.getView().showForm(parameter);
        } else if ("addbizunit".equals(key)) {
            String bizAppId = (String)this.getView().getFormShowParameter().getCustomParam("pkId");
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId("bos_devp_metadataunit");
            parameter.setCustomParam("bizappid", (Object)bizAppId);
            this.getPageCache().put("bizappid", bizAppId);
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "unitWindowClose");
            parameter.setCloseCallBack(callBack);
            parameter.setCaption(ResManager.loadKDString((String)"\u65b0\u589e\u529f\u80fd\u5206\u7ec4", (String)"AppDetailPlugin_7", (String)"bos-devportal-new-plugin", (Object[])new Object[0]));
            parameter.setStatus(OperationStatus.ADDNEW);
            String selectedUnitId = this.getModel().getValue("id", row.intValue()).toString();
            TreeNode node = root.getTreeNode(selectedUnitId, 10);
            if (StringUtils.isNotBlank((CharSequence)node.getParentid())) {
                String parentName = root.getTreeNode(node.getParentid(), 10).getText();
                parameter.setCustomParam("parentunitname", (Object)parentName);
                parameter.setCustomParam("parentunitid", (Object)node.getParentid());
            }
            this.getView().showForm(parameter);
        }
    }

    private void deleteUnitConfirm(JSONObject arg) {
        String bizUnitId = arg.getString("bizunitid");
        String bizAppId = arg.getString("bizappid");
        if (!AppUtils.checkResourceBelongsToCurDeveloper((String)bizAppId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5f00\u53d1\u5546\u6ca1\u6709\u8be5\u8d44\u6e90\u6743\u9650\u3002", (String)"AppDetailPlugin_8", (String)"bos-devportal-new-plugin", (Object[])new Object[0]));
            return;
        }
        Boolean isParentUnit = this.isParentUnit(bizUnitId, bizAppId);
        if (isParentUnit.booleanValue()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u529f\u80fd\u5206\u7ec4\u5305\u542b\u5b50\u8282\u70b9\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"AppDetailPlugin_9", (String)"bos-devportal-new-plugin", (Object[])new Object[0]));
            return;
        }
        Boolean hasPageList = this.hasPageList(bizUnitId);
        if (hasPageList.booleanValue()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u529f\u80fd\u5206\u7ec4\u5305\u542b\u9875\u9762\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"AppDetailPlugin_10", (String)"bos-devportal-new-plugin", (Object[])new Object[0]));
            return;
        }
        Boolean hasScriptList = this.hasScriptList(bizUnitId);
        if (hasScriptList.booleanValue()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u529f\u80fd\u5206\u7ec4\u5305\u542b\u811a\u672c\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"AppDetailPlugin_11", (String)"bos-devportal-new-plugin", (Object[])new Object[0]));
            return;
        }
        String bizUnitName = arg.getString("bizunitname");
        this.getPageCache().put("bizunitid", bizUnitId);
        this.getPageCache().put("bizappid", bizAppId);
        this.getView().showConfirm(MessageFormat.format(ResManager.loadKDString((String)"\u786e\u5b9a\u5220\u9664{0}?", (String)"AppDetailPlugin_12", (String)"bos-devportal-new-plugin", (Object[])new Object[0]), bizUnitName), MessageBoxOptions.YesNo, new ConfirmCallBackListener("unitDeleteCallBack"));
    }

    private Boolean hasScriptList(String bizUnitId) {
        QFilter q = new QFilter("bizunitid", "=", (Object)bizUnitId);
        QFilter[] filters = new QFilter[]{q};
        return QueryServiceHelper.exists((String)"ide_pluginscript", (QFilter[])filters);
    }

    private Boolean hasPageList(String bizUnitId) {
        ORM orm = ORM.create();
        QFilter f1 = new QFilter("bizunit", "=", (Object)bizUnitId);
        QFilter[] filter = new QFilter[]{f1};
        return orm.exists("bos_devportal_unitrelform", filter);
    }

    private void deleteUnit(String bizUnitId) {
        String firstUnitId;
        String bizAppId = this.getPageCache().get("bizappid");
        AppMetaServiceHelper.deleteFunctionPacketById((String)bizUnitId, (String)bizAppId);
        MultiLangEnumBridge opName = new MultiLangEnumBridge("\u5220\u9664", "AppDetailPlugin_13", "bos-devportal-new-plugin");
        MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u5220\u9664\u529f\u80fd\u5206\u7ec4", "AppDetailPlugin_14", "bos-devportal-new-plugin");
        AppUtils.addOpLog((String)"bos_devportal_bizunit", (String)"delete", (String)"bos_devportal_bizunit", (String)"1", (MultiLangEnumBridge)opName, (MultiLangEnumBridge)opDesc, (String[])new String[0]);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f!", (String)"AppDetailPlugin_15", (String)"bos-devportal-new-plugin", (Object[])new Object[0]));
        AppMetadata appMetadata = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)bizAppId, (boolean)false);
        String type = appMetadata.getDevType();
        if ("2".equals(type)) {
            bizAppId = appMetadata.getParentId();
        }
        if ((firstUnitId = this.getFirstUnitId(bizAppId)).trim().length() == 0) {
            return;
        }
        JSONObject selectedUnit = new JSONObject();
        JSONObject selectedUnitName = new JSONObject();
        selectedUnit.put("selectedUnit", (Object)firstUnitId);
        AppFunctionPacketElement func = AppMetaServiceHelper.getFunctionPacketById((String)firstUnitId, (String)bizAppId, (boolean)false);
        String firstUnitName = func.getName().getLocaleValue();
        selectedUnitName.put("selectedUnitName", (Object)firstUnitName);
        ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("INIT_SELECTEDUNITID", (Object)selectedUnit);
        ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("INIT_SELECTEDUNITNAME", (Object)selectedUnitName);
        JSONArray pageItems = this.getPageList(bizAppId, firstUnitId);
        JSONObject arg = new JSONObject();
        arg.put("bizunitid", (Object)firstUnitId);
        arg.put("bizappid", (Object)bizAppId);
        ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("REFRESH_IMPORTPAGE_LIST", (Object)pageItems);
        this.refreshListFormLayout(pageItems, bizUnitId, bizAppId, "all", "AllFormModel", "number");
    }

    private String getFirstUnitId(String bizAppId) {
        String firstUnitId = "";
        AppMetadata metadata = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)bizAppId, (boolean)false);
        if (metadata.getAppFunctionPackets().size() > 0) {
            firstUnitId = ((AppFunctionPacketElement)metadata.getAppFunctionPackets().get(0)).getId();
        }
        return firstUnitId;
    }

    public JSONArray getPageList(String bizAppId, String bizUnitId) {
        AppFunctionPacketElement unitObject = AppMetaServiceHelper.getFunctionPacketById((String)bizUnitId, (String)bizAppId, (boolean)false);
        if (unitObject == null) {
            return null;
        }
        String unitType = null;
        if (unitObject != null && " ".equals(unitType = unitObject.getType())) {
            unitType = "1";
        }
        QFilter unitRelFormFilter = new QFilter("bizunit", "=", (Object)bizUnitId);
        QFilter unitRelFormFilter_1 = new QFilter("bizapp", "=", (Object)bizAppId);
        QFilter[] unitRelFormFilters = new QFilter[]{unitRelFormFilter, unitRelFormFilter_1};
        String unitrelformFields = "bizapp,bizunit,form";
        String formMetaFields = "id,number,name,modeltype,version,basedatafield,type,parentid,createdate,modifydate,modifierid,masterid,isextended,enabled";
        QFilter[] formMetaFilters = new QFilter[]{new QFilter("bizappid", "=", (Object)bizAppId)};
        long userId = Long.parseLong(RequestContext.get().getUserId());
        QFilter shortcutFilter = new QFilter("user", "=", (Object)userId);
        QFilter[] shortcutFilters = new QFilter[]{shortcutFilter};
        String shortcutFields = "bizapp,bizpage";
        String orderby = "number asc";
        JSONArray pageArray = null;
        try (DataSet unitRelFormDataSet = QueryServiceHelper.queryDataSet((String)"bos_devportal_unitrelform", (String)"bos_devportal_unitrelform", (String)unitrelformFields, (QFilter[])unitRelFormFilters, (String)"form asc");
             DataSet formMetaDataSet = QueryServiceHelper.queryDataSet((String)"bos_formmeta", (String)"bos_formmeta", (String)formMetaFields, (QFilter[])formMetaFilters, (String)"number asc");
             DataSet shortcutDataSet = QueryServiceHelper.queryDataSet((String)"bos_devportal_shortcut", (String)"bos_devportal_shortcut", (String)shortcutFields, (QFilter[])shortcutFilters, (String)"bizpage asc");){
            pageArray = DevportalUtil.getPageListSQL((String)bizAppId, (String)unitType, (DataSet)unitRelFormDataSet, (DataSet)formMetaDataSet, (DataSet)shortcutDataSet, (String)orderby, (boolean)false);
        }
        return pageArray;
    }

    private Boolean isParentUnit(String bizUnitId, String bizAppId) {
        return this.getPageCacheList(PARENT_NODE).contains(bizUnitId);
    }

    public void entryRowClick(RowClickEvent evt) {
        Control control = (Control)evt.getSource();
        if (ENTITYMANAGERENTITY.equals(control.getKey())) {
            this.getPageCache().put("entityoperationcol", String.valueOf(evt.getRow()));
        } else if (BIZUNITCARDLIST.equals(control.getKey())) {
            this.getPageCache().put(BIZUNITCARDLIST_ROW, String.valueOf(evt.getRow()));
            this.getPageCache().put("bizunitid", this.getModel().getValue("id", evt.getRow()).toString());
            this.refreshPageList();
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        if ("edit".equals(afterDoOperationEventArgs.getOperateKey()) && this.getPageCache().get("entityoperationcol") != null) {
            Integer entityrow = Integer.parseInt(this.getPageCache().get("entityoperationcol"));
            this.getPageCache().remove("entityoperationcol");
            String entityNumber = (String)this.getModel().getValue("entitynumber", entityrow.intValue());
            String bizAppId = (String)this.getView().getFormShowParameter().getCustomParam("pkId");
            FormShowParameter param = EntityDetailPlugIn.show(bizAppId, entityNumber);
            this.getView().showForm(param);
        }
    }
}

