/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.newdevportal.app;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.devportal.util.DevportalUtil;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IConfirmCallBack;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;

public class BizAppInheritPlugin
extends AbstractFormPlugin
implements RowClickEventListener,
IConfirmCallBack {
    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btnok"});
        this.addClickListeners(new String[]{"btncancel"});
    }

    public void afterCreateNewData(EventObject e) {
        List appIdInfos = BizAppServiceHelp.getSysAppsRuntimeInfoGroupByCloud();
        Map<String, Map<String, String>> apps = this.transferApp(appIdInfos);
        this.getView().getPageCache().put("apps", SerializationUtils.toJsonString(apps));
        IDataModel dataModel = this.getModel();
        this.getModel().batchCreateNewEntryRow("entryentity", apps.size());
        int i = 0;
        Set<Map.Entry<String, Map<String, String>>> appsEntry = apps.entrySet();
        for (Map.Entry<String, Map<String, String>> entry : appsEntry) {
            Map<String, String> singleAppObj = entry.getValue();
            if (singleAppObj instanceof Map) {
                Map<String, String> element = singleAppObj;
                dataModel.setValue("number", (Object)element.get("number"), i);
                dataModel.setValue("name", (Object)element.get("name"), i);
                dataModel.setValue("bizcloud", (Object)element.get("bizcloud"), i);
            }
            ++i;
        }
    }

    private Map<String, Map<String, String>> transferApp(List<String> allApp) {
        if (allApp == null || allApp.isEmpty()) {
            return Collections.EMPTY_MAP;
        }
        HashMap<String, Map<String, String>> appResult = new HashMap<String, Map<String, String>>(16);
        for (String singleCloudStr : allApp) {
            JSONObject singleCloud;
            JSONObject cloudJson;
            if (StringUtils.isEmpty((CharSequence)singleCloudStr) || (cloudJson = (singleCloud = JSONObject.parseObject((String)singleCloudStr)).getJSONObject("cloudinfo")) == null) continue;
            String bizcloud = cloudJson.getString("name");
            String bizcloudId = cloudJson.getString("id");
            String bizcloudNumber = cloudJson.getString("number");
            JSONArray appArray = singleCloud.getJSONArray("appsinfo");
            for (int i = 0; i < appArray.size(); ++i) {
                HashMap<String, String> singleAppMap = new HashMap<String, String>(6);
                String singleAppStr = (String)appArray.get(i);
                JSONObject singleApp = JSONObject.parseObject((String)singleAppStr);
                String appNumber = singleApp.getString("number");
                JSONObject names = singleApp.getJSONObject("name");
                String name = names.getString("zh_CN");
                String bizappid = singleApp.getString("id");
                if (bizcloud == null || appNumber == null || name == null) continue;
                singleAppMap.put("number", appNumber);
                singleAppMap.put("name", name);
                singleAppMap.put("bizcloud", bizcloud);
                singleAppMap.put("bizcloudid", bizcloudId);
                singleAppMap.put("bizcloudnumber", bizcloudNumber);
                singleAppMap.put("bizappid", bizappid);
                appResult.put(appNumber, singleAppMap);
            }
        }
        return appResult;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        if ("inhnumber".equals(propertyName)) {
            String sourceNum = (String)e.getChangeSet()[0].getNewValue();
            sourceNum = DevportalUtil.autoIsvNumber((String)sourceNum);
            this.getModel().beginInit();
            this.getModel().setValue("inhnumber", (Object)sourceNum);
            this.getModel().endInit();
        }
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey().toLowerCase(Locale.ENGLISH)) {
            case "btnok": {
                this.btnok();
                break;
            }
            case "btncancel": {
                this.cancel();
                break;
            }
        }
    }

    private void cancel() {
        this.getView().close();
    }

    private void btnok() {
        String appNumber = (String)this.getModel().getValue("number");
        String appsCache = this.getPageCache().get("apps");
        Map allAppMap = (Map)JSONObject.parseObject((String)appsCache, Map.class);
        Map selectedApp = (Map)allAppMap.get(appNumber);
        String appName = (String)this.getModel().getValue("name");
        String bizcloudName = (String)this.getModel().getValue("bizcloud");
        String bizAppId = (String)selectedApp.get("bizappid");
        String bizCloudNumber = (String)selectedApp.get("bizcloudnumber");
        String bizCloudId = (String)selectedApp.get("bizcloudid");
        String countNumber = DevportalUtil.getParallelExtCountByIsv((String)bizAppId, (String)"bos_devportal_bizapp", (String)"parentid");
        if (!"0".equals(countNumber)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5e94\u7528\u4ec5\u53ef\u6269\u5c551\u6b21\u3002", (String)"BizAppInheritPlugin_0", (String)"bos-devportal-new-plugin", (Object[])new Object[0]));
            return;
        }
        BaseShowParameter parameter = new BaseShowParameter();
        parameter.setFormId("bos_devportal_bizapp");
        parameter.setCustomParam("bizcloudid", (Object)bizCloudId);
        parameter.setCustomParam("bizcloudnumber", (Object)bizCloudNumber);
        parameter.setCustomParam("apptype", (Object)"EXTEND_APP");
        parameter.setCustomParam("bizappid", (Object)bizAppId);
        parameter.setStatus(OperationStatus.ADDNEW);
        parameter.setCaption(ResManager.loadKDString((String)"\u6269\u5c55\u5e94\u7528", (String)"BizAppInheritPlugin_1", (String)"bos-devportal-new-plugin", (Object[])new Object[0]));
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "appExtendsWindowClose"));
        this.getPageCache().put("bizcloudid", bizCloudId);
        this.getView().showForm((FormShowParameter)parameter);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        if ("appExtendsWindowClose".equals(e.getActionId())) {
            this.getView().returnDataToParent(e.getReturnData());
            this.getView().close();
        }
    }
}

