/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.newdevportal.app;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.isv.ISVService;
import kd.bos.newdevportal.util.QueryUtils;

public class MyAppCardList
extends AbstractFormPlugin
implements RowClickEventListener {
    private static final String ENTRYENTITY = "entryentity";
    private String isv = ISVService.getISVInfo().getId();

    public void afterCreateNewData(EventObject e) {
        this.init();
    }

    private String[] getStringArray(DynamicObjectCollection appInfos, String number) {
        return appInfos.stream().map(s -> s.getString(number)).collect(Collectors.toList()).toArray(new String[0]);
    }

    private void init() {
        DynamicObjectCollection appInfos = null;
        String formShowParameter = this.getPageCache().get("FormShowParameter");
        JSONObject parseObject = JSONArray.parseObject((String)formShowParameter);
        JSONObject openStyle = parseObject.getJSONObject("OpenStyle");
        Object targetKey = openStyle.get((Object)"TargetKey");
        appInfos = targetKey.equals("original") ? QueryUtils.getBizAppsByType("0") : (targetKey.equals("expand") ? QueryUtils.getBizAppsByType("2") : QueryUtils.getBizAppsByIsv(this.isv));
        DynamicObjectCollection appCloudInfos = QueryUtils.getBizCloudNames(this.getStringArray(appInfos, "bizcloud"));
        this.getModel().deleteEntryData(ENTRYENTITY);
        if (appInfos.size() > 0) {
            this.getModel().batchCreateNewEntryRow(ENTRYENTITY, appInfos.size());
        }
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRYENTITY);
        DynamicObjectType dt = entryEntity.getDynamicObjectType();
        for (int i = 0; i < appInfos.size(); ++i) {
            DynamicObject appinfo = (DynamicObject)appInfos.get(i);
            DynamicObject target = (DynamicObject)entryEntity.get(i);
            target.set((IDataEntityProperty)dt.getProperty("id"), appinfo.get("id"));
            DynamicObjectCollection formMetas = QueryUtils.getFormMetasByAppId((String)appinfo.get("id"));
            int forms = formMetas.size();
            target.set((IDataEntityProperty)dt.getProperty("appname"), appinfo.get("name"));
            target.set((IDataEntityProperty)dt.getProperty("number"), (Object)String.format(ResManager.loadKDString((String)"\u7f16\u7801\uff1a%s", (String)"MyAppCardList_0", (String)"bos-devportal-new-plugin", (Object[])new Object[0]), appinfo.get("number")));
            target.set((IDataEntityProperty)dt.getProperty("version"), (Object)String.format(ResManager.loadKDString((String)"\u7248\u672c\uff1a%s", (String)"MyAppCardList_1", (String)"bos-devportal-new-plugin", (Object[])new Object[0]), appinfo.get("version")));
            target.set((IDataEntityProperty)dt.getProperty("forms"), (Object)String.format(ResManager.loadKDString((String)"\u9875\u9762\uff1a%s", (String)"MyAppCardList_2", (String)"bos-devportal-new-plugin", (Object[])new Object[0]), String.valueOf(forms)));
            if (appinfo.get("type").equals("0")) {
                target.set((IDataEntityProperty)dt.getProperty("type"), (Object)ResManager.loadKDString((String)"\u539f\u5382", (String)"MyAppCardList_3", (String)"bos-devportal-new-plugin", (Object[])new Object[0]));
            } else {
                target.set((IDataEntityProperty)dt.getProperty("type"), (Object)ResManager.loadKDString((String)"\u6269\u5c55", (String)"MyAppCardList_4", (String)"bos-devportal-new-plugin", (Object[])new Object[0]));
            }
            if (appinfo.get("deploystatus").equals("2")) {
                target.set((IDataEntityProperty)dt.getProperty("deploystatus"), (Object)ResManager.loadKDString((String)"\u5df2\u542f\u7528", (String)"MyAppCardList_5", (String)"bos-devportal-new-plugin", (Object[])new Object[0]));
                continue;
            }
            target.set((IDataEntityProperty)dt.getProperty("deploystatus"), (Object)ResManager.loadKDString((String)"\u672a\u542f\u7528", (String)"MyAppCardList_6", (String)"bos-devportal-new-plugin", (Object[])new Object[0]));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        DynamicObject cloud = (DynamicObject)this.getModel().getValue("cloud");
        String cloudId = "";
        if (cloud != null) {
            cloudId = cloud.getString("id");
        }
        String formShowParameter = this.getPageCache().get("FormShowParameter");
        JSONObject parseObject = JSONArray.parseObject((String)formShowParameter);
        JSONObject openStyle = parseObject.getJSONObject("OpenStyle");
        Object targetKey = openStyle.get((Object)"TargetKey");
        DynamicObjectCollection appInfos = null;
        appInfos = targetKey.equals("original") ? QueryUtils.getBizAppsByBizCloudAndType(cloudId, "0") : (targetKey.equals("expand") ? QueryUtils.getBizAppsByBizCloudAndType(cloudId, "2") : QueryUtils.getBizAppsByBizCloud(cloudId, this.isv));
        DynamicObjectCollection appCloudInfos = QueryUtils.getBizCloudNames(this.getStringArray(appInfos, "bizcloud"));
        this.getModel().deleteEntryData(ENTRYENTITY);
        if (appInfos.size() > 0) {
            this.getModel().batchCreateNewEntryRow(ENTRYENTITY, appInfos.size());
        }
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRYENTITY);
        DynamicObjectType dt = entryEntity.getDynamicObjectType();
        for (int i = 0; i < appInfos.size(); ++i) {
            DynamicObject appinfo = (DynamicObject)appInfos.get(i);
            DynamicObject target = (DynamicObject)entryEntity.get(i);
            target.set((IDataEntityProperty)dt.getProperty("id"), appinfo.get("id"));
            DynamicObjectCollection formMetas = QueryUtils.getFormMetasByAppId((String)appinfo.get("id"));
            int forms = formMetas.size();
            target.set((IDataEntityProperty)dt.getProperty("appname"), appinfo.get("name"));
            target.set((IDataEntityProperty)dt.getProperty("number"), (Object)String.format(ResManager.loadKDString((String)"\u7f16\u7801\uff1a%s", (String)"MyAppCardList_0", (String)"bos-devportal-new-plugin", (Object[])new Object[0]), appinfo.get("number")));
            target.set((IDataEntityProperty)dt.getProperty("version"), (Object)String.format(ResManager.loadKDString((String)"\u7248\u672c\uff1a%s", (String)"MyAppCardList_1", (String)"bos-devportal-new-plugin", (Object[])new Object[0]), appinfo.get("version")));
            target.set((IDataEntityProperty)dt.getProperty("forms"), (Object)String.format(ResManager.loadKDString((String)"\u9875\u9762\uff1a%s", (String)"MyAppCardList_2", (String)"bos-devportal-new-plugin", (Object[])new Object[0]), String.valueOf(forms)));
            if (appinfo.get("type").equals("0")) {
                target.set((IDataEntityProperty)dt.getProperty("type"), (Object)ResManager.loadKDString((String)"\u539f\u5382", (String)"MyAppCardList_3", (String)"bos-devportal-new-plugin", (Object[])new Object[0]));
            } else {
                target.set((IDataEntityProperty)dt.getProperty("type"), (Object)ResManager.loadKDString((String)"\u6269\u5c55", (String)"MyAppCardList_4", (String)"bos-devportal-new-plugin", (Object[])new Object[0]));
            }
            if (appinfo.get("deploystatus").equals("2")) {
                target.set((IDataEntityProperty)dt.getProperty("deploystatus"), (Object)ResManager.loadKDString((String)"\u5df2\u542f\u7528", (String)"MyAppCardList_5", (String)"bos-devportal-new-plugin", (Object[])new Object[0]));
                continue;
            }
            target.set((IDataEntityProperty)dt.getProperty("deploystatus"), (Object)ResManager.loadKDString((String)"\u672a\u542f\u7528", (String)"MyAppCardList_6", (String)"bos-devportal-new-plugin", (Object[])new Object[0]));
        }
        this.getView().updateView(ENTRYENTITY);
    }

    public void entryRowClick(RowClickEvent evt) {
        Control control = (Control)evt.getSource();
        if (ENTRYENTITY.equals(control.getKey())) {
            HashMap<String, Object> customParams = new HashMap<String, Object>();
            Object pkId = this.getModel().getValue("id", evt.getRow());
            customParams.put("pkId", pkId);
            this.openForm("bos_devpn_appdetail", customParams);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
        entryGrid.addRowClickListener((RowClickEventListener)this);
    }

    private OpenStyle getNewTabPageOpenStyle() {
        OpenStyle openStyle = new OpenStyle();
        openStyle.setShowType(ShowType.NewTabPage);
        openStyle.setTargetKey("_submaintab_");
        return openStyle;
    }

    private void openForm(String number, Map<String, Object> customParams) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId(number);
        if (customParams != null) {
            formShowParameter.setCustomParams(customParams);
        }
        formShowParameter.setOpenStyle(this.getNewTabPageOpenStyle());
        if (this.getView().getMainView() == null) {
            return;
        }
        IPageCache iPageCache = (IPageCache)this.getView().getMainView().getService(IPageCache.class);
        String pageId = iPageCache.get("kd.bos.newdevportal.home.HomePlugin_pageId");
        if (StringUtils.isNotBlank((CharSequence)pageId)) {
            formShowParameter.setParentPageId(pageId);
            this.getView().getView(pageId).showForm(formShowParameter);
            this.getView().sendFormAction(this.getView().getView(pageId));
        }
    }
}

