/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.newdevportal.app;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.isv.ISVService;
import kd.bos.newdevportal.util.QueryUtils;

public class MyAppList
extends AbstractFormPlugin
implements HyperLinkClickListener,
RowClickEventListener {
    private static final String ENTRYENTITY = "entryentity";
    private String isv = ISVService.getISVInfo().getId();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
        entryGrid.addRowClickListener((RowClickEventListener)this);
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.init();
    }

    private String[] getStringArray(DynamicObjectCollection appInfos, String number) {
        return appInfos.stream().map(s -> s.getString(number)).collect(Collectors.toList()).toArray(new String[0]);
    }

    private OpenStyle getNewTabPageOpenStyle() {
        OpenStyle openStyle = new OpenStyle();
        openStyle.setShowType(ShowType.NewTabPage);
        openStyle.setTargetKey("_submaintab_");
        return openStyle;
    }

    public void entryRowClick(RowClickEvent evt) {
        Control control = (Control)evt.getSource();
        if (ENTRYENTITY.equals(control.getKey())) {
            this.getPageCache().put("operationcolumnap", String.valueOf(evt.getRow()));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        if ("edit".equals(afterDoOperationEventArgs.getOperateKey())) {
            HashMap<String, Object> customParams = new HashMap<String, Object>();
            if (this.getPageCache().get("operationcolumnap") != null) {
                customParams.put("pkId", this.getModel().getValue("id", Integer.parseInt(this.getPageCache().get("operationcolumnap"))));
                this.getPageCache().remove("operationcolumnap");
            }
            this.openForm("bos_devpn_appdetail", customParams);
        }
    }

    private void openForm(String number, Map<String, Object> customParams) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId(number);
        if (customParams != null) {
            formShowParameter.setCustomParams(customParams);
        }
        formShowParameter.setOpenStyle(this.getNewTabPageOpenStyle());
        if (this.getView().getMainView() == null) {
            return;
        }
        IPageCache iPageCache = (IPageCache)this.getView().getMainView().getService(IPageCache.class);
        String pageId = iPageCache.get("kd.bos.newdevportal.home.HomePlugin_pageId");
        if (StringUtils.isNotBlank((CharSequence)pageId)) {
            formShowParameter.setParentPageId(pageId);
            this.getView().getView(pageId).showForm(formShowParameter);
            this.getView().sendFormAction(this.getView().getView(pageId));
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent arg0) {
        Control control = (Control)arg0.getSource();
        if (ENTRYENTITY.equals(control.getKey())) {
            HashMap<String, Object> customParams = new HashMap<String, Object>();
            Object pkId = this.getModel().getValue("id", arg0.getRowIndex());
            customParams.put("pkId", pkId);
            this.openForm("bos_devpn_appdetail", customParams);
        }
    }

    private void init() {
        DynamicObjectCollection appInfos = null;
        String formShowParameter = this.getPageCache().get("FormShowParameter");
        JSONObject parseObject = JSONArray.parseObject((String)formShowParameter);
        JSONObject openStyle = parseObject.getJSONObject("OpenStyle");
        Object targetKey = openStyle.get((Object)"TargetKey");
        appInfos = targetKey.equals("original") ? QueryUtils.getBizAppsByType("0") : (targetKey.equals("expand") ? QueryUtils.getBizAppsByType("2") : QueryUtils.getBizAppsByIsv(this.isv));
        DynamicObjectCollection appCloudInfos = QueryUtils.getBizCloudNames(this.getStringArray(appInfos, "bizcloud"));
        HashMap<String, String> appCloudInfoMap = new HashMap<String, String>();
        for (DynamicObject appCloudInfo : appCloudInfos) {
            appCloudInfoMap.put(appCloudInfo.getString("id"), appCloudInfo.getString("name"));
        }
        this.getModel().deleteEntryData(ENTRYENTITY);
        if (appInfos.size() > 0) {
            this.getModel().batchCreateNewEntryRow(ENTRYENTITY, appInfos.size());
        }
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRYENTITY);
        DynamicObjectType dt = entryEntity.getDynamicObjectType();
        for (int i = 0; i < appInfos.size(); ++i) {
            DynamicObject appinfo = (DynamicObject)appInfos.get(i);
            DynamicObject target = (DynamicObject)entryEntity.get(i);
            target.set((IDataEntityProperty)dt.getProperty("id"), appinfo.get("id"));
            target.set((IDataEntityProperty)dt.getProperty("appname"), appinfo.get("name"));
            target.set((IDataEntityProperty)dt.getProperty("appnumber"), appinfo.get("number"));
            target.set((IDataEntityProperty)dt.getProperty("bizcloud"), appCloudInfoMap.get(appinfo.get("bizcloud")));
            target.set((IDataEntityProperty)dt.getProperty("apptype"), appinfo.get("type"));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        DynamicObject cloud = (DynamicObject)this.getModel().getValue("cloud");
        String cloudId = "";
        if (cloud != null) {
            cloudId = cloud.getString("id");
        }
        String formShowParameter = this.getPageCache().get("FormShowParameter");
        JSONObject parseObject = JSONArray.parseObject((String)formShowParameter);
        JSONObject openStyle = parseObject.getJSONObject("OpenStyle");
        Object targetKey = openStyle.get((Object)"TargetKey");
        DynamicObjectCollection appInfos = null;
        appInfos = targetKey.equals("original") ? QueryUtils.getBizAppsByBizCloudAndType(cloudId, "0") : (targetKey.equals("expand") ? QueryUtils.getBizAppsByBizCloudAndType(cloudId, "2") : QueryUtils.getBizAppsByBizCloud(cloudId, this.isv));
        DynamicObjectCollection appCloudInfos = QueryUtils.getBizCloudNames(this.getStringArray(appInfos, "bizcloud"));
        HashMap<String, String> appCloudInfoMap = new HashMap<String, String>();
        for (DynamicObject appCloudInfo : appCloudInfos) {
            appCloudInfoMap.put(appCloudInfo.getString("id"), appCloudInfo.getString("name"));
        }
        this.getModel().deleteEntryData(ENTRYENTITY);
        if (appInfos.size() > 0) {
            this.getModel().batchCreateNewEntryRow(ENTRYENTITY, appInfos.size());
        }
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRYENTITY);
        DynamicObjectType dt = entryEntity.getDynamicObjectType();
        for (int i = 0; i < appInfos.size(); ++i) {
            DynamicObject appinfo = (DynamicObject)appInfos.get(i);
            DynamicObject target = (DynamicObject)entryEntity.get(i);
            target.set((IDataEntityProperty)dt.getProperty("id"), appinfo.get("id"));
            target.set((IDataEntityProperty)dt.getProperty("appname"), appinfo.get("name"));
            target.set((IDataEntityProperty)dt.getProperty("appnumber"), appinfo.get("number"));
            target.set((IDataEntityProperty)dt.getProperty("bizcloud"), appCloudInfoMap.get(appinfo.get("bizcloud")));
            target.set((IDataEntityProperty)dt.getProperty("apptype"), appinfo.get("type"));
        }
        this.getView().updateView(ENTRYENTITY);
    }
}

