/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.newdevportal.app.ecological;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.devportal.util.DevportalUtil;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.devportal.AppFunctionPacketElement;
import kd.bos.entity.operate.Donothing;
import kd.bos.entity.report.CellStyle;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.OperationColumn;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.control.events.ListboxClickListener;
import kd.bos.form.control.events.ListboxEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.operatecol.OperationColItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.isv.ISVService;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.mservice.svc.picture.IImage;
import kd.bos.newdevportal.app.ecological.DevportalFormType;
import kd.bos.newdevportal.app.my.DevpPermissionUtils;
import kd.bos.newdevportal.app.my.DevportalModelTypes;
import kd.bos.newdevportal.app.my.MyAppUtils;
import kd.bos.newdevportal.app.my.PageType;
import kd.bos.newdevportal.bean.DynamicFormInfo;
import kd.bos.newdevportal.util.GotoDesignerUtils;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.url.UrlService;

public class EcologyAppDetailPlugin
extends AbstractFormPlugin
implements ListboxClickListener,
TreeNodeClickListener,
HyperLinkClickListener,
EntryGridBindDataListener,
TabSelectListener,
SearchEnterListener {
    private static final String BOS_DEVPORTAL_BIZAPP = "bos_devportal_bizapp";
    private static final String BOS_DEVPN_FORMMETA = "bos_devpn_formmeta";
    private static final String BOS_DEVPORTAL_NEW_PLUGIN = "bos-devportal-new-plugin";
    private static final String BOS_DEVPORTAL_PLUGIN = "bos-devportal-plugin";
    private static final String BOS_DEVPORTAL_SHORTCUT = "bos_devportal_shortcut";
    private static final String BOS_USER = "bos_user";
    private static final String TREEVIEW = "treeviewap";
    private static final String LISTBOXAP = "listboxap";
    private static final String TREEENTRYENTITY = "treeentryentity";
    private static final String NUMBER = "number";
    private static final String NAME = "name";
    private static final String SOURCEPAGE = "sourcepage";
    private static final String MODELTYPE = "modeltype";
    private static final String MODIFIER = "modifier";
    private static final String MODIFYDATE = "modifydate";
    private static final String CURRENT_TYPE = "current_type";
    private static final String CURRENT_NODE = "current_node";
    private static final String STATUS = "status";
    private static final String PAGETYPE = "pagetype";
    protected static final String Key_TreeSearch = "searchap";
    private static final String Key_Search = "search";
    private static final String CacheId_SearchText = "searchText";
    private static final String OBJECT = "object";
    private static final String PAGE = "page";
    private static final String REPORT = "report";
    private static final String PARAMETER = "parameter";
    private static final String LAYOUT = "layout";
    protected static final String FORMID = "formid";
    private static final String ENTITYID = "entityid";
    private static final String COLLECTED = "iscollected";
    private static final String KEY_BTN_REPORT = "btnreport";
    private static final String KEY_TAB_OBJECT = "tabobject";
    private static final String KEY_TAB_DEVPAGE = "tabdevpage";
    private static final String KEY_TAB_PARAM = "tabparam";
    private static final String KEY_TAB_REPORT = "tabreport";
    private static final String KEY_TAB_LAYOUT = "tablayout";
    private static final String KEY_TABAP = "tabap";
    private static final String CARD_VIEW = "cardview";
    private static final String LIST_VIEW = "listview";
    private static final String BIZAPPID = "bizappid";
    private static final String BIZAPP = "bizapp";
    private static final String BIZPAGE = "bizpage";
    private static final String BIZUNIT = "bizunit";
    private static final String PARENTID = "parentid";
    private static final String MASTERID = "masterid";
    private static final String BIZCLOUDNUMBER = "bizcloudnumber";
    private static final String BIZCLOUDID = "bizcloudid";
    private static final String APPWINDOWCLOSE = "appWindowClose";
    private static final String COLLECT = "collect";
    private static final String CANCEL_COLLECT = "cancel_collect";
    private static final String Key_SourcePage = "sourcepage";
    private static final String Key_SourcePage_ID = "sourcepageid";
    private static final String MAINPAGE = "MainPage";
    private static final String BIZAPPTYPE = "bizapptype";
    private static final String BIZAPPPARENTID = "bizappparentid";
    private static final String ZERO = "0";
    private TreeNode rootNode;

    public void initialize() {
        super.initialize();
        Tab tabap = (Tab)this.getView().getControl(KEY_TABAP);
        tabap.addTabSelectListener((TabSelectListener)this);
        TreeView treeView = (TreeView)this.getView().getControl(TREEVIEW);
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        Search search = (Search)this.getControl(Key_Search);
        search.addEnterListener((SearchEnterListener)this);
        this.addClickListeners(new String[]{LIST_VIEW, CARD_VIEW});
        Search treeSearch = (Search)this.getControl(Key_TreeSearch);
        treeSearch.addEnterListener((SearchEnterListener)this);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(TREEENTRYENTITY);
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        entryGrid.addDataBindListener((EntryGridBindDataListener)this);
        entryGrid.addPackageDataListener(pkEvent -> {
            if (pkEvent.getSource() instanceof OperationColumn && "operationcolumnap".equals(((OperationColumn)pkEvent.getSource()).getKey())) {
                List opItems = (List)pkEvent.getFormatValue();
                boolean iscollected = pkEvent.getRowData().getBoolean(COLLECTED);
                for (OperationColItem item : opItems) {
                    if (iscollected && COLLECT.equals(item.getOperationKey())) {
                        item.setVisible(false);
                    }
                    if (iscollected || !CANCEL_COLLECT.equals(item.getOperationKey())) continue;
                    item.setVisible(false);
                }
            }
        });
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        boolean isHasPermisson = DevpPermissionUtils.hasBizPageViewPermission(null, "47150e89000000ac");
        if (!isHasPermisson) {
            e.setCancelMessage(ResManager.loadKDString((String)"\u8bf7\u6dfb\u52a0\u4e1a\u52a1\u5bf9\u8c61\u7684\u67e5\u8be2\u6743\u9650\u3002", (String)"EcologyAppDetailPlugin_14", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
            e.setCancel(true);
        }
    }

    public void afterCreateNewData(EventObject e) {
        String bizAppId = (String)this.getView().getFormShowParameter().getCustomParam(BIZAPPID);
        AppMetaServiceHelper.cleanAppMetaCache((String)bizAppId);
        String type = (String)this.getView().getFormShowParameter().getCustomParam("pageType");
        this.appInfo();
        TreeNode root = this.getRootNode();
        TreeView treeView = (TreeView)this.getView().getControl(TREEVIEW);
        treeView.addNode(root);
        String pageType = ZERO;
        if (StringUtils.isNotBlank((CharSequence)type)) {
            pageType = type;
            this.getPageCache().put(CURRENT_TYPE, pageType);
        }
        boolean isTabActive = this.getView().getFormShowParameter().getCustomParam("isTabActive") == null ? false : (Boolean)this.getView().getFormShowParameter().getCustomParam("isTabActive");
        this.loadAppDetail(isTabActive);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.loadAppDetail(true);
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "cardview": {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u529f\u80fd\u5f00\u53d1\u4e2d\uff0c\u656c\u8bf7\u671f\u5f85\u3002", (String)"EcologyAppDetailPlugin_15", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]), MessageBoxOptions.OK);
                break;
            }
        }
    }

    private void loadAppDetail(boolean isTabActive) {
        String bizUnitId = ZERO;
        String bizPageId = "";
        String pageType = "";
        if (StringUtils.isNotBlank((CharSequence)((CharSequence)this.getView().getFormShowParameter().getCustomParam("pageType")))) {
            pageType = (String)this.getView().getFormShowParameter().getCustomParam("pageType");
            if (StringUtils.isNotBlank((CharSequence)((CharSequence)this.getView().getFormShowParameter().getCustomParam("bizunitid")))) {
                bizUnitId = (String)this.getView().getFormShowParameter().getCustomParam("bizunitid");
            }
            if (StringUtils.isNotBlank((CharSequence)((CharSequence)this.getView().getFormShowParameter().getCustomParam("bizPageId")))) {
                bizPageId = (String)this.getView().getFormShowParameter().getCustomParam("bizPageId");
            }
        }
        TreeView treeView = (TreeView)this.getView().getControl(TREEVIEW);
        TreeNode node = this.rootNode.getTreeNode(bizUnitId, 10);
        treeView.focusNode(node);
        if (isTabActive) {
            this.tabActive(pageType);
            this.markTargetPage(bizUnitId, bizPageId);
        }
    }

    public TreeNode buildTreeNode(String searchText) {
        String bizAppId = (String)this.getView().getFormShowParameter().getCustomParam(BIZAPPID);
        TreeNode root = new TreeNode();
        root.setId(ZERO);
        root.setText(ResManager.loadKDString((String)"\u5168\u90e8", (String)"EcologyAppDetailPlugin_13", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
        root.setParentid("");
        root.setIsOpened(true);
        this.rootNode = root;
        if (StringUtils.isBlank((CharSequence)bizAppId)) {
            return root;
        }
        Map<String, TreeNode> nodes = this.getFunction(bizAppId, searchText);
        if (nodes.isEmpty()) {
            return root;
        }
        for (Map.Entry<String, TreeNode> entry : nodes.entrySet()) {
            TreeNode node = entry.getValue();
            TreeNode parentNode = nodes.get(node.getParentid());
            if (parentNode != null) {
                parentNode.addChild(node);
                continue;
            }
            root.addChild(node);
        }
        return root;
    }

    private TreeNode getRootNode() {
        if (this.rootNode == null) {
            this.rootNode = this.buildTreeNode(null);
        }
        return this.rootNode;
    }

    private Map<String, TreeNode> getFunction(String appId, String searchText) {
        AppMetadata appMetadata = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)appId, (boolean)false);
        String devType = appMetadata.getDevType();
        String parentId = appMetadata.getParentId();
        this.getPageCache().put(BIZAPPTYPE, devType);
        this.getPageCache().put(BIZAPPPARENTID, parentId);
        ArrayList functionPackets = new ArrayList(16);
        functionPackets.addAll(appMetadata.getAppFunctionPackets());
        Collections.sort(functionPackets, new Comparator<AppFunctionPacketElement>(){

            @Override
            public int compare(AppFunctionPacketElement o1, AppFunctionPacketElement o2) {
                if (o1.getSeq() < o2.getSeq()) {
                    return -1;
                }
                if (o1.getSeq() == o2.getSeq()) {
                    return 0;
                }
                return 1;
            }
        });
        LinkedHashMap<String, TreeNode> nodes = new LinkedHashMap<String, TreeNode>(functionPackets.size());
        for (AppFunctionPacketElement function : functionPackets) {
            TreeNode node = new TreeNode();
            String nodeId = function.getId();
            node.setId(nodeId);
            node.setText(function.getName().getLocaleValue());
            node.setParentid(function.getParentId());
            if (StringUtils.equals((CharSequence)MAINPAGE, (CharSequence)function.getNumber())) {
                this.getPageCache().put(MAINPAGE, nodeId);
                this.getPageCache().put("bizUnitId", nodeId);
            }
            if (StringUtils.isNotBlank((CharSequence)searchText) && !StringUtils.contains((CharSequence)node.getText(), (CharSequence)searchText)) continue;
            nodes.put(nodeId, node);
        }
        return nodes;
    }

    private void openAppEditWindow(String status) {
        boolean isHasPermisson = false;
        String bizAppId = (String)this.getView().getFormShowParameter().getCustomParam(BIZAPPID);
        AppMetadata appMeta = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)bizAppId, (boolean)false);
        String bizCloudId = appMeta.getBizCloudID();
        String permisson = "";
        if ("EDIT".equals(status)) {
            isHasPermisson = DevpPermissionUtils.hasBizAppViewPermission(this.getView().getFormShowParameter().getAppId(), "4715a0df000000ac");
            permisson = ResManager.loadKDString((String)"\u4fee\u6539\u5e94\u7528", (String)"BizAppListPlugin_39", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]);
        }
        if (!isHasPermisson) {
            this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c%s\u201d\u7684\u6743\u9650\uff0c\u8bf7\u6dfb\u52a0\u6743\u9650\u540e\u518d\u8bd5\u3002", (String)"BizAppListPlugin_37", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), permisson));
            return;
        }
        DynamicObject cloud = BusinessDataServiceHelper.loadSingleFromCache((Object)bizCloudId, (String)"bos_devportal_bizcloud", (String)NUMBER);
        String bizCloudNumber = cloud == null ? "" : cloud.getString(NUMBER);
        BaseShowParameter parameter = new BaseShowParameter();
        parameter.setFormId("bos_devportal_app_layout");
        parameter.setCustomParam(BIZCLOUDID, (Object)bizCloudId);
        parameter.setCustomParam(BIZAPPID, (Object)bizAppId);
        parameter.setCustomParam(BIZCLOUDNUMBER, (Object)bizCloudNumber);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        if ("EDIT".equals(status)) {
            parameter.setStatus(OperationStatus.EDIT);
            parameter.setCaption(ResManager.loadKDString((String)"\u4fee\u6539\u5e94\u7528", (String)"BizAppListPlugin_39", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            parameter.setPkId((Object)bizAppId);
        }
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, APPWINDOWCLOSE);
        parameter.setCloseCallBack(callBack);
        this.getPageCache().put(BIZCLOUDID, bizCloudId);
        this.getView().showForm((FormShowParameter)parameter);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        if (APPWINDOWCLOSE.equals(e.getActionId())) {
            this.appInfo();
        } else if ("viewPageInheritTree_close".equals(e.getActionId()) && e.getReturnData() != null) {
            this.handleViewPageInheritTreeCallBack(e);
        }
    }

    private void handleViewPageInheritTreeCallBack(ClosedCallBackEvent e) {
        Map returnData = (Map)e.getReturnData();
        String bizUnitId = (String)returnData.get("bizunitid");
        String bizAppId = (String)returnData.get(BIZAPPID);
        String bizPageId = (String)returnData.get("bizpageid");
        String pageType = this.getPageCache().get(CURRENT_TYPE);
        if (StringUtils.isBlank((CharSequence)pageType)) {
            pageType = PageType.EntityObject.getValue();
        }
        MyAppUtils.showAppDetail(this.getView(), bizAppId, bizUnitId, bizPageId, pageType);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String formId = this.getSelectForm();
        if (args.getSource() instanceof Donothing) {
            String key;
            Donothing operate = (Donothing)args.getSource();
            switch (key = operate.getOperateKey()) {
                case "collect": 
                case "cancel_collect": {
                    this.collectPage(formId);
                    break;
                }
                case "showentity": {
                    GotoDesignerUtils.gotoDesigner(PageType.EntityObject.getValue(), this.getView(), formId);
                    break;
                }
                case "showpage": {
                    GotoDesignerUtils.gotoDesigner(PageType.Page.getValue(), this.getView(), formId);
                    break;
                }
                case "viewinherittree": {
                    this.ViewInheritTree(formId);
                    break;
                }
            }
        }
    }

    private void ViewInheritTree(String formId) {
        FormShowParameter showInheritParameter = new FormShowParameter();
        showInheritParameter.getOpenStyle().setShowType(ShowType.Modal);
        showInheritParameter.setFormId("devpn_pageinheritview");
        showInheritParameter.setCustomParam("formId", (Object)formId);
        CloseCallBack inheritCallBack = new CloseCallBack((IFormPlugin)this, "viewPageInheritTree_close");
        showInheritParameter.setCloseCallBack(inheritCallBack);
        this.getView().showForm(showInheritParameter);
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        String bizAppId = (String)this.getView().getFormShowParameter().getCustomParam(BIZAPPID);
        String nodeId = (String)evt.getNodeId();
        this.getPageCache().put(CURRENT_NODE, nodeId);
        String currentNode = this.getPageCache().get(CURRENT_TYPE);
        List<String> collectForm = this.getCollectForm();
        this.renderEntryEntity(currentNode, bizAppId, nodeId, collectForm, "");
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String pageType = this.getPageCache().get(CURRENT_TYPE);
        String formId = null;
        if (StringUtils.isBlank((CharSequence)pageType)) {
            pageType = PageType.EntityObject.getValue();
        }
        if ("sourcepage".equals(evt.getFieldName())) {
            formId = (String)this.getModel().getValue(Key_SourcePage_ID, evt.getRowIndex());
        } else {
            formId = (String)this.getModel().getValue(FORMID);
            String row_formId = (String)this.getModel().getValue(FORMID, evt.getRowIndex());
            formId = formId != null ? formId : row_formId;
        }
        GotoDesignerUtils.gotoDesigner(pageType, this.getView(), formId);
    }

    public void search(SearchEnterEvent e) {
        Search search = (Search)e.getSource();
        if (StringUtils.equals((CharSequence)Key_Search, (CharSequence)search.getKey())) {
            String searchText = e.getText();
            this.getPageCache().put(CacheId_SearchText, searchText);
            String currNodeId = this.getPageCache().get(CURRENT_NODE);
            String pageType = this.getPageCache().get(CURRENT_TYPE);
            String bizAppId = (String)this.getView().getFormShowParameter().getCustomParam(BIZAPPID);
            List<String> collectForm = this.getCollectForm();
            this.renderEntryEntity(pageType, bizAppId, currNodeId, collectForm, searchText);
        } else if (StringUtils.equals((CharSequence)Key_TreeSearch, (CharSequence)search.getKey())) {
            this.rootNode = this.buildTreeNode(e.getText());
            TreeView tree = (TreeView)this.getControl(TREEVIEW);
            tree.updateNode(this.rootNode);
        }
    }

    private void collectPage(String formId) {
        Long userId = RequestContext.get().getCurrUserId();
        DynamicObject app = BizAppServiceHelp.getBizAppByFormID((String)formId);
        String appId = null;
        if (app != null) {
            appId = app.getString("id");
        }
        QFilter qFilter = new QFilter(BIZAPP, "=", (Object)appId);
        QFilter qFilter1 = new QFilter("user", "=", (Object)userId);
        QFilter qFilter2 = new QFilter(BIZPAGE, "=", (Object)formId);
        QFilter[] qFilters = new QFilter[]{qFilter, qFilter1, qFilter2};
        int iscollected = 0;
        boolean isCollect = QueryServiceHelper.exists((String)BOS_DEVPORTAL_SHORTCUT, (QFilter[])qFilters);
        if (isCollect) {
            String pkId = QueryServiceHelper.queryOne((String)BOS_DEVPORTAL_SHORTCUT, (String)"id", (QFilter[])qFilters).getString("id");
            Object[] pkIds = new String[]{pkId};
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)BOS_DEVPORTAL_SHORTCUT);
            DeleteServiceHelper.delete((IDataEntityType)entityType, (Object[])pkIds);
        } else {
            DynamicObject object = BusinessDataServiceHelper.newDynamicObject((String)BOS_DEVPORTAL_SHORTCUT);
            object.set(BIZAPP, (Object)appId);
            object.set("user", (Object)userId);
            object.set(BIZPAGE, (Object)formId);
            DynamicObject[] collect = new DynamicObject[]{object};
            SaveServiceHelper.save((DynamicObject[])collect);
            iscollected = 1;
        }
        EntryGrid treeEntryGrid = (EntryGrid)this.getControl(TREEENTRYENTITY);
        ArrayList<String> opeIds = new ArrayList<String>();
        if (iscollected == 1) {
            opeIds.add(COLLECT);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6536\u85cf\u6210\u529f\u3002", (String)"EcologyAppDetailPlugin_16", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
        } else {
            opeIds.add(CANCEL_COLLECT);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6536\u85cf\u5df2\u53d6\u6d88\u3002", (String)"EcologyAppDetailPlugin_17", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
        }
        int rowIndex = this.getModel().getEntryCurrentRowIndex(TREEENTRYENTITY);
        this.getModel().setValue(COLLECTED, (Object)iscollected, rowIndex);
        treeEntryGrid.hideOperateItems("operationcolumnap", rowIndex, opeIds);
        this.getView().updateView(TREEENTRYENTITY, rowIndex);
    }

    private void listBoxInfo(String bizUnitId, String searchText) {
        String bizAppId = (String)this.getView().getFormShowParameter().getCustomParam(BIZAPPID);
        Map<String, Integer> map = this.getCount(bizAppId, bizUnitId, searchText);
        Integer object = map.get(OBJECT);
        Integer page = map.get(PAGE);
        Integer report = map.get(REPORT);
        Integer param = map.get(PARAMETER);
        Integer layout = map.get(LAYOUT);
        this.updateTabName(KEY_TAB_OBJECT, ResManager.loadKDString((String)"\u4e1a\u52a1\u5bf9\u8c61(%s)", (String)"EcologyAppDetailPlugin_18", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[]{object}));
        this.updateTabName(KEY_TAB_DEVPAGE, ResManager.loadKDString((String)"\u9875\u9762(%s)", (String)"EcologyAppDetailPlugin_19", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[]{page}));
        this.updateTabName(KEY_TAB_REPORT, ResManager.loadKDString((String)"\u62a5\u8868(%s)", (String)"EcologyAppDetailPlugin_20", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[]{report}));
        this.updateTabName(KEY_TAB_PARAM, ResManager.loadKDString((String)"\u53c2\u6570(%s)", (String)"EcologyAppDetailPlugin_21", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[]{param}));
        this.updateTabName(KEY_TAB_LAYOUT, ResManager.loadKDString((String)"\u5e03\u5c40(%s)", (String)"EcologyAppDetailPlugin_22", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[]{layout}));
    }

    private void updateTabName(String key, String name) {
        HashMap map = new HashMap(1);
        HashMap<String, String> nameMap = new HashMap<String, String>(1);
        nameMap.put("zh_CN", name);
        map.put("text", nameMap);
        this.getView().updateControlMetadata(key, map);
    }

    private Map<String, Integer> getCount(String bizAppId, String bizUnitId, String searchText) {
        Map<String, DynamicFormInfo> forms;
        Integer object = 0;
        Integer page = 0;
        Integer report = 0;
        Integer parameter = 0;
        Integer layout = 0;
        List<String> objectType = DevportalModelTypes.getModelTypesByType(PageType.EntityObject.getValue());
        List<String> pageType = DevportalModelTypes.getModelTypesByType(PageType.Page.getValue());
        List<String> reportType = DevportalModelTypes.getModelTypesByType(PageType.Report.getValue());
        List<String> paraType = DevportalModelTypes.getModelTypesByType(PageType.Parameter.getValue());
        List<String> commonTypes = DevportalModelTypes.getModelTypesByType(PageType.Common.getValue());
        List<String> layoutType = DevportalModelTypes.getModelTypesByType(PageType.LayOut.getValue());
        HashMap<String, Integer> map = new HashMap<String, Integer>(16);
        ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
        String isv = ISVService.getISVInfo().getId();
        filters.add(new QFilter("isv", "not in", (Object)new String[]{"kingdee", " "}));
        filters.add(new QFilter("isv", "<>", (Object)isv));
        filters.add(new QFilter(BIZAPPID, "=", (Object)bizAppId));
        if (StringUtils.isNotBlank((CharSequence)searchText)) {
            String searchContent = String.format("%s%s%s", "%", searchText, "%");
            QFilter numberFilter = new QFilter(NUMBER, "like", (Object)searchContent);
            numberFilter.or(new QFilter(NAME, "like", (Object)searchContent));
            filters.add(numberFilter);
        }
        if ((forms = this.queryFormDesignMeta(0, 1000, filters, MODIFYDATE, bizUnitId)).isEmpty()) {
            map.put(OBJECT, object);
            map.put(PAGE, page);
            map.put(REPORT, report);
            map.put(PARAMETER, parameter);
            map.put(LAYOUT, layout);
            return map;
        }
        for (Map.Entry<String, DynamicFormInfo> entry : forms.entrySet()) {
            Integer n;
            Integer n2;
            DynamicFormInfo value = entry.getValue();
            String modelType = value.getModelType();
            if (objectType.contains(modelType)) {
                if (commonTypes.contains(modelType)) {
                    if (value.getFormId().equals(value.getEntityId())) {
                        n2 = object;
                        n = object = Integer.valueOf(object + 1);
                    }
                } else {
                    n2 = object;
                    n = object = Integer.valueOf(object + 1);
                }
            }
            if (pageType.contains(modelType) && !commonTypes.contains(modelType)) {
                n2 = page;
                n = page = Integer.valueOf(page + 1);
            }
            if (reportType.contains(modelType)) {
                n2 = report;
                n = report = Integer.valueOf(report + 1);
            }
            if (paraType.contains(modelType)) {
                n2 = parameter;
                n = parameter = Integer.valueOf(parameter + 1);
            }
            if (!layoutType.contains(modelType)) continue;
            n2 = layout;
            n = layout = Integer.valueOf(layout + 1);
        }
        map.put(OBJECT, object);
        map.put(PAGE, page);
        map.put(REPORT, report);
        map.put(PARAMETER, parameter);
        map.put(LAYOUT, layout);
        return map;
    }

    private String getSelectForm() {
        int entryRowCount = this.getModel().getEntryRowCount(TREEENTRYENTITY);
        int rowIndex = this.getModel().getEntryCurrentRowIndex(TREEENTRYENTITY);
        EntryGrid grid = (EntryGrid)this.getView().getControl(TREEENTRYENTITY);
        int[] selectRows = grid.getSelectRows();
        if (entryRowCount == 0 || selectRows.length == 0) {
            return null;
        }
        return (String)this.getModel().getValue(FORMID, rowIndex);
    }

    private List<String> getCollectForm() {
        QFilter qFilter = new QFilter("user", "=", (Object)RequestContext.get().getCurrUserId());
        String bizAppId = (String)this.getView().getFormShowParameter().getCustomParam(BIZAPPID);
        QFilter qFilter1 = new QFilter(BIZAPP, "=", (Object)bizAppId);
        QFilter[] qFilters = new QFilter[]{qFilter, qFilter1};
        ArrayList<String> formList = new ArrayList<String>(10);
        String fields = BIZPAGE;
        Map fromCache = BusinessDataServiceHelper.loadFromCache((String)BOS_DEVPORTAL_SHORTCUT, (String)fields, (QFilter[])qFilters);
        for (Map.Entry entry : fromCache.entrySet()) {
            DynamicObject entryValue = (DynamicObject)entry.getValue();
            String formId = entryValue.getString(fields);
            formList.add(formId);
        }
        return formList;
    }

    private void renderEntryEntity(String pageType, String bizAppId, String function, List<String> collectPages, String searchText) {
        this.listBoxInfo(function, searchText);
        HashSet<Long> userIds = new HashSet<Long>(16);
        HashSet<String> parentIds = new HashSet<String>(16);
        List<DynamicFormInfo> pageList = this.getPageList(pageType, bizAppId, function, searchText);
        int len = pageList.size();
        if (len == 0) {
            this.getModel().deleteEntryData(TREEENTRYENTITY);
            this.getView().updateView(TREEENTRYENTITY);
            return;
        }
        for (DynamicFormInfo info : pageList) {
            if (StringUtils.isNotBlank((CharSequence)info.getModifier())) {
                userIds.add(Long.parseLong(info.getModifier()));
            }
            if (!StringUtils.isNotBlank((CharSequence)info.getSourcePage())) continue;
            parentIds.add(info.getSourcePage());
        }
        this.getModel().deleteEntryData(TREEENTRYENTITY);
        MainEntityType userDt = EntityMetadataCache.getDataEntityType((String)BOS_USER);
        MainEntityType formDt = EntityMetadataCache.getDataEntityType((String)BOS_DEVPN_FORMMETA);
        Map users = BusinessDataReader.loadFromCache((Object[])userIds.toArray(), (DynamicObjectType)userDt);
        Map forms = BusinessDataReader.loadFromCache((Object[])parentIds.toArray(), (DynamicObjectType)formDt);
        this.getModel().batchCreateNewEntryRow(TREEENTRYENTITY, len);
        ArrayList<CellStyle> cellStyles = new ArrayList<CellStyle>(len);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(TREEENTRYENTITY);
        int index = 0;
        long pid = 0L;
        for (DynamicFormInfo formInfo : pageList) {
            DynamicObject row = (DynamicObject)entryEntity.get(index);
            this.renderRow(formInfo, row, pid, forms, users, collectPages, index, cellStyles, pageType);
            ++index;
        }
        this.getView().updateView(TREEENTRYENTITY);
        EntryGrid entryGrid = (EntryGrid)this.getControl(TREEENTRYENTITY);
        entryGrid.setCellStyle(cellStyles);
        this.showOperationCol(pageType);
    }

    private void renderRow(DynamicFormInfo formInfo, DynamicObject entry, long pid, Map<Object, DynamicObject> forms, Map<Object, DynamicObject> users, List<String> collectPage, int index, List<CellStyle> cellStyles, String pageType) {
        entry.set(NUMBER, (Object)formInfo.getNumber());
        entry.set(NAME, (Object)formInfo.getName());
        if (StringUtils.isNotBlank((CharSequence)formInfo.getSourcePage())) {
            DynamicObject form = forms.get(formInfo.getSourcePage());
            entry.set("sourcepage", form == null ? null : form.get(NUMBER));
            entry.set(Key_SourcePage_ID, (Object)formInfo.getSourcePage());
        }
        String modelType = formInfo.getModelType();
        entry.set(MODELTYPE, (Object)DevportalFormType.getFormType(modelType, pageType));
        String terminal = "pc";
        if ("MobileFormModel".equals(modelType) || "MobileBillFormModel".equals(modelType) || "MobUserGuideFormModel".equals(modelType) || "MobileListModel".equals(modelType)) {
            terminal = "mobile";
        }
        entry.set("terminal", (Object)terminal);
        entry.set(MODIFIER, StringUtils.isBlank((CharSequence)formInfo.getModifier()) ? null : users.get(Long.parseLong(formInfo.getModifier())));
        entry.set(MODIFYDATE, (Object)formInfo.getModifyDate());
        entry.set(FORMID, (Object)formInfo.getFormId());
        entry.set(COLLECTED, (Object)(collectPage.contains(formInfo.getFormId()) ? 1 : 0));
        int enable = formInfo.getEnable();
        entry.set(STATUS, (Object)enable);
        if (enable == 0) {
            cellStyles.add(this.genStyle(STATUS, index, "#b2b2b2"));
        } else {
            cellStyles.add(this.genStyle(STATUS, index, "#2ab277"));
        }
        entry.set(PAGETYPE, (Object)pageType);
        entry.set(ENTITYID, (Object)formInfo.getEntityId());
    }

    private CellStyle genStyle(String key, int i, String foreColor) {
        CellStyle cellStyle = new CellStyle();
        cellStyle.setFieldKey(key);
        cellStyle.setRow(i);
        cellStyle.setForeColor(StringUtils.isBlank((CharSequence)foreColor) ? "#2ab277" : foreColor);
        return cellStyle;
    }

    private List<DynamicFormInfo> getPageList(String pageType, String bizAppId, String function, String searchText) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
        if (StringUtils.isNotBlank((CharSequence)searchText)) {
            String searchContent = String.format("%s%s%s", "%", searchText, "%");
            QFilter numberFilter = new QFilter(NUMBER, "like", (Object)searchContent);
            numberFilter.or(new QFilter(NAME, "like", (Object)searchContent));
            filters.add(numberFilter);
        }
        filters.add(new QFilter(BIZAPPID, "=", (Object)bizAppId));
        String isv = ISVService.getISVInfo().getId();
        filters.add(new QFilter("isv", "<>", (Object)isv));
        filters.add(new QFilter("isv", "not in", (Object)new String[]{"kingdee", " "}));
        Map<String, DynamicFormInfo> metas = this.queryFormDesignMeta(0, 1000, filters, MODIFYDATE, function);
        ArrayList<DynamicFormInfo> allForms = new ArrayList<DynamicFormInfo>(metas.size());
        List<String> enableModelTypes = DevportalModelTypes.getModelTypesByType(pageType);
        List<String> commonTypes = DevportalModelTypes.getModelTypesByType(PageType.Common.getValue());
        for (Map.Entry<String, DynamicFormInfo> entry : metas.entrySet()) {
            DynamicFormInfo info = entry.getValue();
            String modelType = info.getModelType();
            if (!enableModelTypes.contains(modelType) || PageType.EntityObject.getValue().equals(pageType) && commonTypes.contains(modelType) && !info.getFormId().equals(info.getEntityId()) || PageType.Page.getValue().equals(pageType) && commonTypes.contains(modelType)) continue;
            String client = ZERO;
            if (modelType.startsWith("Mobile")) {
                client = "1";
            }
            info.setClient(client);
            allForms.add(info);
        }
        return allForms;
    }

    private Map<String, DynamicFormInfo> queryFormDesignMeta(int start, int limit, List<QFilter> qFilters, String orderBy, String nodeId) {
        QFilter[] unitRelFormFilters = null;
        if (StringUtils.isBlank((CharSequence)nodeId)) {
            nodeId = ZERO;
        }
        if (!ZERO.equals(nodeId)) {
            QFilter unitRelFormFilter = new QFilter(BIZUNIT, "=", (Object)nodeId);
            unitRelFormFilters = new QFilter[]{unitRelFormFilter};
        }
        String unitrelformFields = "bizapp,bizunit,form";
        String formFields = "id,number,modeltype,parentid,masterid,bizappid,bizappid.bizcloud,modifierid,modifydate,name,basedatafield,enable,type,isv";
        ORM orm = ORM.create();
        LinkedHashMap<String, DynamicFormInfo> map = new LinkedHashMap<String, DynamicFormInfo>(10);
        try (DataSet formMetaDataSet = orm.queryDataSet(BOS_DEVPN_FORMMETA, BOS_DEVPN_FORMMETA, formFields, qFilters.toArray(new QFilter[qFilters.size()]), orderBy, start, limit);
             DataSet unitRelFormDataSet = QueryServiceHelper.queryDataSet((String)"bos_devportal_unitrelform", (String)"bos_devportal_unitrelform", (String)unitrelformFields, (QFilter[])unitRelFormFilters, (String)"form asc");
             DataSet result = unitRelFormDataSet.join(formMetaDataSet, JoinType.INNER).on("form", "id").select(new String[]{BIZUNIT, "form"}, new String[]{"id", NUMBER, MODELTYPE, PARENTID, MASTERID, BIZAPPID, "bizappid.bizcloud", "modifierid", MODIFYDATE, NAME, "basedatafield", "enable", "type", "isv"}).finish().orderBy(new String[]{orderBy});){
            result.forEach(rs -> {
                Date modifyDate;
                String id = rs.getString("id");
                String number = rs.getString(NUMBER);
                String modelType = rs.getString(MODELTYPE);
                String parentId = rs.getString(PARENTID);
                String masterId = rs.getString(MASTERID);
                String bizappId = rs.getString(BIZAPPID);
                String modifierId = rs.getString("modifierid");
                String modifyDateStr = rs.getString(MODIFYDATE);
                String entityId = rs.getString("basedatafield");
                try {
                    modifyDate = TimeServiceHelper.parseUserTime((String)modifyDateStr, (Long)RequestContext.get().getCurrUserId());
                }
                catch (Exception e) {
                    throw new KDBizException(e.getMessage());
                }
                String name = rs.getString(NAME);
                String bizCloudId = rs.getString("bizappid.bizcloud");
                String bizUnitId = rs.getString(BIZUNIT);
                String typeStr = rs.getString("type");
                String enableStr = rs.getString("enable");
                String isv = rs.getString("isv");
                int enable = StringUtils.isBlank((CharSequence)enableStr) ? 0 : Integer.parseInt(enableStr);
                int type = StringUtils.isBlank((CharSequence)typeStr) ? 0 : Integer.parseInt(typeStr);
                DynamicFormInfo info = new DynamicFormInfo(number, name, modelType, bizappId, modifierId, modifyDate);
                info.setFormId(id);
                info.setBizCloud(bizCloudId);
                info.setSourcePage(StringUtils.isBlank((CharSequence)masterId) ? parentId : masterId);
                info.setBizUnitId(bizUnitId);
                info.setCollect(ZERO);
                info.setMasterid(masterId);
                info.setEntityId(entityId);
                info.setType(type);
                info.setEnable(enable);
                info.setIsv(isv);
                map.put(id, info);
            });
        }
        return map;
    }

    private void appInfo() {
        String bizAppId = (String)this.getView().getFormShowParameter().getCustomParam(BIZAPPID);
        if (StringUtils.isBlank((CharSequence)bizAppId)) {
            return;
        }
        QFilter qFilter = new QFilter("id", "=", (Object)bizAppId);
        QFilter[] filter = new QFilter[]{qFilter};
        DynamicObject bizApp = BusinessDataServiceHelper.loadSingleFromCache((String)BOS_DEVPORTAL_BIZAPP, (QFilter[])filter);
        String domainUrl = UrlService.getDomainContextUrl();
        String image = bizApp.getString("image");
        if (StringUtils.isNotBlank((CharSequence)image) && !image.startsWith("/")) {
            image = "/" + image;
        }
        String name = bizApp.getString(NAME);
        String description = bizApp.getString("description");
        String number = bizApp.getString(NUMBER);
        String cloudName = bizApp.getDynamicObject("bizcloud").getString(NAME);
        boolean alluserapp = bizApp.getBoolean("alluserapp");
        String dbRoute = bizApp.getString("dbroute");
        String dbRouteName = this.getRouteName(dbRoute);
        this.deployStatuStyle();
        IImage imageLabel = (IImage)this.getControl("imageap");
        imageLabel.setUrl(domainUrl + image);
        this.labelInfo("namelabelap", name);
    }

    private void labelInfo(String key, String value) {
        Label label = (Label)this.getControl(key);
        label.setText(value);
    }

    private void deployStatuStyle() {
        String bizappId = (String)this.getView().getFormShowParameter().getCustomParam("bizappId");
        AppMetadata metadata = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)bizappId, (boolean)false);
        if ("2".equals(metadata.getAppElement().getDeployStatus())) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"deploystatusenable"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"deploystatusdisable"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"deploystatusenable"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"deploystatusdisable"});
        }
    }

    private String getRouteName(String dbRoute) {
        JSONArray dbInstanceList = DevportalUtil.getDbInstanceList();
        for (Object route : dbInstanceList) {
            JSONObject db = (JSONObject)route;
            String dbNumber = db.getString(NUMBER);
            if (!dbRoute.equals(dbNumber)) continue;
            return db.getString(NAME);
        }
        return dbRoute;
    }

    public void listboxClick(ListboxEvent listboxEvent) {
    }

    public void tabSelected(TabSelectEvent evt) {
        String key;
        String activerByServer = this.getPageCache().get("activerByServer");
        if (StringUtils.isNotBlank((CharSequence)activerByServer) && "true".equals(activerByServer)) {
            this.getPageCache().remove("activerByServer");
            return;
        }
        String bizAppId = (String)this.getView().getFormShowParameter().getCustomParam(BIZAPPID);
        String pageType = ZERO;
        switch (key = evt.getTabKey()) {
            case "tabobject": {
                break;
            }
            case "tabdevpage": {
                pageType = "1";
                break;
            }
            case "tabreport": {
                pageType = "2";
                break;
            }
            case "tabparam": {
                pageType = "3";
                break;
            }
            case "tablayout": {
                pageType = "5";
                break;
            }
        }
        String nodeId = this.getPageCache().get(CURRENT_NODE);
        String searchText = this.getPageCache().get(CacheId_SearchText);
        this.renderEntryEntity(pageType, bizAppId, nodeId, this.getCollectForm(), searchText);
        this.showOperationCol(pageType);
        this.getPageCache().put(CURRENT_TYPE, pageType);
    }

    protected void markTargetPage(String bizUnitId, String bizPageId) {
        if (StringUtils.isNotBlank((CharSequence)bizUnitId)) {
            TreeView tView = (TreeView)this.getControl(TREEVIEW);
            tView.treeNodeClick(ZERO, bizUnitId);
            TreeNode node = this.getRootNode().getTreeNode(bizUnitId, 10);
            tView.focusNode(node);
        }
        if (StringUtils.isNotBlank((CharSequence)bizPageId)) {
            TreeEntryGrid grid = (TreeEntryGrid)this.getControl(TREEENTRYENTITY);
            int rowIndex = this.findRowById(bizPageId);
            grid.selectRows(rowIndex);
        }
    }

    private int findRowById(String formId) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(TREEENTRYENTITY);
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject info = (DynamicObject)entryEntity.get(i);
            if (!formId.equals(info.getString(FORMID))) continue;
            return i;
        }
        return -1;
    }

    private void showOperationCol(String pageType) {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(TREEENTRYENTITY);
        if (StringUtils.equals((CharSequence)ZERO, (CharSequence)pageType)) {
            entryGrid.setColumnProperty("operationcolumnap1", "vi", (Object)Boolean.TRUE);
        } else {
            entryGrid.setColumnProperty("operationcolumnap1", "vi", (Object)Boolean.FALSE);
        }
        String numberCaption = ResManager.loadKDString((String)"\u5bf9\u8c61\u7f16\u7801", (String)"EcologyAppDetailPlugin_23", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]);
        String nameCaption = ResManager.loadKDString((String)"\u5bf9\u8c61\u540d\u79f0", (String)"EcologyAppDetailPlugin_24", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]);
        switch (pageType) {
            case "0": {
                break;
            }
            case "1": {
                numberCaption = ResManager.loadKDString((String)"\u9875\u9762\u7f16\u7801", (String)"EcologyAppDetailPlugin_25", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]);
                nameCaption = ResManager.loadKDString((String)"\u9875\u9762\u540d\u79f0", (String)"EcologyAppDetailPlugin_26", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]);
                break;
            }
            case "2": {
                numberCaption = ResManager.loadKDString((String)"\u62a5\u8868\u7f16\u7801", (String)"EcologyAppDetailPlugin_27", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]);
                nameCaption = ResManager.loadKDString((String)"\u62a5\u8868\u540d\u79f0", (String)"EcologyAppDetailPlugin_28", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]);
                break;
            }
            case "3": {
                numberCaption = ResManager.loadKDString((String)"\u53c2\u6570\u7f16\u7801", (String)"EcologyAppDetailPlugin_29", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]);
                nameCaption = ResManager.loadKDString((String)"\u53c2\u6570\u540d\u79f0", (String)"EcologyAppDetailPlugin_30", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]);
                break;
            }
            case "5": {
                numberCaption = ResManager.loadKDString((String)"\u5e03\u5c40\u7f16\u7801", (String)"EcologyAppDetailPlugin_31", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]);
                nameCaption = ResManager.loadKDString((String)"\u5e03\u5c40\u540d\u79f0", (String)"EcologyAppDetailPlugin_32", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]);
                break;
            }
        }
        entryGrid.setColumnProperty(NUMBER, "header", (Object)numberCaption);
        entryGrid.setColumnProperty(NAME, "header", (Object)nameCaption);
    }

    private void tabActive(String pageType) {
        if (StringUtils.isBlank((CharSequence)pageType)) {
            pageType = PageType.EntityObject.getValue();
        }
        String tabKey = KEY_TAB_OBJECT;
        switch (pageType) {
            case "0": {
                break;
            }
            case "1": {
                tabKey = KEY_TAB_DEVPAGE;
                break;
            }
            case "2": {
                tabKey = KEY_TAB_REPORT;
                break;
            }
            case "3": {
                tabKey = KEY_TAB_PARAM;
                break;
            }
            case "5": {
                tabKey = KEY_TAB_LAYOUT;
                break;
            }
        }
        this.getPageCache().put("activerByServer", "true");
        Tab tabap = (Tab)this.getView().getControl(KEY_TABAP);
        tabap.activeTab(tabKey);
    }
}

