/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.newdevportal.app.my;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.devportal.common.util.AppUtils;
import kd.bos.devportal.util.DevportalUtil;
import kd.bos.devportal.util.SVNManageUtil;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.isv.ISVService;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.metadata.devportal.EnvTypeHelper;
import kd.bos.mservice.svc.picture.IImage;
import kd.bos.newdevportal.app.my.DevpPermissionUtils;
import kd.bos.newdevportal.app.my.MyAppUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.util.DevportalCommonUtil;
import kd.bos.url.UrlService;

public class AppDetailViewPlugin
extends AbstractFormPlugin {
    private static final String EntityId_App = "bos_devportal_bizapp";
    private static final String BIZAPPID = "bizappid";
    private static final String KEY_BIZCLOUDID = "bizcloudid";
    private static final String BIZAPPNAME = "bizappname";
    private static final String APPID = "appid";
    private static final String BIZAPPNUMBER = "bizappnumber";
    private static final String SVNMSG = "svnmsg";
    private static final String GITMSG = "gitmsg";
    private static final String BOS_DEVP_GITMANAGE = "bos_devp_gitmanage";
    private static final String GITMANAGECLOSECALLBACK = "gitmanageclosecallback";
    private static final String SAVE_JSESSION_ID = "SAVE_JSESSION_ID";
    private static final String SUCCESS = "success";
    private static final String Key_BtnEditApp = "btneditapp";
    private static final String BIZCLOUDNUMBER = "bizcloudnumber";
    private static final String ADDNEW = "ADDNEW";
    private static final String APPWINDOWCLOSE = "appWindowClose";
    private static final String NAME = "name";
    private static final String Key_BtnExtend = "btnextend";
    protected static final String Key_BtnRefresh = "barrefresh";
    private static final String REFRESHAPPLISTCALLBACK = "refreshapplistcallback";
    private static final String BOS_DEVPORTAL_BIZAPPLIST = "bos_devportal_bizapplist";
    private static final String BOS_DEVPORTAL_BIZAPP = "bos_devportal_bizapp";
    private static final String FORMID_APPDETAIL = "bos_devn_appdetail";
    private static List<String> editOp = new ArrayList<String>(10);

    public void initialize() {
        super.initialize();
        this.addItemClickListeners(new String[]{"tbar_main"});
        this.addClickListeners(new String[]{Key_BtnEditApp});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String bizappId = (String)this.getView().getFormShowParameter().getCustomParam("bizappId");
        MyAppUtils.appBarItemVisibleManager(this.getView(), bizappId);
        this.setAppDetailInfo();
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        boolean type = DevportalCommonUtil.isGitManageType();
        if (type) {
            clientViewProxy.getClientLocalStorage(GITMSG);
        } else {
            clientViewProxy.getClientLocalStorage(SVNMSG);
        }
    }

    public void clientCallBack(ClientCallBackEvent e) {
        Map param = e.getParam();
        if (SVNMSG.equals(e.getName())) {
            if (StringUtils.isNotBlank((Object)param)) {
                String svnSessionId = (String)param.get("actonResult");
                this.getPageCache().put("svnSessionId", svnSessionId);
            } else {
                this.getPageCache().put("svnSessionId", "");
            }
        } else if (GITMSG.equals(e.getName())) {
            if (StringUtils.isNotBlank((Object)param)) {
                String gitSessionId = (String)param.get("actonResult");
                this.getPageCache().put("gitSessionId", gitSessionId);
            } else {
                this.getPageCache().put("gitSessionId", "");
            }
        }
    }

    private void setAppDetailInfo() {
        String type;
        String bizappId = (String)this.getView().getFormShowParameter().getCustomParam("bizappId");
        if (StringUtils.isBlank((CharSequence)bizappId)) {
            return;
        }
        DynamicObject bizApp = BusinessDataServiceHelper.loadSingleFromCache((Object)bizappId, (String)"bos_devportal_bizapp");
        String domainUrl = UrlService.getDomainContextUrl();
        String image = bizApp.getString("image");
        if (StringUtils.isNotBlank((CharSequence)image) && !image.startsWith("/")) {
            image = '/' + image;
        }
        String appName = bizApp.getString(NAME);
        String description = bizApp.getString("description");
        String number = bizApp.getString("number");
        DynamicObject cloud = (DynamicObject)bizApp.get("bizcloud");
        String cloudName = cloud == null ? "" : cloud.getString(NAME);
        String isv = bizApp.getString("isv");
        boolean allUserApp = bizApp.getBoolean("alluserapp");
        String dbRoute = bizApp.getString("dbroute");
        this.DeployStatuStyle();
        JSONObject instance = DevportalUtil.getDbInstanceInfo((String)dbRoute);
        String routeKey = (String)instance.get((Object)"number");
        if (StringUtils.isBlank((CharSequence)routeKey)) {
            routeKey = dbRoute;
        }
        if (!"2".equals(type = bizApp.getString("type"))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{Key_BtnExtend});
        }
        IImage imageAp = (IImage)this.getControl("imageap");
        imageAp.setUrl(domainUrl + image);
        this.setLabelText("namelabelap", appName);
    }

    private void setLabelText(String key, String text) {
        Label labelAp = (Label)this.getControl(key);
        labelAp.setText(text);
    }

    private String getRouteName(String dbRoute) {
        JSONArray dbInstanceList = DevportalUtil.getDbInstanceList();
        for (Object route : dbInstanceList) {
            JSONObject db = (JSONObject)route;
            String dbNumber = db.getString("number");
            if (!dbRoute.equalsIgnoreCase(dbNumber)) continue;
            return db.getString(NAME);
        }
        return dbRoute;
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (editOp.contains(key) && EnvTypeHelper.isProductEnv()) {
            String errorMsg = ResManager.loadKDString((String)"\u4e3a\u4fdd\u8bc1\u73af\u5883\u7a33\u5b9a\uff0c\u751f\u4ea7\u73af\u5883\u6682\u4e0d\u5141\u8bb8\u7f16\u8f91\u5143\u6570\u636e\u3002", (String)"AppDetailViewPlugin_0", (String)"bos-devportal-new-plugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(errorMsg);
            return;
        }
        switch (key) {
            case "btneditapp": {
                this.openAppEditWindow("EDIT");
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String operationKey = evt.getItemKey();
        if (editOp.contains(operationKey) && EnvTypeHelper.isProductEnv()) {
            String errorMsg = ResManager.loadKDString((String)"\u4e3a\u4fdd\u8bc1\u73af\u5883\u7a33\u5b9a\uff0c\u751f\u4ea7\u73af\u5883\u6682\u4e0d\u5141\u8bb8\u7f16\u8f91\u5143\u6570\u636e\u3002", (String)"AppDetailViewPlugin_0", (String)"bos-devportal-new-plugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(errorMsg);
            return;
        }
        String bizappId = (String)this.getView().getFormShowParameter().getCustomParam("bizappId");
        if (StringUtils.isBlank((CharSequence)bizappId)) {
            return;
        }
        switch (operationKey) {
            case "bariteextends": {
                this.extendApp();
                break;
            }
            case "exportapp": {
                this.exportApp(bizappId);
                break;
            }
            case "scriptmgmt": {
                this.scriptManage();
                break;
            }
            case "baritemmenu": {
                DynamicObject bizapp = BusinessDataServiceHelper.loadSingleFromCache((Object)bizappId, (String)"bos_devportal_bizapp");
                this.goto_menuManager(bizapp);
                break;
            }
            case "enable": {
                this.publishApp(bizappId, "1");
                break;
            }
            case "disenable": {
                this.publishApp(bizappId, "2");
                break;
            }
            case "codemanage": {
                this.codeManage(bizappId);
                break;
            }
            case "barrefresh": {
                this.setAppDetailInfo();
                break;
            }
        }
    }

    private void openAppEditWindow(String status) {
        boolean isHasPermisson = false;
        String bizAppId = (String)this.getView().getFormShowParameter().getCustomParam("bizappId");
        AppMetadata appMeta = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)bizAppId, (boolean)false);
        String bizCloudId = appMeta.getBizCloudID();
        if (ADDNEW.equals(status)) {
            isHasPermisson = DevpPermissionUtils.hasBizAppViewPermission(this.getView().getFormShowParameter().getAppId(), "47156aff000000ac");
        } else if ("EDIT".equals(status)) {
            isHasPermisson = DevpPermissionUtils.hasBizAppViewPermission(this.getView().getFormShowParameter().getAppId(), "4715a0df000000ac");
        } else if ("VIEW".equals(status)) {
            isHasPermisson = true;
        }
        if (!isHasPermisson) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u6ca1\u6709\u6743\u9650\uff0c\u8bf7\u6dfb\u52a0\u6743\u9650\u540e\u518d\u8bd5\u3002", (String)"AppDetailViewPlugin_2", (String)"bos-devportal-new-plugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject cloud = BusinessDataServiceHelper.loadSingleFromCache((Object)bizCloudId, (String)"bos_devportal_bizcloud", (String)"number");
        String bizCloudNumber = cloud == null ? "" : cloud.getString("number");
        BaseShowParameter parameter = new BaseShowParameter();
        parameter.setFormId(this.isModel() ? "bos_devp_model_layout" : "bos_devpn_app_layout");
        parameter.setCustomParam(KEY_BIZCLOUDID, (Object)bizCloudId);
        parameter.setCustomParam(BIZAPPID, (Object)bizAppId);
        parameter.setCustomParam(BIZCLOUDNUMBER, (Object)bizCloudNumber);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        if (ADDNEW.equals(status)) {
            parameter.setStatus(OperationStatus.ADDNEW);
            parameter.setCaption(ResManager.loadKDString((String)"\u65b0\u5efa\u5e94\u7528", (String)"AppDetailViewPlugin_3", (String)"bos-devportal-new-plugin", (Object[])new Object[0]));
        } else if ("EDIT".equals(status)) {
            parameter.setStatus(OperationStatus.EDIT);
            parameter.setCaption(ResManager.loadKDString((String)"\u4fee\u6539\u5e94\u7528", (String)"AppDetailViewPlugin_4", (String)"bos-devportal-new-plugin", (Object[])new Object[0]));
            parameter.setPkId((Object)bizAppId);
        } else if ("VIEW".equals(status)) {
            parameter.setStatus(OperationStatus.VIEW);
            parameter.setCaption(ResManager.loadKDString((String)"\u67e5\u770b\u5e94\u7528", (String)"AppDetailViewPlugin_5", (String)"bos-devportal-new-plugin", (Object[])new Object[0]));
            parameter.setPkId((Object)bizAppId);
        }
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, APPWINDOWCLOSE);
        parameter.setCloseCallBack(callBack);
        this.getPageCache().put(KEY_BIZCLOUDID, bizCloudId);
        this.getView().showForm((FormShowParameter)parameter);
    }

    private boolean isModel() {
        return this.getView().getFormShowParameter().getFormId().equals("bos_devn_appdetail_modal");
    }

    private void DeployStatuStyle() {
        String bizappId = (String)this.getView().getFormShowParameter().getCustomParam("bizappId");
        AppMetadata metadata = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)bizappId, (boolean)false);
        if ("2".equals(metadata.getAppElement().getDeployStatus())) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"deploystatusenable"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"deploystatusdisable"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"deploystatusenable"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"deploystatusdisable"});
        }
    }

    private void showExtendAppDetail(ClosedCallBackEvent e) {
        Object data = e.getReturnData();
        String bizappId = "";
        if (data instanceof Map) {
            bizappId = (String)((Map)data).get("bizAppId");
        }
        if (StringUtils.isBlank((CharSequence)bizappId)) {
            String bizAppId = (String)this.getView().getFormShowParameter().getCustomParam("bizappId");
            bizappId = this.getExtAppByAppId(bizAppId);
        }
        if (StringUtils.isBlank((CharSequence)bizappId)) {
            return;
        }
        MyAppUtils.showAppDetail(this.getView(), bizappId);
    }

    private String getExtAppByAppId(String bizAppId) {
        QFilter q = new QFilter("masterid", "=", (Object)bizAppId);
        String currentIsv = ISVService.getISVInfo().getId();
        QFilter qIsv = new QFilter("isv", "=", (Object)currentIsv);
        if ("kingdee".equalsIgnoreCase(currentIsv)) {
            QFilter qIsvNull = new QFilter("isv", "is null", (Object)Boolean.TRUE);
            qIsvNull = qIsvNull.or(new QFilter("isv", "=", (Object)" "));
            qIsv = qIsv.or(qIsvNull);
        }
        String extAppId = "";
        QFilter[] filters = new QFilter[]{q, qIsv};
        DynamicObjectCollection apps = QueryServiceHelper.query((String)"bos_devportal_bizapp", (String)"id,number", (QFilter[])filters);
        if (apps != null && !apps.isEmpty()) {
            extAppId = ((DynamicObject)apps.get(0)).getString("id");
        }
        return extAppId;
    }

    private void extendApp() {
        String bizappId = (String)this.getView().getFormShowParameter().getCustomParam("bizappId");
        DynamicObject bizapp = BusinessDataServiceHelper.loadSingleFromCache((Object)bizappId, (String)"bos_devportal_bizapp");
        String appNumber = bizapp.getString("number");
        String currentApp = BizAppServiceHelp.getAppRuntimeInfo((String)appNumber);
        Map currectAppMap = (Map)JSONObject.parseObject((String)currentApp, Map.class);
        String bizCloudId = (String)currectAppMap.get("cloudId");
        String bizCloudNumber = (String)currectAppMap.get("cloudNum");
        String countNumber = DevportalUtil.getParallelExtCountByIsv((String)bizappId, (String)"bos_devportal_bizapp", (String)"parentid");
        if (!"0".equals(countNumber)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5e94\u7528\u53ea\u5141\u8bb8\u6269\u5c551\u6b21\u3002", (String)"AppDetailViewPlugin_6", (String)"bos-devportal-new-plugin", (Object[])new Object[0]));
            return;
        }
        BaseShowParameter parameter = new BaseShowParameter();
        parameter.setFormId("bos_devpn_app_layout");
        parameter.setCustomParam(KEY_BIZCLOUDID, (Object)bizCloudId);
        parameter.setCustomParam(BIZCLOUDNUMBER, (Object)bizCloudNumber);
        parameter.setCustomParam("apptype", (Object)"EXTEND_APP");
        parameter.setCustomParam(BIZAPPID, (Object)bizappId);
        parameter.setStatus(OperationStatus.ADDNEW);
        parameter.setCaption(ResManager.loadKDString((String)"\u6269\u5c55\u5e94\u7528", (String)"AppDetailViewPlugin_7", (String)"bos-devportal-new-plugin", (Object[])new Object[0]));
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "appExtendsWindowClose"));
        this.getPageCache().put(KEY_BIZCLOUDID, bizCloudId);
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void exportApp(String bizAppId) {
        boolean isHasPermisson = DevpPermissionUtils.hasBizAppViewPermission(this.getView().getFormShowParameter().getAppId(), "4730fc9f000004ae");
        if (!isHasPermisson) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u6ca1\u6709\u5bfc\u51fa\u6743\u9650\uff0c\u8bf7\u5148\u6dfb\u52a0\u5bfc\u51fa\u6743\u9650\u540e\u518d\u8bd5\u3002", (String)"AppDetailViewPlugin_8", (String)"bos-devportal-new-plugin", (Object[])new Object[0]));
            return;
        }
        if (!AppUtils.checkResourceBelongsToCurDeveloper((String)bizAppId)) {
            this.getView().showTipNotification(DevportalUtil.getNoPermissionTip());
            return;
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("bos_devp_madeapppack_inh");
        parameter.setCaption(ResManager.loadKDString((String)"\u5e94\u7528\u5bfc\u51fa\u5411\u5bfc", (String)"AppDetailViewPlugin_9", (String)"bos-devportal-new-plugin", (Object[])new Object[0]));
        parameter.setCustomParam(BIZAPPID, (Object)bizAppId);
        parameter.setCustomParam("checkTempAttUrlPerm", (Object)true);
        parameter.setCustomParam("attDownloadRight_entityNum", (Object)"bos_devpn_portal_grid");
        parameter.setCustomParam("attDownloadRight_appId", (Object)"devnew");
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "madeappdeploycallback");
        parameter.setCloseCallBack(callBack);
        this.getView().showForm(parameter);
        MultiLangEnumBridge opName = new MultiLangEnumBridge("\u5bfc\u51fa", "AppDetailViewPlugin_10", "bos-devportal-new-plugin");
        MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u5bfc\u51fa\u4e1a\u52a1\u5e94\u7528", "AppDetailViewPlugin_11", "bos-devportal-new-plugin");
        AppUtils.addOpLog((String)"bos_devportal_bizapp", (String)"export", (String)"bos_devportal_bizapp", (String)"1", (MultiLangEnumBridge)opName, (MultiLangEnumBridge)opDesc, (String[])new String[0]);
    }

    private void scriptManage() {
        String bizAppId = (String)this.getView().getFormShowParameter().getCustomParam("bizappId");
        AppMetadata appmeta = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)bizAppId, (boolean)false);
        String bizCloudId = appmeta.getBizCloudID();
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.NewWindow);
        parameter.setFormId("bos_devp_kde");
        parameter.setCustomParam(BIZAPPID, (Object)bizAppId);
        parameter.setCustomParam(KEY_BIZCLOUDID, (Object)bizCloudId);
        this.getView().showForm(parameter);
    }

    private void goto_menuManager(DynamicObject bizapp) {
        if (bizapp == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5e94\u7528id\u4e3a\u7a7a\u3002", (String)"AppDetailViewPlugin_12", (String)"bos-devportal-new-plugin", (Object[])new Object[0]));
            return;
        }
        String bizAppId = bizapp.getString("id");
        String bizAppName = bizapp.getString(NAME);
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        if (!AppUtils.checkResourceBelongsToCurDeveloper((String)bizAppId)) {
            parameter.setStatus(OperationStatus.VIEW);
        }
        parameter.setFormId("bos_devp_appmenu");
        parameter.setCustomParam(BIZAPPID, (Object)bizAppId);
        parameter.setCustomParam(BIZAPPNAME, (Object)bizAppName);
        this.getView().showForm(parameter);
    }

    private void publishApp(String bizAppId, String status) {
        boolean visible;
        this.getPageCache().put(BIZAPPID, bizAppId);
        DynamicObject appObj = BusinessDataServiceHelper.loadSingleFromCache((Object)bizAppId, (String)"bos_devportal_bizapp");
        String deployStatus = appObj.getString("deploystatus");
        if (!status.equals(deployStatus)) {
            if ("1".equals(status)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5e94\u7528\u5df2\u542f\u7528\u3002", (String)"AppDetailViewPlugin_13", (String)"bos-devportal-new-plugin", (Object[])new Object[0]));
                return;
            }
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5e94\u7528\u5df2\u7981\u7528\u3002", (String)"AppDetailViewPlugin_14", (String)"bos-devportal-new-plugin", (Object[])new Object[0]));
            return;
        }
        boolean bl = visible = "1".equals(appObj.getString("visible")) || "true".equals(appObj.getString("visible"));
        if (!visible) {
            String msg = "1".equals(deployStatus) ? ResManager.loadKDString((String)"\u5e94\u7528\u4e0d\u53ef\u89c1\uff0c\u65e0\u6cd5\u542f\u7528\u3002", (String)"AppDetailViewPlugin_15", (String)"bos-devportal-new-plugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4e0d\u53ef\u89c1\u7684\u5e94\u7528\uff0c\u4e0d\u80fd\u7981\u7528\u3002", (String)"AppDetailViewPlugin_16", (String)"bos-devportal-new-plugin", (Object[])new Object[0]);
            this.getView().showMessage(msg);
            return;
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.setCustomParam("deploystatus", (Object)deployStatus);
        parameter.setCustomParam(APPID, (Object)bizAppId);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("bos_devportal_uploadapp");
        String appName = appObj.getLocaleString(NAME).getLocaleValue();
        if ("1".equals(deployStatus)) {
            parameter.setCaption(ResManager.loadKDString((String)"\u542f\u7528\u5e94\u7528", (String)"AppDetailViewPlugin_17", (String)"bos-devportal-new-plugin", (Object[])new Object[0]));
            parameter.setCustomParam("message", (Object)String.format(ResManager.loadKDString((String)"\u786e\u5b9a\u542f\u7528%s\u5417\uff1f", (String)"AppDetailViewPlugin_18", (String)"bos-devportal-new-plugin", (Object[])new Object[0]), appName));
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, REFRESHAPPLISTCALLBACK));
            this.getView().showForm(parameter);
        } else {
            parameter.setCaption(ResManager.loadKDString((String)"\u7981\u7528\u5e94\u7528", (String)"AppDetailViewPlugin_19", (String)"bos-devportal-new-plugin", (Object[])new Object[0]));
            parameter.setCustomParam("message", (Object)String.format(ResManager.loadKDString((String)"\u786e\u5b9a\u7981\u7528%s\u5417\uff1f", (String)"AppDetailViewPlugin_20", (String)"bos-devportal-new-plugin", (Object[])new Object[0]), appName));
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, REFRESHAPPLISTCALLBACK));
            this.getView().showForm(parameter);
        }
    }

    private void codeManage(String bizAppId) {
        boolean type = DevportalCommonUtil.isGitManageType();
        String svnmsg = null;
        svnmsg = type ? this.getPageCache().get("gitSessionId") : this.getPageCache().get("svnSessionId");
        String bizAppNumber = MetadataDao.getAppNumberByAppId((String)bizAppId);
        this.getPageCache().put(BIZAPPID, bizAppId);
        this.getPageCache().put(BIZAPPNUMBER, bizAppNumber);
        this.getPageCache().put(SVNMSG, svnmsg);
        boolean flag = DevportalUtil.isGitManageType();
        String codeManageType = "svn";
        if (flag) {
            codeManageType = "git";
        }
        if ("code".equals(codeManageType)) {
            FormShowParameter parameter = new FormShowParameter();
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setCustomParam(BIZAPPID, (Object)bizAppId);
            parameter.setCustomParam(BIZAPPNUMBER, (Object)bizAppNumber);
            parameter.setCustomParam(SVNMSG, (Object)svnmsg);
            parameter.setFormId("bos_devp_codemanage");
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "codemanagecallback"));
            this.getView().showForm(parameter);
        } else if ("svn".equals(codeManageType)) {
            SVNManageUtil.svnManage((String)bizAppId, (String)bizAppNumber, (String)svnmsg, (AbstractFormPlugin)this);
        } else if ("git".equals(codeManageType)) {
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId(BOS_DEVP_GITMANAGE);
            parameter.setCustomParam(BIZAPPID, (Object)bizAppId);
            parameter.setCustomParam(SVNMSG, (Object)svnmsg);
            parameter.setCustomParam(BIZAPPNUMBER, (Object)bizAppNumber);
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, GITMANAGECLOSECALLBACK));
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(parameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        if ("svnmanagecallback".equals(e.getActionId())) {
            this.handleSvnManageCallback(e);
        } else if ("codemanagecallback".equals(e.getActionId()) && e.getReturnData() != null) {
            this.handleCodeManageCallback(e);
        } else if (GITMANAGECLOSECALLBACK.equals(e.getActionId())) {
            this.handleGitManageCloseCallback(e);
        } else if (REFRESHAPPLISTCALLBACK.equals(e.getActionId())) {
            this.DeployStatuStyle();
        } else if ("appExtendsWindowClose".equals(e.getActionId())) {
            this.showExtendAppDetail(e);
        } else if (APPWINDOWCLOSE.equals(e.getActionId())) {
            this.setAppDetailInfo();
        }
    }

    private void handleCodeManageCallback(ClosedCallBackEvent e) {
        String codeManageType = e.getReturnData().toString();
        String bizAppNumber = this.getPageCache().get(BIZAPPNUMBER);
        String svnmsg = this.getPageCache().get(SVNMSG);
        String bizAppId = this.getPageCache().get(BIZAPPID);
        if ("svn".equals(codeManageType)) {
            SVNManageUtil.svnManage((String)bizAppId, (String)bizAppNumber, (String)svnmsg, (AbstractFormPlugin)this);
        } else if ("git".equals(codeManageType)) {
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId(BOS_DEVP_GITMANAGE);
            parameter.setCustomParam(BIZAPPID, (Object)bizAppId);
            parameter.setCustomParam(SVNMSG, (Object)svnmsg);
            parameter.setCustomParam(BIZAPPNUMBER, (Object)bizAppNumber);
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, GITMANAGECLOSECALLBACK));
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(parameter);
        }
    }

    private void handleSvnManageCallback(ClosedCallBackEvent e) {
        if (e.getReturnData() != null) {
            JSONObject ret = (JSONObject)e.getReturnData();
            if (ret != null && ret.getString(BIZAPPID) != null && ret.getString(BIZAPPID).trim().length() > 0) {
                FormShowParameter parameter = new FormShowParameter();
                parameter.setFormId(BOS_DEVP_GITMANAGE);
                parameter.setCustomParam(BIZAPPID, (Object)ret.getString(BIZAPPID));
                parameter.setCustomParam(BIZAPPNUMBER, (Object)ret.getString(BIZAPPNUMBER));
                parameter.setCustomParam(SVNMSG, (Object)ret.getString(SVNMSG));
                parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, GITMANAGECLOSECALLBACK));
                parameter.getOpenStyle().setShowType(ShowType.Modal);
                this.getView().showForm(parameter);
            } else {
                JSONObject map = (JSONObject)e.getReturnData();
                if (SUCCESS.equals(map.getString("result"))) {
                    String svnmsg = map.getString("svnSessionId");
                    if (StringUtils.isNotBlank((CharSequence)svnmsg)) {
                        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
                        clientViewProxy.setClientLocalStorage(SVNMSG, svnmsg);
                        this.getPageCache().put("svnSessionId", svnmsg);
                    }
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"SVN\u7ba1\u7406\u4fdd\u5b58\u6210\u529f\u3002", (String)"AppDetailViewPlugin_21", (String)"bos-devportal-new-plugin", (Object[])new Object[0]));
                }
            }
        }
    }

    private void handleGitManageCloseCallback(ClosedCallBackEvent e) {
        if (e.getReturnData() != null && !"gitmanage".equals(e.getReturnData().toString())) {
            JSONObject ret = (JSONObject)e.getReturnData();
            String bizAppId = ret.getString(BIZAPPID);
            String bizAppNumber = ret.getString(BIZAPPNUMBER);
            String svnMsg = ret.getString(SVNMSG);
            SVNManageUtil.svnManage((String)bizAppId, (String)bizAppNumber, (String)svnMsg, (AbstractFormPlugin)this);
        }
    }

    static {
        editOp.add(Key_BtnEditApp);
        editOp.add("bariteextends");
        editOp.add("scriptmgmt");
        editOp.add("scriptmgmt");
        editOp.add("codemanage");
    }
}

