/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.newdevportal.app.my;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.devportal.util.DevportalUtil;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.devportal.AppFunctionPacketElement;
import kd.bos.entity.report.CellStyle;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.OperationColumn;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ListboxClickListener;
import kd.bos.form.control.events.ListboxEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.operatecol.OperationColItem;
import kd.bos.isv.ISVService;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.newdevportal.app.my.DevpPermissionUtils;
import kd.bos.newdevportal.app.my.DevportalModelTypes;
import kd.bos.newdevportal.app.my.PageType;
import kd.bos.newdevportal.bean.DynamicFormInfo;
import kd.bos.newdevportal.util.GotoDesignerUtils;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.portal.util.SerializationUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;

public class AppPageListPlugin
extends AbstractTreeListPlugin
implements ListboxClickListener,
TreeNodeClickListener,
TabSelectListener,
HyperLinkClickListener,
SearchEnterListener {
    private static final Log log = LogFactory.getLog(AppPageListPlugin.class);
    private static final String KEY_BTN_OBJECT = "btnobject";
    private static final String KEY_BTN_DEVPAGE = "btndevpage";
    private static final String KEY_BTN_PARAM = "btnparam";
    private static final String KEY_BTN_REPORT = "btnreport";
    private static final String KEY_BTN_LAYOUT = "btnlayout";
    private static final String KEY_TAB_OBJECT = "tabobject";
    private static final String KEY_TAB_DEVPAGE = "tabdevpage";
    private static final String KEY_TAB_PARAM = "tabparam";
    private static final String KEY_TAB_LAYOUT = "tablayout";
    private static final String KEY_TAB_REPORT = "tabreport";
    private static final String KEY_TABAP = "tabap";
    private static final String KEY_OPERATION_GIT = "gitoperation";
    private static final String KEY_OPERATION_SVN = "svnoperation";
    private static final String KEY_OPERATION_MORE = "moreoperation";
    private static final String KEY_BTNMY = "my";
    private static final String KEY_BTNORIGIN = "origin";
    private static final String BOS_DEVPORTAL_NEW_PLUGIN = "bos-devportal-new-plugin";
    private static final String KEY_ISV = "isv";
    private static final String KEY_BIZAPP = "bizappid";
    protected static final String Key_TreeView = "treeviewap";
    private static final String CacheId_CurrNode = "currnode";
    protected static final String CacheId_PageType = "currpagetype";
    private static final String CacheId_SearchText = "searchText";
    protected static final String KEY_PageType = "pageType";
    protected static final String Key_TreeEntryEntity = "treeentryentity";
    protected static final String Key_ID = "id";
    protected static final String Key_FORMID = "formid";
    private static final String Key_Number = "number";
    private static final String Key_Name = "name";
    private static final String Key_ModelType = "modeltype";
    private static final String Key_Client = "client";
    private static final String Key_SourcePage = "sourcepage";
    private static final String Key_SourcePage_ID = "sourcepageid";
    private static final String Key_Function = "function";
    private static final String Key_BizCloud = "bizCloud";
    private static final String Key_Modifier = "modifier";
    private static final String Key_ModifyDate = "modifydate";
    private static final String Key_BizUnitId = "bizunitid";
    private static final String Key_ENTRYID = "entityid";
    private static final String Key_PARENTENTRYID = "FParentEntryID";
    private static final String Key_MasterId = "masterid";
    private static final String KINGDEE = "kingdee";
    private static final String ENTITY_ID_KEY = "entityId";
    protected static final String KEY_BIZAPPTYPE = "bizapptype";
    protected static final String BIZAPPPARENTID = "bizappparentid";
    protected static final String Key_IsCollected = "iscollected";
    protected static final String Key_Enable = "enablestatus";
    protected static final String KEY_OpEabled = "enabled";
    protected static final String KEY_OpDisEabled = "disenabled";
    private static final String Key_Type = "type";
    protected static final String Key_MainPage = "MainPage";
    protected static final String Key_root_Id = "0";
    protected static final String Key_Search = "search";
    protected static final String Key_TreeSearch = "searchap";
    private static final String EntityId_Form = "bos_devpn_formmeta";
    private static final String EntityId_App = "bos_devportal_bizapp";
    private static final String EntityId_Cloud = "bos_devportal_bizcloud";
    private static final String EntityId_User = "bos_user";
    private static final String BOS_DEVPORTAL_SHORTCUT = "bos_devportal_shortcut";
    protected static final String Key_BtnNew = "btnnew";
    protected static final String Key_BtnExport = "btnexport";
    protected static final String Key_BtnImport = "btnimport";
    protected static final String Key_BtnDel = "btndelete";
    protected static final String Key_BtnInherit = "btninherit";
    protected static final String Key_BtnExtend = "btnextend";
    protected static final String Key_BtnCodeManage = "btncodemanage";
    private static final String Key_Color_DisEnable = "#b2b2b2";
    private static final String Key_Color_Enable = "#2ab277";
    protected static final String Key_KINGDEE = "kingdee";
    private static final String Key_NODATA = "nodatapanel";
    protected static final String Key_BTN_NEWGUIDE = "newguide";
    protected static final String Key_BTN_EXTENDGUIDE = "extendguide";
    private static final String Key_LABLE1 = "labelap1";
    private static final String Key_LABLE2 = "labelap2";
    private static final String Key_LABLE323 = "labelap323";
    protected static final String DEVTYPE = "devtype";
    private static final String Key_PANEL_TIPS = "flexpaneltips";
    private static final String Key_PANEL_MYAPP_TIPS = "myapppanel";
    private static final String Key_PANEL_NODATA_TIPS = "flexpanelnodatatips";
    private static final String CARD_VIEW = "cardview";
    private static final String LIST_VIEW = "listview";
    private TreeNode rootNode = null;

    public void initialize() {
        Tab tabap = (Tab)this.getView().getControl(KEY_TABAP);
        tabap.addTabSelectListener((TabSelectListener)this);
        Search search = (Search)this.getControl(Key_Search);
        search.addEnterListener((SearchEnterListener)this);
        Search treeSearch = (Search)this.getControl(Key_TreeSearch);
        treeSearch.addEnterListener((SearchEnterListener)this);
        this.addClickListeners(new String[]{LIST_VIEW, CARD_VIEW});
        TreeView tView = (TreeView)this.getControl(Key_TreeView);
        tView.addTreeNodeClickListener((TreeNodeClickListener)this);
        TreeEntryGrid treeGrid = (TreeEntryGrid)this.getView().getControl(Key_TreeEntryEntity);
        treeGrid.addHyperClickListener((HyperLinkClickListener)this);
        treeGrid.addPackageDataListener(pkEvent -> {
            block19: {
                String operationKey;
                Boolean enabled;
                Boolean isExt;
                String pageType;
                Boolean isDefaultLayout;
                block22: {
                    block21: {
                        block20: {
                            String formId = null;
                            String entityId = null;
                            isDefaultLayout = false;
                            pageType = null;
                            isExt = false;
                            enabled = true;
                            String masterId = null;
                            String parentId = null;
                            if (pkEvent.getRowData().containsProperty(Key_FORMID)) {
                                formId = pkEvent.getRowData().getString(Key_FORMID);
                            }
                            if (pkEvent.getRowData().containsProperty(Key_ENTRYID)) {
                                entityId = pkEvent.getRowData().getString(Key_ENTRYID);
                            }
                            if (pkEvent.getRowData().containsProperty("pagetype")) {
                                pageType = pkEvent.getRowData().getString("pagetype");
                            }
                            if (pkEvent.getRowData().containsProperty(Key_MasterId) && StringUtils.isNotBlank((CharSequence)pkEvent.getRowData().getString(Key_MasterId))) {
                                isExt = true;
                            }
                            if (pkEvent.getRowData().containsProperty(Key_Enable)) {
                                enabled = pkEvent.getRowData().getBoolean(Key_Enable);
                            }
                            if (pkEvent.getRowData().containsProperty(Key_MasterId)) {
                                masterId = pkEvent.getRowData().getString(Key_MasterId);
                            }
                            if (pkEvent.getRowData().containsProperty(Key_SourcePage_ID)) {
                                parentId = pkEvent.getRowData().getString(Key_SourcePage_ID);
                            }
                            if (formId != null && formId.equalsIgnoreCase(entityId)) {
                                isDefaultLayout = true;
                            }
                            if (!(pkEvent.getSource() instanceof OperationColumn)) break block19;
                            operationKey = ((OperationColumn)pkEvent.getSource()).getKey();
                            if (!"operationcolumnap1".equals(operationKey)) break block20;
                            List opItems = (List)pkEvent.getFormatValue();
                            boolean iscollected = pkEvent.getRowData().getBoolean(Key_IsCollected);
                            for (OperationColItem item : opItems) {
                                if (iscollected && "collection".equals(item.getOperationKey())) {
                                    item.setVisible(false);
                                }
                                if (iscollected || !"cancel_collection".equals(item.getOperationKey())) continue;
                                item.setVisible(false);
                            }
                            break block19;
                        }
                        if (!"operationcolumnap".equals(operationKey)) break block21;
                        List opItems = (List)pkEvent.getFormatValue();
                        int type = pkEvent.getRowData().getInt(Key_Type);
                        for (OperationColItem item : opItems) {
                            if (type != 2 || !"inherit".equals(item.getOperationKey())) continue;
                            item.setVisible(false);
                        }
                        break block19;
                    }
                    if (!KEY_OPERATION_GIT.equals(operationKey) && !KEY_OPERATION_SVN.equals(operationKey) && !"operationcolumnap3".equals(operationKey)) break block22;
                    if (!PageType.LayOut.getValue().equals(pageType)) break block19;
                    List opItems = (List)pkEvent.getFormatValue();
                    for (OperationColItem item : opItems) {
                        if (!isDefaultLayout.booleanValue()) continue;
                        item.setLocked(true);
                    }
                    break block19;
                }
                if (KEY_OPERATION_MORE.equals(operationKey)) {
                    List opItems = (List)pkEvent.getFormatValue();
                    for (OperationColItem item : opItems) {
                        String key;
                        if (isExt.booleanValue()) {
                            if (enabled.booleanValue() && KEY_OpEabled.equals(item.getOperationKey())) {
                                item.setVisible(false);
                            }
                            if (!enabled.booleanValue() && KEY_OpDisEabled.equals(item.getOperationKey())) {
                                item.setVisible(false);
                            }
                        } else if (KEY_OpDisEabled.equals(item.getOperationKey()) || KEY_OpEabled.equals(item.getOperationKey())) {
                            item.setVisible(false);
                        }
                        if (!PageType.LayOut.getValue().equals(pageType) || !isDefaultLayout.booleanValue() || (key = item.getOperationKey()).equals("preview") || key.equals("more")) continue;
                        item.setLocked(true);
                    }
                }
            }
        });
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        boolean isHasPermisson = DevpPermissionUtils.hasBizPageViewPermission(null, "47150e89000000ac");
        if (!isHasPermisson) {
            e.setCancelMessage(ResManager.loadKDString((String)"\u8bf7\u6dfb\u52a0\u4e1a\u52a1\u5bf9\u8c61\u7684\u67e5\u8be2\u6743\u9650\u3002", (String)"AppPageListPlugin_22", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
            e.setCancel(true);
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.loadAppDetail(false);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String pageType = Key_root_Id;
        if (StringUtils.isNotBlank((CharSequence)((CharSequence)this.getView().getFormShowParameter().getCustomParam(KEY_PageType)))) {
            pageType = (String)this.getView().getFormShowParameter().getCustomParam(KEY_PageType);
            this.getPageCache().put(CacheId_PageType, pageType);
        }
        this.tabActive(pageType);
        this.changeOperation(pageType);
        this.markTargetPage(this.getBizUnitId(false), this.getBizPageId());
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "cardview": {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u529f\u80fd\u5f00\u53d1\u4e2d\uff0c\u656c\u8bf7\u671f\u5f85\u3002", (String)"AppPageListPlugin_23", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]), MessageBoxOptions.OK);
                break;
            }
        }
    }

    protected void loadAppDetail(boolean refresh) {
        boolean isTabActive;
        TreeNode rootNode = this.buildTreeNodes(null);
        TreeView tView = (TreeView)this.getControl(Key_TreeView);
        if (refresh) {
            tView.updateNode(rootNode);
        } else {
            tView.addNode(rootNode);
        }
        String pageType = Key_root_Id;
        if (refresh) {
            if (this.getPageCache().get(CacheId_PageType) != null) {
                pageType = this.getPageCache().get(CacheId_PageType);
            }
        } else if (StringUtils.isNotBlank((CharSequence)((CharSequence)this.getView().getFormShowParameter().getCustomParam(KEY_PageType)))) {
            pageType = (String)this.getView().getFormShowParameter().getCustomParam(KEY_PageType);
            this.getPageCache().put(CacheId_PageType, pageType);
        }
        boolean bl = isTabActive = this.getView().getFormShowParameter().getCustomParam("isTabActive") == null ? false : (Boolean)this.getView().getFormShowParameter().getCustomParam("isTabActive");
        if (isTabActive || refresh) {
            if (!refresh) {
                this.tabActive(pageType);
            }
            this.changeOperation(pageType);
            this.markTargetPage(this.getBizUnitId(refresh), this.getBizPageId());
        }
    }

    protected void markTargetPage(String bizUnitId, String bizPageId) {
        if (StringUtils.isNotBlank((CharSequence)bizUnitId)) {
            TreeView tView = (TreeView)this.getControl(Key_TreeView);
            tView.treeNodeClick(Key_root_Id, bizUnitId);
            TreeNode node = this.getRootNode().getTreeNode(bizUnitId, 10);
            tView.focusNode(node);
        }
        if (StringUtils.isNotBlank((CharSequence)bizPageId)) {
            TreeEntryGrid grid = (TreeEntryGrid)this.getControl(Key_TreeEntryEntity);
            int rowIndex = this.findRowById(bizPageId);
            grid.selectRows(rowIndex);
            String masterId = (String)this.getModel().getValue(Key_MasterId, rowIndex);
            if (StringUtils.isNotBlank((CharSequence)masterId)) {
                int masterIndex = this.findRowById(masterId);
                grid.expand(masterIndex);
            }
            this.pageBarItemManager(this.getView(), bizPageId);
        }
    }

    protected void pageBarItemManager(IFormView formView, String formId) {
    }

    private String getBizUnitId(boolean refresh) {
        String bizunitid = Key_root_Id;
        if (refresh) {
            if (this.getPageCache().get(CacheId_CurrNode) != null) {
                bizunitid = this.getPageCache().get(CacheId_CurrNode);
            } else if (this.getPageCache().get("bizUnitId") != null) {
                bizunitid = this.getPageCache().get("bizUnitId");
            }
        } else if (StringUtils.isNotBlank((CharSequence)((CharSequence)this.getView().getFormShowParameter().getCustomParam(Key_BizUnitId)))) {
            bizunitid = (String)this.getView().getFormShowParameter().getCustomParam(Key_BizUnitId);
        }
        return bizunitid;
    }

    protected String getBizPageId() {
        if (StringUtils.isNotBlank((CharSequence)((CharSequence)this.getView().getFormShowParameter().getCustomParam("bizPageId")))) {
            return (String)this.getView().getFormShowParameter().getCustomParam("bizPageId");
        }
        return "";
    }

    private int findRowById(String formId) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(Key_TreeEntryEntity);
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject info = (DynamicObject)entryEntity.get(i);
            if (!formId.equals(info.getString(Key_FORMID))) continue;
            return i;
        }
        return -1;
    }

    protected void refreshTreeNode() {
        TreeNode rootNode = this.buildTreeNodes(null);
        TreeView tView = (TreeView)this.getControl(Key_TreeView);
        tView.updateNode(rootNode);
    }

    protected TreeNode getRootNode() {
        if (this.rootNode != null) {
            return this.rootNode;
        }
        this.rootNode = this.buildTreeNodes(null);
        return this.rootNode;
    }

    private TreeNode buildTreeNodes(String searchText) {
        TreeNode node;
        String bizAppId = (String)this.getView().getFormShowParameter().getCustomParam("bizappId");
        TreeNode root = new TreeNode();
        root.setId(Key_root_Id);
        root.setText(ResManager.loadKDString((String)"\u5168\u90e8", (String)"AppPageListPlugin_0", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
        root.setParentid("");
        root.setIsOpened(true);
        if (StringUtils.isBlank((CharSequence)bizAppId)) {
            bizAppId = this.getPageCache().get("bizAppId");
        }
        if (StringUtils.isBlank((CharSequence)bizAppId)) {
            return root;
        }
        AppMetadata appMeta = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)bizAppId, (boolean)false);
        String bizAppType = appMeta.getDevType();
        String bizAppParentId = appMeta.getParentId();
        this.getPageCache().put(KEY_BIZAPPTYPE, bizAppType);
        this.getPageCache().put(BIZAPPPARENTID, bizAppParentId);
        ArrayList appFunctions = new ArrayList(16);
        appFunctions.addAll(appMeta.getAppFunctionPackets());
        Collections.sort(appFunctions, new Comparator<AppFunctionPacketElement>(){

            @Override
            public int compare(AppFunctionPacketElement o1, AppFunctionPacketElement o2) {
                if (o1.getSeq() < o2.getSeq()) {
                    return -1;
                }
                if (o1.getSeq() == o2.getSeq()) {
                    return 0;
                }
                return 1;
            }
        });
        LinkedHashMap<String, TreeNode> allNodes = new LinkedHashMap<String, TreeNode>(appFunctions.size());
        for (AppFunctionPacketElement appFunctionPacketElement : appFunctions) {
            node = new TreeNode();
            String nodeID = appFunctionPacketElement.getId();
            node.setText(appFunctionPacketElement.getName().getLocaleValue());
            node.setParentid(appFunctionPacketElement.getParentId());
            node.setId(nodeID);
            if (Key_MainPage.equals(appFunctionPacketElement.getNumber())) {
                this.getPageCache().put("bizUnitId", nodeID);
                this.getPageCache().put(Key_MainPage, nodeID);
            }
            if (StringUtils.isNotBlank((CharSequence)searchText) && !StringUtils.contains((CharSequence)node.getText(), (CharSequence)searchText)) continue;
            allNodes.put(nodeID, node);
        }
        for (Map.Entry entry : allNodes.entrySet()) {
            node = (TreeNode)entry.getValue();
            TreeNode parentNode = (TreeNode)allNodes.get(node.getParentid());
            if (parentNode != null) {
                parentNode.addChild(node);
                continue;
            }
            root.addChild(node);
        }
        return root;
    }

    public void search(SearchEnterEvent e) {
        Search search = (Search)e.getSource();
        if (StringUtils.equals((CharSequence)Key_Search, (CharSequence)search.getKey())) {
            String searchText = e.getText();
            this.getPageCache().put(CacheId_SearchText, searchText);
            String pageType = this.getPageCache().get(CacheId_PageType);
            String currNodeId = this.getPageCache().get(CacheId_CurrNode);
            this.renderTreeEntity(pageType, 0, null, currNodeId, searchText);
        } else if (StringUtils.equals((CharSequence)Key_TreeSearch, (CharSequence)search.getKey())) {
            this.rootNode = this.buildTreeNodes(e.getText());
            TreeView tree = (TreeView)this.getControl(Key_TreeView);
            tree.updateNode(this.rootNode);
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent args) {
        String fieldName = args.getFieldName();
        String pageType = this.getPageCache().get(CacheId_PageType);
        if (StringUtils.isBlank((CharSequence)pageType)) {
            pageType = PageType.EntityObject.getValue();
        }
        switch (fieldName) {
            case "sourcepage": {
                String formId = (String)this.getModel().getValue(Key_SourcePage_ID, args.getRowIndex());
                GotoDesignerUtils.gotoDesigner(pageType, this.getView(), formId);
                break;
            }
            case "number": {
                String id = (String)this.getModel().getValue(Key_FORMID, args.getRowIndex());
                GotoDesignerUtils.gotoDesigner(pageType, this.getView(), id);
                break;
            }
        }
    }

    public void treeNodeClick(TreeNodeEvent e) {
        String newNodeId = (String)e.getNodeId();
        this.getPageCache().put(CacheId_CurrNode, newNodeId);
        String pageType = this.getPageCache().get(CacheId_PageType);
        this.renderTreeEntity(pageType, 0, null, newNodeId, "");
    }

    public void tabSelected(TabSelectEvent evt) {
        String pageType = Key_root_Id;
        switch (evt.getTabKey()) {
            case "tabobject": {
                break;
            }
            case "tabdevpage": {
                pageType = "1";
                break;
            }
            case "tabreport": {
                pageType = "2";
                break;
            }
            case "tabparam": {
                pageType = "3";
                break;
            }
            case "tablayout": {
                pageType = "5";
                break;
            }
        }
        this.getPageCache().put(CacheId_PageType, pageType);
        this.changeOperation(pageType);
        String activerByServer = this.getPageCache().get("activerByServer");
        if (StringUtils.isNotBlank((CharSequence)activerByServer) && "true".equals(activerByServer)) {
            this.getPageCache().remove("activerByServer");
            return;
        }
        String nodeId = this.getPageCache().get(CacheId_CurrNode);
        TreeView treeView = (TreeView)this.getControl(Key_TreeView);
        if (StringUtils.isBlank((CharSequence)nodeId)) {
            nodeId = treeView.getTreeState().getFocusNodeId();
        }
        String searchText = this.getPageCache().get(CacheId_SearchText);
        this.renderTreeEntity(pageType, 0, null, nodeId, searchText);
    }

    private String pageTypeToTab(String pageType) {
        String tab = KEY_BTN_OBJECT;
        switch (pageType) {
            case "0": {
                tab = KEY_BTN_OBJECT;
                break;
            }
            case "1": {
                tab = KEY_BTN_DEVPAGE;
                break;
            }
            case "2": {
                tab = KEY_BTN_REPORT;
                break;
            }
            case "3": {
                tab = KEY_BTN_PARAM;
                break;
            }
            case "5": {
                tab = KEY_BTN_LAYOUT;
                break;
            }
        }
        return tab;
    }

    protected void renderTreeEntity(String pageType, int type, List<QFilter> qFilters, String nodeId, String searchText) {
        boolean isSearch;
        Map<String, DynamicFormInfo> metas = this.loadPages(pageType, type, qFilters, nodeId, searchText);
        boolean bl = isSearch = StringUtils.isNotBlank((CharSequence)searchText);
        if (metas == null) {
            this.updateTabCount(metas, null, null, pageType, 0, isSearch);
            return;
        }
        HashSet<Long> userIds = new HashSet<Long>(16);
        HashSet<String> parentIds = new HashSet<String>(16);
        HashSet<String> formIds = new HashSet<String>(16);
        HashSet<String> masterIds = new HashSet<String>(16);
        HashSet<Object> mergerList = new HashSet<Object>(10);
        for (Map.Entry<String, DynamicFormInfo> entry : metas.entrySet()) {
            DynamicFormInfo info = entry.getValue();
            if (StringUtils.isNotBlank((CharSequence)info.getModifier())) {
                userIds.add(Long.parseLong(info.getModifier()));
            }
            if (StringUtils.isNotBlank((CharSequence)info.getSourcePage())) {
                parentIds.add(info.getSourcePage());
            }
            if (StringUtils.isNotBlank((CharSequence)info.getFormId())) {
                formIds.add(info.getFormId());
            }
            if (!StringUtils.isNotBlank((CharSequence)info.getMasterid())) continue;
            masterIds.add(info.getMasterid());
        }
        Map<String, DynamicFormInfo> masterList = this.getMasterMap(masterIds, nodeId, parentIds);
        this.addMasterUserId(userIds, masterList);
        Map<String, List<DynamicFormInfo>> extendMap = this.getExtendMap(formIds, nodeId, parentIds);
        this.addExtendUserId(userIds, extendMap);
        MainEntityType userDt = EntityMetadataCache.getDataEntityType((String)EntityId_User);
        MainEntityType formDt = EntityMetadataCache.getDataEntityType((String)EntityId_Form);
        Map users = BusinessDataReader.loadFromCache((Object[])userIds.toArray(), (DynamicObjectType)userDt);
        Map forms = BusinessDataReader.loadFromCache((Object[])parentIds.toArray(), (DynamicObjectType)formDt);
        List<DynamicFormInfo> formLists = this.getFormListByPageType(metas, pageType, mergerList, masterList, extendMap);
        String treeEntryEntity = Key_TreeEntryEntity;
        this.getModel().deleteEntryData(treeEntryEntity);
        if (formLists.isEmpty()) {
            this.updateTabCount(metas, masterList, extendMap, pageType, 0, isSearch);
            return;
        }
        int rowcount = mergerList.size();
        this.getModel().batchCreateNewEntryRow(treeEntryEntity, rowcount);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(treeEntryEntity);
        ArrayList<CellStyle> cellStyles = new ArrayList<CellStyle>(formLists.size());
        int index = 0;
        HashMap<String, Long> formId2RowId = new HashMap<String, Long>(10);
        for (DynamicFormInfo info : formLists) {
            List<DynamicFormInfo> extendForms;
            String masterId = info.getMasterid();
            long masterid = 0L;
            if (StringUtils.isNotBlank((CharSequence)masterId)) {
                Long rowId = (Long)formId2RowId.get(masterId);
                DynamicFormInfo masterForm = masterList.get(masterId);
                if (rowId == null) {
                    if (masterForm != null && this.renderRow(entryEntity, pageType, masterForm, forms, users, 0L, index, cellStyles, formId2RowId)) {
                        masterid = ((DynamicObject)entryEntity.get(index)).getLong(Key_ID);
                        ++index;
                    }
                } else {
                    masterid = rowId;
                }
            }
            long pid = 0L;
            if (this.renderRow(entryEntity, pageType, info, forms, users, masterid, index, cellStyles, formId2RowId)) {
                pid = ((DynamicObject)entryEntity.get(index)).getLong(Key_ID);
                ++index;
            } else {
                pid = (Long)formId2RowId.get(info.getFormId());
            }
            if ((extendForms = extendMap.get(info.getFormId())) == null) continue;
            for (DynamicFormInfo extendForm : extendForms) {
                if (!this.renderRow(entryEntity, pageType, extendForm, forms, users, pid, index, cellStyles, formId2RowId)) continue;
                ++index;
            }
        }
        this.updateTabCount(metas, masterList, extendMap, pageType, index, isSearch);
        this.getView().updateView(treeEntryEntity);
        EntryGrid entryGrid = (EntryGrid)this.getControl(treeEntryEntity);
        entryGrid.setCellStyle(cellStyles);
    }

    private void addMasterUserId(Set<Long> userIds, Map<String, DynamicFormInfo> formList) {
        if (formList == null || formList.isEmpty()) {
            return;
        }
        for (Map.Entry<String, DynamicFormInfo> entry : formList.entrySet()) {
            DynamicFormInfo info = entry.getValue();
            if (!StringUtils.isNotBlank((CharSequence)info.getModifier())) continue;
            userIds.add(Long.parseLong(info.getModifier()));
        }
    }

    private void addExtendUserId(Set<Long> userIds, Map<String, List<DynamicFormInfo>> formList) {
        if (formList == null || formList.isEmpty()) {
            return;
        }
        for (Map.Entry<String, List<DynamicFormInfo>> entry : formList.entrySet()) {
            List<DynamicFormInfo> list = entry.getValue();
            if (list == null) continue;
            for (DynamicFormInfo info : list) {
                if (!StringUtils.isNotBlank((CharSequence)info.getModifier())) continue;
                userIds.add(Long.parseLong(info.getModifier()));
            }
        }
    }

    private Map<String, List<DynamicFormInfo>> getExtendMap(Set<String> formIds, String nodeId, Set<String> parentIds) {
        ArrayList<QFilter> extendFilter = new ArrayList<QFilter>(1);
        extendFilter.add(new QFilter(Key_MasterId, "in", formIds));
        Map<String, DynamicFormInfo> extendList = AppPageListPlugin.queryFormDesignMeta(0, 10000, extendFilter, "modifydate desc", nodeId);
        HashMap<String, List<DynamicFormInfo>> extendMap = new HashMap<String, List<DynamicFormInfo>>(extendList.size());
        for (Map.Entry<String, DynamicFormInfo> entry : extendList.entrySet()) {
            DynamicFormInfo info = entry.getValue();
            String parentId = info.getSourcePage();
            parentIds.add(parentId);
            String masterId = info.getMasterid();
            ArrayList<DynamicFormInfo> list = (ArrayList<DynamicFormInfo>)extendMap.get(masterId);
            if (list == null) {
                list = new ArrayList<DynamicFormInfo>(1);
            }
            list.add(info);
            extendMap.put(masterId, list);
        }
        return extendMap;
    }

    private Map<String, DynamicFormInfo> getMasterMap(Set<String> masterIds, String nodeId, Set<String> parentIds) {
        ArrayList<QFilter> masterFilter = new ArrayList<QFilter>(1);
        masterFilter.add(new QFilter(Key_ID, "in", masterIds));
        Map<String, DynamicFormInfo> masterList = AppPageListPlugin.queryFormDesignMeta(0, 10000, masterFilter, "modifydate desc", nodeId);
        for (Map.Entry<String, DynamicFormInfo> entry : masterList.entrySet()) {
            DynamicFormInfo info = entry.getValue();
            String parentId = info.getSourcePage();
            parentIds.add(parentId);
        }
        return masterList;
    }

    private List<DynamicFormInfo> getFormListByPageType(Map<String, DynamicFormInfo> metas, String pageType, Set<Object> mergerList, Map<String, DynamicFormInfo> masterList, Map<String, List<DynamicFormInfo>> extendMap) {
        ArrayList<DynamicFormInfo> formLists = new ArrayList<DynamicFormInfo>(metas.size());
        if (pageType == null) {
            pageType = Key_root_Id;
        }
        List<String> enableModelTypes = DevportalModelTypes.getModelTypesByType(pageType);
        List<String> commonTypes = DevportalModelTypes.getModelTypesByType(PageType.Common.getValue());
        for (Map.Entry<String, DynamicFormInfo> entry : metas.entrySet()) {
            List<DynamicFormInfo> extendForms;
            DynamicFormInfo info = entry.getValue();
            String modelType = info.getModelType();
            if (!enableModelTypes.contains(modelType) || PageType.EntityObject.getValue().equals(pageType) && commonTypes.contains(modelType) && !info.getFormId().equals(info.getEntityId()) || PageType.Page.getValue().equals(pageType) && commonTypes.contains(modelType)) continue;
            String client = Key_root_Id;
            if (modelType.startsWith("Mobile")) {
                client = "1";
            }
            info.setClient(client);
            formLists.add(info);
            mergerList.add(info.getFormId());
            String masterId = info.getMasterid();
            if (StringUtils.isNotBlank((CharSequence)masterId) && masterList.containsKey(masterId)) {
                mergerList.add(masterId);
            }
            if ((extendForms = extendMap.get(info.getFormId())) == null) continue;
            for (DynamicFormInfo extendForm : extendForms) {
                mergerList.add(extendForm.getFormId());
            }
        }
        return formLists;
    }

    private boolean renderRow(DynamicObjectCollection entryEntity, String pageType, DynamicFormInfo info, Map<Object, DynamicObject> forms, Map<Object, DynamicObject> users, long pid, int index, List<CellStyle> cellStyles, Map<String, Long> formId2RowId) {
        Long rowId = formId2RowId.get(info.getFormId());
        if (rowId != null) {
            return false;
        }
        DynamicObject row = (DynamicObject)entryEntity.get(index);
        formId2RowId.put(info.getFormId(), row.getLong(Key_ID));
        int enable = info.getEnable();
        if (enable == 0) {
            cellStyles.add(this.genStyle(Key_Enable, index, Key_Color_DisEnable));
        } else {
            cellStyles.add(this.genStyle(Key_Enable, index, Key_Color_Enable));
        }
        row.set(Key_ENTRYID, (Object)info.getEntityId());
        row.set("pid", (Object)pid);
        row.set(Key_FORMID, (Object)info.getFormId());
        row.set(Key_Number, (Object)info.getNumber());
        row.set(Key_Name, (Object)info.getName());
        row.set(KEY_ISV, (Object)info.getIsv());
        if (PageType.LayOut.getValue().equals(pageType)) {
            row.set(Key_ModelType, (Object)ResManager.loadKDString((String)"\u8868\u5355+\u5217\u8868", (String)"AppPageListPlugin_24", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
        } else {
            row.set(Key_ModelType, (Object)info.getModelType());
        }
        row.set("pagetype", (Object)pageType);
        String modelType = info.getModelType();
        String terminal = "pc";
        if ("MobileFormModel".equals(modelType) || "MobileBillFormModel".equals(modelType) || "MobUserGuideFormModel".equals(modelType) || "MobileListModel".equals(modelType)) {
            terminal = "mobile";
        }
        row.set("terminal", (Object)terminal);
        if (StringUtils.isNotBlank((CharSequence)info.getSourcePage())) {
            DynamicObject form = forms.get(info.getSourcePage());
            row.set(Key_SourcePage, form == null ? null : form.get(Key_Number));
            row.set(Key_SourcePage_ID, (Object)info.getSourcePage());
        }
        row.set(Key_Modifier, StringUtils.isBlank((CharSequence)info.getModifier()) ? null : users.get(Long.parseLong(info.getModifier())));
        row.set(Key_ModifyDate, (Object)info.getModifyDate());
        row.set(Key_IsCollected, (Object)info.getIsCollected());
        row.set(Key_Enable, (Object)info.getEnable());
        row.set(Key_Type, (Object)info.getType());
        row.set(Key_MasterId, (Object)info.getMasterid());
        return true;
    }

    protected CellStyle genStyle(String key, int i, String foreColor) {
        CellStyle cellStyle = new CellStyle();
        cellStyle.setFieldKey(key);
        cellStyle.setRow(i);
        cellStyle.setForeColor(StringUtils.isBlank((CharSequence)foreColor) ? Key_Color_Enable : foreColor);
        return cellStyle;
    }

    protected void renderEnableStyle(int current) {
        int index = this.getModel().getEntryCurrentRowIndex(Key_TreeEntryEntity);
        this.getModel().setValue(Key_Enable, (Object)current, index);
        this.getView().updateView(Key_TreeEntryEntity, index);
        DynamicObjectCollection rows = this.getModel().getEntryEntity(Key_TreeEntryEntity);
        ArrayList<CellStyle> cellStyles = new ArrayList<CellStyle>(1);
        if (rows != null && !rows.isEmpty()) {
            for (int i = 0; i < rows.size(); ++i) {
                DynamicObject row = (DynamicObject)rows.get(i);
                int enable = row.getInt(Key_Enable);
                if (enable == 0) {
                    cellStyles.add(this.genStyle(Key_Enable, i, Key_Color_DisEnable));
                    continue;
                }
                cellStyles.add(this.genStyle(Key_Enable, i, Key_Color_Enable));
            }
        }
        EntryGrid entryGrid = (EntryGrid)this.getControl(Key_TreeEntryEntity);
        entryGrid.setCellStyle(cellStyles);
        ArrayList<String> opeIds = new ArrayList<String>();
        if (current == 1) {
            opeIds.add(KEY_OpEabled);
        } else {
            opeIds.add(KEY_OpDisEabled);
        }
        int rowIndex = this.getModel().getEntryCurrentRowIndex(Key_TreeEntryEntity);
        entryGrid.hideOperateItems(KEY_OPERATION_MORE, rowIndex, opeIds);
        this.getView().updateView(Key_TreeEntryEntity, rowIndex);
    }

    private Map<String, DynamicFormInfo> loadPages(String pageType, int type, List<QFilter> qFilters, String nodeId, String searchText) {
        if (qFilters == null) {
            qFilters = new ArrayList<QFilter>(10);
        }
        if (StringUtils.isNotBlank((CharSequence)searchText)) {
            String searchContent = String.format("%s%s%s", "%", searchText, "%");
            QFilter numberFilter = new QFilter(Key_Number, "like", (Object)searchContent);
            numberFilter.or(new QFilter(Key_Name, "like", (Object)searchContent));
            qFilters.add(numberFilter);
        }
        String bizappId = (String)this.getView().getFormShowParameter().getCustomParam("bizappId");
        qFilters.add(new QFilter(KEY_BIZAPP, "=", (Object)bizappId));
        String isv = ISVService.getISVInfo().getId();
        QFilter isvFilter = new QFilter(KEY_ISV, "=", (Object)isv);
        if (1 == type || "kingdee".equals(isv)) {
            isvFilter = new QFilter(KEY_ISV, "in", (Object)new String[]{"kingdee", " "});
        }
        qFilters.add(isvFilter);
        Map<String, DynamicFormInfo> metas = AppPageListPlugin.queryFormDesignMeta(0, 100000, qFilters, "modifydate desc", nodeId);
        if (metas == null || metas.isEmpty()) {
            return new LinkedHashMap<String, DynamicFormInfo>(1);
        }
        log.info(String.format("\u672c\u6b21\u67e5\u8be2\u5230\u5e94\u7528\u4e0b\u5355\u636e\u5171%s\u6761\uff0cids\uff1a%s", metas.size(), SerializationUtils.toJsonString(metas.keySet())));
        return metas;
    }

    protected static Map<String, DynamicFormInfo> queryFormDesignMeta(int start, int limit, List<QFilter> qFilters, String orderBy, String nodeId) {
        QFilter[] unitRelFormFilters = null;
        if (StringUtils.isBlank((CharSequence)nodeId)) {
            nodeId = Key_root_Id;
        }
        if (!Key_root_Id.equals(nodeId)) {
            QFilter unitRelFormFilter = new QFilter("bizunit", "=", (Object)nodeId);
            unitRelFormFilters = new QFilter[]{unitRelFormFilter};
        }
        String unitrelformFields = "bizapp,bizunit,form";
        String formFields = "id,number,modeltype,parentid,masterid,bizappid,bizappid.bizcloud,modifierid,modifydate,name,basedatafield,enable,type,isv";
        ORM orm = ORM.create();
        LinkedHashMap<String, DynamicFormInfo> map = new LinkedHashMap<String, DynamicFormInfo>(10);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:sss");
        long userId = RequestContext.get().getCurrUserId();
        QFilter shortcutFilter = new QFilter("user", "=", (Object)userId);
        QFilter[] shortcutFilters = new QFilter[]{shortcutFilter};
        String shortcutFields = "bizapp,bizpage";
        try (DataSet formMetaDataSet = orm.queryDataSet(EntityId_Form, EntityId_Form, formFields, qFilters.toArray(new QFilter[qFilters.size()]), orderBy, start, limit);
             DataSet unitRelFormDataSet = QueryServiceHelper.queryDataSet((String)"bos_devportal_unitrelform", (String)"bos_devportal_unitrelform", (String)unitrelformFields, (QFilter[])unitRelFormFilters, (String)"form asc");
             DataSet shortcutDataSet = QueryServiceHelper.queryDataSet((String)BOS_DEVPORTAL_SHORTCUT, (String)BOS_DEVPORTAL_SHORTCUT, (String)shortcutFields, (QFilter[])shortcutFilters, (String)"bizpage asc");
             DataSet result = unitRelFormDataSet.join(formMetaDataSet, JoinType.INNER).on("form", Key_ID).select(new String[]{"bizunit", "form"}, new String[]{Key_ID, Key_Number, Key_ModelType, "parentid", Key_MasterId, KEY_BIZAPP, "bizappid.bizcloud", "modifierid", Key_ModifyDate, Key_Name, "basedatafield", "enable", Key_Type, KEY_ISV}).finish().join(shortcutDataSet, JoinType.LEFT).on("form", "bizpage").select(new String[]{Key_ID, Key_Number, "bizunit", Key_ModelType, "parentid", Key_MasterId, KEY_BIZAPP, "bizappid.bizcloud", "modifierid", Key_ModifyDate, Key_Name, "bizapp", "basedatafield", "enable", Key_Type, KEY_ISV}, new String[]{"bizpage"}).finish().orderBy(new String[]{orderBy});){
            result.forEach(rs -> {
                String id = rs.getString(Key_ID);
                String number = rs.getString(Key_Number);
                String modelType = rs.getString(Key_ModelType);
                String parentId = rs.getString("parentid");
                String masterId = rs.getString(Key_MasterId);
                String bizappId = rs.getString(KEY_BIZAPP);
                String modifierId = rs.getString("modifierid");
                String modifyDateStr = rs.getString(Key_ModifyDate);
                String entityId = rs.getString("basedatafield");
                Date modifyDate = new Date();
                try {
                    modifyDate = sdf.parse(modifyDateStr);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                int isCollection = 0;
                if (rs.getString("bizapp") != null && rs.getString("bizpage") != null) {
                    isCollection = 1;
                }
                String name = rs.getString(Key_Name);
                String bizCloudId = rs.getString("bizappid.bizcloud");
                String bizUnitId = rs.getString("bizunit");
                String typeStr = rs.getString(Key_Type);
                String enableStr = rs.getString("enable");
                String isv = rs.getString(KEY_ISV);
                int enable = StringUtils.isBlank((CharSequence)enableStr) ? 0 : Integer.parseInt(enableStr);
                int type = StringUtils.isBlank((CharSequence)typeStr) ? 0 : Integer.parseInt(typeStr);
                DynamicFormInfo info = new DynamicFormInfo(number, name, modelType, bizappId, modifierId, modifyDate);
                info.setFormId(id);
                info.setBizCloud(bizCloudId);
                info.setSourcePage(parentId);
                info.setBizUnitId(bizUnitId);
                info.setIsCollected(isCollection);
                info.setEntityId(entityId);
                info.setEnable(enable);
                info.setType(type);
                info.setIsv(isv);
                info.setMasterid(masterId);
                map.put(id, info);
            });
        }
        return map;
    }

    public void listboxClick(ListboxEvent event) {
        String pageType = Key_root_Id;
        switch (event.getItemId()) {
            case "btnobject": {
                break;
            }
            case "btndevpage": {
                pageType = "1";
                break;
            }
            case "btnreport": {
                pageType = "2";
                break;
            }
            case "btnparam": {
                pageType = "3";
                break;
            }
            case "btnlayout": {
                pageType = "5";
                break;
            }
        }
        String nodeId = this.getPageCache().get(CacheId_CurrNode);
        TreeView treeView = (TreeView)this.getControl(Key_TreeView);
        if (StringUtils.isBlank((CharSequence)nodeId)) {
            nodeId = treeView.getTreeState().getFocusNodeId();
        }
        this.getPageCache().put(CacheId_PageType, pageType);
        this.renderTreeEntity(pageType, 0, null, nodeId, "");
    }

    private void changeOperation(String pageType) {
        if (StringUtils.isBlank((CharSequence)pageType)) {
            pageType = PageType.EntityObject.getValue();
        }
        String bizAppId = (String)this.getView().getFormShowParameter().getCustomParam("bizappId");
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(Key_TreeEntryEntity);
        if (PageType.EntityObject.getValue().equals(pageType)) {
            entryGrid.setColumnProperty("operationcolumnap2", "vi", (Object)Boolean.TRUE);
            entryGrid.setColumnProperty("operationcolumnap3", "vi", (Object)Boolean.FALSE);
        } else {
            entryGrid.setColumnProperty("operationcolumnap2", "vi", (Object)Boolean.FALSE);
            entryGrid.setColumnProperty("operationcolumnap3", "vi", (Object)Boolean.FALSE);
        }
        String codeManageType = DevportalUtil.getCodeManageTypeByBizAppId((String)bizAppId);
        if ("code".equals(codeManageType) || "none".equals(codeManageType)) {
            entryGrid.setColumnProperty(KEY_OPERATION_GIT, "vi", (Object)Boolean.FALSE);
            entryGrid.setColumnProperty(KEY_OPERATION_SVN, "vi", (Object)Boolean.FALSE);
        } else if ("svn".equals(codeManageType)) {
            entryGrid.setColumnProperty(KEY_OPERATION_GIT, "vi", (Object)Boolean.FALSE);
            entryGrid.setColumnProperty(KEY_OPERATION_SVN, "vi", (Object)Boolean.TRUE);
        } else if ("git".equals(codeManageType)) {
            entryGrid.setColumnProperty(KEY_OPERATION_GIT, "vi", (Object)Boolean.TRUE);
            entryGrid.setColumnProperty(KEY_OPERATION_SVN, "vi", (Object)Boolean.FALSE);
        }
        String numberCaption = ResManager.loadKDString((String)"\u5bf9\u8c61\u7f16\u7801", (String)"AppPageListPlugin_25", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]);
        String nameCaption = ResManager.loadKDString((String)"\u5bf9\u8c61\u540d\u79f0", (String)"AppPageListPlugin_26", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]);
        String gitOperation = ResManager.loadKDString((String)"\u64cd\u4f5c", (String)"AppPageListPlugin_27", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]);
        String svnOperation = ResManager.loadKDString((String)"\u64cd\u4f5c", (String)"AppPageListPlugin_27", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]);
        switch (pageType) {
            case "0": {
                gitOperation = "\u3000";
                svnOperation = "\u3000";
                break;
            }
            case "1": {
                numberCaption = ResManager.loadKDString((String)"\u9875\u9762\u7f16\u7801", (String)"AppPageListPlugin_28", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]);
                nameCaption = ResManager.loadKDString((String)"\u9875\u9762\u540d\u79f0", (String)"AppPageListPlugin_29", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]);
                break;
            }
            case "2": {
                numberCaption = ResManager.loadKDString((String)"\u62a5\u8868\u7f16\u7801", (String)"AppPageListPlugin_30", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]);
                nameCaption = ResManager.loadKDString((String)"\u62a5\u8868\u540d\u79f0", (String)"AppPageListPlugin_31", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]);
                break;
            }
            case "3": {
                numberCaption = ResManager.loadKDString((String)"\u53c2\u6570\u7f16\u7801", (String)"AppPageListPlugin_32", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]);
                nameCaption = ResManager.loadKDString((String)"\u53c2\u6570\u540d\u79f0", (String)"AppPageListPlugin_33", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]);
                break;
            }
            case "5": {
                numberCaption = ResManager.loadKDString((String)"\u5e03\u5c40\u7f16\u7801", (String)"AppPageListPlugin_34", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]);
                nameCaption = ResManager.loadKDString((String)"\u5e03\u5c40\u540d\u79f0", (String)"AppPageListPlugin_35", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]);
                break;
            }
        }
        entryGrid.setColumnProperty(Key_Number, "header", (Object)numberCaption);
        entryGrid.setColumnProperty(Key_Name, "header", (Object)nameCaption);
        entryGrid.setColumnProperty(KEY_OPERATION_GIT, "header", (Object)gitOperation);
        entryGrid.setColumnProperty(KEY_OPERATION_SVN, "header", (Object)svnOperation);
    }

    private void tabActive(String pageType) {
        if (StringUtils.isBlank((CharSequence)pageType)) {
            pageType = PageType.EntityObject.getValue();
        }
        String tabKey = KEY_TAB_OBJECT;
        switch (pageType) {
            case "0": {
                break;
            }
            case "1": {
                tabKey = KEY_TAB_DEVPAGE;
                break;
            }
            case "2": {
                tabKey = KEY_TAB_REPORT;
                break;
            }
            case "3": {
                tabKey = KEY_TAB_PARAM;
                break;
            }
            case "5": {
                tabKey = KEY_TAB_LAYOUT;
                break;
            }
        }
        this.getPageCache().put("activerByServer", "true");
        Tab tabap = (Tab)this.getView().getControl(KEY_TABAP);
        tabap.activeTab(tabKey);
    }

    private void setNodataGuide(String pageType, boolean isNodata, boolean isSearch) {
        String devType = this.getPageCache().get(DEVTYPE);
        if (!isSearch && isNodata) {
            this.getView().setVisible(Boolean.TRUE, new String[]{Key_PANEL_MYAPP_TIPS, Key_PANEL_TIPS});
            this.getView().setVisible(Boolean.FALSE, new String[]{Key_PANEL_NODATA_TIPS});
            this.getView().setVisible(Boolean.FALSE, new String[]{Key_TreeEntryEntity});
            this.getView().setVisible(Boolean.TRUE, new String[]{Key_NODATA});
            String labelText = ResManager.loadKDString((String)"\u6269\u5c55\u5e94\u7528\u4e0b\u6682\u65e0", (String)"AppPageListPlugin_1", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]);
            String labelText1 = ResManager.loadKDString((String)"\u60a8\u53ef\u4ee5\u9009\u62e9", (String)"AppPageListPlugin_2", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]);
            String newGuideText = ResManager.loadKDString((String)"\u65b0\u5efa\u4e1a\u52a1\u5bf9\u8c61", (String)"AppPageListPlugin_3", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]);
            String extendGuideText = ResManager.loadKDString((String)"\u6269\u5c55\u4e1a\u52a1\u5bf9\u8c61", (String)"AppPageListPlugin_4", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]);
            String pageTypeText = ResManager.loadKDString((String)"\u4e1a\u52a1\u5bf9\u8c61", (String)"AppPageListPlugin_5", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]);
            String currNode = this.getPageCache().get(CacheId_CurrNode);
            switch (pageType) {
                case "0": {
                    break;
                }
                case "1": {
                    newGuideText = ResManager.loadKDString((String)"\u65b0\u5efa\u9875\u9762", (String)"AppPageListPlugin_6", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]);
                    extendGuideText = ResManager.loadKDString((String)"\u6269\u5c55\u9875\u9762", (String)"AppPageListPlugin_36", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]);
                    pageTypeText = ResManager.loadKDString((String)"\u9875\u9762", (String)"AppPageListPlugin_7", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]);
                    break;
                }
                case "2": {
                    newGuideText = ResManager.loadKDString((String)"\u65b0\u5efa\u62a5\u8868", (String)"AppPageListPlugin_9", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]);
                    extendGuideText = ResManager.loadKDString((String)"\u6269\u5c55\u62a5\u8868", (String)"AppPageListPlugin_10", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]);
                    pageTypeText = ResManager.loadKDString((String)"\u62a5\u8868", (String)"AppPageListPlugin_11", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]);
                    break;
                }
                case "3": {
                    newGuideText = ResManager.loadKDString((String)"\u65b0\u5efa\u53c2\u6570", (String)"AppPageListPlugin_12", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]);
                    extendGuideText = ResManager.loadKDString((String)"\u6269\u5c55\u53c2\u6570", (String)"AppPageListPlugin_37", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]);
                    pageTypeText = ResManager.loadKDString((String)"\u53c2\u6570", (String)"AppPageListPlugin_13", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]);
                    break;
                }
                case "5": {
                    newGuideText = ResManager.loadKDString((String)"\u65b0\u5efa\u5e03\u5c40", (String)"AppPageListPlugin_15", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]);
                    extendGuideText = ResManager.loadKDString((String)"\u6269\u5c55\u5e03\u5c40", (String)"AppPageListPlugin_16", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]);
                    pageTypeText = ResManager.loadKDString((String)"\u5e03\u5c40", (String)"AppPageListPlugin_17", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]);
                    break;
                }
            }
            if ("2".equals(devType)) {
                labelText = StringUtils.isBlank((CharSequence)currNode) || Key_root_Id.equals(currNode) ? labelText + pageTypeText : ResManager.loadKDString((String)"\u6269\u5c55\u5e94\u7528\u8be5\u5206\u7ec4\u4e0b\u6682\u65e0%s\u3002", (String)"AppPageListPlugin_18", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[]{pageTypeText});
                labelText1 = ResManager.loadKDString((String)"\u60a8\u53ef\u4ee5\u53bb", (String)"AppPageListPlugin_19", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]);
                this.getView().setVisible(Boolean.TRUE, new String[]{Key_BTN_EXTENDGUIDE, Key_LABLE2});
            } else {
                labelText = StringUtils.isBlank((CharSequence)currNode) || Key_root_Id.equals(currNode) ? ResManager.loadKDString((String)"\u8be5\u5e94\u7528\u4e0b\u6682\u65e0%s\u3002", (String)"AppPageListPlugin_20", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[]{pageTypeText}) : ResManager.loadKDString((String)"\u8be5\u5206\u7ec4\u4e0b\u6682\u65e0%s", (String)"AppPageListPlugin_21", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[]{pageTypeText});
                this.getView().setVisible(Boolean.FALSE, new String[]{Key_BTN_EXTENDGUIDE, Key_LABLE2});
            }
            Label label1 = (Label)this.getControl(Key_LABLE1);
            label1.setText(labelText);
            Label label323 = (Label)this.getControl(Key_LABLE323);
            label323.setText(labelText1);
            Label newguide = (Label)this.getControl(Key_BTN_NEWGUIDE);
            newguide.setText(newGuideText);
            Label extendguide = (Label)this.getControl(Key_BTN_EXTENDGUIDE);
            extendguide.setText(extendGuideText);
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{Key_TreeEntryEntity});
            this.getView().setVisible(Boolean.FALSE, new String[]{Key_NODATA});
        }
    }

    private Map<String, Integer> getCount(Map<String, DynamicFormInfo> metas, Map<String, DynamicFormInfo> masterList, Map<String, List<DynamicFormInfo>> extendMap) {
        Integer object = 0;
        Integer page = 0;
        Integer report = 0;
        Integer parameter = 0;
        Integer layout = 0;
        HashMap<String, Integer> map = new HashMap<String, Integer>(6);
        List<String> objectTypes = DevportalModelTypes.getModelTypesByType(PageType.EntityObject.getValue());
        List<String> pageTypes = DevportalModelTypes.getModelTypesByType(PageType.Page.getValue());
        List<String> reportTypes = DevportalModelTypes.getModelTypesByType(PageType.Report.getValue());
        List<String> paramTypes = DevportalModelTypes.getModelTypesByType(PageType.Parameter.getValue());
        List<String> commonTypes = DevportalModelTypes.getModelTypesByType(PageType.Common.getValue());
        List<String> layoutTypes = DevportalModelTypes.getModelTypesByType(PageType.LayOut.getValue());
        log.debug("layoutTypes:" + SerializationUtils.toJsonString(layoutTypes));
        if (metas != null && !metas.isEmpty()) {
            HashSet<String> formId2RowId = new HashSet<String>(10);
            for (Map.Entry<String, DynamicFormInfo> entry : metas.entrySet()) {
                DynamicFormInfo info = entry.getValue();
                String modelType = info.getModelType();
                String masterId = info.getMasterid();
                String formId = info.getFormId();
                int masterSize = 0;
                if (masterList != null && masterList.get(masterId) != null && formId2RowId.add(masterId)) {
                    ++masterSize;
                }
                int extendSize = 0;
                if (extendMap != null && extendMap.get(formId) != null) {
                    List<DynamicFormInfo> extendList = extendMap.get(formId);
                    for (DynamicFormInfo extendinfo : extendList) {
                        if (formId2RowId.contains(extendinfo.getFormId())) continue;
                        ++extendSize;
                        formId2RowId.add(extendinfo.getFormId());
                    }
                }
                if (formId2RowId.contains(formId)) continue;
                formId2RowId.add(formId);
                if (objectTypes.contains(modelType)) {
                    if (commonTypes.contains(modelType)) {
                        if (info.getFormId().equals(info.getEntityId())) {
                            object = object + masterSize + extendSize + 1;
                        }
                    } else {
                        object = object + masterSize + extendSize + 1;
                    }
                }
                if (pageTypes.contains(modelType) && !commonTypes.contains(modelType)) {
                    page = page + masterSize + extendSize + 1;
                }
                if (reportTypes.contains(modelType)) {
                    report = report + masterSize + extendSize + 1;
                }
                if (paramTypes.contains(modelType)) {
                    parameter = parameter + masterSize + extendSize + 1;
                }
                if (!layoutTypes.contains(modelType)) continue;
                layout = layout + masterSize + extendSize + 1;
            }
        }
        map.put(KEY_BTN_OBJECT, object);
        map.put(KEY_BTN_DEVPAGE, page);
        map.put(KEY_BTN_REPORT, report);
        map.put(KEY_BTN_PARAM, parameter);
        map.put(KEY_BTN_LAYOUT, layout);
        return map;
    }

    private void updateTabCount(Map<String, DynamicFormInfo> metas, Map<String, DynamicFormInfo> masterList, Map<String, List<DynamicFormInfo>> extendMap, String pageType, int count, boolean isSearch) {
        if (pageType == null) {
            pageType = PageType.EntityObject.getValue();
        }
        Map<String, Integer> countMap = this.getCount(metas, masterList, extendMap);
        countMap.put(this.pageTypeToTab(pageType), count);
        int object = countMap.get(KEY_BTN_OBJECT);
        int page = countMap.get(KEY_BTN_DEVPAGE);
        int report = countMap.get(KEY_BTN_REPORT);
        int param = countMap.get(KEY_BTN_PARAM);
        int layout = countMap.get(KEY_BTN_LAYOUT);
        this.updateTabName(KEY_TAB_OBJECT, ResManager.loadKDString((String)"\u4e1a\u52a1\u5bf9\u8c61(%s)", (String)"AppPageListPlugin_38", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[]{object}));
        this.updateTabName(KEY_TAB_DEVPAGE, ResManager.loadKDString((String)"\u9875\u9762(%s)", (String)"AppPageListPlugin_39", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[]{page}));
        this.updateTabName(KEY_TAB_REPORT, ResManager.loadKDString((String)"\u62a5\u8868(%s)", (String)"AppPageListPlugin_40", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[]{report}));
        this.updateTabName(KEY_TAB_PARAM, ResManager.loadKDString((String)"\u53c2\u6570(%s)", (String)"AppPageListPlugin_41", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[]{param}));
        this.updateTabName(KEY_TAB_LAYOUT, ResManager.loadKDString((String)"\u5e03\u5c40(%s)", (String)"AppPageListPlugin_42", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[]{layout}));
        this.setNodataGuide(pageType, count == 0, isSearch);
    }

    private void updateTabName(String key, String name) {
        HashMap map = new HashMap(1);
        HashMap<String, String> nameMap = new HashMap<String, String>(1);
        nameMap.put("zh_CN", name);
        map.put("text", nameMap);
        this.getView().updateControlMetadata(key, map);
    }
}

