/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.newdevportal.app.my;

import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.PrintMetadata;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;

public class BizPageInheritTreePlugin
extends AbstractFormPlugin
implements TreeNodeClickListener {
    public void registerListener(EventObject e) {
        TreeView tree = (TreeView)this.getView().getControl("treeviewap");
        tree.addTreeNodeClickListener((TreeNodeClickListener)this);
    }

    public void afterCreateNewData(EventObject evt) {
        String formId = (String)this.getView().getFormShowParameter().getCustomParam("formId");
        TreeNode root = new TreeNode();
        TreeNode node = this.getTopPageInfo(formId, root);
        this.getAllChildrenPages(node);
        TreeView tree = (TreeView)this.getView().getControl("treeviewap");
        tree.addNode(root);
        tree.focusNode(node);
    }

    private TreeNode getTopPageInfo(String formId, TreeNode root) {
        DynamicObject dynamicObject;
        TreeNode node = new TreeNode();
        if (StringUtils.isNotBlank((CharSequence)formId) && (dynamicObject = BusinessDataServiceHelper.loadSingle((Object)formId, (String)"bos_formmeta", (String)"name,number,parentid,basedatafield,modeltype")) != null) {
            String formNumber = dynamicObject.getString("number");
            String formParentId = dynamicObject.getString("parentid_id");
            String formEntityId = dynamicObject.getString("basedatafield_id");
            String formModeltype = dynamicObject.getString("modeltype");
            String formName = dynamicObject.getString("name");
            if (StringUtils.isBlank((CharSequence)formName)) {
                formName = this.getFormMetaName(formId, formModeltype);
            }
            node.setId(formId);
            node.setText(formName + "(" + formNumber + ")");
            node.setData((Object)formNumber);
            node.setIsOpened(true);
            if (!formId.equals(formEntityId) && "".equals(formParentId) && !"PrintModel".equals(formModeltype) && !"MobileBillFormModel".equals(formModeltype)) {
                node.setParentid(formEntityId);
                TreeNode parentRoot = this.getTopPageInfo(formEntityId, root);
                parentRoot.addChild(node);
            } else if (formParentId != null && formParentId.trim().length() != 0) {
                node.setParentid(formParentId);
                TreeNode parentRoot = this.getTopPageInfo(formParentId, root);
                parentRoot.addChild(node);
            } else {
                node.setParentid("");
                root.setId(node.getId());
                root.setParentid(node.getParentid());
                root.setText(node.getText());
                root.setData(node.getData());
                root.setIsOpened(node.getIsOpened());
                return root;
            }
        }
        return node;
    }

    private String getFormMetaName(String formId, String modelType) {
        String formName = "";
        if ("PrintModel".equals(modelType)) {
            PrintMetadata printMeta = (PrintMetadata)MetadataDao.readMeta((String)formId, (MetaCategory)MetaCategory.Form);
            formName = printMeta.getName().getLocaleValue();
        } else {
            FormMetadata formMeta = (FormMetadata)MetadataDao.readMeta((String)formId, (MetaCategory)MetaCategory.Form);
            formName = formMeta.getName().getLocaleValue();
        }
        return formName;
    }

    private void getAllChildrenPages(TreeNode node) {
        String formId = node.getId();
        if (StringUtils.isNotBlank((CharSequence)formId)) {
            QFilter filter = new QFilter("parentid", "=", (Object)formId);
            Map dynamicObjects = BusinessDataServiceHelper.loadFromCache((String)"bos_formmeta", (String)"id,name,number,modeltype", (QFilter[])new QFilter[]{filter});
            for (Map.Entry entrySet : dynamicObjects.entrySet()) {
                DynamicObject dynamicObject = (DynamicObject)entrySet.getValue();
                String selectFormId = dynamicObject.getString("id");
                String formNumber = dynamicObject.getString("number");
                String formModeltype = dynamicObject.getString("modeltype");
                String formName = dynamicObject.getString("name");
                if (StringUtils.isBlank((CharSequence)formName)) {
                    formName = this.getFormMetaName(formId, formModeltype);
                }
                TreeNode childNode = new TreeNode();
                childNode.setId(selectFormId);
                childNode.setText(formName + "(" + formNumber + ")");
                childNode.setParentid(formId);
                childNode.setData((Object)formNumber);
                childNode.setIsOpened(false);
                this.getAllChildrenPages(childNode);
                node.addChild(childNode);
            }
        }
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        String selectedNodeId = evt.getNodeId().toString();
        this.gotoSelectedPage(selectedNodeId);
    }

    private void gotoSelectedPage(String selectedNodeId) {
        if (selectedNodeId == null) {
            this.getView().close();
            return;
        }
        JSONObject positionMsg = new JSONObject();
        positionMsg.put("bizpageid", (Object)selectedNodeId);
        QFilter q = new QFilter("form", "=", (Object)selectedNodeId);
        QFilter[] filters = new QFilter[]{q};
        boolean exists = QueryServiceHelper.exists((String)"bos_devportal_unitrelform", (QFilter[])filters);
        if (!exists) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u9875\u9762\u4e0d\u5728\u5f00\u53d1\u8005\u95e8\u6237\u4e2d\u3002", (String)"BizPageInheritTreePlugin_0", (String)"bos-devportal-new-plugin", (Object[])new Object[0]));
        } else {
            String selectFields = "id,bizapp,bizunit";
            DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"bos_devportal_unitrelform", (String)selectFields, (QFilter[])filters);
            for (DynamicObject dynamicObject : dynamicObjects) {
                String bizAppId = dynamicObject.getString("bizapp");
                positionMsg.put("bizappid", (Object)bizAppId);
                positionMsg.put("bizunitid", (Object)dynamicObject.getString("bizunit"));
                AppMetadata appMeta = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)bizAppId, (boolean)false);
                positionMsg.put("bizcloudid", (Object)appMeta.getBizCloudID());
            }
            this.getView().returnDataToParent((Object)positionMsg);
        }
        this.getView().close();
    }
}

