/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.newdevportal.app.my;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.devportal.util.DevportalUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.report.CellStyle;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.OperationColumn;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.operatecol.OperationColItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.isv.ISVService;
import kd.bos.newdevportal.app.my.DevpPermissionUtils;
import kd.bos.newdevportal.app.my.MyAppUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.runmode.RunModeServiceHelper;
import kd.bos.url.UrlService;

public class MyAppList
extends AbstractFormPlugin
implements TreeNodeClickListener,
SearchEnterListener,
EntryGridBindDataListener {
    private static final String Key_TreeView = "treeviewap";
    protected static final String Key_TreeEntryEntity = "treeentryentity";
    protected static final String Key_EntryEntity = "entryentity";
    private static final String Key_ListView = "listview";
    private static final String Key_CardView = "cardview";
    protected static final String Key_Search = "search";
    protected static final String Key_SearchCloud = "searchcloud";
    private static final String CacheId_TreeNodes = "nodes";
    private static final String CacheId_CurrNode = "currnode";
    protected static final String CacheId_CurrView = "currview";
    protected static final String Key_root_Id = "0";
    protected static final String ENTITYID_APP = "bos_devportal_bizapp";
    private static final String BOS_DEVPORTAL_SHORTCUT = "bos_devportal_shortcut";
    private static final String BOS_DEVPORTAL_BIZCLOUD = "bos_devportal_bizcloud";
    private static final String BIZAPP = "bizapp";
    private static final String BIZPAGE = "bizpage";
    private static final String BIZAPPID = "bizappid";
    protected static final String Key_ID = "id";
    protected static final String Key_APPID = "appid";
    private static final String Key_Number = "number";
    private static final String Key_Name = "name";
    private static final String Key_BizCloud = "bizCloud";
    protected static final String Key_BizCloudId = "bizcloudid";
    private static final String Key_Modifier = "modifier";
    private static final String Key_ModifyDate = "modifydate";
    private static final String Key_Isv = "isv";
    private static final String Key_Description = "description";
    private static final String Key_Version = "version";
    private static final String Key_MasterId = "masterid";
    protected static final String Key_Status = "status";
    protected static final String Key_IsCollected = "iscollected";
    protected static final String Key_IsExtended = "isextended";
    private static final String Key_CARDTYPE = "cardtype";
    protected static final String Key_CardId = "cardid";
    protected static final String Key_CardCloudId = "cardcloudid";
    private static final String Key_CardImage = "cardimage";
    private static final String Key_CardName = "cardname";
    private static final String Key_CardNumber = "cardnumber";
    private static final String Key_CardIsv = "cardisv";
    private static final String Key_CardCloud = "cardcloud";
    private static final String Key_CardDescription = "carddescription";
    protected static final String Key_CardIsCollected = "cardiscollected";
    protected static final String Key_CardStatus = "cardstatus";
    protected static final String Key_CardIsExtended = "cardisextended";
    private static final String Key_CardDisabledTag = "disabledtag";
    private static final String Key_CardDisabledFlex = "disableflex";
    private static final String Key_CardEnableFlex = "enableflex";
    private static final String Key_CardExtendTag = "extendmark";
    private static final String Key_CardOriginalTag = "originalmark";
    protected static final String Key_CardExtendedLabel = "extendedlabel";
    protected static final String Key_CardExtendIcon = "extendicon";
    protected static final String Key_CardExtendedFlex = "extendedflex";
    protected static final String Key_CardToExtendFlex = "toextendflex";
    protected static final String Key_CardToExtendIcon = "toextendicon";
    protected static final String Key_CardToExtendLabel = "toextendedlabel";
    private static final String Key_List_Color_Enable = "#1BA854";
    private static final String Key_List_Color_DisEnable = "#999999";
    private static final String Key_Card_Color_Enable = " #ffffff";
    private static final String Key_Card_Color_DisEnable = "#f5f5f5";
    private static final String Key_Card_FC_Enable = " #666666";
    private static final String Key_Card_FC_DisEnable = "#b2b2b2";
    private static final String Key_List_Color_Collected = "#FF991C";
    private static final String Key_List_Color_UnCollected = "#666";
    private static final String Key_FontClass_Collected = "kdfont kdfont-shoucang";
    private static final String Key_FontClass_UnCollected = "kdfont kdfont-shoucangxuanzhong";
    protected static final String Key_View_List = "0";
    protected static final String Key_View_Card = "1";
    protected static final String Key_KINGDEE = "kingdee";
    private static final String SEQUENCE_ASC = "sequence asc";
    private TreeNode rootNode;

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{Key_ListView, Key_CardView});
        this.addItemClickListeners(new String[]{"tbar_main"});
        TreeView tView = (TreeView)this.getControl(Key_TreeView);
        tView.addTreeNodeClickListener((TreeNodeClickListener)this);
        Search search = (Search)this.getControl(Key_Search);
        search.addEnterListener((SearchEnterListener)this);
        Search searchCloud = (Search)this.getControl(Key_SearchCloud);
        searchCloud.addEnterListener((SearchEnterListener)this);
        TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getControl(Key_TreeEntryEntity);
        treeEntryGrid.addItemClickListener((ItemClickListener)this);
        treeEntryGrid.addDataBindListener((EntryGridBindDataListener)this);
        EntryGrid entryGrid = (EntryGrid)this.getControl(Key_EntryEntity);
        entryGrid.addItemClickListener((ItemClickListener)this);
        treeEntryGrid.addPackageDataListener(pkEvent -> {
            block4: {
                block5: {
                    if (!(pkEvent.getSource() instanceof OperationColumn)) break block4;
                    if (!"operationcolumnap1".equals(((OperationColumn)pkEvent.getSource()).getKey())) break block5;
                    List opItems = (List)pkEvent.getFormatValue();
                    boolean iscollected = pkEvent.getRowData().getBoolean(Key_IsCollected);
                    for (OperationColItem item : opItems) {
                        if (iscollected && "collect".equals(item.getOperationKey())) {
                            item.setVisible(false);
                        }
                        if (iscollected || !"cancel_collect".equals(item.getOperationKey())) continue;
                        item.setVisible(false);
                    }
                    break block4;
                }
                if (!"operationcolumnap".equals(((OperationColumn)pkEvent.getSource()).getKey())) break block4;
                List opItems = (List)pkEvent.getFormatValue();
                boolean isExtended = pkEvent.getRowData().getBoolean(Key_IsExtended);
                for (OperationColItem item : opItems) {
                    if (isExtended && "extend".equals(item.getOperationKey())) {
                        item.setVisible(false);
                    }
                    if (isExtended || !"extended".equals(item.getOperationKey())) continue;
                    item.setVisible(false);
                }
            }
        });
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        boolean isHasPermisson = DevpPermissionUtils.hasBizAppViewPermission(null, "47150e89000000ac");
        if (!isHasPermisson) {
            e.setCancelMessage(ResManager.loadKDString((String)"\u8bf7\u6dfb\u52a0\u4e1a\u52a1\u5e94\u7528\u7684\u67e5\u8be2\u6743\u9650\u3002", (String)"MyAppList_0", (String)"bos-devportal-new-plugin", (Object[])new Object[0]));
            e.setCancel(true);
        }
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        MainEntityType old = e.getOriginalEntityType();
        try {
            MainEntityType newType = (MainEntityType)old.clone();
            e.setNewEntityType(newType);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
    }

    public void afterCreateNewData(EventObject e) {
        TreeNode rootNode = this.buildTreeNodes(null);
        TreeView tView = (TreeView)this.getControl(Key_TreeView);
        tView.addNode(rootNode);
        tView.focusNode(rootNode);
        String bizCloudId = (String)this.getView().getFormShowParameter().getCustomParam("bizcloudId");
        String bizAppId = (String)this.getView().getFormShowParameter().getCustomParam("bizappId");
        this.refreshView(bizCloudId, "", Key_View_Card);
        this.getPageCache().put(CacheId_CurrView, Key_View_Card);
        this.activeListButon(Key_CardView);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{Key_TreeEntryEntity});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{Key_EntryEntity});
        if (StringUtils.isNotBlank((CharSequence)bizAppId)) {
            this.markTargetPage(bizCloudId, bizAppId);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        boolean flag = DevportalUtil.isGitManageType();
        String codeManageType = "svn";
        if (flag) {
            codeManageType = "git";
        }
        if ("code".equals(codeManageType) || "none".equals(codeManageType)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"svncommit"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"gitcommit"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"gitpush"});
        } else if ("svn".equals(codeManageType)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"svncommit"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"gitcommit"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"gitpush"});
        } else if ("git".equals(codeManageType)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"svncommit"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"gitcommit"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"gitpush"});
        }
        String bizCloudId = (String)this.getView().getFormShowParameter().getCustomParam("bizcloudId");
        String bizAppId = (String)this.getView().getFormShowParameter().getCustomParam("bizappId");
        this.markTargetPage(bizCloudId, bizAppId);
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        TreeView tv = (TreeView)this.getControl(Key_TreeView);
        String currNodeId = tv.getTreeState().getFocusNodeId();
        switch (key) {
            case "listview": {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{Key_TreeEntryEntity});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{Key_EntryEntity});
                this.getPageCache().put(CacheId_CurrView, "0");
                this.activeListButon(Key_ListView);
                this.refreshView(currNodeId, "", "0");
                break;
            }
            case "cardview": {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{Key_TreeEntryEntity});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{Key_EntryEntity});
                this.getPageCache().put(CacheId_CurrView, Key_View_Card);
                this.activeListButon(Key_CardView);
                this.refreshView(currNodeId, "", Key_View_Card);
                break;
            }
        }
    }

    private void activeListButon(String type) {
        String active = Key_ListView;
        String other = Key_CardView;
        if (StringUtils.isNotBlank((CharSequence)type) && Key_CardView.equals(type)) {
            active = Key_CardView;
            other = Key_ListView;
        }
        HashMap<String, String> activeMap = new HashMap<String, String>();
        activeMap.put("fc", "#3987ed");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("fc", Key_List_Color_DisEnable);
        this.getView().updateControlMetadata(active, activeMap);
        this.getView().updateControlMetadata(other, map);
    }

    public void treeNodeClick(TreeNodeEvent e) {
        String currNodeId;
        String newNodeId = (String)e.getNodeId();
        if (newNodeId.equals(currNodeId = this.getPageCache().get(CacheId_CurrNode))) {
            return;
        }
        this.refreshView(newNodeId, "");
        this.getPageCache().put(CacheId_CurrNode, newNodeId);
    }

    protected boolean isModel() {
        return "bos_devpn_modelist".equals(this.getView().getFormShowParameter().getFormId());
    }

    protected TreeNode getRootNode() {
        if (this.rootNode == null) {
            this.buildTreeNodes(null);
        }
        return this.rootNode;
    }

    protected TreeNode buildTreeNodes(List<TreeNode> clouds) {
        TreeNode root = new TreeNode();
        root.setId("0");
        String text = this.isModel() ? ResManager.loadKDString((String)"\u6a21\u677f\u5e93", (String)"MyAppList_1", (String)"bos-devportal-new-plugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4e1a\u52a1\u4e91", (String)"MyAppList_4", (String)"bos-devportal-new-plugin", (Object[])new Object[0]);
        root.setText(text);
        root.setParentid("");
        root.setIsOpened(true);
        if (clouds == null) {
            clouds = this.getCloudData();
        }
        root.setChildren(clouds);
        this.rootNode = root;
        String json = SerializationUtils.toJsonString(clouds);
        this.getPageCache().put(CacheId_TreeNodes, json);
        return root;
    }

    public void search(SearchEnterEvent e) {
        Search search = (Search)e.getSource();
        if (StringUtils.equals((CharSequence)Key_Search, (CharSequence)search.getKey())) {
            String searchText = e.getText();
            this.refreshView("", searchText);
            TreeNode root = new TreeNode();
            root.setId("0");
            TreeView tv = (TreeView)this.getControl(Key_TreeView);
            tv.focusNode(root);
        } else if (StringUtils.equals((CharSequence)Key_SearchCloud, (CharSequence)search.getKey())) {
            String searchText = e.getText();
            List<TreeNode> clouds = this.getCloudData();
            ArrayList<TreeNode> newClouds = new ArrayList<TreeNode>(10);
            if (StringUtils.isBlank((CharSequence)searchText)) {
                newClouds.addAll(clouds);
            } else if (clouds != null) {
                for (TreeNode node : clouds) {
                    String name = node.getText();
                    if (!StringUtils.isNotBlank((CharSequence)name) || !name.contains(searchText)) continue;
                    newClouds.add(node);
                }
            }
            TreeNode rootNode = this.buildTreeNodes(newClouds);
            TreeView tView = (TreeView)this.getControl(Key_TreeView);
            tView.updateNode(rootNode);
        }
    }

    protected void refreshView() {
        TreeView tv = (TreeView)this.getControl(Key_TreeView);
        String currNodeId = tv.getTreeState().getFocusNodeId();
        this.refreshView(currNodeId, "");
    }

    protected void refreshView(String nodeId, String searchText) {
        this.getPageCache().remove(BIZAPPID);
        String currView = this.getPageCache().get(CacheId_CurrView);
        this.refreshView(nodeId, searchText, currView);
    }

    private void refreshView(String nodeId, String searchText, String currView) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(1);
        String isv = ISVService.getISVInfo().getId();
        filters.add(new QFilter(Key_Isv, "=", (Object)isv));
        if (StringUtils.isNotBlank((CharSequence)nodeId) && !"0".equals(nodeId)) {
            filters.add(new QFilter("bizcloud", "=", (Object)nodeId));
        }
        String searchContent = String.format("%s%s%s", "%", searchText, "%");
        if (StringUtils.isNotBlank((CharSequence)searchText)) {
            QFilter numberFilter = new QFilter(Key_Number, "like", (Object)searchContent);
            numberFilter.or(new QFilter(Key_Name, "like", (Object)searchContent));
            filters.add(numberFilter);
        }
        Map<Object, DynamicObject> apps = MyAppUtils.loadAppList(filters, this.isModel());
        if (currView == null || "0".equals(currView)) {
            this.getModel().deleteEntryData(Key_TreeEntryEntity);
        } else {
            this.getModel().deleteEntryData(Key_EntryEntity);
        }
        if (apps == null || apps.isEmpty()) {
            return;
        }
        LinkedHashMap<Object, DynamicObject> originApps = new LinkedHashMap<Object, DynamicObject>(16);
        HashMap<Object, DynamicObject> extApps = new HashMap<Object, DynamicObject>(16);
        HashSet<Object> appIds = new HashSet<Object>(16);
        HashSet<Object> masterIds = new HashSet<Object>(16);
        Set<String> extendInheritPath = MyAppUtils.getExtendInheritPath(this.isModel());
        for (Map.Entry<Object, DynamicObject> entry : apps.entrySet()) {
            DynamicObject app = entry.getValue();
            String type = app.getString("type");
            if ("0".equals(type)) {
                appIds.add(entry.getKey());
                originApps.put(entry.getKey(), entry.getValue());
                continue;
            }
            extApps.put(entry.getKey(), entry.getValue());
            Object object = app.get(Key_MasterId);
            if (apps.containsKey(object)) continue;
            masterIds.add(object);
        }
        filters.clear();
        filters.add(new QFilter(Key_MasterId, "in", appIds));
        Map<Object, DynamicObject> exts = MyAppUtils.loadAppList(filters, this.isModel());
        if (exts != null) {
            extApps.putAll(exts);
        }
        filters.clear();
        filters.add(new QFilter(Key_ID, "in", masterIds));
        Map<Object, DynamicObject> ext4Masters = MyAppUtils.loadAppList(filters, this.isModel());
        if (exts != null) {
            originApps.putAll(ext4Masters);
        }
        HashMap<Object, List<DynamicObject>> extGroup = new HashMap<Object, List<DynamicObject>>(10);
        if (extApps != null) {
            for (Map.Entry entry : extApps.entrySet()) {
                ArrayList<DynamicObject> list;
                DynamicObject app = (DynamicObject)entry.getValue();
                String parentId = app.getString(Key_MasterId);
                if (!originApps.containsKey(parentId)) {
                    originApps.put(entry.getKey(), app);
                }
                if ((list = (ArrayList<DynamicObject>)extGroup.get(parentId)) == null) {
                    list = new ArrayList<DynamicObject>(1);
                }
                list.add(app);
                extGroup.put(parentId, list);
            }
        }
        if (apps.isEmpty()) {
            return;
        }
        List<String> collectApps = MyAppList.getCollectedApps();
        if (currView == null || "0".equals(currView)) {
            this.renderTreeEntryEntity(originApps, extApps, extGroup, collectApps, extendInheritPath);
        } else {
            this.renderCardEntry(originApps, extApps, extGroup, collectApps, extendInheritPath);
        }
    }

    private List<TreeNode> getCloudData() {
        QFilter[] qFilters;
        QFilter[] cloudIdBlacklistFilters;
        String selectFields;
        Map cloudObjects;
        ArrayList<TreeNode> cloudNode = new ArrayList<TreeNode>(10);
        HashSet<String> cloudIds = new HashSet<String>(10);
        ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
        String isv = ISVService.getISVInfo().getId();
        if (Key_KINGDEE.equals(isv)) {
            filters.add(new QFilter(Key_Isv, "in", (Object)new String[]{Key_KINGDEE, " "}));
        } else {
            filters.add(new QFilter(Key_Isv, "=", (Object)isv));
        }
        DynamicObject[] appList = this.getAppList(filters);
        if (appList != null) {
            for (DynamicObject app : appList) {
                DynamicObject bizCloud = app.getDynamicObject("bizcloud");
                String cloudId = bizCloud == null ? "" : bizCloud.getString(Key_ID);
                cloudIds.add(cloudId);
            }
        }
        if ((cloudObjects = BusinessDataServiceHelper.loadFromCache((String)BOS_DEVPORTAL_BIZCLOUD, (String)(selectFields = "id,sequence,number,name,description,isv"), (QFilter[])(cloudIdBlacklistFilters = RunModeServiceHelper.getCloudIdBlacklistFilters((QFilter[])(qFilters = new QFilter[]{new QFilter("ismodel", "=", (Object)this.isModel())}), (String)Key_ID)), (String)SEQUENCE_ASC)) != null) {
            for (Map.Entry entry : cloudObjects.entrySet()) {
                DynamicObject cloud = (DynamicObject)entry.getValue();
                String id = cloud.getString(Key_ID);
                String cloudIsv = cloud.getString(Key_Isv);
                if ("2HGKCE94QELW".equalsIgnoreCase(id) || !isv.equals(cloudIsv) && !cloudIds.contains(id)) continue;
                TreeNode node = new TreeNode();
                node.setId(id);
                node.setParentid("0");
                node.setText(cloud.getString(Key_Name));
                cloudNode.add(node);
            }
        }
        return cloudNode;
    }

    private DynamicObject[] getAppList(List<QFilter> filters) {
        if (filters == null) {
            filters = new ArrayList<QFilter>(16);
        }
        filters.add(new QFilter("bizcloud.ismodel", "=", (Object)this.isModel()));
        QFilter[] RunMFilters = RunModeServiceHelper.getAppIdBlacklistFilters(null, (String)Key_ID);
        if (RunMFilters != null) {
            filters.addAll(Arrays.asList(RunMFilters));
        }
        String selectFields = "id, number, name, masterid, isv, bizcloud, industry, version, image";
        DynamicObject[] bizApp = BusinessDataServiceHelper.load((String)ENTITYID_APP, (String)selectFields, (QFilter[])filters.toArray(new QFilter[filters.size()]));
        return bizApp;
    }

    private void renderTreeEntryEntity(Map<Object, DynamicObject> originApps, Map<Object, DynamicObject> extApps, Map<Object, List<DynamicObject>> extGroup, List<String> collectApps, Set<String> extendInheritPath) {
        HashSet<Object> allKeys = new HashSet<Object>(16);
        allKeys.addAll(originApps.keySet());
        allKeys.addAll(extApps.keySet());
        int rowCount = allKeys.size();
        allKeys.clear();
        this.getModel().batchCreateNewEntryRow(Key_TreeEntryEntity, rowCount);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(Key_TreeEntryEntity);
        int index = 0;
        ArrayList<CellStyle> cellStyles = new ArrayList<CellStyle>(rowCount);
        for (Map.Entry<Object, DynamicObject> entry : originApps.entrySet()) {
            DynamicObject row = (DynamicObject)entryEntity.get(index);
            DynamicObject app = entry.getValue();
            this.renderRow(row, app, 0L, cellStyles, index, collectApps, extendInheritPath);
            ++index;
            List<DynamicObject> extendAppList = extGroup.get(entry.getKey());
            if (extendAppList == null) continue;
            long pid = row.getLong(Key_ID);
            for (DynamicObject extApp : extendAppList) {
                row = (DynamicObject)entryEntity.get(index);
                this.renderRow(row, extApp, pid, cellStyles, index, collectApps, extendInheritPath);
                ++index;
            }
        }
        this.getView().updateView(Key_TreeEntryEntity);
        EntryGrid entryGrid = (EntryGrid)this.getControl(Key_TreeEntryEntity);
        entryGrid.setCellStyle(cellStyles);
    }

    protected CellStyle genStyle(String key, int i, String foreColor) {
        CellStyle cellStyle = new CellStyle();
        cellStyle.setFieldKey(key);
        cellStyle.setRow(i);
        cellStyle.setForeColor(StringUtils.isBlank((CharSequence)foreColor) ? Key_List_Color_DisEnable : foreColor);
        return cellStyle;
    }

    protected void renderEnableStyle(String currView, int current) {
        String entryKey = null;
        String id = null;
        if (currView == null || "0".equals(currView)) {
            entryKey = Key_TreeEntryEntity;
            id = Key_APPID;
        } else {
            entryKey = Key_EntryEntity;
            id = Key_CardId;
        }
        int index = this.getModel().getEntryCurrentRowIndex(entryKey);
        DynamicObjectCollection rows = this.getModel().getEntryEntity(entryKey);
        ArrayList<CellStyle> cellStyles = new ArrayList<CellStyle>(1);
        DynamicObject currentRow = (DynamicObject)rows.get(index);
        String currentAppId = currentRow.getString(id);
        List<String> extendAppIds = this.getExtendAppIds(currentAppId);
        extendAppIds.add(currentAppId);
        if (currView == null || "0".equals(currView)) {
            if (rows != null && !rows.isEmpty()) {
                for (int i = 0; i < rows.size(); ++i) {
                    DynamicObject row = (DynamicObject)rows.get(i);
                    int status = row.getInt(Key_Status);
                    String appId = row.getString(id);
                    if (extendAppIds != null && extendAppIds.contains(appId)) {
                        this.getModel().setValue(Key_Status, (Object)current, i);
                        this.getView().updateView(Key_TreeEntryEntity, i);
                        status = current;
                    }
                    if (status == 1) {
                        cellStyles.add(this.genStyle(Key_Status, i, Key_List_Color_DisEnable));
                        continue;
                    }
                    cellStyles.add(this.genStyle(Key_Status, i, Key_List_Color_Enable));
                }
            }
            EntryGrid entryGrid = (EntryGrid)this.getControl(Key_TreeEntryEntity);
            entryGrid.setCellStyle(cellStyles);
        } else if (rows != null && !rows.isEmpty()) {
            for (int i = 0; i < rows.size(); ++i) {
                DynamicObject row = (DynamicObject)rows.get(i);
                String appId = row.getString(id);
                if (extendAppIds == null || !extendAppIds.contains(appId)) continue;
                this.getModel().setValue(Key_CardStatus, (Object)current, i);
                EntryGrid entryGrid = (EntryGrid)this.getControl(Key_EntryEntity);
                if (current != 2) {
                    ((CardEntry)entryGrid).setChildVisible(true, index, new String[]{Key_CardDisabledFlex});
                    ((CardEntry)entryGrid).setChildVisible(false, index, new String[]{Key_CardEnableFlex});
                    continue;
                }
                ((CardEntry)entryGrid).setChildVisible(false, index, new String[]{Key_CardDisabledFlex});
                ((CardEntry)entryGrid).setChildVisible(true, index, new String[]{Key_CardEnableFlex});
            }
        }
    }

    private List<String> getExtendAppIds(String bizAppId) {
        String selectFields = Key_ID;
        QFilter[] filters = new QFilter[]{new QFilter(Key_MasterId, "=", (Object)bizAppId)};
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)ENTITYID_APP, (String)selectFields, (QFilter[])filters);
        ArrayList<String> extendAppIds = new ArrayList<String>();
        if (dynamicObjects != null && dynamicObjects.size() > 0) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                String id = dynamicObject.getString(Key_ID);
                if (!StringUtils.isNotBlank((CharSequence)id)) continue;
                extendAppIds.add(id);
            }
        }
        return extendAppIds;
    }

    private void renderRow(DynamicObject row, DynamicObject app, long pid, List<CellStyle> cellStyles, int index, List<String> collectApps, Set<String> extendInheritPath) {
        row.set("pid", (Object)pid);
        int status = app.getInt("deploystatus");
        if (status == 1) {
            cellStyles.add(this.genStyle(Key_Status, index, Key_List_Color_DisEnable));
        } else {
            cellStyles.add(this.genStyle(Key_Status, index, Key_List_Color_Enable));
        }
        int isExtended = extendInheritPath.contains(app.getString(Key_ID)) ? 1 : 0;
        row.set(Key_APPID, (Object)app.getString(Key_ID));
        row.set(Key_Number, (Object)app.getString(Key_Number));
        row.set(Key_Name, (Object)app.getString(Key_Name));
        row.set(Key_Isv, (Object)app.getString(Key_Isv));
        row.set(Key_BizCloud, (Object)app.getDynamicObject(Key_BizCloud));
        row.set(Key_BizCloudId, (Object)app.getDynamicObject(Key_BizCloud));
        row.set(Key_Modifier, (Object)app.getDynamicObject(Key_Modifier));
        row.set(Key_ModifyDate, (Object)app.getDate(Key_ModifyDate));
        row.set(Key_Version, (Object)app.getString(Key_Version));
        row.set(Key_Status, (Object)app.getInt("deploystatus"));
        row.set(Key_IsCollected, (Object)(collectApps.contains(app.getString(Key_ID)) ? 1 : 0));
        row.set(Key_IsExtended, (Object)isExtended);
        row.set(Key_MasterId, app.get(Key_MasterId));
    }

    private void renderCardEntry(Map<Object, DynamicObject> originApps, Map<Object, DynamicObject> extApps, Map<Object, List<DynamicObject>> extGroup, List<String> collectApps, Set<String> extendInheritPath) {
        HashSet<Object> allKeys = new HashSet<Object>(16);
        allKeys.addAll(originApps.keySet());
        allKeys.addAll(extApps.keySet());
        int rowCount = allKeys.size();
        allKeys.clear();
        this.getModel().batchCreateNewEntryRow(Key_EntryEntity, rowCount);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(Key_EntryEntity);
        int index = 0;
        String domainUrl = UrlService.getDomainContextUrl();
        EntryGrid entryGrid = (EntryGrid)this.getControl(Key_EntryEntity);
        for (Map.Entry<Object, DynamicObject> entry : originApps.entrySet()) {
            DynamicObject app = entry.getValue();
            DynamicObject row = (DynamicObject)entryEntity.get(index);
            this.renderCardRow(row, app, entryGrid, index, collectApps, domainUrl, extendInheritPath);
            ++index;
            List<DynamicObject> extendAppList = extGroup.get(entry.getKey());
            if (extendAppList == null) continue;
            for (DynamicObject extApp : extendAppList) {
                row = (DynamicObject)entryEntity.get(index);
                this.renderCardRow(row, extApp, entryGrid, index, collectApps, domainUrl, extendInheritPath);
                ++index;
            }
        }
        this.getView().updateView(Key_EntryEntity);
    }

    private void renderCardRow(DynamicObject row, DynamicObject app, EntryGrid entryGrid, int index, List<String> collectApps, String domainUrl, Set<String> extendInheritPath) {
        int deployStatus;
        String image = app.getString("image");
        if (StringUtils.isNotBlank((CharSequence)image) && !image.startsWith("/")) {
            image = '/' + image;
        }
        if ((deployStatus = app.getInt("deploystatus")) != 2) {
            ((CardEntry)entryGrid).setChildVisible(true, index, new String[]{Key_CardDisabledFlex});
            ((CardEntry)entryGrid).setChildVisible(false, index, new String[]{Key_CardEnableFlex});
        } else {
            ((CardEntry)entryGrid).setChildVisible(false, index, new String[]{Key_CardDisabledFlex});
            ((CardEntry)entryGrid).setChildVisible(true, index, new String[]{Key_CardEnableFlex});
        }
        entryGrid.setCustomProperties(Key_EntryEntity, index, this.genCollectProps(collectApps.contains(app.getString(Key_ID))));
        int isExtended = extendInheritPath.contains(app.getString(Key_ID)) ? 1 : 0;
        ((CardEntry)entryGrid).setChildVisible(isExtended == 1, index, new String[]{Key_CardExtendedFlex});
        ((CardEntry)entryGrid).setChildVisible(isExtended == 0, index, new String[]{Key_CardToExtendFlex});
        String masterId = app.getString(Key_MasterId);
        boolean isOrigin = StringUtils.isBlank((CharSequence)masterId);
        ((CardEntry)entryGrid).setChildVisible(!isOrigin, index, new String[]{Key_CardExtendTag});
        ((CardEntry)entryGrid).setChildVisible(isOrigin, index, new String[]{Key_CardOriginalTag});
        DynamicObject cloud = app.getDynamicObject(Key_BizCloud);
        String cloudName = cloud == null ? null : cloud.getString(Key_Name);
        String name = app.getString(Key_Name);
        String description = app.getString(Key_Description);
        String string = description = StringUtils.isBlank((CharSequence)description) ? name : description;
        if (isOrigin) {
            row.set(Key_CARDTYPE, (Object)ResManager.loadKDString((String)"\u539f\u5382", (String)"MyAppList_5", (String)"bos-devportal-new-plugin", (Object[])new Object[0]));
        } else {
            row.set(Key_CARDTYPE, (Object)ResManager.loadKDString((String)"\u6269\u5c55", (String)"MyAppList_2", (String)"bos-devportal-new-plugin", (Object[])new Object[0]));
        }
        row.set(Key_CardId, (Object)app.getString(Key_ID));
        row.set(Key_CardCloudId, cloud == null ? null : cloud.getPkValue());
        row.set(Key_CardImage, (Object)(domainUrl + image));
        row.set(Key_CardName, (Object)name);
        row.set(Key_CardNumber, (Object)app.getString(Key_Number));
        row.set(Key_CardIsv, (Object)app.getString(Key_Isv));
        row.set(Key_CardCloud, (Object)cloudName);
        row.set(Key_CardIsCollected, (Object)(collectApps.contains(app.getString(Key_ID)) ? 1 : 0));
        row.set(Key_CardStatus, (Object)deployStatus);
        row.set(Key_CardDescription, (Object)description);
        row.set(Key_CardIsExtended, (Object)isExtended);
    }

    protected Map<String, Object> genCollectProps(boolean isCollected) {
        String fontClass = Key_FontClass_Collected;
        String fc = Key_List_Color_UnCollected;
        if (isCollected) {
            fontClass = Key_FontClass_UnCollected;
            fc = Key_List_Color_Collected;
        }
        HashMap<String, Object> root = new HashMap<String, Object>();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("fc", fc);
        map.put("fontClass", fontClass);
        root.put("collecticon", map);
        return root;
    }

    @Deprecated
    private Map<String, Object> genCardEnaleProps(boolean enable) {
        String bc = Key_Card_Color_DisEnable;
        String fc = Key_Card_FC_DisEnable;
        if (enable) {
            bc = Key_Card_Color_Enable;
            fc = Key_Card_FC_Enable;
        }
        HashMap<String, Object> root = new HashMap<String, Object>();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("bc", bc);
        map.put("fc", fc);
        root.put("cardentryflexpanelap2", map);
        return root;
    }

    private static List<String> getCollectedApps() {
        QFilter q1 = new QFilter("user", "=", (Object)RequestContext.get().getCurrUserId());
        QFilter q3 = new QFilter(BIZPAGE, "=", (Object)" ");
        QFilter[] filters = new QFilter[]{q1, q3};
        DynamicObjectCollection querys = QueryServiceHelper.query((String)BOS_DEVPORTAL_SHORTCUT, (String)BIZAPP, (QFilter[])filters);
        ArrayList<String> collectedAppIds = new ArrayList<String>(querys.size());
        for (int i = 0; i < querys.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)querys.get(i);
            String bizAppId = dynamicObject.getString(BIZAPP);
            collectedAppIds.add(bizAppId);
        }
        return collectedAppIds;
    }

    protected void markTargetPage(String bizCloudId, String bizAppId) {
        if (StringUtils.isNotBlank((CharSequence)bizCloudId)) {
            TreeView tView = (TreeView)this.getControl(Key_TreeView);
            TreeNode node = this.getRootNode().getTreeNode(bizCloudId, 10);
            tView.focusNode(node);
            this.getPageCache().put(CacheId_CurrNode, bizCloudId);
        }
        if (StringUtils.isNotBlank((CharSequence)bizAppId)) {
            TreeEntryGrid grid;
            String currView = this.getPageCache().get(CacheId_CurrView);
            if (currView == null || "0".equals(currView)) {
                grid = (TreeEntryGrid)this.getControl(Key_TreeEntryEntity);
                int rowIndex = this.findRowById(Key_TreeEntryEntity, bizAppId);
                grid.selectRows(rowIndex, true);
                String masterId = (String)this.getModel().getValue(Key_MasterId, rowIndex);
                if (StringUtils.isNotBlank((CharSequence)masterId)) {
                    int masterIndex = this.findRowById(Key_TreeEntryEntity, masterId);
                    grid.expand(masterIndex);
                }
            } else {
                grid = (EntryGrid)this.getControl(Key_EntryEntity);
                int rowIndex = this.findRowById(Key_EntryEntity, bizAppId);
                grid.selectRows(rowIndex, true);
            }
        }
    }

    private int findRowById(String entryEntityKey, String bizAppId) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(entryEntityKey);
        String idKey = Key_CardId;
        if (Key_TreeEntryEntity.equals(entryEntityKey)) {
            idKey = Key_APPID;
        }
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject info = (DynamicObject)entryEntity.get(i);
            if (!bizAppId.equals(info.getString(idKey))) continue;
            return i;
        }
        return -1;
    }

    protected void afterExtend(int isExtended, String cloudId, String bizAppId) {
        String entryEntityKey = Key_EntryEntity;
        String currView = this.getPageCache().get(CacheId_CurrView);
        if (currView == null || "0".equals(currView)) {
            entryEntityKey = Key_TreeEntryEntity;
        }
        int rowIndex = this.getModel().getEntryCurrentRowIndex(entryEntityKey);
        if (Key_TreeEntryEntity.equals(entryEntityKey)) {
            EntryGrid treeEntryGrid = (EntryGrid)this.getControl(entryEntityKey);
            ArrayList<String> opeIds = new ArrayList<String>();
            if (isExtended == 1) {
                opeIds.add("extend");
            } else {
                opeIds.add("extended");
            }
            this.getModel().setValue(Key_IsExtended, (Object)isExtended, rowIndex);
            treeEntryGrid.hideOperateItems("operationcolumnap1", rowIndex, opeIds);
            this.getView().updateView(entryEntityKey, rowIndex);
        } else {
            this.getModel().setValue(Key_CardIsExtended, (Object)isExtended, rowIndex);
            EntryGrid entryGrid = (EntryGrid)this.getControl(entryEntityKey);
            ((CardEntry)entryGrid).setChildVisible(isExtended == 1, rowIndex, new String[]{Key_CardExtendedFlex});
            ((CardEntry)entryGrid).setChildVisible(isExtended == 0, rowIndex, new String[]{Key_CardToExtendFlex});
        }
        this.markTargetPage(cloudId, bizAppId);
    }

    protected Map<String, Object> genExtendProps(boolean isExtended) {
        String text = ResManager.loadKDString((String)"\u6269\u5c55", (String)"MyAppList_2", (String)"bos-devportal-new-plugin", (Object[])new Object[0]);
        if (isExtended) {
            text = ResManager.loadKDString((String)"\u5df2\u6269\u5c55", (String)"MyAppList_3", (String)"bos-devportal-new-plugin", (Object[])new Object[0]);
        }
        HashMap<String, Object> root = new HashMap<String, Object>();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("text", text);
        root.put("extendlabel", map);
        return root;
    }
}

