/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.newdevportal.app.original;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.devportal.util.DevportalUtil;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.devportal.AppFunctionPacketElement;
import kd.bos.entity.operate.Donothing;
import kd.bos.entity.report.CellStyle;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.OperationColumn;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.control.events.ListboxClickListener;
import kd.bos.form.control.events.ListboxEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.operatecol.OperationColItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.mservice.svc.picture.IImage;
import kd.bos.newdevportal.app.my.DevpPermissionUtils;
import kd.bos.newdevportal.app.my.DevportalModelTypes;
import kd.bos.newdevportal.app.my.MyAppUtils;
import kd.bos.newdevportal.app.my.PageType;
import kd.bos.newdevportal.app.original.OriginalAppUtils;
import kd.bos.newdevportal.bean.DynamicFormInfo;
import kd.bos.newdevportal.util.GotoDesignerUtils;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.url.UrlService;

public class OriginalAppDetailPlugin
extends AbstractTreeListPlugin
implements ListboxClickListener,
TreeNodeClickListener,
HyperLinkClickListener,
EntryGridBindDataListener,
SearchEnterListener,
TabSelectListener {
    private static final String BOS_DEVPORTAL_BIZAPP = "bos_devportal_bizapp";
    private static final String BOS_DEVPN_FORMMETA = "bos_devpn_formmeta";
    private static final String BOS_DEVPORTAL_NEW_PLUGIN = "bos-devportal-new-plugin";
    private static final String BOS_DEVPORTAL_PLUGIN = "bos_devportal_plugin";
    private static final String BOS_DEVPORTAL_SHORTCUT = "bos_devportal_shortcut";
    private static final String BOS_USER = "bos_user";
    private static final String TREEVIEW = "treeviewap";
    private static final String TREEENTRYENTITY = "treeentryentity";
    private static final String Key_Number = "number";
    private static final String NAME = "name";
    private static final String Key_SourcePage = "sourcepage";
    private static final String Key_SourcePage_ID = "sourcepageid";
    private static final String MODELTYPE = "modeltype";
    private static final String MODIFIER = "modifier";
    private static final String MODIFYDATE = "modifydate";
    private static final String FORMID = "formid";
    private static final String CURRENT_NODE = "current_node";
    private static final String CURRENT_PAGETYPE = "current_pagetype";
    private static final String CacheId_SearchText = "searchText";
    private static final String PAGETYPE = "pagetype";
    private static final String BTN_OBJECT = "btn_object";
    private static final String BTN_PAGE = "btn_page";
    private static final String BTN_REPORT = "btn_report";
    private static final String BTN_PARAM = "btn_parameter";
    private static final String BTN_LAYOUT = "btn_layout";
    private static final String KEY_TAB_OBJECT = "tabobject";
    private static final String KEY_TAB_DEVPAGE = "tabdevpage";
    private static final String KEY_TAB_PARAM = "tabparam";
    private static final String KEY_TAB_REPORT = "tabreport";
    private static final String KEY_TAB_LAYOUT = "tablayout";
    protected static final String Key_TreeSearch = "searchap";
    private static final String KEY_TABAP = "tabap";
    private static final String Key_Search = "search";
    private static final String CARD_VIEW = "cardview";
    private static final String LIST_VIEW = "listview";
    private static final String COLLECT = "collect";
    private static final String CANCEL_COLLECT = "cancel_collect";
    private static final String COLLECTED = "iscollected";
    private static final String BIZAPP = "bizapp";
    private static final String BIZPAGE = "bizpage";
    private static final String BIZAPPTYPE = "bizapptype";
    private static final String BIZAPP_PARENTID = "bizappparentid";
    private static final String ENTITYID = "entityid";
    private static final String BIZAPPID = "bizappid";
    private static final String ISV = "isv";
    private static final String ROOT_ID = "0";
    protected static final String MainPage = "MainPage";
    protected static final String Key_Enable = "enable";
    private static final String ENABLE_STATUS = "enablestatus";
    private TreeNode rootNode;

    public void initialize() {
        super.initialize();
        Tab tabap = (Tab)this.getView().getControl(KEY_TABAP);
        tabap.addTabSelectListener((TabSelectListener)this);
        TreeView treeView = (TreeView)this.getView().getControl(TREEVIEW);
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        Search search = (Search)this.getControl(Key_Search);
        search.addEnterListener((SearchEnterListener)this);
        this.addClickListeners(new String[]{LIST_VIEW, CARD_VIEW});
        Search treeSearch = (Search)this.getControl(Key_TreeSearch);
        treeSearch.addEnterListener((SearchEnterListener)this);
        EntryGrid treeGrid = (EntryGrid)this.getView().getControl(TREEENTRYENTITY);
        treeGrid.addHyperClickListener((HyperLinkClickListener)this);
        treeGrid.addDataBindListener((EntryGridBindDataListener)this);
        treeGrid.addPackageDataListener(pkEvent -> {
            if (pkEvent.getSource() instanceof OperationColumn && "operationcolumnap".equals(((OperationColumn)pkEvent.getSource()).getKey())) {
                List opItems = (List)pkEvent.getFormatValue();
                boolean iscollected = pkEvent.getRowData().getBoolean(COLLECTED);
                for (OperationColItem item : opItems) {
                    if (iscollected && COLLECT.equals(item.getOperationKey())) {
                        item.setVisible(false);
                    }
                    if (iscollected || !CANCEL_COLLECT.equals(item.getOperationKey())) continue;
                    item.setVisible(false);
                }
            }
        });
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        boolean isHasPermisson = DevpPermissionUtils.hasBizPageViewPermission(null, "47150e89000000ac");
        if (!isHasPermisson) {
            e.setCancelMessage(ResManager.loadKDString((String)"\u8bf7\u6dfb\u52a0\u4e1a\u52a1\u5bf9\u8c61\u7684\u67e5\u8be2\u6743\u9650\u3002", (String)"OriginalAppDetailPlugin_5", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
            e.setCancel(true);
        }
    }

    public void afterCreateNewData(EventObject e) {
        String bizAppId = (String)this.getView().getFormShowParameter().getCustomParam(BIZAPPID);
        AppMetaServiceHelper.cleanAppMetaCache((String)bizAppId);
        TreeNode root = this.getRootNode();
        TreeView treeView = (TreeView)this.getView().getControl(TREEVIEW);
        treeView.addNode(root);
        this.getPageCache().put(CURRENT_NODE, ROOT_ID);
        this.appInfo();
        String pageType = ROOT_ID;
        this.getPageCache().put(CURRENT_PAGETYPE, pageType);
        if (StringUtils.isNotBlank((CharSequence)((CharSequence)this.getView().getFormShowParameter().getCustomParam("pageType")))) {
            pageType = (String)this.getView().getFormShowParameter().getCustomParam("pageType");
            this.getPageCache().put(CURRENT_PAGETYPE, pageType);
        }
        boolean isTabActive = this.getView().getFormShowParameter().getCustomParam("isTabActive") == null ? false : (Boolean)this.getView().getFormShowParameter().getCustomParam("isTabActive");
        this.loadAppDetail(isTabActive);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.loadAppDetail(true);
    }

    public void search(SearchEnterEvent e) {
        Search search = (Search)e.getSource();
        if (StringUtils.equals((CharSequence)Key_Search, (CharSequence)search.getKey())) {
            String searchText = e.getText();
            this.getPageCache().put(CacheId_SearchText, searchText);
            String currNodeId = this.getPageCache().get(CURRENT_NODE);
            String pageType = this.getPageCache().get(CURRENT_PAGETYPE);
            String bizAppId = (String)this.getView().getFormShowParameter().getCustomParam(BIZAPPID);
            this.renderEntryEntity(bizAppId, pageType, currNodeId, searchText);
        } else if (StringUtils.equals((CharSequence)Key_TreeSearch, (CharSequence)search.getKey())) {
            this.rootNode = this.buildTreeNode(e.getText());
            TreeView tree = (TreeView)this.getControl(TREEVIEW);
            tree.updateNode(this.rootNode);
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "cardview": {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u529f\u80fd\u5f00\u53d1\u4e2d\uff0c\u656c\u8bf7\u671f\u5f85\u3002", (String)"OriginalAppDetailPlugin_6", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]), MessageBoxOptions.OK);
                break;
            }
        }
    }

    private void loadAppDetail(boolean isTabActive) {
        String bizunitid = ROOT_ID;
        String bizPageId = "";
        String pageType = "";
        if (StringUtils.isNotBlank((CharSequence)((CharSequence)this.getView().getFormShowParameter().getCustomParam("pageType")))) {
            pageType = (String)this.getView().getFormShowParameter().getCustomParam("pageType");
            if (StringUtils.isNotBlank((CharSequence)((CharSequence)this.getView().getFormShowParameter().getCustomParam("bizunitid")))) {
                bizunitid = (String)this.getView().getFormShowParameter().getCustomParam("bizunitid");
            }
            if (StringUtils.isNotBlank((CharSequence)((CharSequence)this.getView().getFormShowParameter().getCustomParam("bizPageId")))) {
                bizPageId = (String)this.getView().getFormShowParameter().getCustomParam("bizPageId");
            }
        }
        TreeView treeView = (TreeView)this.getView().getControl(TREEVIEW);
        TreeNode node = this.rootNode.getTreeNode(bizunitid, 10);
        treeView.focusNode(node);
        if (isTabActive) {
            this.tabActive(pageType);
            this.markTargetPage(bizunitid, bizPageId);
        }
    }

    private TreeNode getRootNode() {
        if (this.rootNode == null) {
            this.rootNode = this.buildTreeNode(null);
        }
        return this.rootNode;
    }

    private TreeNode buildTreeNode(String searchText) {
        TreeNode node;
        String bizAppId = (String)this.getView().getFormShowParameter().getCustomParam(BIZAPPID);
        TreeNode root = new TreeNode();
        root.setId(ROOT_ID);
        root.setText(ResManager.loadKDString((String)"\u5168\u90e8", (String)"OriginalAppDetailPlugin_0", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
        root.setParentid("");
        root.setIsOpened(true);
        this.rootNode = root;
        if (StringUtils.isBlank((CharSequence)bizAppId)) {
            bizAppId = this.getPageCache().get("bizappId");
        }
        if (StringUtils.isBlank((CharSequence)bizAppId)) {
            return root;
        }
        AppMetadata appMeta = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)bizAppId, (boolean)false);
        String bizAppType = appMeta.getDevType();
        String bizAppParentId = appMeta.getParentId();
        this.getPageCache().put(BIZAPPTYPE, bizAppType);
        this.getPageCache().put(BIZAPP_PARENTID, bizAppParentId);
        ArrayList appFunctions = new ArrayList(16);
        appFunctions.addAll(appMeta.getAppFunctionPackets());
        Collections.sort(appFunctions, Comparator.comparing(AppFunctionPacketElement::getSeq));
        LinkedHashMap<String, TreeNode> allNodes = new LinkedHashMap<String, TreeNode>(appFunctions.size());
        for (AppFunctionPacketElement appFunctionPacketElement : appFunctions) {
            node = new TreeNode();
            String nodeID = appFunctionPacketElement.getId();
            node.setText(appFunctionPacketElement.getName().getLocaleValue());
            node.setParentid(appFunctionPacketElement.getParentId());
            node.setId(nodeID);
            if (MainPage.equals(appFunctionPacketElement.getNumber())) {
                this.getPageCache().put("bizUnitId", nodeID);
                this.getPageCache().put(MainPage, nodeID);
            }
            if (StringUtils.isNotBlank((CharSequence)searchText) && !StringUtils.contains((CharSequence)node.getText(), (CharSequence)searchText)) continue;
            allNodes.put(nodeID, node);
        }
        for (Map.Entry entry : allNodes.entrySet()) {
            node = (TreeNode)entry.getValue();
            TreeNode parentNode = (TreeNode)allNodes.get(node.getParentid());
            if (parentNode != null) {
                parentNode.addChild(node);
                continue;
            }
            root.addChild(node);
        }
        return root;
    }

    private void setDeployStatuStyle() {
        String bizappId = (String)this.getView().getFormShowParameter().getCustomParam("bizappId");
        AppMetadata metadata = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)bizappId, (boolean)false);
        if ("2".equals(metadata.getAppElement().getDeployStatus())) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"deploystatusenable"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"deploystatusdisable"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"deploystatusenable"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"deploystatusdisable"});
        }
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        String nodeId = (String)evt.getNodeId();
        this.getPageCache().put(CURRENT_NODE, nodeId);
        String pageType = this.getPageCache().get(CURRENT_PAGETYPE);
        String bizAppId = (String)this.getView().getFormShowParameter().getCustomParam(BIZAPPID);
        this.renderEntryEntity(bizAppId, pageType, nodeId, "");
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String formId = this.getSelectForm();
        if (args.getSource() instanceof Donothing) {
            String key;
            Donothing operate = (Donothing)args.getSource();
            switch (key = operate.getOperateKey()) {
                case "collect": 
                case "cancel_collect": {
                    this.collectPage(formId);
                    break;
                }
                case "showentity": {
                    GotoDesignerUtils.gotoDesigner(PageType.EntityObject.getValue(), this.getView(), formId);
                    break;
                }
                case "showpage": {
                    GotoDesignerUtils.gotoDesigner(PageType.Page.getValue(), this.getView(), formId);
                    break;
                }
                case "viewinherittree": {
                    this.ViewInheritTree(formId);
                    break;
                }
            }
        }
    }

    private void ViewInheritTree(String formId) {
        FormShowParameter showInheritParameter = new FormShowParameter();
        showInheritParameter.getOpenStyle().setShowType(ShowType.Modal);
        showInheritParameter.setFormId("devpn_pageinheritview");
        showInheritParameter.setCustomParam("formId", (Object)formId);
        CloseCallBack inheritCallBack = new CloseCallBack((IFormPlugin)this, "viewPageInheritTree_close");
        showInheritParameter.setCloseCallBack(inheritCallBack);
        this.getView().showForm(showInheritParameter);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        if ("viewPageInheritTree_close".equals(e.getActionId()) && e.getReturnData() != null) {
            this.handleViewPageInheritTreeCallBack(e);
        }
    }

    private void handleViewPageInheritTreeCallBack(ClosedCallBackEvent e) {
        Map returnData = (Map)e.getReturnData();
        String bizUnitId = (String)returnData.get("bizunitid");
        String bizAppId = (String)returnData.get(BIZAPPID);
        String bizPageId = (String)returnData.get("bizpageid");
        String pageType = this.getPageCache().get(CURRENT_PAGETYPE);
        if (StringUtils.isBlank((CharSequence)pageType)) {
            pageType = PageType.EntityObject.getValue();
        }
        MyAppUtils.showAppDetail(this.getView(), bizAppId, bizUnitId, bizPageId, pageType);
    }

    private String getSelectForm() {
        int entryRowCount = this.getModel().getEntryRowCount(TREEENTRYENTITY);
        int rowIndex = this.getModel().getEntryCurrentRowIndex(TREEENTRYENTITY);
        EntryGrid grid = (EntryGrid)this.getView().getControl(TREEENTRYENTITY);
        int[] selectRows = grid.getSelectRows();
        if (entryRowCount == 0 || selectRows.length == 0) {
            return null;
        }
        return (String)this.getModel().getValue(FORMID, rowIndex);
    }

    private void collectPage(String formId) {
        Long userId = RequestContext.get().getCurrUserId();
        DynamicObject app = BizAppServiceHelp.getBizAppByFormID((String)formId);
        String appId = null;
        if (app != null) {
            appId = app.getString("id");
        }
        QFilter qFilter = new QFilter(BIZAPP, "=", (Object)appId);
        QFilter qFilter1 = new QFilter("user", "=", (Object)userId);
        QFilter qFilter2 = new QFilter(BIZPAGE, "=", (Object)formId);
        QFilter[] qFilters = new QFilter[]{qFilter, qFilter1, qFilter2};
        int iscollected = 0;
        boolean isCollect = QueryServiceHelper.exists((String)BOS_DEVPORTAL_SHORTCUT, (QFilter[])qFilters);
        if (isCollect) {
            String pkId = QueryServiceHelper.queryOne((String)BOS_DEVPORTAL_SHORTCUT, (String)"id", (QFilter[])qFilters).getString("id");
            Object[] pkIds = new String[]{pkId};
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)BOS_DEVPORTAL_SHORTCUT);
            DeleteServiceHelper.delete((IDataEntityType)entityType, (Object[])pkIds);
        } else {
            DynamicObject object = BusinessDataServiceHelper.newDynamicObject((String)BOS_DEVPORTAL_SHORTCUT);
            object.set(BIZAPP, (Object)appId);
            object.set("user", (Object)userId);
            object.set(BIZPAGE, (Object)formId);
            DynamicObject[] collect = new DynamicObject[]{object};
            SaveServiceHelper.save((DynamicObject[])collect);
            iscollected = 1;
        }
        EntryGrid treeEntryGrid = (EntryGrid)this.getControl(TREEENTRYENTITY);
        ArrayList<String> opeIds = new ArrayList<String>();
        if (iscollected == 1) {
            opeIds.add(COLLECT);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6536\u85cf\u6210\u529f\u3002", (String)"OriginalAppDetailPlugin_7", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
        } else {
            opeIds.add(CANCEL_COLLECT);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6536\u85cf\u5df2\u53d6\u6d88\u3002", (String)"OriginalAppDetailPlugin_8", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
        }
        int rowIndex = this.getModel().getEntryCurrentRowIndex(TREEENTRYENTITY);
        this.getModel().setValue(COLLECTED, (Object)iscollected, rowIndex);
        treeEntryGrid.hideOperateItems("operationcolumnap", rowIndex, opeIds);
        this.getView().updateView(TREEENTRYENTITY, rowIndex);
    }

    private void renderEntryEntity(String bizAppId, String pageType, String nodeId, String searchText) {
        this.updateBoxInfo(this.getData(bizAppId, nodeId, searchText));
        List<DynamicFormInfo> formLists = this.getPageList(pageType, nodeId, searchText);
        if (formLists == null || formLists.isEmpty()) {
            this.getModel().deleteEntryData(TREEENTRYENTITY);
            return;
        }
        HashSet<Long> userIds = new HashSet<Long>(16);
        HashSet<String> parentIds = new HashSet<String>(16);
        for (DynamicFormInfo info : formLists) {
            if (StringUtils.isNotBlank((CharSequence)info.getModifier())) {
                userIds.add(Long.parseLong(info.getModifier()));
            }
            if (!StringUtils.isNotBlank((CharSequence)info.getSourcePage())) continue;
            parentIds.add(info.getSourcePage());
        }
        MainEntityType userDt = EntityMetadataCache.getDataEntityType((String)BOS_USER);
        MainEntityType formDt = EntityMetadataCache.getDataEntityType((String)BOS_DEVPN_FORMMETA);
        Map users = BusinessDataReader.loadFromCache((Object[])userIds.toArray(), (DynamicObjectType)userDt);
        Map forms = BusinessDataReader.loadFromCache((Object[])parentIds.toArray(), (DynamicObjectType)formDt);
        String treeEntryEntity = TREEENTRYENTITY;
        this.getModel().deleteEntryData(treeEntryEntity);
        this.getModel().batchCreateNewEntryRow(treeEntryEntity, formLists.size());
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(treeEntryEntity);
        ArrayList<CellStyle> cellStyles = new ArrayList<CellStyle>(formLists.size());
        int index = 0;
        for (DynamicFormInfo info : formLists) {
            DynamicObject row = (DynamicObject)entryEntity.get(index);
            this.renderRow(row, info, forms, users, index, cellStyles, pageType);
            ++index;
        }
        this.getView().updateView(treeEntryEntity);
        EntryGrid entryGrid = (EntryGrid)this.getControl(treeEntryEntity);
        entryGrid.setCellStyle(cellStyles);
        this.showOperationCol(pageType);
    }

    private void renderRow(DynamicObject row, DynamicFormInfo info, Map<Object, DynamicObject> forms, Map<Object, DynamicObject> users, int index, List<CellStyle> cellStyles, String pageType) {
        if (info.getEnable() == 0) {
            cellStyles.add(OriginalAppUtils.genStyle(ENABLE_STATUS, index, "#b2b2b2"));
        } else {
            cellStyles.add(OriginalAppUtils.genStyle(ENABLE_STATUS, index, "#2ab277"));
        }
        row.set("pid", (Object)0L);
        row.set(Key_Number, (Object)info.getNumber());
        row.set(NAME, (Object)info.getName());
        if (StringUtils.isNotBlank((CharSequence)info.getSourcePage())) {
            DynamicObject form = forms.get(info.getSourcePage());
            row.set(Key_SourcePage, form == null ? null : form.get(Key_Number));
            row.set(Key_SourcePage_ID, (Object)info.getSourcePage());
        }
        if (PageType.LayOut.getValue().equals(pageType)) {
            row.set(MODELTYPE, (Object)ResManager.loadKDString((String)"\u8868\u5355+\u5217\u8868", (String)"OriginalAppDetailPlugin_9", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
        } else {
            row.set(MODELTYPE, (Object)info.getModelType());
        }
        String modelType = info.getModelType();
        String terminal = "pc";
        if ("MobileFormModel".equals(modelType) || "MobileBillFormModel".equals(modelType) || "MobUserGuideFormModel".equals(modelType) || "MobileListModel".equals(modelType)) {
            terminal = "mobile";
        }
        row.set("terminal", (Object)terminal);
        row.set(MODIFIER, StringUtils.isBlank((CharSequence)info.getModifier()) ? null : users.get(Long.parseLong(info.getModifier())));
        row.set(MODIFYDATE, (Object)info.getModifyDate());
        row.set(ENABLE_STATUS, (Object)info.getEnable());
        row.set(FORMID, (Object)info.getFormId());
        row.set(COLLECTED, (Object)info.getIsCollected());
        row.set(ISV, (Object)info.getIsv());
        row.set(PAGETYPE, (Object)pageType);
        row.set(ENTITYID, (Object)info.getEntityId());
    }

    private List<DynamicFormInfo> getPageList(String pageType, String nodeId, String searchText) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
        if (StringUtils.isNotBlank((CharSequence)searchText)) {
            String searchContent = String.format("%s%s%s", "%", searchText, "%");
            QFilter numberFilter = new QFilter(Key_Number, "like", (Object)searchContent);
            numberFilter.or(new QFilter(NAME, "like", (Object)searchContent));
            qFilters.add(numberFilter);
        }
        String bizappId = (String)this.getView().getFormShowParameter().getCustomParam(BIZAPPID);
        qFilters.add(new QFilter(BIZAPPID, "=", (Object)bizappId));
        QFilter isvFilter = new QFilter(ISV, "in", (Object)new String[]{"kingdee", " "});
        qFilters.add(isvFilter);
        Map<String, DynamicFormInfo> metas = OriginalAppDetailPlugin.queryFormDesignMeta(0, 100000, qFilters, MODIFYDATE, nodeId);
        if (metas == null || metas.isEmpty()) {
            return new ArrayList<DynamicFormInfo>(1);
        }
        ArrayList<DynamicFormInfo> allForms = new ArrayList<DynamicFormInfo>(metas.size());
        if (pageType == null) {
            pageType = ROOT_ID;
        }
        List<String> enableModelTypes = DevportalModelTypes.getModelTypesByType(pageType);
        List<String> commonTypes = DevportalModelTypes.getModelTypesByType(PageType.Common.getValue());
        for (Map.Entry<String, DynamicFormInfo> entry : metas.entrySet()) {
            DynamicFormInfo info = entry.getValue();
            String modelType = info.getModelType();
            if (!enableModelTypes.contains(modelType) || PageType.EntityObject.getValue().equals(pageType) && commonTypes.contains(modelType) && !info.getFormId().equals(info.getEntityId()) || PageType.Page.getValue().equals(pageType) && commonTypes.contains(modelType)) continue;
            String client = ROOT_ID;
            if (modelType.startsWith("Mobile")) {
                client = "1";
            }
            info.setClient(client);
            allForms.add(info);
        }
        return allForms;
    }

    private void updateBoxInfo(Map<String, DynamicFormInfo> metas) {
        Map<String, Integer> map = this.getCount(metas);
        Integer object = map.get(BTN_OBJECT);
        Integer page = map.get(BTN_PAGE);
        Integer report = map.get(BTN_REPORT);
        Integer param = map.get(BTN_PARAM);
        Integer layout = map.get(BTN_LAYOUT);
        this.updateTabName(KEY_TAB_OBJECT, ResManager.loadKDString((String)"\u4e1a\u52a1\u5bf9\u8c61(%s)", (String)"OriginalAppDetailPlugin_1", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[]{object}));
        this.updateTabName(KEY_TAB_DEVPAGE, ResManager.loadKDString((String)"\u9875\u9762(%s)", (String)"OriginalAppDetailPlugin_2", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[]{page}));
        this.updateTabName(KEY_TAB_REPORT, ResManager.loadKDString((String)"\u62a5\u8868(%s)", (String)"OriginalAppDetailPlugin_3", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[]{report}));
        this.updateTabName(KEY_TAB_PARAM, ResManager.loadKDString((String)"\u53c2\u6570(%s)", (String)"OriginalAppDetailPlugin_4", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[]{param}));
        this.updateTabName(KEY_TAB_LAYOUT, ResManager.loadKDString((String)"\u5e03\u5c40(%s)", (String)"OriginalAppDetailPlugin_10", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[]{layout}));
    }

    private void updateTabName(String key, String name) {
        HashMap map = new HashMap(1);
        HashMap<String, String> nameMap = new HashMap<String, String>(1);
        nameMap.put("zh_CN", name);
        map.put("text", nameMap);
        this.getView().updateControlMetadata(key, map);
    }

    private Map<String, Integer> getCount(Map<String, DynamicFormInfo> metas) {
        Integer objectCount = 0;
        Integer pageCount = 0;
        Integer report = 0;
        Integer parameter = 0;
        Integer layout = 0;
        HashMap<String, Integer> map = new HashMap<String, Integer>(5);
        List<String> objectTypes = DevportalModelTypes.getModelTypesByType(PageType.EntityObject.getValue());
        List<String> pageTypes = DevportalModelTypes.getModelTypesByType(PageType.Page.getValue());
        List<String> reportTypes = DevportalModelTypes.getModelTypesByType(PageType.Report.getValue());
        List<String> paramTypes = DevportalModelTypes.getModelTypesByType(PageType.Parameter.getValue());
        List<String> commonTypes = DevportalModelTypes.getModelTypesByType(PageType.Common.getValue());
        List<String> layoutTypes = DevportalModelTypes.getModelTypesByType(PageType.LayOut.getValue());
        if (metas != null && !metas.isEmpty()) {
            for (Map.Entry<String, DynamicFormInfo> entry : metas.entrySet()) {
                DynamicFormInfo info = entry.getValue();
                String modelType = info.getModelType();
                if (objectTypes != null && objectTypes.contains(modelType) && (!commonTypes.contains(modelType) || info.getFormId().equals(info.getEntityId()))) {
                    objectCount = objectCount + 1;
                }
                if (pageTypes != null && pageTypes.contains(modelType) && !commonTypes.contains(modelType)) {
                    pageCount = pageCount + 1;
                }
                if (reportTypes.contains(modelType)) {
                    report = report + 1;
                }
                if (paramTypes.contains(modelType)) {
                    parameter = parameter + 1;
                }
                if (!layoutTypes.contains(modelType)) continue;
                layout = layout + 1;
            }
        }
        map.put(BTN_OBJECT, objectCount);
        map.put(BTN_PAGE, pageCount);
        map.put(BTN_REPORT, report);
        map.put(BTN_PARAM, parameter);
        map.put(BTN_LAYOUT, layout);
        return map;
    }

    private String pageTypeToTab(String pageType) {
        String tab = BTN_OBJECT;
        switch (pageType) {
            case "0": {
                tab = BTN_OBJECT;
                break;
            }
            case "1": {
                tab = BTN_PAGE;
                break;
            }
            case "2": {
                tab = BTN_REPORT;
                break;
            }
            case "3": {
                tab = BTN_PARAM;
                break;
            }
            case "5": {
                tab = BTN_LAYOUT;
                break;
            }
        }
        return tab;
    }

    private Map<String, DynamicFormInfo> getData(String bizappId, String bizunitId, String searchText) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
        filters.add(new QFilter(BIZAPPID, "=", (Object)bizappId));
        filters.add(new QFilter(ISV, "in", (Object)new String[]{"kingdee", " "}));
        if (StringUtils.isNotBlank((CharSequence)searchText)) {
            String searchContent = String.format("%s%s%s", "%", searchText, "%");
            QFilter numberFilter = new QFilter(Key_Number, "like", (Object)searchContent);
            numberFilter.or(new QFilter(NAME, "like", (Object)searchContent));
            filters.add(numberFilter);
        }
        Map<String, DynamicFormInfo> metas = OriginalAppDetailPlugin.queryFormDesignMeta(0, 100000, filters, MODIFYDATE, bizunitId);
        return metas;
    }

    private static Map<String, DynamicFormInfo> queryFormDesignMeta(int start, int limit, List<QFilter> qFilters, String orderBy, String nodeId) {
        QFilter[] unitRelFormFilters = null;
        if (StringUtils.isBlank((CharSequence)nodeId)) {
            nodeId = ROOT_ID;
        }
        if (!ROOT_ID.equals(nodeId)) {
            QFilter unitRelFormFilter = new QFilter("bizunit", "=", (Object)nodeId);
            unitRelFormFilters = new QFilter[]{unitRelFormFilter};
        }
        String unitrelformFields = "bizapp,bizunit,form";
        String formFields = "id,number,modeltype,parentid,masterid,bizappid,bizappid.bizcloud,modifierid,modifydate,name,basedatafield,enable,type,isv";
        ORM orm = ORM.create();
        LinkedHashMap<String, DynamicFormInfo> map = new LinkedHashMap<String, DynamicFormInfo>(10);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:sss");
        long userId = RequestContext.get().getCurrUserId();
        QFilter shortcutFilter = new QFilter("user", "=", (Object)userId);
        QFilter[] shortcutFilters = new QFilter[]{shortcutFilter};
        String shortcutFields = "bizapp,bizpage";
        try (DataSet formMetaDataSet = orm.queryDataSet(BOS_DEVPN_FORMMETA, BOS_DEVPN_FORMMETA, formFields, qFilters.toArray(new QFilter[qFilters.size()]), orderBy, start, limit);
             DataSet unitRelFormDataSet = QueryServiceHelper.queryDataSet((String)"bos_devportal_unitrelform", (String)"bos_devportal_unitrelform", (String)unitrelformFields, (QFilter[])unitRelFormFilters, (String)"form asc");
             DataSet shortcutDataSet = QueryServiceHelper.queryDataSet((String)BOS_DEVPORTAL_SHORTCUT, (String)BOS_DEVPORTAL_SHORTCUT, (String)shortcutFields, (QFilter[])shortcutFilters, (String)"bizpage asc");){
            HashMap<String, String> unitRelWhereParam = new HashMap<String, String>();
            unitRelWhereParam.put("bizunitVal", nodeId);
            try (DataSet result = formMetaDataSet.join(unitRelFormDataSet, JoinType.LEFT).on("id", "form").select(new String[]{"id", Key_Number, MODELTYPE, "parentid", "masterid", BIZAPPID, "bizappid.bizcloud", "modifierid", MODIFYDATE, NAME, "basedatafield", Key_Enable, "type", ISV}, new String[]{"bizunit", "form"}).finish().where(ROOT_ID.equals(nodeId) ? "1=1" : "bizunit = bizunitVal", unitRelWhereParam).join(shortcutDataSet, JoinType.LEFT).on("form", BIZPAGE).select(new String[]{"id", Key_Number, "bizunit", MODELTYPE, "parentid", "masterid", BIZAPPID, "bizappid.bizcloud", "modifierid", MODIFYDATE, NAME, BIZAPP, "basedatafield", Key_Enable, "type", ISV}, new String[]{BIZPAGE}).finish().orderBy(new String[]{orderBy});){
                result.forEach(rs -> {
                    String id = rs.getString("id");
                    String number = rs.getString(Key_Number);
                    String modelType = rs.getString(MODELTYPE);
                    String parentId = rs.getString("parentid");
                    String masterId = rs.getString("masterid");
                    String bizappId = rs.getString(BIZAPPID);
                    String modifierId = rs.getString("modifierid");
                    String modifyDateStr = rs.getString(MODIFYDATE);
                    String entityId = rs.getString("basedatafield");
                    Date modifyDate = new Date();
                    try {
                        modifyDate = sdf.parse(modifyDateStr);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    int isCollection = 0;
                    if (rs.getString(BIZAPP) != null && rs.getString(BIZPAGE) != null) {
                        isCollection = 1;
                    }
                    String name = rs.getString(NAME);
                    String bizCloudId = rs.getString("bizappid.bizcloud");
                    String bizUnitId = rs.getString("bizunit");
                    String typeStr = rs.getString("type");
                    String enableStr = rs.getString(Key_Enable);
                    String isv = rs.getString(ISV);
                    int enable = StringUtils.isBlank((CharSequence)enableStr) ? 0 : Integer.parseInt(enableStr);
                    int type = StringUtils.isBlank((CharSequence)typeStr) ? 0 : Integer.parseInt(typeStr);
                    DynamicFormInfo info = new DynamicFormInfo(number, name, modelType, bizappId, modifierId, modifyDate);
                    info.setFormId(id);
                    info.setBizCloud(bizCloudId);
                    info.setSourcePage(parentId);
                    info.setBizUnitId(bizUnitId);
                    info.setIsCollected(isCollection);
                    info.setEntityId(entityId);
                    info.setEnable(enable);
                    info.setType(type);
                    info.setIsv(isv);
                    map.put(id, info);
                });
            }
        }
        return map;
    }

    private void appInfo() {
        String bizAppId = (String)this.getView().getFormShowParameter().getCustomParam(BIZAPPID);
        if (StringUtils.isBlank((CharSequence)bizAppId)) {
            return;
        }
        DynamicObject bizApp = BusinessDataServiceHelper.loadSingleFromCache((Object)bizAppId, (String)BOS_DEVPORTAL_BIZAPP);
        String domainUrl = UrlService.getDomainContextUrl();
        String image = bizApp.getString("image");
        if (StringUtils.isNotBlank((CharSequence)image) && !image.startsWith("/")) {
            image = "/" + image;
        }
        IImage imageLabel = (IImage)this.getControl("imageap");
        imageLabel.setUrl(domainUrl + image);
        DynamicObject cloud = (DynamicObject)bizApp.get("bizcloud");
        String cloudName = cloud == null ? "" : cloud.getString(NAME);
        this.setDeployStatuStyle();
        String dbRoute = bizApp.getString("dbroute");
        JSONObject instance = DevportalUtil.getDbInstanceInfo((String)dbRoute);
        String dbRouteKey = (String)instance.get((Object)Key_Number);
        if (StringUtils.isBlank((CharSequence)dbRouteKey)) {
            dbRouteKey = dbRoute;
        }
        this.setLabelText("namelabelap", bizApp.getString(NAME));
    }

    private void setLabelText(String key, String text) {
        Label label = (Label)this.getControl(key);
        label.setText(text);
    }

    private String getRouteName(String dbRoute) {
        JSONArray dbInstanceList = DevportalUtil.getDbInstanceList();
        for (Object route : dbInstanceList) {
            JSONObject db = (JSONObject)route;
            String dbNumber = db.getString(Key_Number);
            if (!dbRoute.equalsIgnoreCase(dbNumber)) continue;
            return db.getString(NAME);
        }
        return dbRoute;
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String pageType = this.getPageCache().get(CURRENT_PAGETYPE);
        if (StringUtils.isBlank((CharSequence)pageType)) {
            pageType = PageType.EntityObject.getValue();
        }
        String formId = null;
        if (Key_SourcePage.equals(evt.getFieldName())) {
            formId = (String)this.getModel().getValue(Key_SourcePage_ID, evt.getRowIndex());
        } else {
            formId = (String)this.getModel().getValue(FORMID);
            String row_formId = (String)this.getModel().getValue(FORMID, evt.getRowIndex());
            formId = formId != null ? formId : row_formId;
        }
        GotoDesignerUtils.gotoDesigner(pageType, this.getView(), formId);
    }

    public void listboxClick(ListboxEvent listboxEvent) {
    }

    public void tabSelected(TabSelectEvent evt) {
        String activerByServer = this.getPageCache().get("activerByServer");
        if (StringUtils.isNotBlank((CharSequence)activerByServer) && "true".equals(activerByServer)) {
            this.getPageCache().remove("activerByServer");
            return;
        }
        String pageType = ROOT_ID;
        switch (evt.getTabKey()) {
            case "tabobject": {
                break;
            }
            case "tabdevpage": {
                pageType = "1";
                break;
            }
            case "tabreport": {
                pageType = "2";
                break;
            }
            case "tabparam": {
                pageType = "3";
                break;
            }
            case "tablayout": {
                pageType = "5";
                break;
            }
        }
        String nodeId = this.getPageCache().get(CURRENT_NODE);
        if (StringUtils.isBlank((CharSequence)nodeId)) {
            TreeView treeView = (TreeView)this.getControl(TREEVIEW);
            nodeId = treeView.getTreeState().getFocusNodeId();
        }
        this.getPageCache().put(CURRENT_PAGETYPE, pageType);
        String bizAppId = (String)this.getView().getFormShowParameter().getCustomParam(BIZAPPID);
        String searchText = this.getPageCache().get(CacheId_SearchText);
        this.renderEntryEntity(bizAppId, pageType, nodeId, searchText);
        this.showOperationCol(pageType);
    }

    private void showOperationCol(String pageType) {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(TREEENTRYENTITY);
        if (PageType.EntityObject.getValue().equals(pageType)) {
            entryGrid.setColumnProperty("operationcolumnap1", "vi", (Object)Boolean.TRUE);
        } else {
            entryGrid.setColumnProperty("operationcolumnap1", "vi", (Object)Boolean.FALSE);
        }
        String numberCaption = ResManager.loadKDString((String)"\u5bf9\u8c61\u7f16\u7801", (String)"OriginalAppDetailPlugin_11", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]);
        String nameCaption = ResManager.loadKDString((String)"\u5bf9\u8c61\u540d\u79f0", (String)"OriginalAppDetailPlugin_12", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]);
        switch (pageType) {
            case "0": {
                break;
            }
            case "1": {
                numberCaption = ResManager.loadKDString((String)"\u9875\u9762\u7f16\u7801", (String)"OriginalAppDetailPlugin_13", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]);
                nameCaption = ResManager.loadKDString((String)"\u9875\u9762\u540d\u79f0", (String)"OriginalAppDetailPlugin_14", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]);
                break;
            }
            case "2": {
                numberCaption = ResManager.loadKDString((String)"\u62a5\u8868\u7f16\u7801", (String)"OriginalAppDetailPlugin_15", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]);
                nameCaption = ResManager.loadKDString((String)"\u62a5\u8868\u540d\u79f0", (String)"OriginalAppDetailPlugin_16", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]);
                break;
            }
            case "3": {
                numberCaption = ResManager.loadKDString((String)"\u53c2\u6570\u7f16\u7801", (String)"OriginalAppDetailPlugin_17", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]);
                nameCaption = ResManager.loadKDString((String)"\u53c2\u6570\u540d\u79f0", (String)"OriginalAppDetailPlugin_18", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]);
                break;
            }
            case "5": {
                numberCaption = ResManager.loadKDString((String)"\u5e03\u5c40\u7f16\u7801", (String)"OriginalAppDetailPlugin_19", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]);
                nameCaption = ResManager.loadKDString((String)"\u5e03\u5c40\u540d\u79f0", (String)"OriginalAppDetailPlugin_20", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]);
                break;
            }
        }
        entryGrid.setColumnProperty(Key_Number, "header", (Object)numberCaption);
        entryGrid.setColumnProperty(NAME, "header", (Object)nameCaption);
    }

    protected void markTargetPage(String bizUnitId, String bizPageId) {
        if (StringUtils.isNotBlank((CharSequence)bizUnitId)) {
            TreeView tView = (TreeView)this.getControl(TREEVIEW);
            tView.treeNodeClick(ROOT_ID, bizUnitId);
            TreeNode node = this.getRootNode().getTreeNode(bizUnitId, 10);
            tView.focusNode(node);
        }
        if (StringUtils.isNotBlank((CharSequence)bizPageId)) {
            TreeEntryGrid grid = (TreeEntryGrid)this.getControl(TREEENTRYENTITY);
            int rowIndex = this.findRowById(bizPageId);
            grid.selectRows(rowIndex);
        }
    }

    private int findRowById(String formId) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(TREEENTRYENTITY);
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject info = (DynamicObject)entryEntity.get(i);
            if (!formId.equals(info.getString(FORMID))) continue;
            return i;
        }
        return -1;
    }

    private void tabActive(String pageType) {
        if (StringUtils.isBlank((CharSequence)pageType)) {
            pageType = PageType.EntityObject.getValue();
        }
        String tabKey = KEY_TAB_OBJECT;
        switch (pageType) {
            case "0": {
                break;
            }
            case "1": {
                tabKey = KEY_TAB_DEVPAGE;
                break;
            }
            case "2": {
                tabKey = KEY_TAB_REPORT;
                break;
            }
            case "3": {
                tabKey = KEY_TAB_PARAM;
                break;
            }
            case "5": {
                tabKey = KEY_TAB_LAYOUT;
                break;
            }
        }
        this.getPageCache().put("activerByServer", "true");
        Tab tabap = (Tab)this.getView().getControl(KEY_TABAP);
        tabap.activeTab(tabKey);
    }
}

