/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.newdevportal.card;

import com.alibaba.fastjson.JSONArray;
import java.sql.Date;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlBuilder;
import kd.bos.designer.tree.BizAppTreeBuilder;
import kd.bos.devportal.common.util.AppUtils;
import kd.bos.devportal.util.DevportalUtil;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.devportal.AppFunctionPacketElement;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.isv.ISVService;
import kd.bos.lang.Lang;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.newdevportal.app.my.DevpPermissionUtils;
import kd.bos.newdevportal.bean.DynamicFormInfo;
import kd.bos.newdevportal.bean.EntityFormInfo;
import kd.bos.newdevportal.constant.PageType;
import kd.bos.newdevportal.dynamicform.AppFunctionCacheUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;

public class CardListManagerPlugin
extends AbstractFormPlugin
implements TreeNodeClickListener,
SearchEnterListener {
    private static final String Key_Number = "number";
    private static final String Key_Name = "name";
    private static final String Key_SourcePage = "sourcepage";
    private static final String Key_BizApp = "bizapp";
    private static final String Key_Function = "function";
    private static final String Key_BizCloud = "bizCloud";
    private static final String Key_Modifier = "modifier";
    private static final String Key_ModifyDate = "modifyDate";
    private static final String Key_BizUnitId = "bizunitid";
    private static final String Key_Collect = "like";
    protected static final String Key_TreeView = "treeviewap";
    protected static final String CacheId_TreeNodes = "nodes";
    protected static final String CacheId_CurrNode = "currnode";
    protected static final String Key_EntryEntity = "entryentity";
    protected static final String Key_Search = "search";
    protected static final String PAGETYPE = "PAGE_TYPE";
    protected static final String Key_BtnClearAppFuncCache = "btnclearappfunccache";
    protected static final String EntityId_Form = "bos_formmeta";
    protected static final String EntityId_App = "bos_devportal_bizapp";
    protected static final String EntityId_Cloud = "bos_devportal_bizcloud";
    protected static final String EntityId_User = "bos_user";
    protected List<DynamicFormInfo> dynamicFormListInfos;
    protected List<String> enableModelTypes = new ArrayList<String>(5);

    public void initialize() {
        super.initialize();
        this.addItemClickListeners(new String[]{"toolbarap"});
        TreeView tView = (TreeView)this.getControl(Key_TreeView);
        tView.addTreeNodeClickListener((TreeNodeClickListener)this);
        Search search = (Search)this.getControl(Key_Search);
        search.addEnterListener((SearchEnterListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        TreeNode rootNode = this.buildTreeNodes();
        TreeView tView = (TreeView)this.getControl(Key_TreeView);
        tView.addNode(rootNode);
        this.loadEnableModelType();
        List<DynamicFormInfo> allDynamicFormList = this.loadAllDynamicFormList();
        this.putDynamicFormCache(allDynamicFormList);
        this.doSearch("");
    }

    private TreeNode buildTreeNodes() {
        BizAppTreeBuilder bizAppTreeBuilder = new BizAppTreeBuilder();
        bizAppTreeBuilder.setRuntime(true);
        TreeNode root = bizAppTreeBuilder.buildTree();
        root.setId("0");
        root.setText(ResManager.loadKDString((String)"\u4e1a\u52a1\u4e91", (String)"CardListManagerPlugin_0", (String)"bos-devportal-new-plugin", (Object[])new Object[0]));
        root.setParentid("");
        root.setIsOpened(true);
        String json = SerializationUtils.toJsonString((Object)bizAppTreeBuilder);
        this.getPageCache().put(CacheId_TreeNodes, json);
        return root;
    }

    public void treeNodeClick(TreeNodeEvent e) {
        String currNodeId;
        String newNodeId = (String)e.getNodeId();
        if (newNodeId.equals(currNodeId = this.getPageCache().get(CacheId_CurrNode))) {
            return;
        }
        List<DynamicFormInfo> allForms = this.getDynamicFormCache();
        this.doSearchByNodeId(allForms, newNodeId);
        this.getPageCache().put(CacheId_CurrNode, newNodeId);
    }

    private void doSearchByNodeId(List<DynamicFormInfo> allForms, String nodedId) {
        ArrayList<DynamicFormInfo> myForms = new ArrayList<DynamicFormInfo>();
        if (StringUtils.isBlank((CharSequence)nodedId)) {
            myForms.addAll(allForms);
        } else {
            String rootNodeJson = this.getPageCache().get(CacheId_TreeNodes);
            BizAppTreeBuilder bizAppTreeBuilder = (BizAppTreeBuilder)SerializationUtils.fromJsonString((String)rootNodeJson, BizAppTreeBuilder.class);
            TreeNode rootNode = bizAppTreeBuilder.getRootNode();
            if (rootNode.getId().equals(nodedId)) {
                myForms.addAll(allForms);
            } else {
                TreeNode cloudNode = null;
                for (TreeNode node : rootNode.getChildren()) {
                    if (!node.getId().equals(nodedId)) continue;
                    cloudNode = node;
                    break;
                }
                HashSet<String> bizAppIds = new HashSet<String>();
                if (cloudNode != null) {
                    bizAppIds.add(nodedId);
                    if (cloudNode.getChildren() != null) {
                        for (TreeNode bizAppNode : cloudNode.getChildren()) {
                            bizAppIds.add(bizAppNode.getId());
                            bizAppIds.addAll((Collection)bizAppTreeBuilder.getAppExtIds().get(bizAppNode.getId()));
                        }
                    }
                } else {
                    bizAppIds.add(nodedId);
                    bizAppIds.addAll((Collection)bizAppTreeBuilder.getAppExtIds().get(nodedId));
                }
                for (DynamicFormInfo form : allForms) {
                    if (!bizAppIds.contains(form.getBizApp())) continue;
                    myForms.add(form);
                }
            }
        }
        this.refreshEntryGrid(myForms);
    }

    private void doSearch(String searchText) {
        List<DynamicFormInfo> lists = this.getDynamicFormCache();
        ArrayList<DynamicFormInfo> formLists = new ArrayList<DynamicFormInfo>();
        if (StringUtils.isBlank((CharSequence)searchText)) {
            formLists.addAll(lists);
        } else {
            for (DynamicFormInfo cloud : lists) {
                if ((!StringUtils.isNotBlank((CharSequence)cloud.getNumber()) || cloud.getNumber().indexOf(searchText) < 0) && (!StringUtils.isNotBlank((CharSequence)cloud.getName()) || cloud.getName().indexOf(searchText) < 0)) continue;
                formLists.add(cloud);
            }
        }
        this.refreshEntryGrid(formLists);
    }

    private List<DynamicFormInfo> getDynamicFormCache() {
        if (this.dynamicFormListInfos != null && !this.dynamicFormListInfos.isEmpty()) {
            return this.dynamicFormListInfos;
        }
        String listJsonString = this.getPageCache().get(this.getFormListCacheId());
        this.dynamicFormListInfos = StringUtils.isBlank((CharSequence)listJsonString) || "[]".equals(listJsonString) ? this.loadAllDynamicFormList() : SerializationUtils.fromJsonStringToList((String)listJsonString, DynamicFormInfo.class);
        return this.dynamicFormListInfos;
    }

    private DynamicFormInfo getSelectForm() {
        int rowCount = this.getModel().getEntryRowCount(Key_EntryEntity);
        int rowIndex = this.getModel().getEntryCurrentRowIndex(Key_EntryEntity);
        EntryGrid grid = (EntryGrid)this.getView().getControl(Key_EntryEntity);
        int[] selRows = grid.getSelectRows();
        if (rowCount == 0 || rowIndex < 0 || selRows == null || selRows.length < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u8bb0\u5f55\u3002", (String)"CardListManagerPlugin_1", (String)"bos-devportal-new-plugin", (Object[])new Object[0]));
            return null;
        }
        String number = (String)this.getModel().getValue(Key_Number, rowIndex);
        List<DynamicFormInfo> allFormList = this.getDynamicFormCache();
        DynamicFormInfo form = null;
        for (DynamicFormInfo info : allFormList) {
            if (!number.equals(info.getNumber())) continue;
            form = info;
            break;
        }
        return form;
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if (Key_BtnClearAppFuncCache.equals(key)) {
            AppFunctionCacheUtils.removeCache();
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u529f\u80fd\u5206\u7ec4\u7f13\u5b58\u6e05\u9664\u6210\u529f\u3002", (String)"CardListManagerPlugin_2", (String)"bos-devportal-new-plugin", (Object[])new Object[0]));
            return;
        }
        if ("baritenew".equals(key)) {
            this.createParam();
            return;
        }
        DynamicFormInfo info = this.getSelectForm();
        if (null == info) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u53ef\u80fd\u5df2\u5220\u9664\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u9875\u9762\u3002", (String)"CardListManagerPlugin_3", (String)"bos-devportal-new-plugin", (Object[])new Object[0]));
            return;
        }
        switch (key) {
            case "bariteexport": {
                this.exportParam(info);
                break;
            }
            case "baritedelete": {
                this.deleteParam(info);
                break;
            }
            case "bariteinherit": {
                this.inherit(info);
                break;
            }
            case "bariteextend": {
                this.extendParam(info);
                break;
            }
        }
    }

    protected void createParam() {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("bos_devpn_crtpage");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.getCustomParams().put("createPageType", this.getPageType());
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "createPageCallBack");
        formShowParameter.setCloseCallBack(callBack);
        this.getView().showForm(formShowParameter);
    }

    protected void exportParam(DynamicFormInfo info) {
        String bizAppId = info.getBizApp();
        String bizFormNumber = info.getNumber();
        String bizunitId = info.getBizUnitId();
        String bizFormId = info.getFormId();
        this.getPageCache().put("bizappid", bizAppId);
        this.getPageCache().put("bizformid", bizFormId);
        this.getPageCache().put("bizformnumber", bizFormNumber);
        FormShowParameter parameter = new FormShowParameter();
        parameter.setCaption(ResManager.loadKDString((String)"\u5bfc\u51fa\u9875\u9762", (String)"CardListManagerPlugin_4", (String)"bos-devportal-new-plugin", (Object[])new Object[0]));
        parameter.setCustomParam("bizappid", (Object)bizAppId);
        parameter.setCustomParam(Key_BizUnitId, (Object)bizunitId);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("bos_devp_exportsource");
        parameter.setCustomParam("bizid", (Object)bizFormId);
        parameter.setCustomParam("bizformnumber", (Object)bizFormNumber);
        parameter.setCustomParam("type", (Object)PAGETYPE);
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "exportsourcecallback");
        parameter.setCloseCallBack(callBack);
        this.getView().showForm(parameter);
        MultiLangEnumBridge opName = new MultiLangEnumBridge("\u5bfc\u51fa", "CardListManagerPlugin_5", "bos-devportal-new-plugin");
        MultiLangEnumBridge opDescription = new MultiLangEnumBridge("\u5bfc\u51fa\u8868\u5355", "CardListManagerPlugin_6", "bos-devportal-new-plugin");
        AppUtils.addOpLog((String)EntityId_Form, (String)"export", (String)EntityId_Form, (String)"1", (MultiLangEnumBridge)opName, (MultiLangEnumBridge)opDescription, (String[])new String[0]);
    }

    protected void inherit(DynamicFormInfo info) {
        String bizAppId = info.getBizApp();
        String bizUnitId = info.getBizUnitId();
        String modeltype = info.getModelType();
        if ("PCLayout".equals(modeltype)) {
            String formId = info.getFormId();
            modeltype = BusinessDataServiceHelper.loadSingleFromCache((Object)formId, (String)EntityId_Form, (String)"modeltype").getString("modeltype");
        }
        String parentId = info.getFormId();
        String parentName = info.getName();
        String parentNumber = info.getNumber();
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("bos_devp_pageinherit");
        parameter.setCustomParam("bizAppId", (Object)bizAppId);
        parameter.setCustomParam(Key_BizUnitId, (Object)bizUnitId);
        parameter.setCustomParam("modeltype", (Object)modeltype);
        parameter.setCustomParam("parentId", (Object)parentId);
        parameter.setCustomParam("parentName", (Object)parentName);
        parameter.setCustomParam("parentNumber", (Object)parentNumber);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCaption(ResManager.loadKDString((String)"\u7ee7\u627f\u9875\u9762", (String)"CardListManagerPlugin_7", (String)"bos-devportal-new-plugin", (Object[])new Object[0]));
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "inheritPageWindowClose");
        parameter.setCloseCallBack(callBack);
        this.getView().showForm(parameter);
    }

    private void extendParam(DynamicFormInfo info) {
        String extbizAppId;
        String count;
        String bizAppId = info.getBizApp();
        String bizUnitId = info.getBizUnitId();
        String bizformId = info.getFormId();
        String bizPageName = info.getName();
        String bizPageNumber = info.getNumber();
        String modelType = info.getModelType();
        String entityId = "";
        if (info instanceof EntityFormInfo) {
            entityId = ((EntityFormInfo)info).getEntityId();
        }
        if ("0".equals(count = DevportalUtil.getParallelExtCountByIsv((String)bizformId, (String)EntityId_Form, (String)"parentid"))) {
            extbizAppId = this.getExtAppByAppId(bizAppId);
            if (StringUtils.isBlank((CharSequence)extbizAppId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u6269\u5c55\u5e94\u7528", (String)"CardListManagerPlugin_8", (String)"bos-devportal-new-plugin", (Object[])new Object[0]));
                return;
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u9875\u9762\u4ec5\u53ef\u6269\u5c551\u6b21\u3002", (String)"CardListManagerPlugin_10", (String)"bos-devportal-new-plugin", (Object[])new Object[0]));
            return;
        }
        this.getPageCache().put(Key_BizUnitId, bizUnitId);
        this.getPageCache().put("extbizAppId", extbizAppId);
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("bos_devp_extappextpage");
        parameter.setCustomParam("extBizAppId", (Object)extbizAppId);
        parameter.setCustomParam("oriBizunitId", (Object)bizUnitId);
        parameter.setCustomParam("oriFormId", (Object)bizformId);
        parameter.setCustomParam("oriBizPageName", (Object)bizPageName);
        parameter.setCustomParam("oriBizPageNumber", (Object)bizPageNumber);
        parameter.setCustomParam("modelType", (Object)modelType);
        parameter.setCustomParam("entityid", (Object)entityId);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCaption(ResManager.loadKDString((String)"\u6269\u5c55\u9875\u9762", (String)"CardListManagerPlugin_9", (String)"bos-devportal-new-plugin", (Object[])new Object[0]));
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "extendPageWindowClose");
        parameter.setCloseCallBack(callBack);
        this.getView().showForm(parameter);
    }

    private String getExtAppByAppId(String bizAppId) {
        QFilter q = new QFilter("masterid", "=", (Object)bizAppId);
        String currentIsv = ISVService.getISVInfo().getId();
        QFilter qIsv = new QFilter("isv", "=", (Object)currentIsv);
        if ("kingdee".equalsIgnoreCase(currentIsv)) {
            QFilter qIsvNull = new QFilter("isv", "is null", (Object)Boolean.TRUE);
            qIsvNull = qIsvNull.or(new QFilter("isv", "=", (Object)" "));
            qIsv = qIsv.or(qIsvNull);
        }
        String extAppId = "";
        QFilter[] filters = new QFilter[]{q, qIsv};
        DynamicObjectCollection apps = QueryServiceHelper.query((String)EntityId_App, (String)"id,number", (QFilter[])filters);
        if (apps != null && !apps.isEmpty()) {
            extAppId = ((DynamicObject)apps.get(0)).getString("id");
        }
        return extAppId;
    }

    protected void deleteParam(DynamicFormInfo info) {
        String bizAppId = info.getBizApp();
        if (!AppUtils.checkResourceBelongsToCurDeveloper((String)bizAppId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5f00\u53d1\u5546\u6ca1\u6709\u8be5\u8d44\u6e90\u6743\u9650\u3002", (String)"CardListManagerPlugin_11", (String)"bos-devportal-new-plugin", (Object[])new Object[0]));
            return;
        }
        boolean isHasPermisson = DevpPermissionUtils.hasBizPageViewPermission(this.getView().getFormShowParameter().getAppId(), "4715e1f1000000ac");
        if (!isHasPermisson) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u6743\u9650\uff0c\u8bf7\u6dfb\u52a0\u6743\u9650\u540e\u518d\u8bd5\u3002", (String)"CardListManagerPlugin_12", (String)"bos-devportal-new-plugin", (Object[])new Object[0]));
            return;
        }
        String formId = info.getFormId();
        boolean checkDeleteResource = AppUtils.checkDeleteResource((String)formId, (String)bizAppId, (IFormView)this.getView(), (String)"page", (String)"devportal");
        if (!checkDeleteResource) {
            return;
        }
        String formName = info.getName();
        String bizUnitId = info.getBizUnitId();
        String isCollection = "";
        String jSessionId = "";
        String source = formId + "-" + isCollection;
        JSONArray pageArray = new JSONArray();
        pageArray.add((Object)source);
        this.getPageCache().put("bizAppId", bizAppId);
        this.getPageCache().put("formid", formId);
        this.getPageCache().put(Key_BizUnitId, bizUnitId);
        this.getPageCache().put("iscollection", isCollection);
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("bos_devportal_confirmdel");
        parameter.setCustomParam("message", (Object)String.format(ResManager.loadKDString((String)"\u786e\u5b9a\u5220\u9664\u9875\u9762%s\u5417\uff1f", (String)"CardListManagerPlugin_13", (String)"bos-devportal-new-plugin", (Object[])new Object[0]), formName));
        parameter.setCustomParam("source", (Object)pageArray.toJSONString());
        parameter.setCustomParam("type", (Object)"page");
        parameter.setCustomParam("bizappid", (Object)bizAppId);
        parameter.setCustomParam("jsessionid", (Object)jSessionId);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "pageDeleteCallBack"));
        this.getView().showForm(parameter);
    }

    private void putDynamicFormCache(List<DynamicFormInfo> lists) {
        String listsJsonString = SerializationUtils.toJsonString(lists);
        this.getPageCache().put(this.getFormListCacheId(), listsJsonString);
        this.dynamicFormListInfos = lists;
    }

    protected void refreshEntryGrid(List<DynamicFormInfo> formLists) {
        if (formLists == null) {
            return;
        }
        HashSet<String> appIds = new HashSet<String>(16);
        HashSet<String> cloudIds = new HashSet<String>(16);
        HashSet<Long> userIds = new HashSet<Long>(16);
        for (DynamicFormInfo info : formLists) {
            if (StringUtils.isNotBlank((CharSequence)info.getBizApp())) {
                appIds.add(info.getBizApp());
            }
            if (StringUtils.isNotBlank((CharSequence)info.getBizCloud())) {
                cloudIds.add(info.getBizCloud());
            }
            if (!StringUtils.isNotBlank((CharSequence)info.getModifier())) continue;
            userIds.add(Long.parseLong(info.getModifier()));
        }
        MainEntityType appDt = EntityMetadataCache.getDataEntityType((String)EntityId_App);
        MainEntityType cloudDt = EntityMetadataCache.getDataEntityType((String)EntityId_Cloud);
        MainEntityType userDt = EntityMetadataCache.getDataEntityType((String)EntityId_User);
        Map apps = BusinessDataReader.loadFromCache((Object[])appIds.toArray(), (DynamicObjectType)appDt);
        Map clouds = BusinessDataReader.loadFromCache((Object[])cloudIds.toArray(), (DynamicObjectType)cloudDt);
        Map users = BusinessDataReader.loadFromCache((Object[])userIds.toArray(), (DynamicObjectType)userDt);
        this.getModel().getDataEntity(true);
        DynamicObjectCollection rows = this.getModel().getEntryEntity(Key_EntryEntity);
        rows.clear();
        EntryType entryType = (EntryType)this.getModel().getDataEntityType().getAllEntities().get(Key_EntryEntity);
        int seq = 1;
        for (DynamicFormInfo info : formLists) {
            DynamicObject row = new DynamicObject((DynamicObjectType)entryType);
            row.set("seq", (Object)seq);
            row.set(Key_Number, (Object)info.getNumber());
            row.set(Key_Name, (Object)info.getName());
            row.set(Key_SourcePage, (Object)info.getSourcePage());
            row.set(Key_BizApp, apps.get(info.getBizApp()));
            row.set(Key_Function, (Object)info.getFunction());
            row.set(Key_BizCloud, clouds.get(info.getBizCloud()));
            if (StringUtils.isNotBlank((CharSequence)info.getModifier())) {
                row.set(Key_Modifier, users.get(Long.parseLong(info.getModifier())));
            }
            row.set(Key_ModifyDate, (Object)info.getModifyDate());
            row.set(Key_Collect, (Object)info.getCollect());
            rows.add((Object)row);
            ++seq;
        }
        this.getView().updateView(Key_EntryEntity);
    }

    protected List<DynamicFormInfo> loadAllDynamicFormList() {
        Map<String, DynamicFormInfo> metas = CardListManagerPlugin.queryFormDesignMeta();
        if (metas == null || metas.isEmpty()) {
            return new ArrayList<DynamicFormInfo>(1);
        }
        ArrayList<DynamicFormInfo> allForms = new ArrayList<DynamicFormInfo>(metas.size());
        HashSet<String> appIds = new HashSet<String>(16);
        HashMap appFunctions = new HashMap();
        for (Map.Entry<String, DynamicFormInfo> entry : metas.entrySet()) {
            DynamicFormInfo info = entry.getValue();
            String modelType = info.getModelType();
            if (!this.enableModelTypes.contains(modelType)) continue;
            allForms.add(info);
            String bizAppId = info.getBizApp();
            if (StringUtils.isBlank((CharSequence)bizAppId) || appIds.contains(bizAppId)) continue;
            appIds.add(info.getBizApp());
            AppMetadata appMeta = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)bizAppId, (boolean)true);
            appFunctions.putAll(appMeta.getMapFuncs());
        }
        for (DynamicFormInfo meta : allForms) {
            String modelType = meta.getModelType();
            if (!this.enableModelTypes.contains(modelType)) continue;
            String client = "0";
            if (modelType.startsWith("Mobile")) {
                client = "1";
            }
            meta.setClient(client);
            String sourcePageId = meta.getSourcePage();
            DynamicFormInfo source = metas.get(sourcePageId);
            meta.setSourcePage(source == null ? "" : source.getNumber());
            String bizUnitId = meta.getBizUnitId();
            AppFunctionPacketElement function = (AppFunctionPacketElement)appFunctions.get(bizUnitId);
            meta.setFunction(function == null ? "" : function.getName().getLocaleValue());
        }
        return allForms;
    }

    private static Map<String, DynamicFormInfo> queryFormDesignMeta() {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append(String.format(" SELECT a.FID,a.FNUMBER,a.FMODELTYPE,a.FPARENTID,a.FMASTERID,a.FBIZAPPID,a.FMODIFIERID,a.FMODIFYDATE,b.FNAME,c.FBIZCLOUDID,d.FBIZUNITID FROM T_META_FORMDESIGN a INNER JOIN T_META_FORMDESIGN_L b on a.FID = b.FID INNER JOIN T_META_BIZAPP c ON a.FBIZAPPID = c.FID  INNER JOIN T_Meta_BizUnitRelForm d ON a.FID = d.FFORMID  WHERE b.FLOCALEID = '%s' ORDER BY a.FNUMBER ASC", Lang.get().getLocale()), new Object[0]);
        ResultSetHandler<Map<String, DynamicFormInfo>> action = new ResultSetHandler<Map<String, DynamicFormInfo>>(){

            public Map<String, DynamicFormInfo> handle(ResultSet rs) throws Exception {
                LinkedHashMap<String, DynamicFormInfo> map = new LinkedHashMap<String, DynamicFormInfo>(10);
                while (rs.next()) {
                    String id = rs.getString(1);
                    String number = rs.getString(2);
                    String modelType = rs.getString(3);
                    String parentId = rs.getString(4);
                    String masterId = rs.getString(5);
                    String bizappId = rs.getString(6);
                    String modifierId = rs.getString(7);
                    Date modifyDate = rs.getDate(8);
                    String name = rs.getString(9);
                    String bizCloudId = rs.getString(10);
                    String bizUnitId = rs.getString(11);
                    DynamicFormInfo info = new DynamicFormInfo(number, name, modelType, bizappId, modifierId, modifyDate);
                    info.setFormId(id);
                    info.setBizCloud(bizCloudId);
                    info.setSourcePage(StringUtils.isBlank((CharSequence)masterId) ? parentId : masterId);
                    info.setBizUnitId(bizUnitId);
                    info.setCollect("0");
                    map.put(id, info);
                }
                return map;
            }
        };
        Map map = (Map)DB.query((DBRoute)DBRoute.meta, (SqlBuilder)sqlBuilder, (ResultSetHandler)action);
        return map;
    }

    protected void loadEnableModelType() {
        this.enableModelTypes.add("WidgetFormModel");
        this.enableModelTypes.add("CardModel");
    }

    protected String getFormListCacheId() {
        return "CardFormList";
    }

    protected String getPageType() {
        return String.valueOf(PageType.Report.getValue());
    }

    public void search(SearchEnterEvent e) {
        Search search = (Search)e.getSource();
        if (StringUtils.equals((CharSequence)Key_Search, (CharSequence)search.getKey())) {
            String searchText = e.getText();
            this.doSearch(searchText);
        }
    }
}

