/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.newdevportal.cloud;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.devportal.business.git.GitContext;
import kd.bos.devportal.business.git.GitOperationUtils;
import kd.bos.devportal.business.git.GitSaveFileHandler;
import kd.bos.devportal.business.hosting.GitOperationUtil;
import kd.bos.devportal.common.util.AppUtils;
import kd.bos.devportal.git.proxy.GitAppPluginProxy;
import kd.bos.devportal.util.DevportalUtil;
import kd.bos.devportal.util.SVNManageUtil;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.Donothing;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.OperationColumn;
import kd.bos.form.control.Search;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operatecol.OperationColItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.isv.ISVService;
import kd.bos.metadata.devportal.EnvTypeHelper;
import kd.bos.newdevportal.app.my.DevpPermissionUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.BizCloudServiceHelp;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.runmode.RunModeServiceHelper;
import kd.bos.servicehelper.util.DevportalCommonUtil;
import kd.bos.session.SessionDAO;
import kd.bos.session.SessionDAOFactory;
import kd.bos.url.UrlService;

public class CloudListPlugin
extends AbstractFormPlugin
implements SearchEnterListener,
CellClickListener {
    private static final String BOS_DEVPORTAL_BIZCLOUD = "bos_devportal_bizcloud";
    private static final String BOS_DEVPORTAL_BIZAPP = "bos_devportal_bizapp";
    private static final String BOS_DEVPORTAL_NEW_PLUGIN = "bos-devportal-new-plugin";
    private static final String LISTVIEW = "listview";
    private static final String CARDVIEW = "cardview";
    private static final String REFRESH = "refresh";
    private static final String ADD = "add";
    private static final String MODIFY = "modify";
    private static final String DELETE = "delete";
    private static final String SVNCOMMIT = "svncommit";
    private static final String GITCOMMIT = "gitcommit";
    private static final String GITPUSH = "gitpush";
    private static final String ENTRYENTITY = "entryentity";
    private static final String CARD_ENTRYENTITY = "cardentryentity";
    private static final String SEARCHAP = "searchap";
    private static final String BIZCLOUDNUMBER = "bizcloudnumber";
    private static final String SVNSESSIONID = "svnsessionid";
    private static final String KEY_BIZCLOUDID = "bizcloudid";
    private static final String BIZCLOUDNAME = "bizcloudname";
    private static final String ISV = "isv";
    private static final String VERSION = "version";
    private static final String CLOUDID = "cloudid";
    private static final String CLOUD = "cloud";
    private static final String GITOPERATEID = "gitoperateid";
    private static final String GITOPERATETYPE = "gitoperatetype";
    private static final String GITOPERATEKEY = "gitoperatekey";
    private static final String SUCCESS = "success";
    private static final String GITURL = "giturl";
    private static final String PERSONALGITREPOSITORY = "personalgitrepository";
    private static final String NUMBER = "number";
    private static final String ID = "id";
    private static final String NAME = "name";
    private static final String IMAGE = "image";
    private static final String DESCRIPTION = "description";
    private static final String IMAGELABEL = "imagelabel";
    private static final String CARDNAME = "cardname";
    private static final String CARDNUMBER = "cardnumber";
    private static final String CARDISV = "cardisv";
    private static final String CARDID = "cardid";
    private static final String UPDATEICON = "updateicon";
    private static final String CARDMODIFY = "cardmodify";
    private static final String DELETEICON = "deleteicon";
    private static final String CARDDELETE = "carddelete";
    private static final String SVNICON = "iconsvncommit";
    private static final String GITICON = "icongitcommit";
    private static final String GITPUSHICON = "icongitpush";
    private static final String CURRENT_VIEW = "current_view";
    private static final String LIST = "0";
    private static final String CARD = "1";
    private static final String USERNAME = "username";
    private static final String P = "password";
    private static final String GITREPOSITORY = "gitrepository";
    private static final String GITMSG = "gitmsg";
    private static final String ISCHECKED = "ischecked";
    private static final String BIZAPPID = "bizappid";
    private static final String SVNPATH = "svnpath";
    private static final String SVNMSG = "svnmsg";
    private static final String SAVE_JSESSION_ID = "SAVE_JSESSION_ID";
    private static final String GIT_COMMIT_NEW_CALLBACK = "gitCommitNewCallBack";
    private static final String GIT_COMMIT_PUSH_CONFIRM_BACK = "gitCommitAndPushConfirmBack";
    private static final String GIT_PUSH_NEW_CALLBACK = "gitPushNewCallBack";
    private static final String GIT_PULL_CONFLICT_CALLBACK = "gitPullConflictCallBack";
    private static final String GIT_RESTORE_CALL_BACK = "gitRestoreCallBack";
    private static final String SVN_SESSIONID = "svnSessionId";
    private static final String GIT_SESSIONID = "gitSessionId";
    private static List<String> editOp = new ArrayList<String>(10);

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{LISTVIEW, CARDVIEW, REFRESH, ADD, UPDATEICON, CARDMODIFY, DELETEICON, CARDDELETE, SVNICON, SVNCOMMIT, GITICON, GITCOMMIT, GITPUSHICON, GITPUSH});
        Search search = (Search)this.getView().getControl(SEARCHAP);
        search.addEnterListener((SearchEnterListener)this);
        boolean type = DevportalCommonUtil.isGitManageType();
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRYENTITY);
        entryGrid.addPackageDataListener(pkEvent -> {
            if (pkEvent.getSource() instanceof OperationColumn && "operationcolumnap".equals(((OperationColumn)pkEvent.getSource()).getKey())) {
                List opItems = (List)pkEvent.getFormatValue();
                for (OperationColItem item : opItems) {
                    if (type && SVNCOMMIT.equals(item.getOperationKey())) {
                        item.setVisible(false);
                    }
                    if (!type && (GITCOMMIT.equals(item.getOperationKey()) || GITPUSH.equals(item.getOperationKey()))) {
                        item.setVisible(false);
                    }
                    if (!SVNCOMMIT.equals(item.getOperationKey()) && !GITCOMMIT.equals(item.getOperationKey()) && !GITPUSH.equals(item.getOperationKey())) continue;
                    String isv = (String)pkEvent.getRowData().get(ISV);
                    String currentIsv = ISVService.getISVInfo().getId();
                    if (StringUtils.equals((CharSequence)currentIsv, (CharSequence)isv)) continue;
                    item.setLocked(true);
                }
            }
        });
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRYENTITY);
        entryGrid.addCellClickListener((CellClickListener)this);
        CardEntry cardGrid = (CardEntry)this.getView().getControl(CARD_ENTRYENTITY);
        cardGrid.addCellClickListener((CellClickListener)this);
    }

    private String getTitle() {
        if (this.isModel()) {
            return ResManager.loadKDString((String)"\u6a21\u677f\u5e93", (String)"CloudListPlugin_2", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]);
        }
        return ResManager.loadKDString((String)"\u4e1a\u52a1\u4e91", (String)"CloudListPlugin_3", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]);
    }

    private boolean isModel() {
        return "bos_devpn_model".equals(this.getView().getFormShowParameter().getFormId());
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setVisible(Boolean.valueOf(true), new String[]{ENTRYENTITY});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{CARD_ENTRYENTITY});
        this.getPageCache().put(CURRENT_VIEW, LIST);
        this.currentViewStyle(LISTVIEW);
        this.renderEntity("");
        boolean type = DevportalCommonUtil.isGitManageType();
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        if (type) {
            clientViewProxy.getClientLocalStorage(GITMSG);
        } else {
            clientViewProxy.getClientLocalStorage(SVNMSG);
        }
    }

    public void clientCallBack(ClientCallBackEvent e) {
        Map param = e.getParam();
        if (SVNMSG.equals(e.getName())) {
            if (StringUtils.isNotBlank((Object)param)) {
                String svnSessionId = (String)param.get("actonResult");
                this.getPageCache().put(SVN_SESSIONID, svnSessionId);
            } else {
                this.getPageCache().put(SVNSESSIONID, "");
            }
        } else if (GITMSG.equals(e.getName())) {
            if (StringUtils.isNotBlank((Object)param)) {
                String gitSessionId = (String)param.get("actonResult");
                this.getPageCache().put(GIT_SESSIONID, gitSessionId);
            } else {
                this.getPageCache().put(GIT_SESSIONID, "");
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if (editOp.contains(key) && EnvTypeHelper.isProductEnv()) {
            String errorMsg = ResManager.loadKDString((String)"\u4e3a\u4fdd\u8bc1\u73af\u5883\u7a33\u5b9a\uff0c\u751f\u4ea7\u73af\u5883\u6682\u4e0d\u5141\u8bb8\u7f16\u8f91\u5143\u6570\u636e\u3002", (String)"CloudListPlugin_4", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]);
            this.getView().showErrorNotification(errorMsg);
            return;
        }
        switch (key) {
            case "listview": {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{ENTRYENTITY});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{CARD_ENTRYENTITY});
                this.getPageCache().put(CURRENT_VIEW, LIST);
                this.currentViewStyle(LISTVIEW);
                this.renderEntity("");
                break;
            }
            case "cardview": {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{ENTRYENTITY});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{CARD_ENTRYENTITY});
                this.getPageCache().put(CURRENT_VIEW, CARD);
                this.cardView();
                this.currentViewStyle(CARDVIEW);
                this.renderCardEntry("");
                break;
            }
            case "refresh": {
                this.refresh();
                break;
            }
            case "add": {
                this.addCloud();
                break;
            }
            case "updateicon": 
            case "cardmodify": {
                String cloudId = this.getSelectCloudId();
                this.editCloud(cloudId);
                break;
            }
            case "deleteicon": 
            case "carddelete": {
                this.deleteCloudConfirm();
                break;
            }
            case "iconsvncommit": 
            case "svncommit": 
            case "icongitcommit": 
            case "gitcommit": 
            case "icongitpush": 
            case "gitpush": {
                this.checkinCloud(key);
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof Donothing) {
            Donothing operate = (Donothing)args.getSource();
            String key = operate.getOperateKey();
            if (editOp.contains(key) && EnvTypeHelper.isProductEnv()) {
                String errorMsg = ResManager.loadKDString((String)"\u4e3a\u4fdd\u8bc1\u73af\u5883\u7a33\u5b9a\uff0c\u751f\u4ea7\u73af\u5883\u6682\u4e0d\u5141\u8bb8\u7f16\u8f91\u5143\u6570\u636e\u3002", (String)"CloudListPlugin_4", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]);
                this.getView().showErrorNotification(errorMsg);
                args.setCancel(true);
                return;
            }
            switch (key) {
                case "modify": {
                    String id = this.getSelectCloudId();
                    this.editCloud(id);
                    break;
                }
                case "delete": {
                    this.deleteCloudConfirm();
                    break;
                }
                case "svncommit": 
                case "gitcommit": 
                case "gitpush": {
                    this.checkinCloud(key);
                    break;
                }
            }
        }
    }

    public void search(SearchEnterEvent searchEnterEvent) {
        String searchText = searchEnterEvent.getText();
        String view = this.getPageCache().get(CURRENT_VIEW);
        if (StringUtils.equals((CharSequence)LIST, (CharSequence)view)) {
            this.renderEntity(searchText);
        } else {
            this.renderCardEntry(searchText);
        }
    }

    private void cardView() {
        boolean type = DevportalCommonUtil.isGitManageType();
        if (type) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{SVNICON});
            Label label = (Label)this.getView().getControl(SVNCOMMIT);
            label.setText("");
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{GITICON});
            Label label = (Label)this.getView().getControl(GITCOMMIT);
            label.setText("");
            Label label2 = (Label)this.getView().getControl(GITPUSH);
            label2.setText("");
            this.getView().setVisible(Boolean.valueOf(false), new String[]{GITPUSHICON});
        }
    }

    private void refresh() {
        String view = this.getPageCache().get(CURRENT_VIEW);
        if (StringUtils.equals((CharSequence)LIST, (CharSequence)view)) {
            this.renderEntity("");
        } else {
            this.renderCardEntry("");
        }
    }

    private String getSelectCloudId() {
        String cloudId;
        if (LIST.equals(this.getPageCache().get(CURRENT_VIEW))) {
            int rowIndex = this.getModel().getEntryCurrentRowIndex(ENTRYENTITY);
            cloudId = (String)this.getModel().getValue(CLOUDID, rowIndex);
        } else {
            int rowIndex = this.getModel().getEntryCurrentRowIndex(CARD_ENTRYENTITY);
            cloudId = (String)this.getModel().getValue(CARDID, rowIndex);
        }
        return cloudId;
    }

    private void editCloud(String cloudId) {
        Boolean isHasPermisson = DevpPermissionUtils.hasBizCloudPermission(this.getView().getFormShowParameter().getAppId(), "4715a0df000000ac");
        if (!isHasPermisson.booleanValue()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u4e1a\u52a1\u4e91\u7684\u4fee\u6539\u6743\u9650\uff0c\u8bf7\u6dfb\u52a0\u6743\u9650\u540e\u64cd\u4f5c\u3002", (String)"CloudListPlugin_5", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
            return;
        }
        if (!this.isExist()) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u5f53\u524d%s\u53ef\u80fd\u5df2\u88ab\u5176\u4ed6\u7528\u6237\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u5217\u8868\u540e\u91cd\u8bd5\u3002", (String)"CloudListPlugin_6", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[]{this.getTitle()}));
            return;
        }
        DynamicObject cloud = BizCloudServiceHelp.getBizCloudByID((String)cloudId);
        String isv = cloud.getString(ISV);
        String currentIsv = ISVService.getISVInfo().getId();
        if (currentIsv != null && !currentIsv.equals(isv)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u975e\u5f53\u524d\u5f00\u53d1\u5546\u53ea\u80fd\u67e5\u770b\uff0c\u65e0\u6cd5\u4fee\u6539\u3002", (String)"CloudListPlugin_1", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
        }
        BaseShowParameter showParameter = new BaseShowParameter();
        showParameter.setFormId(this.isModel() ? "bos_devpn_modelcloud" : "bos_devp_bizcloud_layout");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCaption(String.format(ResManager.loadKDString((String)"\u4fee\u6539%s", (String)"CloudListPlugin_7", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]), this.getTitle()));
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "refreshCloud"));
        showParameter.setStatus(OperationStatus.EDIT);
        showParameter.setPkId((Object)cloudId);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void addCloud() {
        Boolean isHasPermisson = DevpPermissionUtils.hasBizCloudPermission(this.getView().getFormShowParameter().getAppId(), "47156aff000000ac");
        if (!isHasPermisson.booleanValue()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u4e1a\u52a1\u4e91\u7684\u65b0\u589e\u6743\u9650\uff0c\u8bf7\u6dfb\u52a0\u6743\u9650\u540e\u64cd\u4f5c\u3002", (String)"CloudListPlugin_8", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
            return;
        }
        BaseShowParameter showParameter = new BaseShowParameter();
        showParameter.setFormId(this.isModel() ? "bos_devpn_modelcloud" : "bos_devp_bizcloud_layout");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCaption(String.format(ResManager.loadKDString((String)"\u65b0\u5efa%s", (String)"CloudListPlugin_9", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]), this.getTitle()));
        showParameter.setCustomParam("ismodel", (Object)this.isModel());
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "refreshCloud"));
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void deleteCloudConfirm() {
        Boolean isHasPermisson = DevpPermissionUtils.hasBizCloudPermission(this.getView().getFormShowParameter().getAppId(), "4715e1f1000000ac");
        if (!isHasPermisson.booleanValue()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u4e1a\u52a1\u4e91\u7684\u5220\u9664\u6743\u9650\uff0c\u8bf7\u6dfb\u52a0\u6743\u9650\u540e\u64cd\u4f5c\u3002", (String)"CloudListPlugin_10", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
            return;
        }
        if (!this.isExist()) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u5f53\u524d%s\u53ef\u80fd\u5df2\u88ab\u5176\u4ed6\u7528\u6237\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u5217\u8868\u540e\u91cd\u8bd5\u3002", (String)"CloudListPlugin_6", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[]{this.getTitle()}));
            return;
        }
        String bizCloudId = this.getSelectCloudId();
        DynamicObject cloud = BusinessDataServiceHelper.loadSingleFromCache((Object)bizCloudId, (String)BOS_DEVPORTAL_BIZCLOUD, (String)"isv,name");
        if (!DevportalUtil.acctIsvIsKingdee() && "kingdee".equals(cloud.getString(ISV))) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u91d1\u8776%s\u4e0d\u53ef\u5220\u9664\u3002", (String)"CloudListPlugin_11", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[]{this.getTitle()}));
            return;
        }
        if (this.isHaveApp(bizCloudId)) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u5f53\u524d%s\u4e0b\u5b58\u5728\u5e94\u7528\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"CloudListPlugin_12", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[]{this.getTitle()}));
            return;
        }
        String cloudName = cloud.getString(NAME);
        this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u786e\u5b9a\u5220\u9664%s\u5417\uff1f", (String)"CloudListPlugin_13", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]), cloudName), MessageBoxOptions.YesNo, new ConfirmCallBackListener("cloudDeleteCallBack"));
    }

    private boolean isHaveApp(String bizCloudId) {
        QFilter q = new QFilter("bizcloud", "=", (Object)bizCloudId);
        QFilter[] filters = new QFilter[]{q};
        return QueryServiceHelper.exists((String)BOS_DEVPORTAL_BIZAPP, (QFilter[])filters);
    }

    private boolean isExist() {
        String cloudId = this.getSelectCloudId();
        QFilter qFilter = new QFilter(ID, "=", (Object)cloudId);
        QFilter[] qFilters = new QFilter[]{qFilter};
        return QueryServiceHelper.exists((String)BOS_DEVPORTAL_BIZCLOUD, (QFilter[])qFilters);
    }

    private void checkinCloud(String key) {
        if (!this.isExist()) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u5f53\u524d\u4e91\u5df2\u88ab\u5176\u4ed6\u7528\u6237\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u5217\u8868\u540e\u91cd\u8bd5\u3002", (String)"CloudListPlugin_0", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
            return;
        }
        boolean isGit = DevportalUtil.isGitManageType();
        String type = "svn";
        if (isGit) {
            type = "git";
        }
        String bizCloudId = this.getSelectCloudId();
        DynamicObject cloud = BusinessDataServiceHelper.loadSingleFromCache((Object)bizCloudId, (String)BOS_DEVPORTAL_BIZCLOUD, (String)"isv,name,number");
        String operateKey = key.substring(3);
        String bizCloudNumber = cloud.getString(NUMBER);
        String sessionId = "";
        JSONObject arg = new JSONObject();
        arg.put(KEY_BIZCLOUDID, (Object)bizCloudId);
        arg.put(BIZCLOUDNUMBER, (Object)bizCloudNumber);
        arg.put("operatekey", (Object)operateKey);
        if (!AppUtils.checkCloudResourceBelongsToCurDeveloper((String)bizCloudId)) {
            this.getView().showTipNotification(DevportalUtil.getNoPermissionTip());
            return;
        }
        String hint = String.format(ResManager.loadKDString((String)"%1$s\u4f1a\u7b7e\u5165\u5230\u5f53\u524d\u4e91\u7684\u57fa\u7840\u5e94\u7528%2$s\u8def\u5f84\u4e0b\uff0c\u8bf7\u5148\u5728%3$s\u4e2d\u7ed1\u5b9a\u57fa\u7840\u5e94\u7528\u3002", (String)"CloudListPlugin_14", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]), this.getTitle(), type, this.getTitle());
        DynamicObject cloudObject = BusinessDataServiceHelper.loadSingle((Object)bizCloudId, (String)BOS_DEVPORTAL_BIZCLOUD, (String)"baseapp");
        String bizAppId = cloudObject.getString("baseapp_id");
        if (StringUtils.isBlank((CharSequence)bizAppId)) {
            this.getView().showTipNotification(hint);
            return;
        }
        boolean appExist = QueryServiceHelper.exists((String)BOS_DEVPORTAL_BIZAPP, (Object)bizAppId);
        if (!appExist) {
            this.getView().showTipNotification(hint);
            return;
        }
        if (isGit) {
            sessionId = this.getPageCache().get(GIT_SESSIONID);
            GitOperationUtil.gitConfirmOperate((String)bizCloudId, (String)CLOUD, (String)operateKey, (String)sessionId, (AbstractFormPlugin)this);
        } else {
            sessionId = this.getPageCache().get(SVN_SESSIONID);
            arg.put(SVNSESSIONID, (Object)sessionId);
            SVNManageUtil.checkinCloud((JSONObject)arg, (AbstractFormPlugin)this, (String)bizAppId);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        if ("cloudDeleteCallBack".equals(e.getCallBackId()) && MessageBoxResult.Yes.equals((Object)e.getResult())) {
            String bizCloudId = this.getSelectCloudId();
            this.deleteCloud(bizCloudId);
        } else if ("gitOperateCallBack".equals(e.getCallBackId()) && MessageBoxResult.Yes.equals((Object)e.getResult())) {
            this.handleGitOperateConfirmCallBack();
        } else if (GIT_COMMIT_PUSH_CONFIRM_BACK.equals(e.getCallBackId()) && MessageBoxResult.Yes.equals((Object)e.getResult())) {
            this.handleGitCommitAndPushConfirmBack();
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        if ("gitcommitcallback".equals(e.getActionId()) && e.getReturnData() != null) {
            this.handleGitCommitCallback(e);
        } else if ("gitlogincallback".equals(e.getActionId()) && e.getReturnData() != null) {
            this.handleGitLoginCallback(e);
        } else if ("svnlogincloudcallback".equals(e.getActionId())) {
            this.handleSvnLoginCloudCallback(e);
        } else if ("refreshCloud".equals(e.getActionId()) && e.getReturnData() != null) {
            this.refresh();
        } else if (GIT_COMMIT_NEW_CALLBACK.equals(e.getActionId()) && e.getReturnData() != null) {
            this.handleGitCommitNewCallBack(e);
        } else if (GIT_PUSH_NEW_CALLBACK.equals(e.getActionId()) && e.getReturnData() != null) {
            GitAppPluginProxy.getProxy((AbstractFormPlugin)this).invoke(GIT_PUSH_NEW_CALLBACK, new Object[]{e});
        } else if (GIT_PULL_CONFLICT_CALLBACK.equals(e.getActionId()) && e.getReturnData() != null) {
            this.handleGitPullConflictCallBack(e);
        } else if (GIT_RESTORE_CALL_BACK.equals(e.getActionId()) && e.getReturnData() != null) {
            this.handleGitRestoreCallBack(e);
        } else if ("gitPullUpdateMetaCallBack".equals(e.getActionId()) && e.getReturnData() != null) {
            this.handleGitPullUpdateMetaCallBack(e);
        }
    }

    private void handleGitCommitAndPushConfirmBack() {
        GitAppPluginProxy.getProxy((AbstractFormPlugin)this).invoke(GIT_COMMIT_PUSH_CONFIRM_BACK, new Object[]{""});
    }

    private void handleGitPullUpdateMetaCallBack(ClosedCallBackEvent e) {
        String gitContext = (String)e.getReturnData();
        GitContext context = (GitContext)SerializationUtils.fromJsonString((String)gitContext, GitContext.class);
        if (context.getPullUpdate()) {
            GitOperationUtils.updateMetadata((GitContext)context, (AbstractFormPlugin)this);
        }
        if (context.isExportToLocal()) {
            GitSaveFileHandler saveFileHandler = new GitSaveFileHandler();
            saveFileHandler.handler(context, (AbstractFormPlugin)this);
        }
    }

    private void handleGitRestoreCallBack(ClosedCallBackEvent e) {
        GitAppPluginProxy.getProxy((AbstractFormPlugin)this).invoke(GIT_RESTORE_CALL_BACK, new Object[]{e});
    }

    private void handleGitPullConflictCallBack(ClosedCallBackEvent e) {
        GitAppPluginProxy.getProxy((AbstractFormPlugin)this).invoke(GIT_PULL_CONFLICT_CALLBACK, new Object[]{e});
    }

    private void handleGitCommitNewCallBack(ClosedCallBackEvent e) {
        GitAppPluginProxy.getProxy((AbstractFormPlugin)this).invoke(GIT_COMMIT_NEW_CALLBACK, new Object[]{e});
    }

    private void currentViewStyle(String view) {
        String viewStr = CARDVIEW;
        String activeKey = LISTVIEW;
        if (StringUtils.isNotBlank((CharSequence)view) && CARDVIEW.equals(view)) {
            activeKey = CARDVIEW;
            viewStr = LISTVIEW;
        }
        HashMap<String, String> select = new HashMap<String, String>();
        select.put("fc", "#3987ed");
        HashMap<String, String> other = new HashMap<String, String>();
        other.put("fc", "#999999");
        this.getView().updateControlMetadata(activeKey, select);
        this.getView().updateControlMetadata(viewStr, other);
    }

    private void handleGitOperateConfirmCallBack() {
        JSONObject gitInfo = JSONObject.parseObject((String)this.getPageCache().get("gitinfo"));
        String id = gitInfo.getString(GITOPERATEID);
        String type = gitInfo.getString(GITOPERATETYPE);
        String operateKey = gitInfo.getString(GITOPERATEKEY);
        String sessionId = gitInfo.getString("gitoperatesessionid");
        this.getPageCache().remove("gitinfo");
        GitOperationUtil.beforeGitOperate((String)operateKey, (String)id, (String)type, (String)sessionId, (AbstractFormPlugin)this);
    }

    private void handleGitCommitCallback(ClosedCallBackEvent event) {
        JSONObject returnResult = JSONObject.parseObject((String)event.getReturnData().toString());
        String result = returnResult.getString("result");
        if ("nochange".equals(result) || "nochange_commitandpush".equals(result)) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u5185\u5bb9\u6ca1\u6709\u53d8\u5316,\u65e0\u9700\u63d0\u4ea4\u3002", (String)"CloudListPlugin_15", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
        } else if (SUCCESS.equals(result)) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u63d0\u4ea4\u6210\u529f\u3002", (String)"CloudListPlugin_16", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
        } else if ("success_commitandpush".equals(result)) {
            JSONArray fileArray = new JSONArray();
            String gitUrl = returnResult.getString(GITURL);
            String personalGitRepository = returnResult.getString(PERSONALGITREPOSITORY);
            String id = returnResult.getString(ID);
            String type = returnResult.getString("type");
            String userName = returnResult.getString(USERNAME);
            String passWord = returnResult.getString(P);
            String gitBranch = returnResult.getString("gitbranch");
            String gitRootpath = returnResult.getString("gitrootpath");
            String bizAppId = returnResult.getString(BIZAPPID);
            Boolean flag = GitOperationUtil.beforePush((JSONArray)fileArray, (String)gitUrl, (String)personalGitRepository, (String)gitBranch, (String)gitRootpath, (String)id, (String)type, (AbstractFormPlugin)this, (String)userName, (String)passWord);
            if (flag.booleanValue()) {
                String gitRepository = returnResult.getString(GITREPOSITORY);
                String projectURL = returnResult.getString("projecturl");
                GitOperationUtil.push((String)bizAppId, (String)gitUrl, (String)gitRepository, (String)gitBranch, (String)gitRootpath, (String)personalGitRepository, (String)projectURL, (String)userName, (String)passWord, (String)type, (AbstractFormPlugin)this, (JSONArray)fileArray);
            }
        } else {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u63d0\u4ea4\u5931\u8d25\uff1a%s", (String)"CloudListPlugin_17", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]), result));
        }
    }

    private void handleGitLoginCallback(ClosedCallBackEvent event) {
        JSONObject sourceMsg = JSONObject.parseObject((String)((String)event.getReturnData()));
        String userName = sourceMsg.getString(USERNAME);
        String passWord = sourceMsg.getString(P);
        String sessionId = sourceMsg.getString(GITMSG);
        String gitUrl = sourceMsg.getString(GITURL);
        String gitOperateKey = sourceMsg.getString(GITOPERATEKEY);
        String gitOperateId = sourceMsg.getString(GITOPERATEID);
        String gitOperateType = sourceMsg.getString(GITOPERATETYPE);
        String gitRepository = sourceMsg.getString(GITREPOSITORY);
        String gitBranch = sourceMsg.getString("gitbranch");
        String gitRootpath = sourceMsg.getString("gitrootpath");
        String bizAppId = sourceMsg.getString(BIZAPPID);
        String personalGitRepository = sourceMsg.getString(PERSONALGITREPOSITORY);
        GitOperationUtil.gitOperate((String)bizAppId, (String)gitUrl, (String)gitRepository, (String)gitBranch, (String)gitRootpath, (String)personalGitRepository, (String)userName, (String)passWord, (String)gitOperateKey, (String)gitOperateId, (String)gitOperateType, (AbstractFormPlugin)this);
        Boolean ischecked = sourceMsg.getBoolean(ISCHECKED);
        if (ischecked.booleanValue()) {
            IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            clientViewProxy.setClientLocalStorage(GITMSG, sessionId);
            this.getPageCache().put(GIT_SESSIONID, sessionId);
        }
    }

    private void handleSvnLoginCloudCallback(ClosedCallBackEvent e) {
        JSONObject sourceMsg = JSONObject.parseObject((String)((String)e.getReturnData()));
        if (sourceMsg != null) {
            String bizAppId = this.getPageCache().get(BIZAPPID);
            String userName = sourceMsg.getString(USERNAME);
            String passWord = sourceMsg.getString(P);
            String svnPath = sourceMsg.getString(SVNPATH);
            String sessionId = this.getPageCache().get(SVNSESSIONID);
            Boolean ischecked = sourceMsg.getBoolean(ISCHECKED);
            this.getPageCache().put(USERNAME, userName);
            this.getPageCache().put(P, passWord);
            if (ischecked.booleanValue()) {
                SessionDAO sessionDao = SessionDAOFactory.getSessionDAO((String)sessionId);
                String sessionKey = AppUtils.getSessionKey((String)svnPath, (String)sessionId);
                JSONObject userObj = new JSONObject();
                userObj.put(USERNAME, (Object)userName);
                userObj.put(P, (Object)passWord);
                String userInfo = userObj.toJSONString();
                sessionDao.setAttribute(sessionKey, userInfo);
                IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
                clientViewProxy.setClientLocalStorage(SVNMSG, sessionId);
                this.getPageCache().put(SVN_SESSIONID, sessionId);
            }
            JSONObject userInfo = new JSONObject();
            userInfo.put(USERNAME, (Object)userName);
            userInfo.put(P, (Object)passWord);
            String oldsessionId = AppUtils.getSessionIdForSvnDiff((String)"");
            String sessionKey = AppUtils.getSessionKeyForSvnDiff((String)svnPath, (String)oldsessionId);
            SessionDAO sessionDao = SessionDAOFactory.getSessionDAO((String)oldsessionId);
            sessionDao.setAttribute(sessionKey, userInfo.toJSONString());
            if (StringUtils.isNotBlank((Object)sourceMsg.get((Object)"ERROR"))) {
                this.getView().showErrorNotification((String)sourceMsg.get((Object)"ERROR"));
            } else {
                String bizCloudNumber = this.getPageCache().get("cloudnumber");
                String bizCloudId = this.getPageCache().get(CLOUDID);
                FormShowParameter parameter = new FormShowParameter();
                parameter.setCaption(String.format(ResManager.loadKDString((String)"\u7b7e\u5165%1$s\"%2$s\"", (String)"CloudListPlugin_18", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]), this.getTitle(), bizCloudNumber));
                parameter.setFormId("bos_devp_svndiff");
                parameter.setPageId(UUID.randomUUID().toString());
                HashMap<String, String> customMap = new HashMap<String, String>();
                customMap.put(BIZAPPID, bizAppId);
                customMap.put(ID, bizCloudId);
                customMap.put("type", CLOUD);
                customMap.put(SVNPATH, svnPath);
                customMap.put("oldversion", "locale");
                customMap.put("newversion", "head");
                customMap.put("scene", CLOUD);
                parameter.setCustomParams(customMap);
                OpenStyle style = new OpenStyle();
                StyleCss cssStyle = new StyleCss();
                cssStyle.setHeight("760");
                cssStyle.setWidth("1200");
                style.setInlineStyleCss(cssStyle);
                style.setShowType(ShowType.Modal);
                parameter.setOpenStyle(style);
                this.getView().showForm(parameter);
            }
            this.getPageCache().remove(SVNSESSIONID);
            this.getPageCache().remove(BIZAPPID);
            this.getPageCache().remove("cloudnumber");
            this.getPageCache().remove(CLOUDID);
        }
    }

    private void deleteCloud(String bizCloudId) {
        Object[] ids = new Object[]{bizCloudId};
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)BOS_DEVPORTAL_BIZCLOUD);
        DeleteServiceHelper.delete((IDataEntityType)type, (Object[])ids);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"CloudListPlugin_19", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
        String view = this.getPageCache().get(CURRENT_VIEW);
        if (StringUtils.equals((CharSequence)LIST, (CharSequence)view)) {
            this.renderEntity("");
        } else {
            this.renderCardEntry("");
        }
        MultiLangEnumBridge opName = new MultiLangEnumBridge("\u5220\u9664", "CloudListPlugin_20", BOS_DEVPORTAL_NEW_PLUGIN);
        MultiLangEnumBridge opDescription = new MultiLangEnumBridge("\u5220\u9664%s", "CloudListPlugin_21", BOS_DEVPORTAL_NEW_PLUGIN);
        AppUtils.addOpLog((String)BOS_DEVPORTAL_BIZCLOUD, (String)DELETE, (String)BOS_DEVPORTAL_BIZCLOUD, (String)CARD, (MultiLangEnumBridge)opName, (MultiLangEnumBridge)opDescription, (String[])new String[]{this.getTitle()});
    }

    private void renderEntity(String searchText) {
        this.getModel().deleteEntryData(ENTRYENTITY);
        DynamicObjectCollection clouds = this.getCloudsFilter(searchText);
        int size = clouds.size();
        if (size == 0) {
            return;
        }
        this.getModel().batchCreateNewEntryRow(ENTRYENTITY, size);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRYENTITY);
        for (int index = 0; index < size; ++index) {
            DynamicObject cloudInfo = (DynamicObject)clouds.get(index);
            DynamicObject row = (DynamicObject)entryEntity.get(index);
            this.renderRow(cloudInfo, row);
        }
        this.getView().updateView(ENTRYENTITY);
    }

    private void renderRow(DynamicObject cloud, DynamicObject row) {
        row.set(BIZCLOUDNUMBER, (Object)cloud.getString(NUMBER));
        row.set(BIZCLOUDNAME, (Object)cloud.getString(NAME));
        row.set(ISV, (Object)cloud.getString(ISV));
        row.set(VERSION, (Object)cloud.getString(VERSION));
        row.set(CLOUDID, (Object)cloud.getString(ID));
        row.set(DESCRIPTION, (Object)cloud.getString(DESCRIPTION));
    }

    private void renderCardEntry(String searchText) {
        this.getModel().deleteEntryData(CARD_ENTRYENTITY);
        DynamicObjectCollection clouds = this.getCloudsFilter(searchText);
        int size = clouds.size();
        if (size == 0) {
            return;
        }
        this.getModel().batchCreateNewEntryRow(CARD_ENTRYENTITY, size);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(CARD_ENTRYENTITY);
        for (int index = 0; index < size; ++index) {
            DynamicObject cloudInfo = (DynamicObject)clouds.get(index);
            DynamicObject row = (DynamicObject)entryEntity.get(index);
            this.renderCardRow(cloudInfo, row);
        }
        this.getView().updateView(CARD_ENTRYENTITY);
    }

    private void renderCardRow(DynamicObject cardInfo, DynamicObject row) {
        String domainUrl = UrlService.getDomainContextUrl();
        String image = cardInfo.getString(IMAGE);
        if (StringUtils.isNotBlank((CharSequence)image) && !image.startsWith("/")) {
            image = "/" + image;
        }
        row.set(CARDID, (Object)cardInfo.getString(ID));
        row.set(IMAGELABEL, (Object)(domainUrl + image));
        row.set(CARDNAME, (Object)cardInfo.getString(NAME));
        row.set(CARDNUMBER, (Object)cardInfo.getString(NUMBER));
        row.set(CARDISV, (Object)cardInfo.getString(ISV));
    }

    private DynamicObjectCollection getCloudsFilter(String searchText) {
        String fields = "id, number, version, name, isv, image, description";
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(16);
        QFilter[] cloudBlackFilter = RunModeServiceHelper.getCloudIdBlacklistFilters(null, (String)ID);
        if (cloudBlackFilter != null && cloudBlackFilter.length != 0) {
            qFilters.addAll(Arrays.asList(cloudBlackFilter));
        }
        if (StringUtils.isNotBlank((CharSequence)searchText)) {
            String text = String.format("%s%s%s", "%", searchText, "%");
            QFilter qFilter = new QFilter(NUMBER, "like", (Object)text);
            QFilter qFilter1 = new QFilter(NAME, "like", (Object)text);
            QFilter filter = qFilter.or(qFilter1);
            qFilters.add(filter);
        }
        qFilters.add(new QFilter("ismodel", this.isModel() ? "=" : "!=", (Object)CARD));
        qFilters.add(new QFilter(ID, "!=", (Object)"2HGKCE94QELW"));
        return QueryServiceHelper.query((String)BOS_DEVPORTAL_BIZCLOUD, (String)fields, (QFilter[])qFilters.toArray(new QFilter[0]), (String)"modifydate desc");
    }

    private QFilter[] concat(QFilter[] q1, QFilter[] q2) {
        if (q1 == null) {
            return q2;
        }
        QFilter[] q3 = new QFilter[q1.length + q2.length];
        System.arraycopy(q1, 0, q3, 0, q1.length);
        System.arraycopy(q2, 0, q3, q1.length, q2.length);
        return q3;
    }

    public void cellClick(CellClickEvent evt) {
    }

    public void cellDoubleClick(CellClickEvent evt) {
        Control source = (Control)evt.getSource();
        String cloudId = "";
        if (ENTRYENTITY.equals(source.getKey())) {
            cloudId = (String)this.getModel().getValue(CLOUDID, evt.getRow());
        }
        if (CARD_ENTRYENTITY.equals(source.getKey())) {
            cloudId = (String)this.getModel().getValue(CARDID, evt.getRow());
        }
        if (StringUtils.isNotBlank((CharSequence)cloudId)) {
            this.gotoBizApp(cloudId);
        }
    }

    private void gotoBizApp(String cloudId) {
        FormShowParameter fsp = new FormShowParameter();
        fsp.setCustomParam("bizcloudId", (Object)cloudId);
        fsp.setFormId("bos_devpn_applist_my");
        IFormView parentView = this.getView().getView(this.getView().getFormShowParameter().getRootPageId());
        if (parentView != null) {
            fsp.getOpenStyle().setShowType(ShowType.NewTabPage);
            fsp.getOpenStyle().setTargetKey("_submaintab_");
            parentView.showForm(fsp);
            this.getView().sendFormAction(parentView);
        } else {
            fsp.getOpenStyle().setShowType(ShowType.Modal);
            fsp.getOpenStyle().setTargetKey("");
            this.getView().showForm(fsp);
        }
    }

    static {
        editOp.add(ADD);
        editOp.add(UPDATEICON);
        editOp.add(CARDMODIFY);
        editOp.add(DELETEICON);
        editOp.add(CARDDELETE);
        editOp.add(SVNICON);
        editOp.add(SVNCOMMIT);
        editOp.add(GITICON);
        editOp.add(GITCOMMIT);
        editOp.add(GITPUSHICON);
        editOp.add(GITPUSH);
        editOp.add(DELETE);
        editOp.add(MODIFY);
    }
}

