/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.newdevportal.designer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.dao.DesignerData;
import kd.bos.designer.dao.EntityDesignerData;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.mvc.SessionManager;
import kd.bos.mvc.form.IFormController;
import kd.bos.newdevportal.designer.DesignerTabCloseEvent;
import kd.bos.newdevportal.designer.DesignerTabEvent;
import kd.bos.newdevportal.designer.DesignerTabReLoadEvent;
import kd.bos.newdevportal.designer.DesignerTabRefreshEvent;
import kd.bos.newdevportal.designer.IFormDesignerTabPlugin;
import kd.bos.newdevportal.designer.MergeDesignerTabDataEvent;
import kd.bos.newdevportal.designer.SwitchDesignerTabEvent;

public abstract class AbstractFormDesignerTabPlugin
extends AbstractFormPlugin
implements IFormDesignerTabPlugin {
    @Override
    public IFormView getMainDesignView() {
        return this.getView().getView(this.getView().getFormShowParameter().getParentPageId());
    }

    @Override
    public IFormView getMainDesignViewNoPlugin() {
        return this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
    }

    public Lang getEditLang() {
        if (this.getView() == null) {
            return RequestContext.get().getLang();
        }
        String lang = this.getMainDesignView().getPageCache().get("preview_lang");
        return lang == null ? RequestContext.get().getLang() : Lang.valueOf((String)lang.toString());
    }

    public boolean switchLang(Lang lang) {
        IFormView mainDesignView = this.getView().getView(this.getView().getFormShowParameter().getParentPageId());
        OperateOption opParameter = OperateOption.create();
        opParameter.setVariableValue("lang", lang.toString());
        OperationResult result = mainDesignView.invokeOperation("switchlang", opParameter);
        this.getView().sendFormAction(mainDesignView);
        return result.isSuccess();
    }

    @Override
    public void fireEvent(DesignerTabEvent e) {
        if (e instanceof DesignerTabCloseEvent) {
            this.fireTabCloseEvent((DesignerTabCloseEvent)e);
        } else if (e instanceof DesignerTabReLoadEvent) {
            this.fireTabReloadEvent((DesignerTabReLoadEvent)e);
        } else if (e instanceof MergeDesignerTabDataEvent) {
            this.fireMergeTabDataEvent((MergeDesignerTabDataEvent)e);
        } else if (e instanceof SwitchDesignerTabEvent) {
            this.fireSwitchTabEvent((SwitchDesignerTabEvent)e);
        } else if (e instanceof DesignerTabRefreshEvent) {
            this.fireRefreshTabEvent((DesignerTabRefreshEvent)e);
        }
    }

    protected void fireRefreshTabEvent(DesignerTabRefreshEvent e) {
    }

    protected void fireTabCloseEvent(DesignerTabCloseEvent e) {
        IFormView tabView = this.getView();
        tabView.close();
        e.getMainDesignView().sendFormAction(tabView);
    }

    protected void fireTabReloadEvent(DesignerTabReLoadEvent e) {
        IFormView tabView = this.getView();
        FormShowParameter subFsp = tabView.getFormShowParameter();
        subFsp.getCustomParams().putAll(e.getCustomParams() == null ? new HashMap(3) : e.getCustomParams());
        IFormController formController = (IFormController)tabView.getService(IFormController.class);
        if (formController == null) {
            return;
        }
        tabView.getPageCache().batchRemove(new ArrayList(tabView.getPageCache().getAll().keySet()));
        tabView.cacheFormShowParameter();
        tabView.getPageCache().saveChanges();
        formController.loadData();
        e.getMainDesignView().sendFormAction(tabView);
    }

    protected void fireSwitchTabEvent(SwitchDesignerTabEvent e) {
    }

    protected void fireMergeTabDataEvent(MergeDesignerTabDataEvent e) {
    }

    protected String getMetaViewId() {
        return this.getMetaViewId(this.getView().getFormShowParameter());
    }

    protected IPageCache getMainPageCache(FormShowParameter fsp) {
        IFormView formView = this.getMainDesignView(fsp);
        return formView.getPageCache();
    }

    protected IFormView getMainDesignView(FormShowParameter fsp) {
        if (this.getView() == null) {
            return SessionManager.getCurrent().getView(fsp.getParentPageId());
        }
        return this.getView().getView(fsp.getParentPageId());
    }

    protected String getMetaViewId(FormShowParameter fsp) {
        return this.getMainPageCache(fsp).get("metaMenuId");
    }

    protected String getFormModelType(FormShowParameter fsp) {
        String cacheStr = this.getMainPageCache(fsp).get("cache_all_metadata");
        String metaTypeId = this.getMetaViewId(fsp);
        Map allMetaData = (Map)SerializationUtils.fromJsonString((String)cacheStr, Map.class);
        Map formData = (Map)allMetaData.get(metaTypeId);
        return ((Map)formData.get("formmeta")).get("ModelType").toString();
    }

    protected String getEntityModelType(FormShowParameter fsp) {
        return this.getMainPageCache(fsp).get("entityModelType");
    }

    protected EntityMetadata getEntityMeta(FormShowParameter fsp) {
        String cacheStr = this.getMainPageCache(fsp).get("cache_all_metadata");
        Map allMetaData = (Map)SerializationUtils.fromJsonString((String)cacheStr, Map.class);
        Map entityData = (Map)allMetaData.get("formmeta");
        EntityDesignerData designerData = new EntityDesignerData();
        FormMetadata formMetadata = (FormMetadata)designerData.convertTo(entityData, this.getEntityModelType(fsp));
        EntityMetadata entityMetadata = formMetadata.getEntityMetadata();
        entityMetadata.createIndex();
        return entityMetadata;
    }

    protected FormMetadata getFormMeta() {
        FormMetadata meta = this.getFormMeta(this.getView().getFormShowParameter(), this.getMetaViewId());
        meta.createIndex();
        return meta;
    }

    protected FormMetadata getFormMeta(FormShowParameter fsp, String metaTypeId) {
        String cacheStr = this.getMainPageCache(fsp).get("cache_all_metadata");
        Map allMetaData = (Map)SerializationUtils.fromJsonString((String)cacheStr, Map.class);
        Map formData = (Map)allMetaData.get(metaTypeId);
        String modelType = ((Map)formData.get("formmeta")).get("ModelType").toString();
        if (formData.get("entitymeta") instanceof Map && !StringUtils.equals((CharSequence)String.valueOf(((Map)formData.get("entitymeta")).get("ModelType")), (CharSequence)modelType)) {
            formData.remove("entitymeta");
        }
        if (formData.get("language") == null) {
            formData.put("language", this.getEditLang().toString());
        }
        DesignerData dao = new DesignerData();
        return (FormMetadata)dao.convertTo(formData, modelType);
    }

    protected List<Map<String, Object>> getFormItemMetaList(FormShowParameter fsp, String metaTypeId) {
        String cacheStr = this.getMainPageCache(fsp).get("cache_all_metadata");
        Map allMetaData = (Map)SerializationUtils.fromJsonString((String)cacheStr, Map.class);
        Map formData = (Map)((Map)allMetaData.get(metaTypeId)).get("formmeta");
        return (List)formData.get("Items");
    }

    protected void mergeFormMeta(Map<String, Object> allMetaMenuData, List<Map<String, Object>> propValues) {
        Map formContent = (Map)allMetaMenuData.get("formmeta");
        Map entityContent = (Map)((Map)allMetaMenuData.get("formmeta")).get("entitymeta");
        if (propValues == null || propValues.isEmpty()) {
            return;
        }
        String metaTypeId = this.getMetaViewId();
        if (StringUtils.isBlank((CharSequence)metaTypeId)) {
            metaTypeId = "formmeta";
        }
        for (Map<String, Object> itemPropMap : propValues) {
            String itemId = (String)itemPropMap.getOrDefault("itemId", "");
            String propertyName = (String)itemPropMap.getOrDefault("propertyName", "");
            String metaType = (String)itemPropMap.get("metaType");
            Object value = itemPropMap.get("value");
            if (StringUtils.isBlank((CharSequence)itemId) || StringUtils.isBlank((CharSequence)propertyName)) continue;
            LinkedHashMap itemsMetaMap = new LinkedHashMap(10);
            List itemsData = new ArrayList(10);
            if (StringUtils.equals((CharSequence)"entitymeta", (CharSequence)metaType)) {
                itemsData = (List)entityContent.get("Items");
            } else if ("formmeta".equals(metaTypeId)) {
                itemsData = (List)((Map)formContent.get("formmeta")).get("Items");
            } else if ("listmeta".equals(metaTypeId)) {
                itemsData = (List)((Map)((Map)allMetaMenuData.get("listmeta")).get("formmeta")).get("Items");
            }
            itemsData.forEach(d -> itemsMetaMap.put(String.valueOf(d.get("Id")), d));
            Map itemData = (Map)itemsMetaMap.get(itemId);
            if (itemData == null) continue;
            itemData.put(propertyName, value);
        }
    }

    protected String getMainDesignViewFocusTab() {
        return this.getMainDesignView().getPageCache().get("proformdesigner.designerbar.focuspage");
    }

    protected abstract String getTabId();

    protected boolean isFocusCurrentTab() {
        return StringUtils.equals((CharSequence)this.getMainDesignViewFocusTab(), (CharSequence)this.getTabId());
    }
}

