/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.newdevportal.domaindefine;

import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListView;

public class BaseListPlugin
extends AbstractListPlugin {
    private static final String NUMBER = "number";
    private static final String BOS_DEVPORTAL_NEW_PLUGIN = "bos-devportal-new-plugin";
    private static final String BILL_NUMBER = "billno";

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        ListSelectedRow row = ((BillListHyperLinkClickEvent)args.getHyperLinkClickEvent()).getCurrentRow();
        String fieldName = args.getFieldName();
        IPageCache pageCache = this.getView().getPageCache();
        pageCache.put("fieldname", fieldName);
        if (NUMBER.equals(args.getFieldName())) {
            this.showBill(BillOperationStatus.EDIT, false);
            args.setCancel(true);
        }
        if (BILL_NUMBER.equals(args.getFieldName())) {
            String billNo = row.getBillNo();
            pageCache.put("value", billNo);
            this.showBill(BillOperationStatus.VIEW, false);
            args.setCancel(true);
        }
    }

    protected void showBill(BillOperationStatus status, boolean isCustom) {
        ListSelectedRow row = ((ListView)this.getView()).getCurrentSelectedRowInfo();
        if (row != null) {
            String value = row.getNumber();
            BillShowParameter parameter = new BillShowParameter();
            String formId = ((IListView)this.getView()).getBillFormId();
            parameter.setFormId(formId);
            IPageCache pageCache = this.getView().getPageCache();
            String fieldName = pageCache.get("fieldname");
            if (BILL_NUMBER.equals(fieldName)) {
                value = pageCache.get("value");
                parameter.setCustomParam(BILL_NUMBER, (Object)value);
            } else {
                parameter.setCustomParam(NUMBER, (Object)value);
            }
            parameter.getOpenStyle().setShowType(ShowType.NewTabPage);
            parameter.getOpenStyle().setTargetKey("_submaintab_");
            parameter.setBillStatus(status);
            String pkStr = String.valueOf(value);
            String[] info = pkStr.split("@@");
            if (info.length < 1) {
                throw new KDException("err data");
            }
            if (BillOperationStatus.EDIT.equals((Object)status)) {
                parameter.setStatus(OperationStatus.EDIT);
            }
            if (!isCustom) {
                parameter.setPkId(row.getPrimaryKeyValue());
            }
            IFormView formView = this.getView();
            ShowType showType = this.getView().getFormShowParameter().getOpenStyle().getShowType();
            if (showType == ShowType.NewTabPage) {
                IFormView mainView = formView.getMainView();
                String mainFormId = "";
                if (mainView != null) {
                    mainFormId = formView.getMainView().getFormShowParameter().getFormId();
                }
                if (formView.getMainView() == null || "pc_main_console".equals(mainFormId)) {
                    String pageIdKey = "TableManagerList" + info[0];
                    String tablePageId = formView.getPageCache().get(pageIdKey);
                    String parentPageId = formView.getFormShowParameter().getParentPageId();
                    parameter.setParentPageId(parentPageId);
                    if (StringUtils.isBlank((CharSequence)parameter.getAppId())) {
                        parameter.setAppId(formView.getFormShowParameter().getAppId());
                    }
                    parameter.getOpenStyle().setShowType(ShowType.NewTabPage);
                    parameter.getOpenStyle().setTargetKey("_submaintab_");
                    if (StringUtils.isBlank((CharSequence)tablePageId) || formView.getViewNoPlugin(tablePageId) == null) {
                        String pageId = parentPageId + info[0];
                        formView.getPageCache().put(pageIdKey, pageId);
                        parameter.setPageId(pageId);
                        IFormView parentView = formView.getView(parentPageId);
                        this.beforeShowTabForm((FormShowParameter)parameter);
                        parentView.showForm((FormShowParameter)parameter);
                        formView.sendFormAction(parentView);
                    } else {
                        IFormView tabView = formView.getViewNoPlugin(tablePageId);
                        tabView.activate();
                        formView.sendFormAction(tabView);
                    }
                } else if ("home_page".equals(mainFormId)) {
                    parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                    formView.showForm((FormShowParameter)parameter);
                }
            } else {
                parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm((FormShowParameter)parameter);
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u884c\u3002", (String)"BaseListPlugin_0", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
        }
    }

    protected void beforeShowTabForm(FormShowParameter formShowParameter) {
    }

    protected void newShowParam() {
        BillShowParameter parameter = new BillShowParameter();
        parameter.setFormId(((IListView)this.getView()).getBillFormId());
        parameter.getOpenStyle().setShowType(ShowType.NewTabPage);
        parameter.getOpenStyle().setTargetKey("_submaintab_");
        ShowType showType = this.getView().getFormShowParameter().getOpenStyle().getShowType();
        if (this.getView().getMainView() != null || showType == ShowType.NewTabPage) {
            IFormView parentView = this.getView().getParentView();
            parentView.showForm((FormShowParameter)parameter);
            this.getView().sendFormAction(parentView);
        } else {
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.getOpenStyle().setTargetKey("");
            this.getView().showForm((FormShowParameter)parameter);
        }
    }

    protected void showNewTabPage(BillShowParameter parameter) {
        parameter.getOpenStyle().setShowType(ShowType.NewTabPage);
        parameter.getOpenStyle().setTargetKey("_submaintab_");
        ShowType showType = this.getView().getFormShowParameter().getOpenStyle().getShowType();
        if (this.getView().getMainView() != null || showType == ShowType.NewTabPage) {
            IFormView parentView = this.getView().getParentView();
            parentView.showForm((FormShowParameter)parameter);
            this.getView().sendFormAction(parentView);
        } else {
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.getOpenStyle().setTargetKey("");
            this.getView().showForm((FormShowParameter)parameter);
        }
    }
}

