/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.newdevportal.domaindefine;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcxmlSerializer;
import kd.bos.dataentity.serialization.ListDcxmlBinder;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.isv.ISVService;
import kd.bos.metadata.domainmodel.Category;
import kd.bos.metadata.domainmodel.DomainModelType;
import kd.bos.metadata.domainmodel.ElementType;
import kd.bos.metadata.domainmodel.define.DomainModelTypeFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class DMElementTypeListPlugin
extends AbstractFormPlugin {
    private static final String MODELTYPE = "modeltype";
    private static final String CATEGORY = "category";
    private static final String NUMBER = "number";
    private static final String APPLYNUMBER = "applynumber";
    private static final String BOS_DEVP_ELEMENT = "bos_devp_element";
    private static final String MODIFYELEMENT = "modifyelement";
    private static final String ENTRYENTITY = "entryentity";
    private static final String CATEGORYNUMBER = "categorynumber";

    public void afterCreateNewData(EventObject e) {
        String modelType = (String)this.getView().getFormShowParameter().getCustomParam(MODELTYPE);
        Object showInvisible = this.getView().getFormShowParameter().getCustomParam("showinvisible");
        String search = (String)this.getView().getFormShowParameter().getCustomParam("search");
        List searchList = null;
        if (search != null) {
            searchList = (List)SerializationUtils.fromJsonString((String)search, List.class);
        }
        DomainModelType domainModelType = DomainModelTypeFactory.getDomainModelType((String)modelType, (boolean)true);
        int rowCount = this.getElementCount(domainModelType);
        this.getModel().batchCreateNewEntryRow(ENTRYENTITY, this.getElementCount(domainModelType));
        QFilter qFilter = new QFilter(APPLYNUMBER, "like", (Object)("%," + modelType + "%"));
        qFilter.or(new QFilter(MODELTYPE, "=", (Object)modelType).and(new QFilter("ISV", "=", (Object)ISVService.getISVInfo().getId())));
        QFilter qFilterEnable = new QFilter("enable", "=", (Object)"1");
        QFilter[] filter = new QFilter[]{qFilter, qFilterEnable};
        DynamicObjectCollection rs = QueryServiceHelper.query((String)BOS_DEVP_ELEMENT, (String)"category,number,issys", (QFilter[])filter);
        HashMap<String, DynamicObject> mapNewElement = new HashMap<String, DynamicObject>(16);
        for (DynamicObject row : rs) {
            String key = row.getString(CATEGORY) + "|" + row.getString(NUMBER);
            mapNewElement.put(key, row);
        }
        int rowIndex = 0;
        for (Category category : domainModelType.getCategories()) {
            if (!Boolean.TRUE.equals(showInvisible) && !category.isVisible()) continue;
            for (ElementType elementType : category.getElementTypes()) {
                String key = category.getId() + "|" + elementType.getId();
                DynamicObject row = this.getMatchRow(category, elementType, searchList);
                if (row == null || Boolean.TRUE.equals(this.getView().getFormShowParameter().getCustomParam("isextend")) && mapNewElement.containsKey(key) && !"true".equalsIgnoreCase(((DynamicObject)mapNewElement.get(key)).getString("issys"))) continue;
                this.copyRow(rowIndex, row);
                if (mapNewElement.containsKey(key)) {
                    this.getModel().setValue("extend", (Object)this.getExtendValue(((DynamicObject)mapNewElement.get(key)).getString("issys")), rowIndex);
                }
                ++rowIndex;
            }
        }
        this.getModel().clearNoDataRow();
    }

    private String getExtendValue(String issys) {
        return Boolean.parseBoolean(issys) ? "2" : "1";
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (Boolean.TRUE.equals(this.getView().getFormShowParameter().getCustomParam("selectmode"))) {
            HashMap<String, Boolean> map = new HashMap<String, Boolean>(16);
            map.put("selchexkbox", true);
            this.getView().updateControlMetadata(ENTRYENTITY, map);
        }
    }

    private void copyRow(int rowIndex, DynamicObject row) {
        for (IDataEntityProperty property : row.getDynamicObjectType().getProperties()) {
            if ("id".equals(property.getName()) || "seq".equals(property.getName())) continue;
            this.getModel().setValue(property.getName(), property.getValueFast((Object)row), rowIndex);
        }
        if (row.getString("name") == null) {
            this.getModel().setValue("name", (Object)"-", rowIndex);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        if (MODIFYELEMENT.equals(args.getOperateKey())) {
            this.doShowElementType();
        }
    }

    private <T> String toXml(T t) {
        ArrayList dts = new ArrayList();
        DcxmlSerializer ser = new DcxmlSerializer((DcBinder)new ListDcxmlBinder(true, dts));
        return ser.serializeToString(t, null);
    }

    private void doShowElementType() {
        BillShowParameter parameter = new BillShowParameter();
        OpenStyle openStyle = new OpenStyle();
        openStyle.setShowType(ShowType.Modal);
        parameter.setOpenStyle(openStyle);
        int currentRow = this.getModel().getEntryCurrentRowIndex(ENTRYENTITY);
        String elementNumber = (String)this.getModel().getValue(NUMBER, currentRow);
        String categoryNumber = (String)this.getModel().getValue(CATEGORYNUMBER, currentRow);
        String modelType = (String)this.getView().getFormShowParameter().getCustomParam(MODELTYPE);
        DomainModelType domainModelType = DomainModelTypeFactory.getDomainModelType((String)modelType, (boolean)true);
        ElementType type = null;
        block0: for (Category category : domainModelType.getCategories()) {
            for (ElementType elementType : category.getElementTypes()) {
                if (!this.isEqual(categoryNumber, category.getId()) || !elementNumber.equals(elementType.getId())) continue;
                type = elementType;
                continue block0;
            }
        }
        if (type == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5143\u6a21\u578b\u5f02\u5e38\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u9875\u9762\u3002", (String)"DMElementTypeListPlugin_0", (String)"bos-devportal-new-plugin", (Object[])new Object[0]));
            return;
        }
        String xml = this.toXml(type);
        if (!StringUtils.isBlank((CharSequence)xml)) {
            parameter.setCustomParam("xml", (Object)xml);
            parameter.setCustomParam(CATEGORYNUMBER, (Object)categoryNumber);
            parameter.setCustomParam(MODELTYPE, (Object)modelType);
            parameter.setFormId(BOS_DEVP_ELEMENT);
            this.getView().showForm((FormShowParameter)parameter);
        }
    }

    private boolean isEqual(String t, String s) {
        if (StringUtils.isBlank((CharSequence)t) && StringUtils.isBlank((CharSequence)s)) {
            return true;
        }
        return t.equals(s);
    }

    private int getElementCount(DomainModelType domainModelType) {
        int row = 0;
        for (Category category : domainModelType.getCategories()) {
            row += category.getElementTypes().size();
        }
        return row;
    }

    private DynamicObject getMatchRow(Category category, ElementType elementType, List<Map<String, Object>> searchList) {
        DynamicObject row = new DynamicObject(this.getModel().getEntryEntity(ENTRYENTITY).getDynamicObjectType());
        row.set(CATEGORY, (Object)category.getName());
        row.set(CATEGORYNUMBER, (Object)category.getId());
        row.set(NUMBER, (Object)elementType.getId());
        row.set("name", (Object)elementType.getName());
        row.set("extend", (Object)"0");
        if (searchList == null) {
            return row;
        }
        for (Map<String, Object> searchField : searchList) {
            if (!this.isMatch(row, (List)searchField.get("fieldName"), (List)searchField.get("value"))) continue;
            return row;
        }
        return null;
    }

    private boolean isMatch(DynamicObject row, List<String> filterFields, List<String> filterValues) {
        for (String field : filterFields) {
            for (String value : filterValues) {
                if (row.getString(field) == null || !row.getString(field).contains(value)) continue;
                return true;
            }
        }
        return false;
    }
}

